/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.mechanism;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismCapacityParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismPartParser;
import com.digiwin.athena.knowledgegraph.utils.Utils;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMechanismCapacityParser
implements MechanismCapacityParser {
    private static final Logger log = LoggerFactory.getLogger(AbstractMechanismCapacityParser.class);
    @Autowired
    private List<MechanismPartParser> partParsers;

    public void parsePart(MechanismParseContext context, MechanismPart part) throws DWBusinessException {
        if (null == part) {
            return;
        }
        for (MechanismPartParser parser : this.partParsers) {
            if (!parser.accept(part)) continue;
            parser.parse(context, part);
            return;
        }
        throw new DWBusinessException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684MechanismPart by:" + part);
    }

    public void generateCypherPart(MechanismParseContext context, MechanismPart part, String parentNode) throws DWBusinessException {
        if (null == part) {
            return;
        }
        String nodeId = this.doGenerateCypherPart(context, part, parentNode);
        for (MechanismPartParser parser : this.partParsers) {
            if (!parser.accept(part)) continue;
            parser.generateCypher(context, part, nodeId);
            return;
        }
        throw new DWBusinessException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684MechanismPart by:" + part);
    }

    protected String doGenerateCypherPart(MechanismParseContext context, MechanismPart part, String parentNode) {
        String nodeId = part.getCode();
        context.getCypherSb().append("create(").append(nodeId).append(":MechanismPart:MechanismComponent{").append("code").append(":'").append(part.getCode()).append("',").append("name").append(":'").append(part.getName() == null ? "Part_" + part.getCode() : part.getName()).append("',").append("type").append(":'").append(part.getType()).append("',");
        this.fieldCypher(context, part);
        context.getCypherSb().append("pluginId").append(":'").append(context.getPluginId()).append("'").append("})\r\n");
        context.getCypherSb().append("create(").append(parentNode).append(")-[:PART]->(").append(nodeId).append(")\r\n");
        return nodeId;
    }

    protected String doGenerateCypherPart(MechanismParseContext context, MechanismPart part) {
        String nodeId = part.getCode();
        context.getCypherSb().append("create(").append(nodeId).append(":MechanismPart:MechanismComponent{").append("code").append(":'").append(part.getCode()).append("',").append("name").append(":'").append(part.getName() == null ? "Part_" + part.getCode() : part.getName()).append("',").append("type").append(":'").append(part.getType()).append("',");
        context.getCypherSb().append("tenantId").append(":'").append(context.getTenantId()).append("',");
        context.getCypherSb().append("pluginId").append(":'").append(context.getPluginId()).append("'").append("})\r\n");
        return nodeId;
    }

    protected void doGenerateCypherPartRelation(MechanismParseContext context, String fromNode, String toNode, String relation) {
        context.getCypherSb().append("create(").append(fromNode).append(")-[:" + relation + "]->(").append(toNode).append(")\r\n");
    }

    private void fieldCypher(MechanismParseContext context, MechanismPart part) {
        Field[] fields;
        for (Field f : fields = part.getClass().getDeclaredFields()) {
            try {
                Object obj;
                f.setAccessible(true);
                if (f.getName().equals("strategies") || null == (obj = f.get(part))) continue;
                String objStr = null;
                objStr = !Utils.isPrimitive(f.getType()) ? JSON.toJSONString((Object)obj) : obj.toString();
                if (objStr.contains("'")) continue;
                context.getCypherSb().append(f.getName()).append(":'").append(objStr).append("',");
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("abs'afsd'bb".contains("'"));
    }
}

