/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.mechanism;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismCapacityParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.pre.MechanismCapacity;
import org.springframework.stereotype.Service;

@Service
public class MechanismCapacityLimitParser
extends AbstractMechanismCapacityParser {
    @Override
    public boolean accept(MechanismCapacity capacity) {
        return ComponentTypeEnum.MechanismLimit.name().equals(capacity.getType());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismCapacity capacity) throws DWBusinessException {
        super.parsePart(context, capacity.getSource());
        super.parsePart(context, capacity.getCondition());
        super.parsePart(context, capacity.getAction());
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismCapacity capacity, String parentNode) throws DWBusinessException {
        String sourceNode = super.doGenerateCypherPart(context, capacity.getSource());
        String checkNode = super.doGenerateCypherPart(context, capacity.getCondition());
        String actionNode = super.doGenerateCypherPart(context, capacity.getAction());
        super.doGenerateCypherPartRelation(context, checkNode, sourceNode, "condition");
        super.doGenerateCypherPartRelation(context, checkNode, actionNode, "ACTION");
    }
}

