/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.LimitTaskActionPart;
import com.digiwin.athena.mechanism.widgets.PlanWidget;
import com.digiwin.athena.mechanism.widgets.Widget;
import com.digiwin.athena.mechanism.widgets.action.LimitAction;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import com.digiwin.athena.mechanism.widgets.plan.LimitTaskActionPlan;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class LimitActionParser
extends AbstractMechanismPartParser {
    @Override
    public boolean accept(MechanismPart part) {
        return "limitAction".equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) {
        LimitTaskActionPart limitTaskActionPart = (LimitTaskActionPart)part;
        LimitAbilityBo logic = (LimitAbilityBo)context.getLogic();
        this.limitActionHandler(limitTaskActionPart.getLimitAction(), logic);
        limitTaskActionPart.setStrategies(logic.getStrategies());
        LimitAction limitAction = limitTaskActionPart.getLimitAction();
        if (null != logic) {
            logic.setLimitAction(limitAction);
        }
    }

    private void limitActionHandler(LimitAction limitAction, LimitAbilityBo logic) {
        List conditions = limitAction.getConditions();
        for (MechanismConditionConfig condition : conditions) {
            condition.setLimitType(limitAction.getType());
        }
        for (SingleStrategyWidget strategy : logic.getStrategies()) {
            strategy.setCode(MechanismPlanType.limitTaskActionPlan.name());
            strategy.setActionHookType(MechanismEnum.ComponentType.CHECK_VALID.getCode());
            LimitTaskActionPlan positiveTarget = (LimitTaskActionPlan)JSON.parseObject((String)JSON.toJSONString((Object)strategy.getPositiveTarget()), LimitTaskActionPlan.class);
            positiveTarget.setValidateType(limitAction.getType());
            positiveTarget.setType(MechanismPlanType.limitTaskActionPlan.name());
            positiveTarget.setActionType(MechanismEnum.LimitActionType.LIMIT_ACTION.getCode());
            positiveTarget.setConditions(conditions);
            strategy.setPositiveTarget((PlanWidget)positiveTarget);
        }
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        LimitTaskActionPart limitTaskActionPart = (LimitTaskActionPart)part;
        List strategies = limitTaskActionPart.getStrategies();
        for (SingleStrategyWidget strategy : strategies) {
            super.generateCypherSimple(context, (Widget)strategy, parentNode);
        }
    }
}

