/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.LimitTaskActionPart;
import com.digiwin.athena.mechanism.widgets.PlanWidget;
import com.digiwin.athena.mechanism.widgets.Widget;
import com.digiwin.athena.mechanism.widgets.action.Reminder;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.plan.ReminderPlan;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReminderParser
extends AbstractMechanismPartParser {
    private static final Logger log = LoggerFactory.getLogger(ReminderParser.class);

    @Override
    public boolean accept(MechanismPart part) {
        return "reminder".equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) {
        LimitTaskActionPart limitTaskActionPart = (LimitTaskActionPart)part;
        Reminder reminder = limitTaskActionPart.getReminder();
        Object message = reminder.getMessage();
        List variables = reminder.getVariables();
        LimitAbilityBo logic = (LimitAbilityBo)context.getLogic();
        for (SingleStrategyWidget strategy : logic.getStrategies()) {
            strategy.setCode(MechanismPlanType.reminderPlan.name());
            strategy.setActionHookType(MechanismEnum.ComponentType.ASSIGNMENT.getCode());
            ReminderPlan positiveTarget = (ReminderPlan)JSON.parseObject((String)JSON.toJSONString((Object)strategy.getPositiveTarget()), ReminderPlan.class);
            positiveTarget.setType(MechanismPlanType.reminderPlan.name());
            positiveTarget.setActionType(MechanismEnum.LimitActionType.REMINDER.getCode());
            positiveTarget.setMessage(message);
            positiveTarget.setMessageType(reminder.getMessageType());
            positiveTarget.setLang(reminder.getLang());
            positiveTarget.setVariables(variables);
            strategy.setPositiveTarget((PlanWidget)positiveTarget);
        }
        limitTaskActionPart.setStrategies(logic.getStrategies());
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        LimitTaskActionPart limitTaskActionPart = (LimitTaskActionPart)part;
        List strategies = limitTaskActionPart.getStrategies();
        for (SingleStrategyWidget strategy : strategies) {
            super.generateCypherSimple(context, (Widget)strategy, parentNode);
        }
    }
}

