/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.mq;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RabbitMQManager
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQManager.class);
    private static String rabbitMQUri = "amqp://digiwin:digiwin@mq-test.digiwincloud.com.cn/athena";
    @Value(value="${rabbitMQExchangeName}")
    private String exchangeName = "themeMap";
    @Value(value="${rabbitMQExchangeType}")
    private String exchangeType = "direct";
    @Value(value="${rabbitMQPersistent}")
    private Boolean persistent = true;
    @Value(value="${rabbitMQEnabled}")
    private Boolean rabbitMQEnabled = true;
    private static RabbitMQManager rabbitMQManager = null;
    @Autowired(required=false)
    private ConnectionFactory connectionFactory;
    @Autowired(required=false)
    private RabbitTemplate rabbitTemplate;
    private Connection connection = null;

    public static RabbitMQManager getRabbitMQManager() throws DWBusinessException {
        if (rabbitMQManager == null) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.mqCreateError", new Object[0]));
        }
        return rabbitMQManager;
    }

    public boolean getEnabled() {
        return this.rabbitMQEnabled;
    }

    private Channel CreateChannel(String exchangeName, String exchangeType, boolean durable, String queueName, String routingKey) throws NoSuchAlgorithmException, KeyManagementException, URISyntaxException, IOException, TimeoutException {
        Channel channel = this.connection.createChannel();
        channel.exchangeDeclare(exchangeName, exchangeType, durable);
        channel.queueDeclare(queueName, durable, false, false, null);
        channel.queueBind(queueName, exchangeName, routingKey);
        return channel;
    }

    public boolean PublishMessage(String message, String routingKey) {
        if (!this.rabbitMQEnabled.booleanValue()) {
            return true;
        }
        log.info("sendMQMessage exchangeName:{}, routingKey:{}, message:{}", new Object[]{this.exchangeName, routingKey, message});
        this.rabbitTemplate.convertAndSend(this.exchangeName, routingKey, (Object)message);
        return true;
    }

    public boolean PublishMessage(String message, String queueName, String routingKey) {
        if (!this.rabbitMQEnabled.booleanValue()) {
            return false;
        }
        log.info("sendMQMessage exchangeName:{}, routingKey:{}, message:{}", new Object[]{this.exchangeName, routingKey, message});
        this.rabbitTemplate.convertAndSend(this.exchangeName, routingKey, (Object)message);
        return true;
    }

    public boolean PublishMessage(String message, String exchange, String routingKey, final String expiration) {
        if (!this.rabbitMQEnabled.booleanValue()) {
            return true;
        }
        this.rabbitTemplate.convertAndSend(exchange, routingKey, (Object)message, new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws AmqpException {
                message.getMessageProperties().setExpiration(expiration);
                return message;
            }
        }, new CorrelationData(UUID.randomUUID().toString()));
        return true;
    }

    public String GetMessage(String queueName, String routingKey) throws URISyntaxException, IOException, TimeoutException, NoSuchAlgorithmException, KeyManagementException {
        String re = null;
        if (!this.rabbitMQEnabled.booleanValue()) {
            return re;
        }
        Channel channel = this.CreateChannel(this.exchangeName, this.exchangeType, this.persistent, queueName, routingKey);
        GetResponse resp = channel.basicGet(queueName, false);
        if (resp != null) {
            re = new String(resp.getBody());
        }
        if (null != resp && null != resp.getEnvelope()) {
            channel.basicAck(resp.getEnvelope().getDeliveryTag(), false);
        }
        channel.close();
        return re;
    }

    public void afterPropertiesSet() throws Exception {
        rabbitMQManager = this;
        if (null != this.connectionFactory) {
            try {
                this.connection = this.connectionFactory.createConnection().createChannel(false).getConnection();
            }
            catch (Exception e) {
                log.error("afterPropertiesSet connectionFactory createConnection fail, e:{} ", (Throwable)e);
            }
        }
    }
}

