/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.pullingMap.service;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.knowledgegraph.data.Neo4jManager;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@MyExceptionHandler
public class EntityAndDependencyGeneratorService {
    private static final Logger log = LoggerFactory.getLogger(EntityAndDependencyGeneratorService.class);
    @Autowired
    KgHelpService kgHelpService;
    @Autowired
    private ActionRepository actionRepository;
    @Autowired
    private DataPickService dataPickService;

    public void BuildAll() throws Exception {
        this.CreateEntitiesAndFields();
        this.CreateFieldMap();
    }

    public void BuildOne(String actionId, String nameSpace) {
        List actionList = this.dataPickService.excludeWithSameCode(this.actionRepository.findByActionId(actionId));
        if (actionList.size() == 0) {
            System.err.println("Failed to build metadata for [" + actionId + "], no action matched found");
            return;
        }
        if (actionList.size() > 1) {
            System.err.println("Failed to build metadata for [" + actionId + "], more than action matched found");
            return;
        }
        for (Action record : actionList) {
            String parametersString = record.getRequest_parameters().toString().replaceAll("\\\\", "");
            List parameters = JSON.parseArray((String)parametersString, ApiDataFieldMetadataDTO.class);
            if (parameters != null) {
                for (ApiDataFieldMetadataDTO parameter : parameters) {
                    this.CreateParameter(parameter, actionId, nameSpace, false, null);
                }
            }
            String responseString = record.getResponse_object().toString().replaceAll("\\\\", "");
            ApiDataFieldMetadataDTO response = (ApiDataFieldMetadataDTO)JSON.parseObject((String)responseString, ApiDataFieldMetadataDTO.class);
            this.CreateResponseEntity(response, actionId, nameSpace, false, null);
        }
    }

    private void CreateEntitiesAndFields() {
        String queryStatement = "MATCH (action:EspAction) return action.actionId as actionId, action.tenantId as tenantId, action.request_parameters as parameters, action.response_object as response";
        List<Map<String, Object>> actionQueryResult = Neo4jManager.getNeo4jManager().ExecuteQuery(queryStatement);
        actionQueryResult.parallelStream().forEach(record -> {
            String actionId = record.get("actionId").toString();
            Boolean singleCase = "NULL".equals(record.get("tenantId"));
            String tenantId = singleCase != false ? record.get("tenantId").toString() : null;
            try {
                System.out.println(Thread.currentThread().getName() + "--->>api createEntitiesAndFields: " + actionId);
                String parametersString = record.get("parameters").toString().replaceAll("\\\\", "");
                List parameters = JSON.parseArray((String)parametersString, ApiDataFieldMetadataDTO.class);
                if (parameters != null) {
                    for (ApiDataFieldMetadataDTO parameter : parameters) {
                        this.CreateParameter(parameter, actionId, "espCommon", singleCase, tenantId);
                    }
                }
                String responseString = record.get("response").toString().replaceAll("\\\\", "");
                ApiDataFieldMetadataDTO response = (ApiDataFieldMetadataDTO)JSON.parseObject((String)responseString, ApiDataFieldMetadataDTO.class);
                this.CreateResponseEntity(response, actionId, "espCommon", singleCase, tenantId);
            }
            catch (Exception e) {
                System.err.println(Thread.currentThread().getName() + "--->>api\u89e3\u6790\u5931\u8d25\uff01\uff01\u6e05\u68c0\u67e5API\u5143\u6570\u636e: " + actionId);
            }
        });
    }

    private void CreateParameter(ApiDataFieldMetadataDTO metadata, String actionId, String nameSpace, Boolean singleCase, String tenantId) {
        if (!metadata.getData_type().equals("object")) {
            String fieldUid = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
            StringBuffer statementBuilder = new StringBuffer();
            if (singleCase.booleanValue()) {
                statementBuilder.append(String.format("match (action:%s) where action.%s=\"%s\" and action.%s=\"%s\" and action.%s=\"%s\"", "Action", "actionId", actionId, "nameSpace", nameSpace, "tenantId", tenantId));
            } else {
                statementBuilder.append(String.format("match (action:%s) where action.%s=\"%s\" and action.%s=\"%s\" and action.%s is null", "Action", "actionId", actionId, "nameSpace", nameSpace, "tenantId"));
            }
            statementBuilder.append(" ");
            statementBuilder.append(String.format("create (field:%s { %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\",version:'1.0'})", "DataField", "name", metadata.getData_name(), "description", metadata.getDescription() == null ? "" : metadata.getDescription().getZh_CN(), "id", fieldUid, "fullPath", metadata.getData_name(), "nameSpace", nameSpace));
            statementBuilder.append(" ");
            statementBuilder.append(String.format("create (action)-[:%s]->(field)", "Requires"));
            this.kgHelpService.executeCyhper(statementBuilder.toString(), new HashMap<String, Object>());
        } else {
            String entityUid = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
            StringBuffer statementBuilder = new StringBuffer();
            if (singleCase.booleanValue()) {
                statementBuilder.append(String.format("match (action:%s) where action.%s=\"%s\" and action.%s=\"%s\" and action.%s=\"%s\"", "Action", "actionId", actionId, "nameSpace", nameSpace, "tenantId", tenantId));
            } else {
                statementBuilder.append(String.format("match (action:%s) where action.%s=\"%s\" and action.%s=\"%s\" and action.%s is null", "Action", "actionId", actionId, "nameSpace", nameSpace, "tenantId"));
            }
            statementBuilder.append(" ");
            statementBuilder.append(String.format("create (entity:%s { %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\",version:'1.0'})", "DataEntity", "name", metadata.getData_name(), "description", metadata.getDescription() == null ? "" : metadata.getDescription().getZh_CN(), "id", entityUid, "fullPath", metadata.getData_name(), "nameSpace", nameSpace));
            statementBuilder.append(" ");
            statementBuilder.append(String.format("create (action)-[:%s]->(entity)", "Requires"));
            this.kgHelpService.executeCyhper(statementBuilder.toString(), new HashMap<String, Object>());
            if (metadata.getField() == null || metadata.getField().size() == 0) {
                return;
            }
            for (ApiDataFieldMetadataDTO fieldDTO : metadata.getField()) {
                if (fieldDTO.getData_type().equals("object")) {
                    this.CreateDetailEntity(fieldDTO, entityUid, metadata.getData_name(), true, actionId, nameSpace);
                    continue;
                }
                this.CreateParameterField(fieldDTO, entityUid, metadata.getData_name(), true, actionId, nameSpace);
            }
        }
    }

    private void CreateResponseEntity(ApiDataFieldMetadataDTO metadata, String actionId, String nameSpace, Boolean singleCase, String tenantId) {
        if (metadata == null) {
            return;
        }
        if (!metadata.getData_type().equals("object")) {
            String fieldUid = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
            StringBuffer statementBuilder = new StringBuffer();
            if (singleCase.booleanValue()) {
                statementBuilder.append(String.format("match (action:%s) where action.%s=\"%s\" and action.%s=\"%s\" and action.%s=\"%s\"", "Action", "actionId", actionId, "nameSpace", nameSpace, "tenantId", tenantId));
            } else {
                statementBuilder.append(String.format("match (action:%s) where action.%s=\"%s\" and action.%s=\"%s\" and action.%s is null", "Action", "actionId", actionId, "nameSpace", nameSpace, "tenantId"));
            }
            statementBuilder.append(" ");
            statementBuilder.append(String.format("create (field:%s { %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\"})", "DataField", "name", metadata.getData_name(), "description", metadata.getDescription() == null ? "" : metadata.getDescription().getZh_CN(), "id", fieldUid, "fullPath", metadata.getData_name(), "nameSpace", nameSpace));
            statementBuilder.append(" ");
            statementBuilder.append(String.format("create (action)-[:%s]->(field)", "Creates"));
            this.kgHelpService.executeCyhper(statementBuilder.toString(), new HashMap<String, Object>());
        } else {
            String entityUid = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
            StringBuffer statementBuilder = new StringBuffer();
            if (singleCase.booleanValue()) {
                statementBuilder.append(String.format("match (action:%s) where action.%s=\"%s\" and action.%s=\"%s\" and action.%s=\"%s\"", "Action", "actionId", actionId, "nameSpace", nameSpace, "tenantId", tenantId));
            } else {
                statementBuilder.append(String.format("match (action:%s) where action.%s=\"%s\" and action.%s=\"%s\" and action.%s is null", "Action", "actionId", actionId, "nameSpace", nameSpace, "tenantId"));
            }
            statementBuilder.append(" ");
            statementBuilder.append(String.format("create (entity:%s { %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\"})", "DataEntity", "name", metadata.getData_name(), "description", metadata.getDescription() == null ? "" : metadata.getDescription().getZh_CN(), "id", entityUid, "fullPath", metadata.getData_name(), "nameSpace", nameSpace));
            statementBuilder.append(" ");
            statementBuilder.append(String.format("create (action)-[:%s]->(entity)", "Creates"));
            this.kgHelpService.executeCyhper(statementBuilder.toString(), new HashMap<String, Object>());
            if (metadata.getField() == null || metadata.getField().size() == 0) {
                return;
            }
            for (ApiDataFieldMetadataDTO fieldDTO : metadata.getField()) {
                if (fieldDTO.getData_type().equals("object")) {
                    this.CreateDetailEntity(fieldDTO, entityUid, metadata.getData_name(), false, actionId, nameSpace);
                    continue;
                }
                this.CreateParameterField(fieldDTO, entityUid, metadata.getData_name(), false, actionId, nameSpace);
            }
        }
    }

    private void CreateDetailEntity(ApiDataFieldMetadataDTO metadata, String parentEntityUid, String path, boolean isRequest, String actionId, String nameSpace) {
        if (!metadata.getData_type().equals("object")) {
            return;
        }
        String entityUid = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
        StringBuffer statementBuilder = new StringBuffer();
        statementBuilder.append(String.format("match (parentEntity:%s) where parentEntity.%s=\"%s\"", "DataEntity", "id", parentEntityUid));
        statementBuilder.append(" ");
        statementBuilder.append(String.format("create (entity:%s { %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\",version:'1.0'})", "DataEntity", "name", metadata.getData_name(), "description", metadata.getDescription() == null ? "" : metadata.getDescription().getZh_CN(), "id", entityUid, "fullPath", path + "." + metadata.getData_name(), "nameSpace", nameSpace));
        statementBuilder.append(" ");
        statementBuilder.append(String.format("create (parentEntity)-[:%s]->(entity)", "Contains"));
        this.kgHelpService.executeCyhper(statementBuilder.toString(), new HashMap<String, Object>());
        if (metadata.getField() == null || metadata.getField().size() == 0) {
            return;
        }
        for (ApiDataFieldMetadataDTO fieldDTO : metadata.getField()) {
            if (fieldDTO.getData_type().equals("object")) {
                this.CreateDetailEntity(fieldDTO, entityUid, path + "." + metadata.getData_name(), isRequest, actionId, nameSpace);
                continue;
            }
            this.CreateParameterField(fieldDTO, entityUid, path + "." + metadata.getData_name(), isRequest, actionId, nameSpace);
        }
    }

    private void CreateParameterField(ApiDataFieldMetadataDTO metadata, String entityId, String path, boolean isRequest, String actionId, String nameSpace) {
        String fieldUid = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
        StringBuffer statementBuilder = new StringBuffer();
        statementBuilder.append(String.format("match (entity:%s) where entity.%s=\"%s\"", "DataEntity", "id", entityId));
        statementBuilder.append(" ");
        statementBuilder.append(String.format("create (field:%s { %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\", %s:\"%s\",version:'1.0'})", "DataField", "name", metadata.getData_name(), "description", metadata.getDescription() == null ? "" : metadata.getDescription().getZh_CN(), "id", fieldUid, "fullPath", path + "." + metadata.getData_name(), "dataType", metadata.getData_type(), "nameSpace", nameSpace));
        statementBuilder.append(" ");
        statementBuilder.append(String.format("create (entity)-[:%s]->(field)", "Contains"));
        this.kgHelpService.executeCyhper(statementBuilder.toString(), new HashMap<String, Object>());
    }

    private void CreateFieldMap() {
        Neo4jManager.getNeo4jManager().ExecuteNoQuery("match(a:EspAction)-[:Requires]->(ae:DataEntity)-[:Contains*0..3]->(ad:DataField) match(b:EspAction)-[:Creates]->(be:DataEntity)-[:Contains*0..3]->(bd:DataField) where ad.fullPath=bd.fullPath and id(a)<>id(b) merge (ad)-[:MapsTo]->(bd)");
    }
}

