/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.report;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kg.authority.AppPurchaseInfo;
import com.digiwin.athena.kg.monitorRule.DynamicCondition;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.kg.monitorRule.StandardPollingRule;
import com.digiwin.athena.kg.report.hz.model.ReportMonitorRuleDTO;
import com.digiwin.athena.knowledgegraph.clients.CacService;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.knowledgegraph.domain.VariableDefinition;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleConfigService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.ActionService;
import com.digiwin.athena.knowledgegraph.service.impl.KgProductService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.service.model.MonitorRuleConfigDTO;
import com.digiwin.athena.knowledgegraph.set.PartParserService;
import com.digiwin.athena.knowledgegraph.set.SetsRelatedInfo;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.TranslateUtils;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MonitorPartParser {
    private static final Logger log = LoggerFactory.getLogger(MonitorPartParser.class);
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    KgHelpService kgHelpService;
    @Autowired
    MonitorRuleRepository monitorRuleRepository;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    CacService cacService;
    @Autowired
    TranslateUtils translateUtils;
    @Autowired
    MonitorRuleConfigService monitorRuleConfigService;
    @Autowired
    PartParserService partParserService;
    @Autowired
    ActionService actionService;
    @Autowired
    KgProductService productService;

    public Object buildReportMonitorRule(ReportMonitorRuleDTO reportMonitorRuleDTO) throws DWBusinessException {
        if (null != reportMonitorRuleDTO) {
            String tenantId = AthenaUtils.getTenantId();
            String tenantVersion = this.kgInnerService.currentTenantVersion();
            SetsRelatedInfo setsRelatedInfo = new SetsRelatedInfo();
            String pluginId = reportMonitorRuleDTO.getCode();
            String appCode = reportMonitorRuleDTO.getAppCode();
            String appName = reportMonitorRuleDTO.getAppName();
            String ruleId = "MonitorRule_" + pluginId;
            String ruleName = reportMonitorRuleDTO.getName() + "_\u4fa6\u6d4b";
            this.deleteIfPresent(appCode, pluginId, ruleId, tenantVersion);
            if (Objects.equals(reportMonitorRuleDTO.getOperate(), "delete")) {
                this.updateTenantMonitorRuleStatus(ruleId);
                return null;
            }
            MonitorRule monitorRule = new MonitorRule();
            monitorRule.setId(ruleId);
            monitorRule.setName(ruleName);
            monitorRule.setVersion(tenantVersion);
            monitorRule.setProductName(reportMonitorRuleDTO.getProductName());
            this.saveMonitorRule(reportMonitorRuleDTO, monitorRule);
            this.buildVariableDefinition(setsRelatedInfo, reportMonitorRuleDTO, ruleId, ruleName, tenantVersion);
            this.buildApplicationRelation(setsRelatedInfo, pluginId, appCode, appName, ruleId, ruleName, tenantVersion);
            this.saveReportRelatedInfo(setsRelatedInfo);
            List<String> tenantIds = this.createMonitorRelation(appCode, ruleId);
            this.saveMonitorRuleByTenant(tenantIds, ruleId, reportMonitorRuleDTO.getProductName());
            HashMap<String, String> profile = new HashMap<String, String>();
            profile.put("tenantId", tenantId);
            DWServiceContext.getContext().setProfile(profile);
            return ruleId;
        }
        return null;
    }

    private void saveReportRelatedInfo(SetsRelatedInfo setsRelatedInfo) throws DWBusinessException {
        String setsRelatedInfoStr = this.translateUtils.translateContent(setsRelatedInfo);
        SetsRelatedInfo relatedInfo = (SetsRelatedInfo)JSON.parseObject((String)setsRelatedInfoStr, SetsRelatedInfo.class);
        this.mongoTemplateSystem.save((Object)relatedInfo.getApplicationRelation());
        this.mongoTemplateSystem.save((Object)relatedInfo.getVariableDefinition());
    }

    private void deleteIfPresent(String appCode, String pluginId, String ruleId, String tenantVersion) {
        if (StringUtils.isNotEmpty((CharSequence)pluginId)) {
            this.deleteMonitorRule(pluginId, tenantVersion);
            this.deleteApplicationRelation(appCode, ruleId, tenantVersion);
            this.deleteVariableDefinition(ruleId, tenantVersion);
        }
    }

    private void saveMonitorRule(ReportMonitorRuleDTO monitorRuleDTO, MonitorRule monitorRule) {
        String jsonString = "CREATE (m:MonitorRule{code:$code,autoRun:true,pluginId:$pluginId,name:$name,actionCommonId:$actionCommonId,scene:$scene,";
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("code", monitorRule.getId());
        props.put("pluginId", monitorRuleDTO.getCode());
        props.put("name", monitorRule.getName());
        props.put("actionCommonId", monitorRuleDTO.getActionId());
        props.put("scene", JSON.toJSONString((Object)monitorRuleDTO.getScene()));
        if (monitorRuleDTO.getStandard_polling_rule() != null) {
            jsonString = jsonString + "standardPollingRule:$standardPollingRule,";
            props.put("standardPollingRule", JSON.toJSONString((Object)monitorRuleDTO.getStandard_polling_rule()));
        }
        jsonString = jsonString + "type:'SCHEDULE',category:'SCHEDULE',actionType:'agileData',version:$version,athena_namespace:$athena_namespace})";
        props.put("version", monitorRule.getVersion());
        props.put("athena_namespace", monitorRuleDTO.getAppCode());
        this.kgHelpService.executeCyhper(jsonString, props);
        MonitorRuleProductConfig monitorRuleProductConfig = new MonitorRuleProductConfig();
        monitorRuleProductConfig.setMonitorRuleId(monitorRule.getId());
        monitorRuleProductConfig.setProductName(monitorRule.getProductName());
        monitorRuleProductConfig.setVersion(monitorRule.getVersion());
        monitorRuleProductConfig.setPluginId(monitorRuleDTO.getCode());
        monitorRuleProductConfig.setIsPollingIds(Boolean.FALSE);
        monitorRuleProductConfig.setAthena_namespace(monitorRuleDTO.getAppCode());
        monitorRuleProductConfig.setActionParamDefine(monitorRuleDTO.getActionParamDefine());
        monitorRuleProductConfig.setRecast(monitorRuleDTO.getRecast());
        this.mongoTemplateSystem.save((Object)monitorRuleProductConfig);
    }

    private List<String> createMonitorRelation(String appCode, String ruleId) {
        List<String> tenantIds = new ArrayList<String>();
        List tenantIdDatas = this.cacService.getAllEffectiveTenantAndAppInfo(appCode).getList();
        if (!CollectionUtils.isEmpty((Collection)tenantIdDatas)) {
            tenantIds = tenantIdDatas.stream().map(AppPurchaseInfo::getTenantId).collect(Collectors.toList());
        }
        return tenantIds;
    }

    private void saveMonitorRuleByTenant(List<String> tenantIds, String ruleId, String productName) {
        if (CollectionUtils.isEmpty(tenantIds)) {
            return;
        }
        for (String id : tenantIds) {
            MonitorRuleConfigDTO config = new MonitorRuleConfigDTO();
            config.setMonitorRuleId(ruleId);
            config.setTenantId(id);
            config.setProductName(productName);
            config.setStatus(1);
            try {
                HashMap<String, String> profile = new HashMap<String, String>();
                profile.put("tenantId", config.getTenantId());
                DWServiceContext.getContext().setProfile(profile);
                this.monitorRuleConfigService.post(config);
            }
            catch (Exception e) {
                log.error("buildReport call post method error : {}", (Throwable)e);
            }
        }
    }

    private void deleteMonitorRule(String pluginId, String tenantVersion) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("pluginId", pluginId);
        param.put("version", tenantVersion);
        String deleteCyhper = "match(m:MonitorRule{pluginId:$pluginId,version:$version}) detach delete m";
        this.kgHelpService.executeCyhper(deleteCyhper, param);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"pluginId").is((Object)pluginId).and("version").is((Object)tenantVersion));
        this.mongoTemplateSystem.remove(query, MonitorRuleProductConfig.class);
    }

    private void buildApplicationRelation(SetsRelatedInfo setsRelatedInfo, String pluginId, String appCode, String appName, String ruleId, String ruleName, String tenantVersion) {
        ApplicationRelation applicationRelation = new ApplicationRelation();
        applicationRelation.setAppCode(appCode);
        applicationRelation.setAppName(appName);
        applicationRelation.setCode(ruleId);
        applicationRelation.setType("monitorRule");
        applicationRelation.setName(ruleName);
        applicationRelation.setVersion(tenantVersion);
        applicationRelation.setApplication(appCode);
        applicationRelation.setAthena_namespace(appCode);
        applicationRelation.setPluginId(pluginId);
        setsRelatedInfo.setApplicationRelation(applicationRelation);
    }

    private void deleteApplicationRelation(String appCode, String ruleId, String tenantVersion) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode).and("version").is((Object)tenantVersion).and("code").is((Object)ruleId));
        this.mongoTemplateSystem.remove(query, ApplicationRelation.class);
    }

    private void buildVariableDefinition(SetsRelatedInfo setsRelatedInfo, ReportMonitorRuleDTO reportMonitorRuleDTO, String ruleId, String ruleName, String tenantVersion) {
        StandardPollingRule rules = reportMonitorRuleDTO.getStandard_polling_rule();
        String timeType = this.getDefaultValue(rules);
        VariableDefinition variableDefinition = new VariableDefinition();
        variableDefinition.setName(ruleName);
        variableDefinition.setDescription(ruleName);
        variableDefinition.setIsExecute(Boolean.TRUE);
        variableDefinition.setCode(ruleId);
        variableDefinition.setForceOpen(Boolean.FALSE);
        variableDefinition.setIsOperation(Boolean.FALSE);
        variableDefinition.setDefaultValue(timeType);
        variableDefinition.setExtendData(ruleId);
        variableDefinition.setFormat("rule;yyyyMMdd HH:mm;switch");
        variableDefinition.setReadOnly(Boolean.FALSE);
        variableDefinition.setRequired(Boolean.TRUE);
        variableDefinition.setExecutable(1);
        variableDefinition.setSequence(1);
        variableDefinition.setDisplayType("PERIODIC");
        variableDefinition.setCategory("period");
        variableDefinition.setIsSimulation(Boolean.FALSE);
        variableDefinition.setVersion(tenantVersion);
        variableDefinition.setAthena_namespace(reportMonitorRuleDTO.getAppCode());
        variableDefinition.setPluginId(reportMonitorRuleDTO.getCode());
        DynamicCondition visibleCondition = new DynamicCondition();
        visibleCondition.setType("SINGLE");
        visibleCondition.setOp("IN");
        visibleCondition.setLeft("productName");
        visibleCondition.setLeftValueType("SYSTEM");
        visibleCondition.setRightValueType("CONSTANT");
        visibleCondition.setRight(reportMonitorRuleDTO.getProductName());
        variableDefinition.setVisibleCondition(visibleCondition);
        setsRelatedInfo.setVariableDefinition(variableDefinition);
    }

    private String getDefaultValue(StandardPollingRule rules) {
        String timeType = "";
        if (null != rules.getRepeat_type()) {
            if (rules.getRepeat_type() == 1) {
                timeType = "F";
            }
            if (rules.getRepeat_type() == 2) {
                timeType = "H";
            }
            if (rules.getRepeat_type() == 3) {
                timeType = "D";
            }
            timeType = timeType + rules.getFrequency();
        } else if (rules.getWeekly() != null) {
            HashMap<String, String> week = new HashMap<String, String>();
            week.put("SU", "7");
            week.put("MO", "1");
            week.put("TU", "2");
            week.put("WE", "3");
            week.put("TH", "4");
            week.put("FR", "5");
            week.put("SA", "6");
            timeType = "W" + (String)week.get(rules.getByday());
        } else if (rules.getMonthly() != null) {
            timeType = "M" + rules.getBymonthday();
        }
        return timeType + ";" + rules.getStart_time().substring(0, 16).replaceAll("-", "") + ";" + Boolean.TRUE;
    }

    private void deleteVariableDefinition(String ruleId, String tenantVersion) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"code").is((Object)ruleId).and("version").is((Object)tenantVersion));
        this.mongoTemplateSystem.remove(query, VariableDefinition.class);
    }

    private void updateTenantMonitorRuleStatus(String ruleId) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"monitorRuleId").is((Object)ruleId);
        query.addCriteria((CriteriaDefinition)criteria);
        List monitorRuleTenantConfigList = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        try {
            if (!CollectionUtils.isEmpty((Collection)monitorRuleTenantConfigList)) {
                for (MonitorRuleTenantConfig monitorRuleTenantConfig : monitorRuleTenantConfigList) {
                    this.monitorRuleConfigService.putDisable(monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(), monitorRuleTenantConfig.getEocMap());
                }
            }
        }
        catch (Exception e) {
            log.error("Report  updateTenantMonitorRuleStatus error: {}", (Throwable)e);
        }
    }
}

