/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.rule.dao;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.knowledgegraph.data.MongoEntityBaseDAO;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class MonitorRuleProductConfigDAO
extends MongoEntityBaseDAO {
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplate;

    public MonitorRuleProductConfig findProductConfigByRuleIdAndProductName(String ruleId, String productName, String tenantVersion) throws DWBusinessException {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        conditions.put("monitorRuleId", ruleId);
        conditions.put("productName", productName);
        MonitorRuleProductConfig result = super.findOne(conditions, tenantVersion, MonitorRuleProductConfig.class);
        if (result != null) {
            return result;
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.noAvailableConfiguration", ruleId, productName));
    }
}

