/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.knowledgegraph.domain.TenantEntity;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.filter.LoginInfo;
import com.digiwin.athena.knowledgegraph.po.DapResponse;
import com.digiwin.athena.knowledgegraph.po.dap.DapResponseBase;
import com.digiwin.athena.knowledgegraph.utils.Utils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class AppMetaCaller {
    private static final Logger log = LoggerFactory.getLogger(AppMetaCaller.class);
    @Value(value="${dataMapUrl}")
    private String dataMapUrl;
    private String kgHost = null;

    public static void main(String[] args) {
        TenantEntity entity1 = new TenantEntity();
        entity1.setId("id1");
        entity1.setTenantId("tenant001");
        DapResponse<TenantEntity> d1 = new DapResponse<TenantEntity>();
        d1.setDuration(100);
        d1.setResponse(entity1);
        String str = JSON.toJSONString(d1);
        System.out.println(str);
        DapResponse d2 = (DapResponse)JSON.parseObject((String)str, DapResponse.class);
        TenantEntity i1 = (TenantEntity)((Object)d2.getResponse());
        System.out.println((Object)i1);
        System.out.println(((Object)((Object)i1)).getClass());
    }

    public static Map<String, Object> of(String k, Object v) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(k, v);
        return map;
    }

    public <T extends DapResponseBase> T call(String service, String httpMethod, Map<String, Object> params, Class<T> c) {
        DapResponseBase result = null;
        try {
            LoginInfo loginInfo;
            String url = this.dataMapUrl + service;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (null == this.kgHost) {
                try {
                    URL u = new URL(this.dataMapUrl);
                    this.kgHost = u.getHost();
                }
                catch (MalformedURLException e) {
                    log.error(e.toString());
                }
            }
            headers.put("Host", this.kgHost);
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String routerKey = request.getHeader("routerKey");
            String token = request.getHeader("token");
            String locale = request.getHeader("locale");
            String designer = request.getHeader("designer");
            String securityToken = request.getHeader("security-token");
            String reportKey = request.getHeader("reportKey");
            if (null == token) {
                token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
            }
            if (null == token) {
                token = DWServiceContext.getContext().getToken();
            }
            if (null == token && null != (loginInfo = KgFilter.getLoginInfo())) {
                token = loginInfo.getToken();
                routerKey = loginInfo.getRouterKey();
                locale = loginInfo.getLocale();
                designer = loginInfo.getDesigner();
            }
            if (null != routerKey) {
                headers.put("routerKey", routerKey);
            }
            if (null != token) {
                headers.put("token", token);
            }
            if (null != locale) {
                headers.put("locale", locale);
            }
            if (null != designer) {
                headers.put("designer", designer);
            }
            if (null != securityToken) {
                headers.put("security-token", securityToken);
            }
            if (null != reportKey) {
                headers.put("reportKey", reportKey);
            }
            result = "post".equalsIgnoreCase(httpMethod) ? (DapResponseBase)Utils.postJson(url, headers, params, c) : (DapResponseBase)Utils.get(url, headers, params, c);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw new RemoteAccessException("io\u5f02\u5e38");
            }
            log.warn("request to datamap failed.", (Throwable)e);
        }
        if (null == result) {
            try {
                return (T)((DapResponseBase)c.newInstance());
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (result.getStatus() == 404 || result.getStatus() == 500 || result.getStatus() == 502 || result.getStatus() == 400) {
            log.error("request to datamap failed, status:{}", (Object)result.getErrorMessage());
            throw new DWRuntimeException("P.KG.503.0017", "call datamap error");
        }
        return (T)result;
    }

    public DapResponse requestDataMap(String service, String httpMethod, Map<String, Object> params, String routerKey) {
        DapResponse result = new DapResponse();
        try {
            String url = this.dataMapUrl + service;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (null == this.kgHost) {
                try {
                    URL u = new URL(this.dataMapUrl);
                    this.kgHost = u.getHost();
                }
                catch (MalformedURLException e) {
                    log.error(e.toString());
                }
            }
            headers.put("Host", this.kgHost);
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            if (StringUtils.isEmpty((CharSequence)routerKey)) {
                routerKey = request.getHeader("routerKey");
            }
            String token = request.getHeader("token");
            String locale = request.getHeader("locale");
            String designer = request.getHeader("designer");
            String securityToken = request.getHeader("security-token");
            String reportKey = request.getHeader("reportKey");
            if (null == token) {
                token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
            }
            if (null != routerKey) {
                headers.put("routerKey", routerKey);
            }
            if (null != token) {
                headers.put("token", token);
            }
            if (null != locale) {
                headers.put("locale", locale);
            }
            if (null != designer) {
                headers.put("designer", designer);
            }
            if (null != securityToken) {
                headers.put("security-token", securityToken);
            }
            if (null != reportKey) {
                headers.put("reportKey", reportKey);
            }
            result = "post".equalsIgnoreCase(httpMethod) ? Utils.postJson(url, headers, params, DapResponse.class) : Utils.get(url, headers, params, DapResponse.class);
        }
        catch (Exception e) {
            log.warn("request to datamap failed," + e.getMessage());
        }
        if (null == result) {
            return new DapResponse();
        }
        return result;
    }

    public DapResponse requestDataMapAnonymous(String service, String httpMethod, Map<String, Object> params) {
        DapResponse result = new DapResponse();
        try {
            String url = this.dataMapUrl + service;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (null == this.kgHost) {
                try {
                    URL u = new URL(this.dataMapUrl);
                    this.kgHost = u.getHost();
                }
                catch (MalformedURLException e) {
                    log.error(e.toString());
                }
            }
            headers.put("Host", this.kgHost);
            try {
                HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                String routerKey = request.getHeader("routerKey");
                if (null != routerKey) {
                    headers.put("routerKey", routerKey);
                }
            }
            catch (Exception e) {
                log.warn("requestDataMapAnonymous get request null");
            }
            result = "post".equalsIgnoreCase(httpMethod) ? Utils.postJson(url, headers, params, DapResponse.class) : Utils.get(url, headers, params, DapResponse.class);
        }
        catch (Exception e) {
            log.error("request to datamap anonymous failed.", (Throwable)e);
        }
        if (null == result) {
            return new DapResponse();
        }
        if (result.getStatus() == 404 || result.getStatus() == 500 || result.getStatus() == 502) {
            throw new DWRuntimeException("P.KG.503.0017", "anonymous call datamap error");
        }
        return result;
    }
}

