/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.knowledgegraph.domain.common.OperationUnit;
import com.digiwin.athena.knowledgegraph.domain.task.EmailView;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.filter.LoginInfo;
import com.digiwin.athena.knowledgegraph.po.DapResponse;
import com.digiwin.athena.knowledgegraph.po.ViewRequest;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import com.digiwin.athena.knowledgegraph.utils.Utils;
import com.digiwin.athena.knowledgegraph.vo.TaskCardFieldRequest;
import com.digiwin.athena.knowledgegraph.vo.TaskCardFieldVO;
import com.digiwin.athena.preset.Rule;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class DataMapService {
    private static final Logger log = LoggerFactory.getLogger(DataMapService.class);
    @Value(value="${dataMapUrl}")
    private String dataMapUrl;
    private String kgHost = null;
    WebClient webClient;
    @Autowired
    private IamService iamService;
    @Autowired
    RestTemplate restTemplate;

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public Object getProject(String code, OperationUnit eocInfo) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("projectCode", code);
        params.put("eocInfo", eocInfo);
        DapResponse resp = this.requestDataMap("/view/project", "post", params);
        return resp.getResponse();
    }

    public List<TaskCardFieldVO> postViewTaskCardField(TaskCardFieldRequest request) {
        DapResponse dapResponse = this.requestDataMap("/view/taskCardField", "post", (Map<String, Object>)JSON.parseObject((String)JSON.toJSONString((Object)request)));
        Object response = dapResponse.getResponse();
        return JSON.parseArray((String)JSON.toJSONString(response), TaskCardFieldVO.class);
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public Object getAppCardFields(String application) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("application", application);
        DapResponse resp = this.requestDataMap("/view/appCardFields", "post", params);
        return resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public Object postFixProject(String code) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", code);
        DapResponse resp = this.requestDataMap("/project/fixProjectByCode", "post", params);
        return resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public Object getProject(String code) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("projectCode", code);
        DapResponse resp = this.requestDataMap("/view/project", "post", params);
        return resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public Object geMonitorConfig(String dataEventId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", dataEventId);
        DapResponse resp = this.requestDataMap("/project/monitorConfig", "get", params);
        return resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public List getProjectsBasic(Map<String, Object> query) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("query", query);
        DapResponse resp = this.requestDataMap("/view/projectListBasic", "post", params);
        return (List)resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public Object getBatchProjects(Map<String, Object> query) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("query", query);
        DapResponse resp = this.requestDataMap("/batch/projects", "post", params);
        return resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public List getProjectsByAuthorityPrefix(String authorityPrefix) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("authorityPrefix", authorityPrefix);
        DapResponse resp = this.requestDataMap("/project/projectByAuthorityPrefix", "get", params);
        return (List)resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public Object getBatchTasks(Map<String, Object> query) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("query", query);
        DapResponse resp = this.requestDataMap("/batch/tasks", "post", params);
        return resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public List getProjects(Map<String, Object> query) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("query", query);
        DapResponse resp = this.requestDataMap("/view/projectList", "post", params);
        return (List)resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public List getTaskList(Map<String, Object> query) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("query", query);
        DapResponse resp = this.requestDataMap("/view/taskList", "post", params);
        return (List)resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public Object getTasks(String code) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("projectCode", code);
        DapResponse resp = this.requestDataMap("/view/tasks", "post", params);
        return resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public Object getTask(String projectCode, String taskCode, String pageCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("projectCode", projectCode);
        params.put("taskCode", taskCode);
        params.put("pageCode", pageCode);
        DapResponse resp = this.requestDataMap("/view/task", "post", params);
        return resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public Object getTask(String projectCode, String taskCode, String pageCode, OperationUnit operationUnit) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("projectCode", projectCode);
        params.put("taskCode", taskCode);
        params.put("pageCode", pageCode);
        params.put("eocInfo", operationUnit);
        DapResponse resp = this.requestDataMap("/view/task", "post", params);
        return resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public List getCodeNames(List<String> codes, boolean isTask) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, List<String>> query = new HashMap<String, List<String>>();
        query.put("code", codes);
        params.put("query", query);
        String url = isTask ? "/view/taskNamesByCodes" : "/view/projectNamesByCodes";
        DapResponse resp = this.requestDataMap(url, "post", params);
        return (List)resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public Object getTaskName(String taskCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", taskCode);
        DapResponse resp = this.requestDataMap("/task/taskByCode", "get", params);
        return resp.getResponse();
    }

    public Object initTenantInfo(String tenantId, String application, String routerKey) {
        return this.initTenantInfo(tenantId, application, routerKey, null);
    }

    public Object initTenantInfo(String tenantId, String application, String routerKey, String appCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", tenantId);
        params.put("application", application);
        params.put("appCode", appCode);
        DapResponse resp = this.requestDataMap("/tenant/init", "post", params, routerKey);
        return resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public List approveTaskList(Map<String, Object> query) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("query", query);
        DapResponse resp = this.requestDataMap("/view/taskListApprove", "post", params);
        return (List)resp.getResponse();
    }

    public void updateProject(Object pro) {
        JSONObject params = JSON.parseObject((String)JSON.toJSONString((Object)pro));
        this.requestDataMap("/view/updateProject", "post", (Map<String, Object>)params);
    }

    public void updateProject(Object pro, OperationUnit operationUnit) {
        JSONObject params = JSON.parseObject((String)JSON.toJSONString((Object)pro));
        params.put("eocInfo", JSON.parseObject((String)JSON.toJSONString((Object)operationUnit)));
        this.requestDataMap("/view/updateProject", "post", (Map<String, Object>)params);
    }

    public void updateTask(Object pro) {
        JSONObject params = JSON.parseObject((String)JSON.toJSONString((Object)pro));
        this.requestDataMap("/view/updateTask", "post", (Map<String, Object>)params);
    }

    public void updateTaskScheduleFlag(Object pro) {
        JSONObject params = JSON.parseObject((String)JSON.toJSONString((Object)pro));
        this.requestDataMap("/view/updateTaskScheduleFlag", "post", (Map<String, Object>)params);
    }

    public void postTaskSchedule(Object pro) {
        JSONObject params = JSON.parseObject((String)JSON.toJSONString((Object)pro));
        this.requestDataMap("/view/taskSchedule", "post", (Map<String, Object>)params);
    }

    public void postDeleteTaskSchedule(Object pro) {
        JSONObject params = JSON.parseObject((String)JSON.toJSONString((Object)pro));
        this.requestDataMap("/view/deleteTaskSchedule", "post", (Map<String, Object>)params);
    }

    public void updateTask(Object pro, OperationUnit operationUnit) {
        JSONObject params = JSON.parseObject((String)JSON.toJSONString((Object)pro));
        params.put("eocInfo", JSON.parseObject((String)JSON.toJSONString((Object)operationUnit)));
        this.requestDataMap("/view/updateTask", "post", (Map<String, Object>)params);
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public List getProjectTasks(String projectCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("projectCode", projectCode);
        DapResponse resp = this.requestDataMap("/view/projectTasks", "post", params);
        return (List)resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public List batchProjects(List<String> codes) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("codes", codes);
        DapResponse resp = this.requestDataMap("/batch/projectBasic", "post", params);
        return (List)resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public Object batchTaskDetails(Set<String> codes, String pageCode, OperationUnit operationUnit) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("codes", codes);
        params.put("pageCode", pageCode);
        params.put("eocInfo", operationUnit);
        DapResponse resp = this.requestDataMap("/batch/taskDetails", "post", params);
        return resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public List batchTasks(List<String> codes) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("codes", codes);
        DapResponse resp = this.requestDataMap("/batch/taskBasic", "post", params);
        return (List)resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public List postEmails(ViewRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskCode", request.getTaskCode());
        DapResponse resp = this.requestDataMap("/email/emails", "post", params);
        return (List)resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public List postTasksByProject(Map<String, Object> params) {
        DapResponse resp = this.requestDataMap("/view/tasksByProject", "post", params);
        return (List)resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public Object postEmailTemplateCode(ViewRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskCode", request.getTaskCode());
        DapResponse resp = this.requestDataMap("/email/emailTemplateCode", "post", params);
        return resp.getResponse();
    }

    public List postEmailUpdate(EmailView view) {
        JSONObject params = JSON.parseObject((String)JSON.toJSONString((Object)((Object)view)));
        DapResponse resp = this.requestDataMap("/email/emailUpdate", "post", (Map<String, Object>)params);
        return (List)resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public Object postActivityStartTargetCode(Map<String, Object> query) {
        DapResponse resp = this.requestDataMap("/view/activityStartTargetCode", "post", query);
        return resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public Object projectInputData(String code) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("projectCode", code);
        DapResponse resp = this.requestDataMap("/view/projectInputData", "post", params);
        return resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public Object taskInputData(String code) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskCode", code);
        DapResponse resp = this.requestDataMap("/view/taskInputData", "post", params);
        return resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public List projectExcludeMainlineByAppCode(String appCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appCode", appCode);
        DapResponse resp = this.requestDataMap("/business/projectExcludeMainlineByAppCode", "post", params);
        return (List)resp.getResponse();
    }

    public Object enableTenantServiceCapability(String code) {
        return this.updateTenantServiceCapabilityStatus(code, 0);
    }

    public Object disableTenantServiceCapability(String code) {
        return this.updateTenantServiceCapabilityStatus(code, 1);
    }

    private Object updateTenantServiceCapabilityStatus(String code, int status) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("scCode", code);
        params.put("status", status);
        DapResponse resp = this.requestDataMap("/word/UpdateTenantServiceCapabilityStatus", "post", params);
        return resp.getResponse();
    }

    public Object bindMechanismDecision(String tenantId, String mechanismCode, String mechanismTheoryCode, String mechanismComponentCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", tenantId);
        params.put("mechanismCode", mechanismCode);
        params.put("mechanismTheoryCode", mechanismTheoryCode);
        params.put("mechanismComponentCode", mechanismComponentCode);
        DapResponse resp = this.requestDataMap("/mechanism/bindMechanism", "post", params);
        return resp.getResponse();
    }

    public Object unbindMechanismDecision(String tenantId, String mechanismCode, String mechanismTheoryCode, String mechanismComponentCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", tenantId);
        params.put("mechanismCode", mechanismCode);
        params.put("mechanismTheoryCode", mechanismTheoryCode);
        params.put("mechanismComponentCode", mechanismComponentCode);
        DapResponse resp = this.requestDataMap("/mechanism/unBindMechanism", "post", params);
        return resp.getResponse();
    }

    public Object mechanismPluginMerge(String tenantId, List<String> pluginIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", tenantId);
        params.put("pluginIds", pluginIds);
        DapResponse resp = this.requestDataMap("/plugin/merge", "post", params);
        return resp.getResponse();
    }

    public DapResponse bindMechanismComponent(Map<String, Object> query) {
        DapResponse resp = this.requestDataMap("/mechanism/componentApply", "post", query);
        return resp;
    }

    public DapResponse unBindMechanismComponent(Map<String, Object> query) {
        DapResponse resp = this.requestDataMap("/mechanism/componentUnApply", "post", query);
        return resp;
    }

    public DapResponse filterListByBusinessCondition(Map<String, Object> query) {
        DapResponse resp = this.requestDataMap("/mechanism/filterListByBusinessCondition", "post", query);
        return resp;
    }

    public void unBindMechanismComponentWithTenantId(Map<String, Object> query, String tenantId) throws IOException {
        String url = this.dataMapUrl + "/mechanism/componentUnApply";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (null == this.kgHost) {
            URL u = new URL(this.dataMapUrl);
            this.kgHost = u.getHost();
        }
        headers.put("Host", this.kgHost);
        headers.put("routerKey", tenantId);
        headers.put("token", this.iamService.getIntegrationToken(tenantId, null));
        DapResponse result = Utils.postJson(url, headers, query, DapResponse.class);
        if (result.getStatus() == 404 || result.getStatus() == 500 || result.getStatus() == 502) {
            throw new DWRuntimeException("P.KG.503.0017", "call datamap error");
        }
    }

    public List postCardConfig(Map<String, Object> query, String pageCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageCode", pageCode);
        params.put("query", query);
        DapResponse resp = this.requestDataMap("/view/cardConfig", "post", params);
        return (List)resp.getResponse();
    }

    public List postCardConfig(Map<String, Object> query) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("query", query);
        DapResponse resp = this.requestDataMap("/view/cardConfig", "post", params);
        return (List)resp.getResponse();
    }

    public List postCardConfig4Order(Map<String, Object> query) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("query", query);
        params.put("type", "all");
        DapResponse resp = this.requestDataMap("/view/cardConfig", "post", params);
        return (List)resp.getResponse();
    }

    public Object getPageUIElement(String code, String activityId, String pageCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", code);
        params.put("taskCode", activityId);
        params.put("pageCode", pageCode);
        DapResponse resp = this.requestDataMap("/view/pageUIElement", "post", params);
        return resp.getResponse();
    }

    public Object getSystemHooks(List<String> activityIds, List<String> pageCodes) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskCodes", activityIds);
        params.put("pageCodes", pageCodes);
        DapResponse resp = this.requestDataMap("/view/systemHooks", "post", params);
        return resp.getResponse();
    }

    public Object postQueryApiResult(String api, Map<String, Object> params) {
        DapResponse resp = this.requestDataMap(api, "post", params);
        return resp.getResponse();
    }

    public Object queryBatchCodeAndName(List<String> codes, String type, String version) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("codes", codes);
        params.put("type", type);
        params.put("version", version);
        DapResponse resp = this.requestDataMapAnonymous("/batch/queryCodeAndName", "post", params);
        return resp.getResponse();
    }

    public DapResponse requestDataMap(String service, String httpMethod, Map<String, Object> params) {
        String url = this.dataMapUrl + service;
        HttpMethod method = HttpMethod.POST;
        if ("get".equalsIgnoreCase(httpMethod)) {
            method = HttpMethod.GET;
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
            if (params != null && !params.isEmpty()) {
                params.forEach((x$0, xva$1) -> builder.queryParam(x$0, new Object[]{xva$1}));
            }
            url = builder.toUriString();
        }
        HttpHeaders headers = new HttpHeaders();
        Utils.requiredHeaders(headers);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity exchange = this.restTemplate.exchange(url, method, httpEntity, DapResponse.class, new Object[0]);
        return (DapResponse)exchange.getBody();
    }

    public DapResponse requestDataMap2(String service, String httpMethod, Map<String, Object> params) {
        DapResponse result = new DapResponse();
        try {
            LoginInfo loginInfo;
            String url = this.dataMapUrl + service;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (null == this.kgHost) {
                try {
                    URL u = new URL(this.dataMapUrl);
                    this.kgHost = u.getHost();
                }
                catch (MalformedURLException e) {
                    log.error(e.toString());
                }
            }
            headers.put("Host", this.kgHost);
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String routerKey = request.getHeader("routerKey");
            String token = request.getHeader("token");
            String locale = request.getHeader("locale");
            String designer = request.getHeader("designer");
            String securityToken = request.getHeader("security-token");
            if (null == token) {
                token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
            }
            if (null == token && null != (loginInfo = KgFilter.getLoginInfo())) {
                token = loginInfo.getToken();
                routerKey = loginInfo.getRouterKey();
                locale = loginInfo.getLocale();
                designer = loginInfo.getDesigner();
            }
            if (null != routerKey) {
                headers.put("routerKey", routerKey);
            }
            if (null != token) {
                headers.put("token", token);
            }
            if (null != locale) {
                headers.put("locale", locale);
            }
            if (null != designer) {
                headers.put("designer", designer);
            }
            if (null != securityToken) {
                headers.put("security-token", securityToken);
            }
            result = "post".equalsIgnoreCase(httpMethod) ? Utils.postJson(url, headers, params, DapResponse.class) : Utils.get(url, headers, params, DapResponse.class);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw new RemoteAccessException("io\u5f02\u5e38");
            }
            log.warn("request to datamap failed.", (Throwable)e);
        }
        if (null == result) {
            return new DapResponse();
        }
        if (result.getStatus() == 404 || result.getStatus() == 500 || result.getStatus() == 502 || result.getStatus() == 400) {
            log.error("request to datamap failed, status:{}", (Object)result.getErrorMessage());
            throw new DWRuntimeException("P.KG.503.0017", "call datamap error uri:" + service + ",msg:" + result.getErrorMessage());
        }
        return result;
    }

    public DapResponse requestDataMap(String service, String httpMethod, Map<String, Object> params, String routerKey) {
        DapResponse result = new DapResponse();
        try {
            String url = this.dataMapUrl + service;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (null == this.kgHost) {
                try {
                    URL u = new URL(this.dataMapUrl);
                    this.kgHost = u.getHost();
                }
                catch (MalformedURLException e) {
                    log.error(e.toString());
                }
            }
            headers.put("Host", this.kgHost);
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            if (StringUtils.isEmpty((CharSequence)routerKey)) {
                routerKey = request.getHeader("routerKey");
            }
            String token = request.getHeader("token");
            String locale = request.getHeader("locale");
            String designer = request.getHeader("designer");
            String securityToken = request.getHeader("security-token");
            if (null == token) {
                token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
            }
            if (null != routerKey) {
                headers.put("routerKey", routerKey);
            }
            if (null != token) {
                headers.put("token", token);
            }
            if (null != locale) {
                headers.put("locale", locale);
            }
            if (null != designer) {
                headers.put("designer", designer);
            }
            if (null != securityToken) {
                headers.put("security-token", securityToken);
            }
            result = "post".equalsIgnoreCase(httpMethod) ? Utils.postJson(url, headers, params, DapResponse.class) : Utils.get(url, headers, params, DapResponse.class);
        }
        catch (Exception e) {
            log.warn("request to datamap failed," + e.getMessage());
        }
        if (null == result) {
            return new DapResponse();
        }
        return result;
    }

    public DapResponse requestDataMapAnonymous(String service, String httpMethod, Map<String, Object> params) {
        DapResponse result = new DapResponse();
        try {
            String url = this.dataMapUrl + service;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (null == this.kgHost) {
                try {
                    URL u = new URL(this.dataMapUrl);
                    this.kgHost = u.getHost();
                }
                catch (MalformedURLException e) {
                    log.error(e.toString());
                }
            }
            headers.put("Host", this.kgHost);
            try {
                HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                String routerKey = request.getHeader("routerKey");
                if (null != routerKey) {
                    headers.put("routerKey", routerKey);
                }
            }
            catch (Exception e) {
                log.warn("requestDataMapAnonymous get request null");
            }
            result = "post".equalsIgnoreCase(httpMethod) ? Utils.postJson(url, headers, params, DapResponse.class) : Utils.get(url, headers, params, DapResponse.class);
        }
        catch (Exception e) {
            log.error("request to datamap anonymous failed.", (Throwable)e);
        }
        if (null == result) {
            return new DapResponse();
        }
        if (result.getStatus() == 404 || result.getStatus() == 500 || result.getStatus() == 502) {
            throw new DWRuntimeException("P.KG.503.0017", "anonymous call datamap error");
        }
        return result;
    }

    public Object allApproveActivityByApp(String applicationCode, String locale) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("applicationCode", applicationCode);
        params.put("locale", locale);
        DapResponse resp = this.requestDataMap("/activity/allApproveActivityByApp", "get", params);
        return resp.getResponse();
    }

    public Object getDefinitionWithMultiLanguage(String taskId, String pageCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskId", taskId);
        params.put("pageCode", pageCode);
        DapResponse resp = this.requestDataMap("/task/definitionWithMultiLanguage", "get", params);
        return resp.getResponse();
    }

    public Object getDefinitionByTaskId(String taskId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskId", taskId);
        DapResponse resp = this.requestDataMap("/task/definitionByTaskId", "get", params);
        return resp.getResponse();
    }

    public Object postDefinitionByTaskIdAndOperationUnit(Map<String, Object> query) {
        DapResponse resp = this.requestDataMap("/task/definitionByTaskIdAndOperationUnit", "post", query);
        return resp.getResponse();
    }

    public Object getActivityDefinition(String activityId, String pageCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("activityId", activityId);
        params.put("pageCode", pageCode);
        DapResponse resp = this.requestDataMap("/task/activityDefinition", "get", params);
        return resp.getResponse();
    }

    public Object getActivityDefinitionWithMergeRule(String taskId, String activityId, String pageCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskId", taskId);
        params.put("activityId", activityId);
        params.put("pageCode", pageCode);
        DapResponse resp = this.requestDataMap("/task/activityDefinitionWithMergeRule", "get", params);
        return resp.getResponse();
    }

    public Object getActivityConfig(String taskId, String activityId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskId", taskId);
        params.put("activityId", activityId);
        DapResponse resp = this.requestDataMap("/task/activityConfig", "get", params);
        return resp.getResponse();
    }

    public Object postActivityDefinition(Map<String, Object> query) {
        DapResponse resp = this.requestDataMap("/task/activityDefinition", "post", query);
        return resp.getResponse();
    }

    public Object getManualList() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        DapResponse resp = this.requestDataMap("/task/manualList", "get", params);
        return resp.getResponse();
    }

    public Object getManualListMobile() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        DapResponse resp = this.requestDataMap("/task/manualListMobile", "get", params);
        return resp.getResponse();
    }

    public Object getDetail(String taskId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskId", taskId);
        DapResponse resp = this.requestDataMap("/task/detail", "get", params);
        return resp.getResponse();
    }

    public Object postTaskByApp(Map<String, Object> query) {
        DapResponse resp = this.requestDataMap("/task/taskByApp", "post", query);
        return resp.getResponse();
    }

    public Object postActivityByTask(Map<String, Object> params) {
        DapResponse resp = this.requestDataMap("/activity/activityByTask", "post", params);
        return resp.getResponse();
    }

    @Retryable(value={RemoteAccessException.class}, maxAttempts=5, backoff=@Backoff(delay=50L, multiplier=2.0))
    public Object findTaskFromUser(Map<String, Object> query) {
        DapResponse resp = this.requestDataMap("/task/findTaskFromUser", "post", query);
        return resp.getResponse();
    }

    public Object saveRules(List<Rule> rules) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rules", rules);
        DapResponse resp = this.requestDataMap("/rule/batchSave", "post", params);
        return resp.getResponse();
    }
}

