/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kg.action.ActionConfig;
import com.digiwin.athena.kg.action.ActionLabel;
import com.digiwin.athena.kg.action.ActionMetadataDTO;
import com.digiwin.athena.kg.action.EspActionMetadataDTO;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.kg.action.TaskDataGroupAction;
import com.digiwin.athena.kg.report.hz.model.metaData.DataSourceStructDTO;
import com.digiwin.athena.kg.report.hz.model.metaData.FieldDTO;
import com.digiwin.athena.kg.report.hz.model.pushMetadata.ActionExecutionParam;
import com.digiwin.athena.kmservice.action.execution.ProductNameGetter;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionParamDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionPathDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionParamTypeEnum;
import com.digiwin.athena.kmservice.action.execution.model.ApiDataFieldDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ESPActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.MultiPathActionExecutionParamDTO;
import com.digiwin.athena.kmservice.action.execution.model.PullingActionExecutionParamDTO;
import com.digiwin.athena.kmservice.action.execution.model.StartDataEventActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.StartProcessActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.StartServiceComposerActionExecutionDTO;
import com.digiwin.athena.kmservice.action.metadata.ActionMetadataManager;
import com.digiwin.athena.kmservice.action.metadata.model.ApiDataMetadataDTO;
import com.digiwin.athena.kmservice.action.metadata.model.ApiMetadataDataDTO;
import com.digiwin.athena.kmservice.action.model.LogDataDto;
import com.digiwin.athena.kmservice.action.model.LogDto;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.service.ActionExecutionPathService;
import com.digiwin.athena.kmservice.utils.IAMUtils;
import com.digiwin.athena.kmservice.utils.MetadataTranslator;
import com.digiwin.athena.knowledgegraph.action.execution.ActionQueryService;
import com.digiwin.athena.knowledgegraph.action.metadata.ApiSynchronizer;
import com.digiwin.athena.knowledgegraph.action.model.ActionMetadataDTOConvertor;
import com.digiwin.athena.knowledgegraph.action.model.ActionParamDTO;
import com.digiwin.athena.knowledgegraph.action.model.DutyRoleDTO;
import com.digiwin.athena.knowledgegraph.action.model.ProcessParamDTO;
import com.digiwin.athena.knowledgegraph.action.model.TaskActionDefinitionDTO;
import com.digiwin.athena.knowledgegraph.action.transrule.TransformActionRuleManager;
import com.digiwin.athena.knowledgegraph.app.AppTenantVersionService;
import com.digiwin.athena.knowledgegraph.data.MongoEntityBaseDAO;
import com.digiwin.athena.knowledgegraph.data.Neo4jManager;
import com.digiwin.athena.knowledgegraph.domain.Task;
import com.digiwin.athena.knowledgegraph.domain.application.AppTenantVersion;
import com.digiwin.athena.knowledgegraph.domain.task.DueDateTimeDistance;
import com.digiwin.athena.knowledgegraph.po.DimensionParam;
import com.digiwin.athena.knowledgegraph.service.IActionService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.AppService;
import com.digiwin.athena.knowledgegraph.service.impl.SceneService;
import com.digiwin.athena.knowledgegraph.service.impl.TaskService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.support.AbstractionHandler;
import com.digiwin.athena.knowledgegraph.svcomposition.bpm.BPMConverter;
import com.digiwin.athena.knowledgegraph.svcomposition.bpm.NodeType;
import com.digiwin.athena.knowledgegraph.svcomposition.graph.Edge;
import com.digiwin.athena.knowledgegraph.svcomposition.graph.MatrixGraph;
import com.digiwin.athena.knowledgegraph.svcomposition.graph.OldGraphHelper;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Lang
@Service
@MyExceptionHandler
public class ActionService
implements IActionService {
    private static final Logger log = LoggerFactory.getLogger(ActionService.class);
    public static final String DESCRIPTION_FILED = "Description";
    public static final String REMARK_FILED = "Remark";
    private final String SYS_TENANT = "SYSTEM";
    @Autowired
    ActionExecutionPathService actionExecutionPathService;
    @Autowired
    ActionMetadataManager actionMetadataManager;
    @Autowired
    ApiSynchronizer apiSynchronizer;
    @Autowired
    IAMUtils iamUtils;
    @Autowired
    ActionRepository actionRepository;
    @Autowired
    ProductNameResolver productNameResolver;
    @Autowired
    ActionQueryService actionQueryService;
    @Autowired
    AbstractionHandler abstractionHandler;
    @Autowired
    TaskService taskService;
    @Autowired
    TenantService tenantService;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    AppService appService;
    @Autowired
    AppTenantVersionService appTenantVersionService;
    @Autowired
    MongoEntityBaseDAO mongoEntityBaseDAO;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain1")
    SessionFactory sessionFactoryDomain1;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain2")
    SessionFactory sessionFactoryDomain2;
    @Autowired
    private SceneService sceneService;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    SessionFactory neo4jSessionFactory;
    @Autowired
    private DataPickService dataPickService;
    private static boolean mockSwitch = false;

    @Override
    public Object getDefinition(String actionId) throws Exception {
        if (actionId.equals("requisition_actionid")) {
            TaskActionDefinitionDTO dto = new TaskActionDefinitionDTO();
            dto.setActionId(actionId);
            dto.setType("task");
            DutyRoleDTO dutyRole = new DutyRoleDTO();
            dutyRole.setRoleId("176591553090112");
            dutyRole.setRoleName("\u91c7\u8d2d\u5458");
            dto.setDutyRole(dutyRole);
            dto.setTaskId("task_StartProductionOnSchedule");
            dto.setTaskName("\u5982\u671f\u5f00\u5de5\u4efb\u52a1");
            dto.setProcessId("AthenaRequisitionToPurchase");
            ArrayList<ProcessParamDTO> processParams = new ArrayList<ProcessParamDTO>();
            ProcessParamDTO purchaseNoParam = new ProcessParamDTO();
            purchaseNoParam.setName("purchase_no");
            purchaseNoParam.setType("actionParam");
            purchaseNoParam.setValue("purchase_no");
            processParams.add(purchaseNoParam);
            ProcessParamDTO timeDistanceDTO = new ProcessParamDTO();
            timeDistanceDTO.setName("time_distance");
            timeDistanceDTO.setType("mechanismVariable");
            timeDistanceDTO.setValue("var_time_distance");
            processParams.add(timeDistanceDTO);
            dto.setProcessParams(processParams);
            ArrayList<ActionParamDTO> actionParams = new ArrayList<ActionParamDTO>();
            ActionParamDTO actionParamDTO = new ActionParamDTO();
            actionParamDTO.setName("purchase_no");
            actionParamDTO.setDescription("\u8bf7\u8d2d\u5355\u53f7");
            actionParamDTO.setData_type("string");
            actionParamDTO.setRequired(true);
            actionParams.add(actionParamDTO);
            dto.setActionParams(actionParams);
            return dto;
        }
        DWServiceResult result = DWServiceResultBuilder.build((boolean)false, (String)I18nUtils.getValue("knowledgegraph.actionNotFound2", new Object[0]), (Object)actionId);
        return result;
    }

    @Override
    public Object delete(String actionId) throws Exception {
        String queryStatement = "MATCH (action:Action) where action.actionId='" + actionId + "' delete action";
        Neo4jManager.getNeo4jManager().ExecuteNoQuery(queryStatement);
        return actionId;
    }

    @Override
    public Object getActionRule(String ruleId) throws Exception {
        String tenantVersion;
        String tenantId = AthenaUtils.getTenantId();
        Object ruleObj = new TransformActionRuleManager().getRuleById(ruleId, tenantId, tenantVersion = this.kgInnerService.getTenantVersion(tenantId));
        if (null == ruleObj) {
            ruleObj = new TransformActionRuleManager().getRuleById(ruleId, "SYSTEM", tenantVersion);
        }
        if (null == ruleObj) {
            ruleObj = new TransformActionRuleManager().getRuleById(ruleId, null, tenantVersion);
        }
        if (null == ruleObj) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.ruleNotFound", ruleId));
        }
        List<ActionLabel> actionAndLabelsByRuleId = this.dataPickService.filterByIndividual(this.actionRepository.getActionAndLabelsByRuleId(ruleId), tenantId, actionLabel -> actionLabel.getAction().getNameSpace());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(actionAndLabelsByRuleId)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.ruleLabelNotFound", ruleId));
        }
        ActionLabel actionLabel2 = actionAndLabelsByRuleId.get(0);
        if (actionLabel2.getAction() instanceof TaskDataGroupAction) {
            TaskDataGroupAction action = (TaskDataGroupAction)actionLabel2.getAction();
            String taskId = action.getTaskId();
            Object taskObj = this.taskService.getDefinitionWithMultiLanguage(taskId);
            Task task = (Task)((Object)JSON.parseObject((String)JSON.toJSONString((Object)taskObj), Task.class));
            DueDateTimeDistance dateTimeDistance = null;
            dateTimeDistance = StringUtils.equals((CharSequence)task.getType(), (CharSequence)"FEEDBACK") ? task.getDateTimeDistance() : task.getDueDateTimeDistance();
            if (StringUtils.equals((CharSequence)dateTimeDistance.getType(), (CharSequence)"MULTI_DAY") || StringUtils.equals((CharSequence)dateTimeDistance.getType(), (CharSequence)"DAY") || StringUtils.equals((CharSequence)dateTimeDistance.getType(), (CharSequence)"WEEK_DAY")) {
                String startDate = "";
                String format = "";
                String count = "";
                if (StringUtils.equals((CharSequence)dateTimeDistance.getType(), (CharSequence)"MULTI_DAY")) {
                    startDate = dateTimeDistance.getStartDate();
                    format = dateTimeDistance.getFormat();
                    count = dateTimeDistance.getCount();
                } else if (StringUtils.equals((CharSequence)dateTimeDistance.getType(), (CharSequence)"DAY")) {
                    startDate = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    format = "yyyy-MM-dd";
                    count = "1";
                } else {
                    String timeDistanceBegin = StringUtils.isEmpty((CharSequence)dateTimeDistance.getTimeDistanceBegin()) ? "1" : dateTimeDistance.getTimeDistanceBegin();
                    startDate = LocalDate.now().with(DayOfWeek.of(Integer.parseInt(timeDistanceBegin))).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    format = "yyyy-MM-dd";
                    count = "7";
                }
                JSONObject object = JSON.parseObject((String)JSON.toJSONString((Object)ruleObj));
                JSONArray step = object.getJSONArray("step");
                for (int i = 0; i < step.size(); ++i) {
                    if (!StringUtils.equals((CharSequence)step.getJSONObject(i).getString("technique"), (CharSequence)"calculate")) continue;
                    JSONArray rule = step.getJSONObject(i).getJSONArray("rule");
                    for (int j = 0; j < rule.size(); ++j) {
                        if (!StringUtils.equals((CharSequence)rule.getJSONObject(j).getString("calcType"), (CharSequence)"NumberOfIntervalByDay")) continue;
                        rule.getJSONObject(j).put("fieldB", (Object)startDate);
                        rule.getJSONObject(j).put("formatB", (Object)format);
                        rule.getJSONObject(j).put("intervalDays", (Object)Integer.valueOf(count));
                    }
                }
                return object;
            }
        }
        return ruleObj;
    }

    @Override
    public String getProductName(String serviceName) throws Exception {
        Map profile = DWServiceContext.getContext().getProfile();
        String tenantId = profile.getOrDefault("tenantId", "");
        return this.productNameResolver.getProductName(serviceName, tenantId);
    }

    @Override
    public Object getMetadata(String actionId) throws Exception {
        Map profile = DWServiceContext.getContext().getProfile();
        String tenantId = profile.getOrDefault("tenantId", "");
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        EspActionMetadataDTO responseDTO = this.actionMetadataManager.getActionMetadata(actionId, tenantId, tenantVersion);
        GetActionLocaleResponseDTO localeResponseDTO = ActionMetadataDTOConvertor.convertToGetActionLocaleResponseDTO(responseDTO);
        ProductNameGetter.MdcProductNameGetter productNameGetter = null;
        if (actionId.startsWith("esp_")) {
            productNameGetter = new ProductNameGetter.MdcProductNameGetter(this.productNameResolver, actionId.substring(4), tenantId);
        }
        MetadataTranslator.translateField((GetActionLocaleResponseDTO)localeResponseDTO, (ActionMetadataDTO)responseDTO, (String)localeStr, productNameGetter);
        return localeResponseDTO;
    }

    @Override
    public Object getCompositAction(String actionId, String tenantId) throws Exception {
        String queryStatement = "MATCH (action:TestCompositAction)-[:Contains]->(eleAction)\nwhere action.actionId='" + actionId + "'\nreturn eleAction,labels(eleAction) as eleLabels";
        List<Map<String, Object>> actionQueryResult = Neo4jManager.getNeo4jManager().ExecuteQuery(queryStatement);
        if (actionQueryResult.size() == 0) {
            throw new DWBusinessException("P.KG.500.0001 action not found: " + actionId);
        }
        List actions = actionQueryResult.stream().map(item -> {
            HashMap map = new HashMap(3);
            map.putAll((Map)item.get("eleAction"));
            map.put("eleLabels", item.get("eleLabels"));
            return map;
        }).collect(Collectors.toList());
        List nodes = JSONObject.parseArray((String)JSONObject.toJSONString(actions), HashMap.class);
        for (int i = 0; i < nodes.size(); ++i) {
            ((HashMap)nodes.get(i)).put("index", i);
        }
        Map<String, Map> actionMap = nodes.stream().collect(Collectors.toMap(x -> x.get("actionId").toString(), x -> x));
        Set<String> actionIds = nodes.stream().map(item -> (String)item.get("actionId")).collect(Collectors.toSet());
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        for (HashMap item2 : nodes) {
            String queryActionId = (String)item2.get("actionId");
            OldGraphHelper graphHelperTemplate = new OldGraphHelper();
            graphHelperTemplate.processNodeAndEdges(actionMap, actionIds, edgeList, item2, queryActionId);
            item2.put("type", NodeType.SERVICE);
        }
        MatrixGraph<Map> graph = new MatrixGraph<Map>(nodes.toArray(new HashMap[nodes.size()]), edgeList.toArray(new Edge[edgeList.size()]));
        BPMConverter.addStartEndNodes(graph);
        graph.trimEdge();
        BPMConverter.addGateway(graph);
        return BPMConverter.convertToBPMJson(graph, tenantId);
    }

    @Override
    public Object getMetadata(String actionId, String language) throws Exception {
        mockSwitch = !mockSwitch;
        return null;
    }

    @Override
    public Object put(String apiName, String productName, String productVersion) throws Exception {
        this.apiSynchronizer.SynchronizeOne(apiName, productName, productVersion);
        return null;
    }

    @Override
    public Object put(String tenantId) throws Exception {
        this.apiSynchronizer.SynchronizeAll(tenantId);
        return null;
    }

    @Override
    public Object postQueryExecutionPath(String actionId, String tenant, List<String> existingActionParams, List<String> existingSysParams) throws Exception {
        return this.actionExecutionPathService.postQueryExecutionPath(actionId, tenant, existingActionParams, existingSysParams);
    }

    @Override
    public Object postQueryExecutionPath(String actionId, String tenantId, List<String> existingActionParams) throws Exception {
        return this.postQueryExecutionPath(actionId, tenantId, existingActionParams, null);
    }

    @Override
    public Object postActionConfig(DimensionParam data) throws Exception {
        if (data.getActionId() == null) {
            throw new IllegalArgumentException(I18nUtils.getValue("knowledgegraph.actionNull", new Object[0]));
        }
        ActionConfig config = this.actionRepository.queryActionConfig(data.getActionId());
        this.abstractionHandler.dealWithAbstraction(config, data);
        return config;
    }

    @Override
    public Object postQueryExecutionInfo(String actionId) throws Exception {
        Map profile = DWServiceContext.getContext().getProfile();
        String tenantId = profile.getOrDefault("tenantId", "");
        ActionExecutionDTO actionExecutionDTO = this.actionQueryService.queryActionExeution(actionId, tenantId);
        if (null == actionExecutionDTO) {
            return new ActionExecutionDTO();
        }
        this.postActionExecutionProcessor(Arrays.asList(actionExecutionDTO), tenantId, null);
        this.processAppCodeVersion(actionExecutionDTO);
        return actionExecutionDTO;
    }

    private void processAppCodeVersion(ActionExecutionDTO actionExecutionDTO) throws DWBusinessException {
        ApplicationRelation relation = this.appService.getApplicationByTypeAndCode("action", actionExecutionDTO.getActionId());
        if (relation != null) {
            actionExecutionDTO.setAppCode(relation.getAppCode());
            AppTenantVersion version = this.appTenantVersionService.postQueryVersion(relation.getAppCode());
            if (version != null) {
                actionExecutionDTO.setAppVersion(version.getAppVersion());
            }
        }
    }

    private void postActionExecutionProcessor(List<ActionExecutionDTO> actionExecutions, String tenantId, List<String> existsSysParamsWithoutRoot) throws Exception {
        for (ActionExecutionDTO e : actionExecutions) {
            List params;
            String token;
            Map headers;
            if (e instanceof ESPActionExecutionDTO) {
                String productName = this.productNameResolver.getProductName(((ESPActionExecutionDTO)e).getServiceName(), tenantId);
                ((ESPActionExecutionDTO)e).setProductName(productName);
            } else if (e instanceof StartProcessActionExecutionDTO) {
                headers = DWServiceContext.getContext().getRequestHeader();
                token = headers == null ? null : (String)headers.get("token");
                ((StartProcessActionExecutionDTO)e).setLocale(this.iamUtils.getTenantLocale(token));
            } else if (e instanceof StartDataEventActionExecutionDTO) {
                headers = DWServiceContext.getContext().getRequestHeader();
                token = headers == null ? null : (String)headers.get("token");
                ((StartDataEventActionExecutionDTO)e).setLocale(this.iamUtils.getTenantLocale(token));
            } else if (e instanceof StartServiceComposerActionExecutionDTO) {
                headers = DWServiceContext.getContext().getRequestHeader();
                token = headers == null ? null : (String)headers.get("token");
                ((StartServiceComposerActionExecutionDTO)e).setLocale(this.iamUtils.getTenantLocale(token));
            }
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(existsSysParamsWithoutRoot) || !org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(params = e.getParams()))) continue;
            for (ActionExecutionParamDTO executionParamDTO : params) {
                String value = !(executionParamDTO instanceof MultiPathActionExecutionParamDTO) && executionParamDTO.getValue().startsWith("$.") ? executionParamDTO.getValue().substring(2) : executionParamDTO.getValue();
                if (!existsSysParamsWithoutRoot.contains(value)) continue;
                executionParamDTO.setType(ActionParamTypeEnum.SYSPARAM);
            }
        }
    }

    private List<String> removeActionParamRoot(List<String> existsActionParams) {
        ArrayList<String> actionParamsWithoutRoot = new ArrayList<String>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(existsActionParams)) {
            existsActionParams.forEach(e -> {
                if (e.startsWith("$.")) {
                    actionParamsWithoutRoot.add(e.substring(2));
                } else {
                    actionParamsWithoutRoot.add((String)e);
                }
            });
        }
        return actionParamsWithoutRoot;
    }

    @Override
    public Object getEspApi() throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        String locale = DWResourceBundleUtils.getCurrentLocale().toString();
        List espServiceVOS = this.actionRepository.queryEspService(tenantId, locale, tenantVersion);
        return espServiceVOS;
    }

    @Override
    public Object getProduct(String serviceName) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        this.productNameResolver.getCloudProductNamesWithRetry(tenantId, 3);
        List cloudProductNamesWithRetry = this.productNameResolver.getCloudProductNamesWithRetry(serviceName, tenantId, 3);
        return cloudProductNamesWithRetry;
    }

    @Override
    public Object postSetProduct(String serviceName, String productName) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        this.productNameResolver.setProductNames(serviceName, tenantId, productName);
        return "success";
    }

    @Override
    public Object postQueryActionInfo(String actionId) throws Exception {
        Map profile = DWServiceContext.getContext().getProfile();
        String tenantId = profile.getOrDefault("tenantId", "");
        ActionDefinitionDTO actionDefinitionDTO = this.actionQueryService.queryActionMetadataInfo(actionId, tenantId);
        return actionDefinitionDTO;
    }

    @Override
    public List<String> getTenantProductList() throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        List cloudProductNamesWithRetry = this.productNameResolver.getCloudProductNamesWithRetryAfterEocSet(tenantId, 3);
        return cloudProductNamesWithRetry;
    }

    @Override
    public Object getSourceIdKey(String ruleCode) throws Exception {
        String tenantVersion = this.kgInnerService.getTenantVersion(AthenaUtils.getTenantId());
        return this.actionRepository.getSourceIdKey(ruleCode, tenantVersion);
    }

    @Override
    public Object postQueryExecutionInfo(List<String> actionIds) throws Exception {
        Map profile = DWServiceContext.getContext().getProfile();
        String tenantId = profile.getOrDefault("tenantId", "");
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<ActionExecutionDTO> actionExecutionDTOS = this.actionQueryService.queryActionExeutionList(actionIds, tenantId, tenantVersion);
        this.postActionExecutionProcessor(actionExecutionDTOS, tenantId, null);
        return actionExecutionDTOS;
    }

    @Override
    public Object postAddMdcApiMetadataToNeo4j(String messageStr) {
        StringBuffer stringBuffer;
        ApiMetadataDataDTO espApiMetadata = (ApiMetadataDataDTO)JSON.parseObject((String)messageStr, ApiMetadataDataDTO.class);
        String apiName = espApiMetadata.getApi_name();
        String apiVersion = espApiMetadata.getApi_version();
        String remark_cn = espApiMetadata.getRemark().getZh_CN();
        String remark_tw = espApiMetadata.getRemark().getZh_TW();
        remark_cn = remark_cn.replaceAll("'", "");
        remark_tw = remark_tw.replaceAll("'", "");
        String desc_cn = espApiMetadata.getDescription().getZh_CN();
        String desc_tw = espApiMetadata.getDescription().getZh_TW();
        String url = espApiMetadata.getUrl() == null ? "" : espApiMetadata.getUrl();
        String invokeType = espApiMetadata.getType();
        String lastUpdateTime = espApiMetadata.getLastUpdateTime();
        LocalDateTime currentDateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String currentTime = currentDateTime.format(formatter);
        Boolean idempotency = espApiMetadata.getIdempotency();
        String actionId = "esp_" + apiName;
        String deployVersion = "1.0";
        ApiDataMetadataDTO dataMetadata = espApiMetadata.getData_metadata();
        List fieldsOfParameter = new ArrayList();
        if (dataMetadata.getRequest().getBody().getField() != null && ((ApiDataFieldMetadataDTO)dataMetadata.getRequest().getBody().getField().get(0)).getField() != null) {
            fieldsOfParameter = ((ApiDataFieldMetadataDTO)dataMetadata.getRequest().getBody().getField().get(0)).getField();
        }
        ArrayList<ApiDataFieldMetadataDTO> fieldRequestObjects = new ArrayList<ApiDataFieldMetadataDTO>();
        for (ApiDataFieldMetadataDTO fieldOfParameter : fieldsOfParameter) {
            if (fieldOfParameter.getData_name().equals("enterprise_no") || fieldOfParameter.getData_name().equals("site_no") || fieldOfParameter.getData_name().equals("call_id")) continue;
            fieldRequestObjects.add(fieldOfParameter);
        }
        Action oneByActionId = null;
        List actions = this.dataPickService.excludeWithSameCode(this.actionRepository.findByActionIdAndVersion(actionId, deployVersion));
        if (!CollectionUtils.isEmpty(actions)) {
            oneByActionId = (Action)actions.get(0);
        }
        if (!ObjectUtils.isEmpty(oneByActionId)) {
            try {
                List request_parameters = JSONArray.parseArray((String)oneByActionId.getRequest_parameters(), ApiDataFieldMetadataDTO.class);
                this.putEnumKey(fieldRequestObjects, request_parameters);
            }
            catch (Exception e) {
                log.error("postAddMdcApiMetadataToNeo4j parseObject error:{}", (Throwable)e);
            }
        }
        String request_str = JSON.toJSONString(fieldRequestObjects, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
        List fieldsOfResponse = dataMetadata.getResponse_success().getBody().getField();
        ApiDataFieldMetadataDTO fieldReponseObject = null;
        for (ApiDataFieldMetadataDTO fieldOfResponse : fieldsOfResponse) {
            if (!fieldOfResponse.getData_name().equals("parameter")) continue;
            fieldReponseObject = fieldOfResponse;
            break;
        }
        String response_str = "";
        if (fieldReponseObject != null && fieldReponseObject.getField().size() > 0) {
            Optional<ApiDataFieldMetadataDTO> findObject = fieldReponseObject.getField().stream().filter(field -> "object".equals(field.getData_type())).findFirst();
            if (findObject.isPresent()) {
                ApiDataFieldMetadataDTO apiDataFieldMetadataDTO = findObject.get();
                if (!ObjectUtils.isEmpty((Object)oneByActionId)) {
                    try {
                        ApiDataFieldMetadataDTO response_object = (ApiDataFieldMetadataDTO)JSONObject.parseObject((String)oneByActionId.getResponse_object(), ApiDataFieldMetadataDTO.class);
                        if (response_object != null) {
                            this.putEnumKey(apiDataFieldMetadataDTO, response_object);
                        }
                    }
                    catch (Exception e) {
                        log.error("postAddMdcApiMetadataToNeo4j parseObject error:{}", (Throwable)e);
                    }
                }
                response_str = JSON.toJSONString((Object)apiDataFieldMetadataDTO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
            } else {
                response_str = JSON.toJSONString(fieldReponseObject.getField().get(0), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
            }
        }
        ArrayList<String> executeNeo4jScripts = new ArrayList<String>();
        if (ObjectUtils.isEmpty((Object)oneByActionId)) {
            log.info("MdcApiMetadata Create\uff1a{}", (Object)actionId);
            stringBuffer = new StringBuffer();
            stringBuffer.append("Create (action:Action:EspAction {");
            stringBuffer.append("actionId:'");
            stringBuffer.append(actionId);
            stringBuffer.append("', url:'");
            stringBuffer.append(url);
            stringBuffer.append("', serviceName:'");
            stringBuffer.append(apiName);
            stringBuffer.append("', serviceVersion:'");
            stringBuffer.append(apiVersion);
            stringBuffer.append("', actionName:'");
            stringBuffer.append(desc_cn);
            stringBuffer.append("', actionName_tw:'");
            stringBuffer.append(desc_tw);
            stringBuffer.append("', desc:'");
            stringBuffer.append(remark_cn);
            stringBuffer.append("', desc_tw:'");
            stringBuffer.append(remark_tw);
            stringBuffer.append("', request_parameters:'");
            stringBuffer.append(request_str.replaceAll("'", ""));
            stringBuffer.append("', response_object:'");
            stringBuffer.append(response_str.replaceAll("'", ""));
            stringBuffer.append("', invokeType:'");
            stringBuffer.append(invokeType);
            stringBuffer.append("', lastUpdateTime:'");
            stringBuffer.append(lastUpdateTime);
            stringBuffer.append("', updateTime:'");
            stringBuffer.append(currentTime);
            stringBuffer.append("', idempotency:");
            stringBuffer.append(idempotency);
            stringBuffer.append(", version:'");
            stringBuffer.append(deployVersion);
            stringBuffer.append("', nameSpace:'");
            stringBuffer.append("espCommon");
            stringBuffer.append("'})");
            executeNeo4jScripts.add(StringEscapeUtils.escapeJava((String)stringBuffer.toString()));
        } else {
            log.info("MdcApiMetadata Update\uff1a{}", (Object)actionId);
            stringBuffer = new StringBuffer();
            stringBuffer.append("Match (action:Action:EspAction {");
            stringBuffer.append("actionId:'");
            stringBuffer.append(actionId);
            stringBuffer.append("', version:'");
            stringBuffer.append(deployVersion);
            stringBuffer.append("'})  set action.url='");
            stringBuffer.append(url);
            stringBuffer.append("', action.serviceName='");
            stringBuffer.append(apiName);
            stringBuffer.append("', action.serviceVersion='");
            stringBuffer.append(apiVersion);
            stringBuffer.append("', action.actionName='");
            stringBuffer.append(desc_cn);
            stringBuffer.append("', action.actionName_tw='");
            stringBuffer.append(desc_tw);
            stringBuffer.append("', action.desc='");
            stringBuffer.append(remark_cn);
            stringBuffer.append("', action.desc_tw='");
            stringBuffer.append(remark_tw);
            stringBuffer.append("', action.request_parameters='");
            stringBuffer.append(request_str.replaceAll("'", ""));
            stringBuffer.append("', action.response_object='");
            stringBuffer.append(response_str.replaceAll("'", ""));
            stringBuffer.append("', action.invokeType='");
            stringBuffer.append(invokeType);
            stringBuffer.append("', action.lastUpdateTime='");
            stringBuffer.append(lastUpdateTime);
            stringBuffer.append("', action.updateTime='");
            stringBuffer.append(currentTime);
            stringBuffer.append("', action.idempotency=");
            stringBuffer.append(idempotency);
            stringBuffer.append(", action.version='");
            stringBuffer.append(deployVersion);
            stringBuffer.append("', action.nameSpace='");
            stringBuffer.append("espCommon");
            stringBuffer.append("'");
            executeNeo4jScripts.add(StringEscapeUtils.escapeJava((String)stringBuffer.toString()));
        }
        this.executeNeo4jScript(executeNeo4jScripts, this.sessionFactoryDomain1);
        this.executeNeo4jScript(executeNeo4jScripts, this.sessionFactoryDomain2);
        return "success";
    }

    private void executeNeo4jScript(List<String> executeNeo4jScripts, SessionFactory sessionFactory) {
        if (CollectionUtils.isEmpty(executeNeo4jScripts)) {
            return;
        }
        if (sessionFactory == null) {
            return;
        }
        Session session = sessionFactory.openSession();
        try (Transaction transaction = session.beginTransaction();){
            for (String str : executeNeo4jScripts) {
                session.query(str, new HashMap());
            }
            transaction.commit();
        }
        catch (Exception e) {
            log.error("executeNeo4jScript error:{}", (Throwable)e);
        }
        session.clear();
    }

    private void putEnumKey(ApiDataFieldMetadataDTO toApiDataFieldMeta, ApiDataFieldMetadataDTO fromApiDataFieldMeta) {
        if (toApiDataFieldMeta.getData_name().equals(fromApiDataFieldMeta.getData_name())) {
            if ("object".equals(toApiDataFieldMeta.getData_type()) && "object".equals(fromApiDataFieldMeta.getData_type())) {
                List toApiSubDataFieldMeta = toApiDataFieldMeta.getField();
                List fromApiSubDataFieldMeta = fromApiDataFieldMeta.getField();
                this.putEnumKey(toApiSubDataFieldMeta, fromApiSubDataFieldMeta);
            } else {
                toApiDataFieldMeta.setEnum_key(fromApiDataFieldMeta.getEnum_key());
            }
        }
    }

    private void putEnumKey(List<ApiDataFieldMetadataDTO> toApiDataFieldMetas, List<ApiDataFieldMetadataDTO> fromApiDataFieldMetas) {
        toApiDataFieldMetas.forEach(toApiDataFieldMetadata -> {
            Optional<ApiDataFieldMetadataDTO> fromApiDataFieldMeta = fromApiDataFieldMetas.stream().filter(fromApiDataFieldMetadata -> fromApiDataFieldMetadata.getData_name().equals(toApiDataFieldMetadata.getData_name())).findFirst();
            if (fromApiDataFieldMeta.isPresent()) {
                this.putEnumKey((ApiDataFieldMetadataDTO)toApiDataFieldMetadata, fromApiDataFieldMeta.get());
            }
        });
    }

    private void logTrace(String actionId, boolean success, String errorMsg) {
        LogDataDto logDataDto = new LogDataDto(actionId, "\u884c\u52a8actionId", "config", "actionId");
        String message = success ? "\u77e5\u8bc6\u56fe\u8c31\u6c42\u53d6\u884c\u52a8\u903b\u8f91\u56fe\u8c31\u6210\u529f" : "\u77e5\u8bc6\u56fe\u8c31\u6c42\u53d6\u884c\u52a8\u903b\u8f91\u56fe\u8c31\u5931\u8d25,\u5931\u8d25\u4fe1\u606f:" + errorMsg;
        LogDto logDto = new LogDto(message, Arrays.asList(logDataDto));
        if (success) {
            log.info(logDto.toString());
        } else {
            log.error(logDto.toString());
        }
    }

    private void handleDistinctActions(List<ActionExecutionDTO> actions) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(actions)) {
            actions.forEach(action -> {
                List params = action.getParams();
                ArrayList<ActionExecutionParamDTO> uniqueParams = new ArrayList<ActionExecutionParamDTO>();
                HashSet<String> distinctParams = new HashSet<String>();
                for (ActionExecutionParamDTO param : params) {
                    if (param instanceof PullingActionExecutionParamDTO) {
                        PullingActionExecutionParamDTO pullingParam = (PullingActionExecutionParamDTO)param;
                        String key = this.createKey(pullingParam.getName(), pullingParam.getType().toString(), pullingParam.getValue(), pullingParam.getSource());
                        if (distinctParams.contains(key)) continue;
                        uniqueParams.add(param);
                        distinctParams.add(key);
                        continue;
                    }
                    String key = this.createKey(param.getName(), param.getType().toString(), param.getValue(), null);
                    if (distinctParams.contains(key)) continue;
                    uniqueParams.add(param);
                    distinctParams.add(key);
                }
                action.setParams(uniqueParams);
            });
        }
    }

    private String createKey(String name, String type, String value, String source) {
        return name + type + value + (source != null ? source : "");
    }

    @Override
    public String postFindLastNodeShapeType(String nodeType, String reportRelationFir, String reportRelationSec, String reportRelationThi, String reportRelationFou) {
        if (StringUtils.isEmpty((CharSequence)nodeType)) {
            return null;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        String query = "MATCH (rd:ReportDesign {nodeType: $nodeType})";
        param.put("nodeType", nodeType);
        if ("2".equals(nodeType)) {
            if (reportRelationFir != null) {
                query = query + "-[:LINK*]->(vis:ReportDistributionVariable {reportRelationFir: $reportRelationFir})";
                param.put("reportRelationFir", reportRelationFir);
                if ("1".equals(reportRelationFir) && StringUtils.isNotEmpty((CharSequence)reportRelationSec)) {
                    query = query + "-[:LINK]->(rel:ReportDistributionRelation {reportRelationSec: $reportRelationSec})";
                    param.put("reportRelationSec", reportRelationSec);
                }
            }
        } else if ("4".equals(nodeType)) {
            if (reportRelationFir != null) {
                query = query + "-[:LINK*]->(vis:ReportRelationVariable {reportRelationFir: $reportRelationFir})";
                param.put("reportRelationFir", reportRelationFir);
            }
        } else if ("3".equals(nodeType)) {
            if (StringUtils.isNotEmpty((CharSequence)reportRelationFir)) {
                query = query + "-[:LINK]->(relationFir:ReportConstituteRelationFir {reportRelationFir: $reportRelationFir})";
                param.put("reportRelationFir", reportRelationFir);
            }
            if (StringUtils.isNotEmpty((CharSequence)reportRelationSec) && "\u968f\u65f6\u95f4\u53d8\u5316".equals(reportRelationSec)) {
                query = query + "-[:LINK]->(relationSec:ReportConstituteRelationSec {reportRelationSec: $reportRelationSec})";
                param.put("reportRelationSec", reportRelationSec);
            }
            if (StringUtils.isNotEmpty((CharSequence)reportRelationThi)) {
                query = query + "-[:LINK]->(relationThi:ReportConstituteRelationThi {reportRelationThi: $reportRelationThi})";
                param.put("reportRelationThi", reportRelationThi);
            }
        } else if ("1".equals(nodeType)) {
            if (StringUtils.isNotEmpty((CharSequence)reportRelationFir)) {
                query = query + "-[:LINK]->(relationFir:ReportCompareRelationFir {reportRelationFir: $reportRelationFir})";
                param.put("reportRelationFir", reportRelationFir);
            }
            if (StringUtils.isNotEmpty((CharSequence)reportRelationSec)) {
                query = query + "-[:LINK]->(relationSec:ReportCompareRelationSec {reportRelationSec: $reportRelationSec})";
                param.put("reportRelationSec", reportRelationSec);
            }
            if (StringUtils.isNotEmpty((CharSequence)reportRelationThi) && (!"\u57fa\u4e8e\u5206\u7c7b".equals(reportRelationFir) || "\u57fa\u4e8e\u5206\u7c7b".equals(reportRelationFir) && !"\u6bcf\u9879\u76ee2\u4e2a\u53d8\u91cf".equals(reportRelationSec))) {
                query = query + "-[:LINK]->(relationThi:ReportCompareRelationThi {reportRelationThi: $reportRelationThi})";
                param.put("reportRelationThi", reportRelationThi);
            }
            if (StringUtils.isNotEmpty((CharSequence)reportRelationFou) && "\u5c11\u6570\u5206\u7c7b".equals(reportRelationThi)) {
                query = query + "-[:LINK]->(relationFou:ReportCompareRelationFou {reportRelationFou: $reportRelationFou})";
                param.put("reportRelationFou", reportRelationFou);
            }
        }
        query = query + "-[:LINK*]->(shape:ReportShape) RETURN shape.type AS shapeType LIMIT 1";
        Session session = this.neo4jSessionFactory.openSession();
        Result result = session.query(query, param);
        Iterable iterableResult = (Iterable)result.queryResults();
        Iterator iterator = iterableResult.iterator();
        if (iterator.hasNext()) {
            Map record = (Map)iterator.next();
            if (Objects.nonNull(record.get("shapeType"))) {
                return "3".equals(nodeType) ? "\u997c\u56fe" : record.get("shapeType").toString();
            }
            return null;
        }
        return null;
    }

    @Override
    public Object postMetaDataStruct(List<String> actionIds) throws Exception {
        ArrayList<DataSourceStructDTO> dataSources = new ArrayList<DataSourceStructDTO>();
        String tenantId = AthenaUtils.getTenantId();
        List actionExecutionParams = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"actionId").in(actionIds)), ActionExecutionParam.class);
        Map<String, List> actionExecutionParamMap = actionExecutionParams.stream().collect(Collectors.toMap(ActionExecutionParam::getActionId, a -> a.getExecutionParam()));
        Iterator<String> iterator = actionIds.iterator();
        while (iterator.hasNext()) {
            String actionId;
            ActionExecutionPathDTO pathDTO = (ActionExecutionPathDTO)this.postQueryExecutionPath(actionId, tenantId, org.apache.commons.collections.CollectionUtils.isEmpty((Collection)actionExecutionParamMap.get(actionId = iterator.next())) ? new ArrayList() : actionExecutionParamMap.get(actionId), new ArrayList<String>());
            List actionData = pathDTO.getActionMetadatas();
            dataSources.add(this.convertActionDefinitionToDataSourceField(actionData, actionId));
        }
        return dataSources;
    }

    public DataSourceStructDTO convertActionDefinitionToDataSourceField(List<ActionDefinitionDTO> actionDefinitions, String actionId) {
        DataSourceStructDTO dataSourceStructDTO = new DataSourceStructDTO();
        dataSourceStructDTO.setActionId(actionId);
        ArrayList<FieldDTO> input = new ArrayList<FieldDTO>();
        ArrayList<FieldDTO> output = new ArrayList<FieldDTO>();
        for (ActionDefinitionDTO actionDefinition : actionDefinitions) {
            if (actionDefinition.getRequest() != null && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)actionDefinition.getRequest().getParameters())) {
                for (ApiDataFieldDefinitionDTO param : actionDefinition.getRequest().getParameters()) {
                    input.addAll(this.convertApiDataFieldWithNestedFieldsToFields(param));
                }
            }
            if (!Objects.equals(actionId, actionDefinition.getActionId()) || actionDefinition.getResponse() == null || actionDefinition.getResponse().getData() == null || CollectionUtils.isEmpty((Collection)actionDefinition.getResponse().getData().getField())) continue;
            for (ApiDataFieldDefinitionDTO field2 : actionDefinition.getResponse().getData().getField()) {
                output.addAll(this.convertApiDataFieldWithNestedFieldsToFields(field2));
            }
        }
        output.removeIf(field -> input.stream().anyMatch(inputField -> Objects.equals(inputField.getName(), field.getName()) && Objects.equals("date", inputField.getDataType())));
        dataSourceStructDTO.setInput(this.mergeAdjustFieldParam(input));
        dataSourceStructDTO.setOutput(output);
        return dataSourceStructDTO;
    }

    public List<FieldDTO> convertApiDataFieldWithNestedFieldsToFields(ApiDataFieldDefinitionDTO apiDataField) {
        ArrayList<FieldDTO> fields = new ArrayList<FieldDTO>();
        if (!"object".equals(apiDataField.getData_type())) {
            FieldDTO field = this.convertApiDataFieldToField(apiDataField);
            fields.add(field);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)apiDataField.getField())) {
            for (ApiDataFieldDefinitionDTO nestedField : apiDataField.getField()) {
                fields.addAll(this.convertApiDataFieldWithNestedFieldsToFields(nestedField));
            }
        }
        return fields;
    }

    public FieldDTO convertApiDataFieldToField(ApiDataFieldDefinitionDTO apiDataField) {
        FieldDTO field = new FieldDTO();
        field.setName(apiDataField.getData_name());
        field.setRequired(Boolean.parseBoolean(apiDataField.getRequired()));
        field.setDataType(apiDataField.getData_type());
        return field;
    }

    public List<FieldDTO> mergeAdjustFieldParam(List<FieldDTO> fieldDTOList) {
        Map<String, FieldDTO> mergedFieldMap = fieldDTOList.stream().collect(Collectors.toMap(FieldDTO::getName, field -> field, (existing, replacement) -> existing));
        List<FieldDTO> mergedFieldList = mergedFieldMap.values().stream().collect(Collectors.toList());
        return mergedFieldList;
    }

    @Override
    public Object postMetricActionData(List<String> actionIds) throws Exception {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(actionIds)) {
            return null;
        }
        String tenantId = AthenaUtils.getTenantId();
        HashMap<String, ActionExecutionPathDTO> metricMap = new HashMap<String, ActionExecutionPathDTO>();
        for (String actionId : actionIds) {
            ActionExecutionPathDTO pathDTO = (ActionExecutionPathDTO)this.postQueryExecutionPath(actionId, tenantId, Collections.emptyList(), Collections.emptyList());
            metricMap.put(actionId, pathDTO);
        }
        return metricMap;
    }
}

