/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.clients.CACUtils;
import com.digiwin.athena.knowledgegraph.dto.report.ReportSceneDTOs;
import com.digiwin.athena.knowledgegraph.service.ICommandService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.SceneService;
import com.digiwin.athena.knowledgegraph.service.impl.ScreenService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Lang
@Service
@MyExceptionHandler
public class CommandService
implements ICommandService {
    private static final Logger log = LoggerFactory.getLogger(CommandService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    private KgInnerService kgInnerService;
    @Autowired
    private CACUtils cacUtils;
    @Autowired
    private ScreenService screenService;
    @Autowired
    private SceneService sceneService;

    @Override
    public Object getQueryCommandIntentions(String userId) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<String> appCodes = this.cacUtils.getAppAuth(userId);
        List commandIntentions = this.mongoTemplate.find(this.queryCriteria(appCodes, tenantVersion), Map.class, "agiledata_instruction_set");
        if (CollectionUtils.isEmpty((Collection)commandIntentions)) {
            return Collections.emptyList();
        }
        List<String> applicationCodes = commandIntentions.stream().map(commandIntention -> (String)commandIntention.get("applicationCode")).distinct().collect(Collectors.toList());
        List<String> permissionCodes = this.screenService.getUserPermissionScreen(userId, Arrays.asList("scene", "metric"), applicationCodes);
        commandIntentions.forEach(commandIntention -> this.filterIntentions((Map<String, Object>)commandIntention, permissionCodes));
        LanguageUtil.processLocaleLanguage(commandIntentions, DWResourceBundleUtils.getCurrentLocale().toString());
        return commandIntentions;
    }

    @Override
    public Object getDataSetCommandIntentions(String appCode) throws Exception {
        String userId = AthenaUtils.getUserId();
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        Map application = (Map)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)appCode).and("version").is((Object)tenantVersion)), Map.class, "application");
        if (Objects.isNull(application)) {
            return Collections.emptyMap();
        }
        HashMap commandIntentionInfo = new HashMap();
        commandIntentionInfo.put("name", application.get("name"));
        commandIntentionInfo.put("introduction", application.get("introduction"));
        commandIntentionInfo.put("prompt", application.get("prompt"));
        commandIntentionInfo.put("commandIntentions", Collections.emptyList());
        commandIntentionInfo.put("appType", application.get("appType"));
        commandIntentionInfo.put("iconUrl", application.get("iconUrl"));
        commandIntentionInfo.put("lang", application.get("lang"));
        List<String> permissionCodes = this.screenService.getUserPermissionScreen(userId, new ArrayList<String>(), Collections.singletonList(appCode));
        if (CollectionUtils.isEmpty(permissionCodes)) {
            return commandIntentionInfo;
        }
        List dataSetList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("appCode").is((Object)appCode)), ReportSceneDTOs.class, "agiledatainquiry_data_set");
        if (CollectionUtils.isEmpty((Collection)dataSetList)) {
            return commandIntentionInfo;
        }
        ArrayList commandIntentions = new ArrayList();
        for (ReportSceneDTOs dataSet : dataSetList) {
            if (CollectionUtils.isEmpty(dataSet.getQuestions())) continue;
            HashMap<String, Object> dataSetInfo = new HashMap<String, Object>();
            dataSetInfo.put("code", dataSet.getCode());
            dataSetInfo.put("name", dataSet.getName());
            dataSetInfo.put("questions", dataSet.getQuestions());
            dataSetInfo.put("modelCode", dataSet.getModelCode());
            dataSetInfo.put("lang", dataSet.getLang());
            commandIntentions.add(dataSetInfo);
        }
        commandIntentionInfo.put("commandIntentions", commandIntentions);
        LanguageUtil.processLocaleLanguage(commandIntentionInfo, DWResourceBundleUtils.getCurrentLocale().toString());
        return commandIntentionInfo;
    }

    @Override
    public Object getQueryAllCommandIntentions(String userId) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<String> appCodes = this.cacUtils.getAppAuth(userId);
        List applications = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"code").in(appCodes).and("version").is((Object)tenantVersion)), Application.class, "application");
        List<String> applicationCodes = applications.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
        List commandIntentions = this.mongoTemplate.find(this.queryCriteria(applicationCodes, tenantVersion), Map.class, "agiledata_instruction_set");
        List<String> permissionCodes = this.screenService.getUserPermissionScreen(userId, new ArrayList<String>(), applicationCodes);
        commandIntentions.forEach(commandIntention -> this.filterIntentions((Map<String, Object>)commandIntention, permissionCodes));
        List<ReportSceneDTOs> reportSceneDTOList = this.sceneService.querySceneByAppAndTags(appCodes, "dataset", tenantVersion);
        commandIntentions.addAll(this.filterDataSetIntentions(reportSceneDTOList, permissionCodes));
        LanguageUtil.processLocaleLanguage(commandIntentions, DWResourceBundleUtils.getCurrentLocale().toString());
        return commandIntentions;
    }

    private List<Map> filterDataSetIntentions(List<ReportSceneDTOs> reportSceneDTOList, List<String> permissionCodes) {
        return reportSceneDTOList.stream().filter(reportScenes -> CollectionUtils.isNotEmpty(reportScenes.getQuestions()) && permissionCodes.contains(reportScenes.getCode())).map(this::convertToDataSetInfo).collect(Collectors.toList());
    }

    private Map<String, Object> convertToDataSetInfo(ReportSceneDTOs reportScenes) {
        HashMap<String, Object> dataSetInfo = new HashMap<String, Object>();
        dataSetInfo.put("code", reportScenes.getCode());
        dataSetInfo.put("intentionGroupCode", reportScenes.getCode());
        dataSetInfo.put("intentionGroupName", reportScenes.getLang().get("sceneTitle").getOrDefault(AthenaUtils.getCurrentLocale(), reportScenes.getSceneTitle()));
        dataSetInfo.put("version", reportScenes.getVersion());
        dataSetInfo.put("applicationCode", reportScenes.getAppCode());
        dataSetInfo.put("lang", reportScenes.getLang());
        List intentions = reportScenes.getQuestions().stream().map(question -> {
            HashMap<String, Object> intention = new HashMap<String, Object>();
            intention.put("relationType", 1);
            intention.put("relationName", reportScenes.getName());
            intention.put("relationValue", reportScenes.getCode());
            JSONObject lang = (JSONObject)question.get((Object)"lang");
            Object value = lang.getOrDefault((Object)AthenaUtils.getCurrentLocale(), question.get((Object)"question"));
            intention.put("intention", value);
            intention.put("lang", question.get((Object)"lang"));
            intention.put("sort", 999);
            intention.put("relationStatus", 1);
            return intention;
        }).collect(Collectors.toList());
        dataSetInfo.put("intentions", intentions);
        return dataSetInfo;
    }

    private Query queryCriteria(List<String> appCode, String tenantVersion) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"applicationCode").in(appCode).and("version").is((Object)tenantVersion));
        return query;
    }

    private void filterIntentions(Map<String, Object> commandIntention, List<String> permissionCodes) {
        List intentions = (List)commandIntention.get("intentions");
        if (CollectionUtils.isEmpty((Collection)intentions)) {
            return;
        }
        List filteredIntentions = intentions.stream().filter(intention -> intention.get("relationValue") != null && permissionCodes.contains(intention.get("relationValue").toString()) || intention.get("relationValue") == null && intention.get("intention") != null).collect(Collectors.toList());
        commandIntention.put("intentions", filteredIntentions);
    }
}

