/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.clients.TBBUtils;
import com.digiwin.athena.knowledgegraph.domain.MechanismTenantVariable;
import com.digiwin.athena.knowledgegraph.domain.VariableDefinition;
import com.digiwin.athena.knowledgegraph.po.TbbGlobal;
import com.digiwin.athena.knowledgegraph.service.IDBPatchService;
import com.digiwin.athena.knowledgegraph.utils.JsonUtil;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Lang
@Service
public class DBPatchService
implements IDBPatchService {
    private static final Logger log = LoggerFactory.getLogger(DBPatchService.class);
    @Autowired
    private TBBUtils tbbUtils;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;

    @Override
    public Object getPatchGlobalMessage(String version) throws DWBusinessException {
        List<TbbGlobal> globalList = this.tbbUtils.getGlobal();
        HashMap map = new HashMap();
        map.put("chooseList", new ArrayList());
        ArrayList dataList = new ArrayList();
        for (TbbGlobal tbbGlobal : globalList) {
            HashMap<String, Object> global = new HashMap<String, Object>();
            global.put("chartId", tbbGlobal.getChartId());
            global.put("linkageIds", tbbGlobal.getLinkageIds());
            global.put("sequence", 50);
            global.put("title", tbbGlobal.getTitle().get("zh_CN"));
            global.put("lang", ImmutableMap.of((Object)"title", tbbGlobal.getTitle()));
            global.put("language", ImmutableMap.of((Object)"title", tbbGlobal.getTitle()));
            global.put("appCode", tbbGlobal.getAppCode());
            dataList.add(global);
        }
        map.put("dataList", dataList);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"code").is((Object)"globalMessagePageType").and("version").is((Object)version));
        Update update = new Update();
        update.set("version", (Object)version);
        update.set("common", (Object)"common");
        update.set("code", (Object)"globalMessagePageType");
        update.set("defaultValue", map);
        this.mongoTemplateSystem.upsert(query, update, VariableDefinition.class);
        return "ok";
    }

    @Override
    public Object getPatchTenantGlobalMessage() throws Exception {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"variableId").is((Object)"globalMessagePageType"));
        List mechanismVariable = this.mongoTemplate.find(query, MechanismTenantVariable.class, "mechanismVariable");
        if (mechanismVariable.isEmpty()) {
            return "no data";
        }
        log.info(mechanismVariable.toString());
        for (MechanismTenantVariable mv : mechanismVariable) {
            String typeCode;
            if (null == mv.getValue() || ObjectUtils.isEmpty((Object)(typeCode = String.valueOf(JsonUtil.getJsonValue(JsonUtil.toJsonString(mv.getValue()), "typeCode")))) || typeCode.equals("null")) continue;
            this.mongoTemplate.save((Object)mv, "mechanismVariableBackUp");
            List<Object> valueList = JsonUtil.toList(JsonUtil.getJsonValue(JsonUtil.toJsonString(mv.getValue()), "value").toString(), Object.class);
            HashMap map = new HashMap();
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object jsonValue : valueList) {
                Object code;
                Object show = JsonUtil.getJsonValue(JsonUtil.toJsonString(jsonValue), "show");
                Object isShow = JsonUtil.getJsonValue(JsonUtil.toJsonString(show), "value");
                if (!isShow.equals(true) || !(code = JsonUtil.getJsonValue(JsonUtil.toJsonString(show), "code")).equals(typeCode)) continue;
                Object chartId = JsonUtil.getJsonValue(JsonUtil.toJsonString(jsonValue), "chartId");
                if (chartId.equals("604551b1-979f-4aa7-86c2-33b817787597")) {
                    list.add("e6232c3b-b792-4753-8abb-0af6b1096218");
                    continue;
                }
                if (chartId.equals("c8e948d0-d22c-4aed-8dca-016ac671453c")) {
                    list.add("20ca62c8-6730-44f6-8a90-8b5234b3be44");
                    continue;
                }
                list.add(chartId);
            }
            map.put("chooseList", list);
            Query query1 = new Query();
            Criteria criteria = Criteria.where((String)"tenantId").is((Object)mv.getTenantId()).and("variableId").is((Object)mv.getVariableId());
            query1.addCriteria((CriteriaDefinition)criteria);
            Update update = new Update();
            update.set("value", map);
            this.mongoTemplate.upsert(query1, update, MechanismTenantVariable.class);
        }
        return "ok";
    }
}

