/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.domain.decisionmodel.Api;
import com.digiwin.athena.knowledgegraph.domain.decisionmodel.ApiPreCondition;
import com.digiwin.athena.knowledgegraph.domain.decisionmodel.ApiRestrict;
import com.digiwin.athena.knowledgegraph.domain.decisionmodel.ApiVisualizationExpression;
import com.digiwin.athena.knowledgegraph.domain.decisionmodel.DecisionMakingScheme;
import com.digiwin.athena.knowledgegraph.domain.decisionmodel.DecisionMakingSchemeVO;
import com.digiwin.athena.knowledgegraph.domain.decisionmodel.DecisionModel;
import com.digiwin.athena.knowledgegraph.domain.decisionmodel.DecisionScheme;
import com.digiwin.athena.knowledgegraph.domain.decisionmodel.DecisionSchemeNameVO;
import com.digiwin.athena.knowledgegraph.domain.decisionmodel.Factor;
import com.digiwin.athena.knowledgegraph.domain.decisionmodel.SchemeFactor;
import com.digiwin.athena.knowledgegraph.domain.decisionmodel.TenantDecisionModel;
import com.digiwin.athena.knowledgegraph.service.IDecisionService;
import com.digiwin.athena.knowledgegraph.service.impl.AppService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import com.digiwin.athena.knowledgegraph.utils.TranslateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Lang
@Service
public class DecisionService
implements IDecisionService {
    private static final Logger log = LoggerFactory.getLogger(DecisionService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    TenantService tenantService;
    @Autowired
    AppService appService;
    @Autowired
    TranslateUtils translateUtils;
    @Autowired
    private DataPickService dataPickService;

    @Override
    public Object postDecisionSchemesBatchByCodes(List<String> evlModelCodes) throws Exception {
        return null;
    }

    @Override
    public Object getDecisionModelsByApp(String appCode) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String version = this.tenantService.getTenantVersion(tenantId);
        String locale = AthenaUtils.getCurrentLocale();
        List<ApplicationRelation> applicationRelations = this.appService.getApplicationRelationByTypeAndAppCodeAndVersion("decisionModel", appCode, version);
        if (CollectionUtils.isEmpty(applicationRelations)) {
            return Collections.EMPTY_LIST;
        }
        List modelCode = applicationRelations.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        List<DecisionModel> decisionModels = this.dataPickService.find(Criteria.where((String)"code").in(modelCode), DecisionModel.class, "decisionModel");
        if (CollectionUtils.isEmpty(decisionModels)) {
            return Collections.EMPTY_LIST;
        }
        LinkedList result = new LinkedList();
        decisionModels.forEach(item -> {
            try {
                LanguageUtil.processLocaleLanguage(item, locale);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            HashMap<String, String> codeName = new HashMap<String, String>();
            codeName.put("code", item.getCode());
            codeName.put("name", item.getName());
            result.add(codeName);
        });
        return result;
    }

    private DecisionModel findByCode(String evlModelCode) throws DWBusinessException {
        return this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)evlModelCode), DecisionModel.class, "decisionModel");
    }

    @Override
    public Object getDecisionSchemesByCode(String evlModelCode) throws Exception {
        DecisionModel decisionModel = this.getDecisionModel(evlModelCode);
        if (Objects.isNull((Object)decisionModel)) {
            return null;
        }
        this.syncDecisionScheme(decisionModel);
        this.syncDecisionMakingScheme(decisionModel);
        log.info("after sync decisionMode:{}", (Object)decisionModel);
        return decisionModel;
    }

    @Override
    public Object getDecisionSchemesByCodeForWeb(String evlModelCode) throws Exception {
        return this.getDecisionModel(evlModelCode);
    }

    private void syncDecisionScheme(DecisionModel decisionModel) {
        if (Objects.isNull((Object)decisionModel)) {
            return;
        }
        if (CollectionUtils.isEmpty(decisionModel.getSchemes())) {
            return;
        }
        List<DecisionScheme> schemes = decisionModel.getSchemes();
        List<Factor> sysFactors = decisionModel.getFactors();
        if (CollectionUtils.isEmpty(sysFactors)) {
            schemes.forEach(scheme -> scheme.setFactors(Collections.EMPTY_LIST));
            return;
        }
        Map<String, Map> sysFactorApiMap = sysFactors.stream().collect(Collectors.toMap(Factor::getCode, factor -> factor.getApis().stream().collect(Collectors.toMap(Api::getUid, api -> api))));
        List sysFactorCode = sysFactors.stream().map(Factor::getCode).collect(Collectors.toList());
        for (DecisionScheme scheme2 : schemes) {
            List<SchemeFactor> tenantFactors = scheme2.getFactors();
            if (CollectionUtils.isEmpty(tenantFactors)) continue;
            tenantFactors = tenantFactors.stream().filter(tenantFactor -> sysFactorCode.contains(tenantFactor.getCode())).collect(Collectors.toList());
            scheme2.setFactors(tenantFactors);
            for (SchemeFactor tenantFactor2 : tenantFactors) {
                String tenantFactorCode = tenantFactor2.getCode();
                Map sysApiMap = sysFactorApiMap.get(tenantFactorCode);
                if (MapUtils.isEmpty((Map)sysApiMap)) {
                    tenantFactor2.setApis(Collections.EMPTY_LIST);
                    continue;
                }
                List<Api> tenantApis = tenantFactor2.getApis();
                if (CollectionUtils.isEmpty(tenantApis)) continue;
                tenantApis = tenantApis.stream().filter(api -> sysApiMap.containsKey(api.getUid())).collect(Collectors.toList());
                tenantApis.forEach(api -> {
                    Api sysApi = (Api)((Object)((Object)sysApiMap.get(api.getUid())));
                    if (Objects.nonNull((Object)sysApi)) {
                        api.setName(sysApi.getName());
                        api.setLang(sysApi.getLang());
                    }
                });
                tenantFactor2.setApis(tenantApis);
            }
        }
    }

    private void syncDecisionMakingScheme(DecisionModel decisionModel) {
        if (Objects.isNull((Object)decisionModel)) {
            return;
        }
        if (CollectionUtils.isEmpty(decisionModel.getDecisionScheme()) && CollectionUtils.isEmpty(decisionModel.getOriginDecisionScheme())) {
            return;
        }
        List<DecisionMakingScheme> sysDecisionScheme = decisionModel.getOriginDecisionScheme();
        if (CollectionUtils.isEmpty(sysDecisionScheme)) {
            decisionModel.setDecisionScheme(Collections.EMPTY_LIST);
            return;
        }
        List<DecisionMakingScheme> tenantDecisionScheme = decisionModel.getDecisionScheme();
        if (CollectionUtils.isEmpty(tenantDecisionScheme)) {
            decisionModel.setDecisionScheme(sysDecisionScheme);
            return;
        }
        ArrayList<DecisionMakingScheme> newTenantDecisionScheme = new ArrayList<DecisionMakingScheme>(sysDecisionScheme.size());
        sysDecisionScheme.forEach(item -> {
            DecisionMakingScheme makingScheme = new DecisionMakingScheme();
            BeanUtils.copyProperties((Object)item, (Object)((Object)makingScheme));
            newTenantDecisionScheme.add(makingScheme);
        });
        Map tenantDecisionSchemeMap = tenantDecisionScheme.stream().collect(Collectors.toMap(DecisionMakingScheme::getCode, Function.identity(), (a, b) -> b));
        for (DecisionMakingScheme decisionMakingScheme : newTenantDecisionScheme) {
            DecisionMakingScheme makingScheme = (DecisionMakingScheme)((Object)tenantDecisionSchemeMap.get(decisionMakingScheme.getCode()));
            if (!Objects.nonNull((Object)makingScheme)) continue;
            decisionMakingScheme.setIfRecommend(makingScheme.getIfRecommend());
            decisionMakingScheme.setMode(makingScheme.getMode());
            decisionMakingScheme.setCondition(makingScheme.getCondition());
            decisionMakingScheme.setShowFields(makingScheme.getShowFields());
            decisionMakingScheme.setEvlToDecisionMakingRouting(makingScheme.getEvlToDecisionMakingRouting());
        }
        decisionModel.setDecisionScheme(newTenantDecisionScheme);
    }

    private DecisionModel getDecisionModel(String evlModelCode) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String version = this.tenantService.getTenantVersion(tenantId);
        String locale = AthenaUtils.getCurrentLocale();
        DecisionModel decisionModel = this.findByCode(evlModelCode);
        if (null == decisionModel) {
            return null;
        }
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where((String)"version").is((Object)version).and("evlModelCode").is((Object)evlModelCode).and("tenantId").is((Object)tenantId);
        queryUser.addCriteria((CriteriaDefinition)criteriaUser);
        List decisionSchemes = this.mongoTemplateUser.find(queryUser, DecisionScheme.class);
        this.transformApiPrecondition(decisionSchemes);
        Query queryTenantModel = new Query();
        Criteria criteriaTenantModel = Criteria.where((String)"code").is((Object)evlModelCode).and("tenantId").is((Object)tenantId).and("version").is((Object)version);
        queryTenantModel.addCriteria((CriteriaDefinition)criteriaTenantModel);
        TenantDecisionModel tenantDecisionModel = (TenantDecisionModel)this.mongoTemplateUser.findOne(queryTenantModel, TenantDecisionModel.class);
        this.mergeDecisionModel(decisionModel, tenantDecisionModel);
        this.copyFromDecisionModel(decisionModel, decisionSchemes);
        decisionModel.setSchemes(decisionSchemes);
        if (CollectionUtils.isEmpty((Collection)decisionSchemes)) {
            decisionModel.setEnabled(false);
            decisionModel.setBanSwitch(false);
            LanguageUtil.processLocaleLanguage((Object)decisionModel, locale);
            return decisionModel;
        }
        if (null == tenantDecisionModel) {
            if (CollectionUtils.isEmpty((Collection)decisionSchemes)) {
                decisionModel.setEnabled(false);
            } else {
                decisionModel.setEnabled(true);
            }
            decisionModel.setBanSwitch(false);
            decisionModel.setUseAI(false);
        } else {
            decisionModel.setEnabled(Optional.ofNullable(tenantDecisionModel.getEnabled()).orElse(true));
            decisionModel.setBanSwitch(Optional.ofNullable(tenantDecisionModel.getEnabled()).orElse(true));
            decisionModel.setUseAI(Optional.ofNullable(tenantDecisionModel.getUseAI()).orElse(false));
        }
        LanguageUtil.processLocaleLanguage((Object)decisionModel, locale);
        log.info("decisionMode:{}", (Object)decisionModel);
        return decisionModel;
    }

    private void copyFromDecisionModel(DecisionModel decisionModel, List<DecisionScheme> decisionSchemes) {
        Map<String, Map> apiMap = decisionModel.getFactors().stream().collect(Collectors.toMap(Factor::getCode, factor -> factor.getApis().stream().collect(Collectors.toMap(Api::getUid, api -> api))));
        if (!CollectionUtils.isEmpty(decisionSchemes)) {
            decisionSchemes.forEach(decisionScheme -> {
                List<SchemeFactor> schemeFactors = decisionScheme.getFactors();
                if (schemeFactors != null) {
                    schemeFactors.forEach(schemeFactor -> {
                        List<Api> apis;
                        String factorCode = schemeFactor.getCode();
                        Map factorApis = (Map)apiMap.get(factorCode);
                        if (factorApis != null && (apis = schemeFactor.getApis()) != null) {
                            apis.forEach(api -> {
                                String apiUid = api.getUid();
                                Api matchingApi = (Api)((Object)((Object)((Object)((Object)factorApis.get(apiUid)))));
                                if (matchingApi != null) {
                                    api.setAccuracy(matchingApi.getAccuracy());
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    private void mergeDecisionModel(DecisionModel decisionModel, TenantDecisionModel tenantDecisionModel) {
        decisionModel.setOriginDecisionScheme(decisionModel.getDecisionScheme());
        if (null != tenantDecisionModel && !CollectionUtils.isEmpty(tenantDecisionModel.getDecisionScheme()) && !CollectionUtils.isEmpty(decisionModel.getDecisionScheme())) {
            List<DecisionMakingScheme> sysDecisionScheme = decisionModel.getDecisionScheme();
            Map sysDecisionSchemeMap = sysDecisionScheme.stream().collect(Collectors.toMap(DecisionMakingScheme::getCode, Function.identity()));
            List<DecisionMakingScheme> tenantDecisionScheme = tenantDecisionModel.getDecisionScheme();
            tenantDecisionScheme.forEach(item -> {
                DecisionMakingScheme sysScheme = (DecisionMakingScheme)((Object)((Object)sysDecisionSchemeMap.get(item.getCode())));
                if (null != sysScheme) {
                    item.setDecisionCode(sysScheme.getDecisionCode());
                    item.setName(sysScheme.getName());
                    item.setShowFields(sysScheme.getShowFields());
                    item.setLang(sysScheme.getLang());
                }
            });
            decisionModel.setDecisionScheme(tenantDecisionScheme);
        }
        if (null != tenantDecisionModel && !CollectionUtils.isEmpty(tenantDecisionModel.getDecisionScheme()) && CollectionUtils.isEmpty(decisionModel.getDecisionScheme())) {
            decisionModel.setDecisionScheme(tenantDecisionModel.getDecisionScheme());
        }
    }

    private void transformApiPrecondition(List<DecisionScheme> decisionSchemes) {
        if (!CollectionUtils.isEmpty(decisionSchemes)) {
            decisionSchemes.forEach(decisionScheme -> {
                List<SchemeFactor> factors = decisionScheme.getFactors();
                if (!CollectionUtils.isEmpty(factors)) {
                    factors.forEach(schemeFactor -> {
                        List<Api> apis = schemeFactor.getApis();
                        if (!CollectionUtils.isEmpty(apis)) {
                            apis.forEach(api -> {
                                ApiPreCondition apiPreCondition = api.getPrecondition();
                                String expression = this.transformApiExpression(apiPreCondition);
                                if (null != apiPreCondition) {
                                    apiPreCondition.setExpressionTransformed(expression);
                                    api.setPrecondition(apiPreCondition);
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    private String transformApiExpression(ApiPreCondition apiPreCondition) {
        if (null == apiPreCondition) {
            return null;
        }
        switch (apiPreCondition.getConditionType()) {
            case "expression": {
                return apiPreCondition.getExpression();
            }
            case "visualization": {
                return DecisionService.transformVisualizationToExpression(apiPreCondition.getVisualization());
            }
        }
        return null;
    }

    private static String transformVisualizationToExpression(ApiVisualizationExpression visualization) {
        boolean bothNotEmpty;
        StringBuilder expressionBuilder = new StringBuilder();
        boolean bl = bothNotEmpty = !CollectionUtils.isEmpty(visualization.getAnd()) && !CollectionUtils.isEmpty(visualization.getOr());
        if (visualization != null) {
            ApiRestrict element;
            int i;
            if (!CollectionUtils.isEmpty(visualization.getAnd())) {
                if (bothNotEmpty) {
                    expressionBuilder.append("(");
                }
                List<ApiRestrict> andList = visualization.getAnd();
                for (i = 0; i < andList.size(); ++i) {
                    if (i > 0) {
                        expressionBuilder.append(" && ");
                    }
                    element = andList.get(i);
                    expressionBuilder.append("($(").append(element.getSourceId()).append(")").append(element.getOperator()).append(" ").append(element.getRestrictType().equals("dataSource") ? "$(" + element.getValue() + ")" : element.getValue()).append(")");
                }
                if (bothNotEmpty) {
                    expressionBuilder.append(")");
                }
            }
            if (!CollectionUtils.isEmpty(visualization.getOr())) {
                if (!CollectionUtils.isEmpty(visualization.getAnd())) {
                    expressionBuilder.append(" && (");
                }
                if (bothNotEmpty) {
                    expressionBuilder.append("(");
                }
                List<ApiRestrict> orList = visualization.getOr();
                for (i = 0; i < orList.size(); ++i) {
                    if (i > 0) {
                        expressionBuilder.append(" || ");
                    }
                    element = orList.get(i);
                    expressionBuilder.append("($(").append(element.getSourceId()).append(")").append(element.getOperator()).append(" ").append(element.getRestrictType().equals("dataSource") ? "$(" + element.getValue() + ")" : element.getValue()).append(")");
                }
                if (bothNotEmpty) {
                    expressionBuilder.append(")");
                }
            }
        }
        return expressionBuilder.toString();
    }

    @Override
    public Object postDecisionModel(DecisionModel decisionModel) throws Exception {
        DecisionModel byCode = this.findByCode(decisionModel.getCode());
        decisionModel.setTenantId(byCode.getTenantId());
        decisionModel.setSourceLevel(byCode.getSourceLevel());
        decisionModel.setVersion(byCode.getVersion());
        this.mongoTemplate.save((Object)decisionModel);
        return null;
    }

    @Override
    public Object postDecisionScheme(DecisionScheme decisionScheme) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String version = this.tenantService.getTenantVersion(tenantId);
        decisionScheme.setTenantId(tenantId);
        decisionScheme.setVersion(version);
        this.translateDecisionSchemeName(decisionScheme);
        this.mongoTemplateUser.save((Object)decisionScheme);
        return decisionScheme;
    }

    @Override
    public Object postSetRecommend(DecisionScheme decisionScheme) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String version = this.tenantService.getTenantVersion(tenantId);
        decisionScheme.setTenantId(tenantId);
        decisionScheme.setVersion(version);
        decisionScheme.setIfRecommend(true);
        this.mongoTemplateUser.save((Object)decisionScheme);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"evlModelCode").is((Object)decisionScheme.getEvlModelCode()).and("tenantId").is((Object)tenantId).and("version").is((Object)version).and("_id").ne((Object)new ObjectId(decisionScheme.getId()));
        query.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("ifRecommend", (Object)false);
        this.mongoTemplateUser.updateMulti(query, update, DecisionScheme.class);
        return decisionScheme;
    }

    @Override
    public Object postDecisionSchemeName(DecisionSchemeNameVO decisionSchemeNameVO) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String version = this.tenantService.getTenantVersion(tenantId);
        String name = decisionSchemeNameVO.getName();
        String evlModelCode = decisionSchemeNameVO.getEvlModelCode();
        String evlSchemeCode = decisionSchemeNameVO.getEvlSchemeCode();
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"evlModelCode").is((Object)evlModelCode).and("code").is((Object)evlSchemeCode).and("tenantId").is((Object)tenantId).and("version").is((Object)version);
        query.addCriteria((CriteriaDefinition)criteria);
        DecisionScheme decisionScheme = (DecisionScheme)((Object)this.mongoTemplateUser.findOne(query, DecisionScheme.class));
        if (null == decisionScheme) {
            throw new DWBusinessException("no decisionScheme found");
        }
        decisionScheme.setName(name);
        this.translateDecisionSchemeName(decisionScheme);
        this.mongoTemplateUser.save((Object)decisionScheme);
        return decisionScheme;
    }

    @Override
    public Object postDecisionMakingScheme(DecisionMakingSchemeVO decisionMakingSchemeVO) throws Exception {
        List<DecisionMakingScheme> tenantDecisionMakingScheme;
        String tenantId = AthenaUtils.getTenantId();
        String version = this.tenantService.getTenantVersion(tenantId);
        DecisionModel decisionModel = this.findByCode(decisionMakingSchemeVO.getEvlModelCode());
        if (null == decisionModel) {
            throw new DWBusinessException("no decisionModel found");
        }
        if (!decisionModel.getUseDecisionScheme().booleanValue()) {
            throw new DWBusinessException("decisionModel not allowed to set decisionMakingScheme");
        }
        List<DecisionMakingScheme> sysDecisionMakingScheme = decisionModel.getDecisionScheme();
        if (!this.compareTenantSystem(sysDecisionMakingScheme, tenantDecisionMakingScheme = decisionMakingSchemeVO.getDecisionScheme())) {
            throw new DWBusinessException("tenant decisionMakingScheme does not match scheme");
        }
        TenantDecisionModel tenantDecisionModel = this.findTenantDecisionModel(decisionMakingSchemeVO.getEvlModelCode());
        if (null == tenantDecisionModel) {
            tenantDecisionModel = new TenantDecisionModel();
            tenantDecisionModel.setTenantId(tenantId);
            tenantDecisionModel.setVersion(version);
            tenantDecisionModel.setCode(decisionMakingSchemeVO.getEvlModelCode());
        }
        tenantDecisionModel.setDecisionScheme(tenantDecisionMakingScheme);
        this.mongoTemplateUser.save((Object)tenantDecisionModel);
        return tenantDecisionModel;
    }

    private boolean compareTenantSystem(List<DecisionMakingScheme> sysDecisionMakingScheme, List<DecisionMakingScheme> tenantDecisionMakingScheme) {
        if (CollectionUtils.isEmpty(sysDecisionMakingScheme) || CollectionUtils.isEmpty(tenantDecisionMakingScheme)) {
            return false;
        }
        Set codeSet = sysDecisionMakingScheme.stream().map(DecisionMakingScheme::getCode).collect(Collectors.toSet());
        for (int i = 0; i < tenantDecisionMakingScheme.size(); ++i) {
            if (!codeSet.contains(tenantDecisionMakingScheme.get(i).getCode())) {
                return false;
            }
            codeSet.remove(tenantDecisionMakingScheme.get(i).getCode());
        }
        return CollectionUtils.isEmpty(codeSet);
    }

    @Override
    public Object postBanModel(String evlModelCode, Boolean setOrBan) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String version = this.tenantService.getTenantVersion(tenantId);
        TenantDecisionModel decisionModel = this.findTenantDecisionModel(evlModelCode);
        if (null == decisionModel) {
            decisionModel = new TenantDecisionModel();
            decisionModel.setTenantId(tenantId);
            decisionModel.setVersion(version);
        }
        decisionModel.setEnabled(setOrBan);
        decisionModel.setCode(evlModelCode);
        this.mongoTemplateUser.save((Object)decisionModel);
        return decisionModel;
    }

    private TenantDecisionModel findTenantDecisionModel(String evlModeCode) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String version = this.tenantService.getTenantVersion(tenantId);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"code").is((Object)evlModeCode).and("tenantId").is((Object)tenantId).and("version").is((Object)version);
        query.addCriteria((CriteriaDefinition)criteria);
        TenantDecisionModel decisionModel = (TenantDecisionModel)this.mongoTemplateUser.findOne(query, TenantDecisionModel.class);
        return decisionModel;
    }

    @Override
    public Object deleteDecisionScheme(String id) throws Exception {
        DecisionScheme decisionScheme = (DecisionScheme)((Object)this.mongoTemplateUser.findById((Object)id, DecisionScheme.class));
        this.mongoTemplateUser.remove((Object)decisionScheme);
        return decisionScheme;
    }

    @Override
    public Object postSwitchAIAssistant(String evlModelCode, Boolean useAI) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String version = this.tenantService.getTenantVersion(tenantId);
        TenantDecisionModel decisionModel = this.findTenantDecisionModel(evlModelCode);
        if (null == decisionModel) {
            decisionModel = new TenantDecisionModel();
            decisionModel.setTenantId(tenantId);
            decisionModel.setVersion(version);
        }
        decisionModel.setUseAI(useAI);
        decisionModel.setCode(evlModelCode);
        this.mongoTemplateUser.save((Object)decisionModel);
        return decisionModel;
    }

    private void translateDecisionSchemeName(DecisionScheme decisionScheme) throws DWBusinessException {
        String name = decisionScheme.getName();
        JSONObject transResult = this.translateUtils.translateContent("name", name, new String[]{"zh2Hant", "zh2Hans"});
        if (transResult == null) {
            decisionScheme.setLang(null);
            return;
        }
        JSONObject nameObject = transResult.getJSONObject("name");
        if (nameObject == null) {
            decisionScheme.setLang(null);
            return;
        }
        HashMap lang = new HashMap();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        lang.put("name", nameMap);
        if (nameObject.containsKey((Object)"zh_CN")) {
            nameMap.put("zh_CN", nameObject.getString("zh_CN"));
        }
        if (nameObject.containsKey((Object)"zh_TW")) {
            nameMap.put("zh_TW", nameObject.getString("zh_TW"));
        }
        decisionScheme.setLang(lang);
    }
}

