/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.po.dap.RespObject;
import com.digiwin.athena.knowledgegraph.service.AppMetaCaller;
import com.digiwin.athena.knowledgegraph.service.IDictService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Lang
@Service
public class DictService
implements IDictService {
    private static final Logger log = LoggerFactory.getLogger(DictService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate sysMongoTemplate;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    AppMetaCaller appMetaCaller;

    @Override
    public Object getDictByKey(String key) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("key", key);
        RespObject respObject = this.appMetaCaller.call("/dict/dictByKey", "get", map, RespObject.class);
        return respObject.getResponse();
    }

    @Override
    public Object getDictByKeyAndCode(String key, String code) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("key", key);
        map.put("code", code);
        RespObject respObject = this.appMetaCaller.call("/dict/dictByKeyAndCode", "get", map, RespObject.class);
        return respObject.getResponse();
    }

    @Override
    public Object postFindDictByKeyList(List<String> keyList) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("keyList", keyList);
        RespObject respTenantEntity = this.appMetaCaller.call("/dict/findDictByKeyList", "post", map, RespObject.class);
        return respTenantEntity.getResponse();
    }
}

