/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.domain.task.EmailView;
import com.digiwin.athena.knowledgegraph.dto.BusinessLogicBasic;
import com.digiwin.athena.knowledgegraph.po.ViewRequest;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IEmailService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.impl.ViewService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Lang
@Service
public class EmailService
implements IEmailService {
    private static final Logger log = LoggerFactory.getLogger(EmailService.class);
    @Autowired
    ViewService viewService;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplateSystem;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    DataMapService dataMapService;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    TenantService tenantService;
    @Autowired
    private DataPickService dataPickService;

    @Override
    public Object getEmail(String emailCode, String locale) throws DWException {
        return this.viewService.getEmail(emailCode, locale);
    }

    @Override
    public Object postEmails(ViewRequest request) throws DWException {
        Activity activity;
        if (null != request.getTaskCode() && null != request.getProjectCode() && null != (activity = this.kgInnerService.activityBasic(request.getProjectCode(), request.getTaskCode()))) {
            if (null != activity.getConfig() && null != activity.getConfig().get("businessLogic")) {
                List logics = JSON.parseArray((String)JSON.toJSONString(activity.getConfig().get("businessLogic")), BusinessLogicBasic.class);
                for (BusinessLogicBasic logic : logics) {
                    if (!"emailTemplate".equalsIgnoreCase(logic.getKey())) continue;
                    return this.findEmailViewByTemplateCode(logic.getTemplateCode());
                }
            }
            return null;
        }
        if (null != request.getTaskCode()) {
            try {
                Object templateCode = this.dataMapService.postEmailTemplateCode(request);
                if (null != templateCode) {
                    return this.findEmailViewByTemplateCode((String)templateCode);
                }
            }
            catch (Exception dme) {
                log.error("find emails from datamap failed", (Throwable)dme);
            }
        }
        return null;
    }

    List<EmailView> findEmailViewByTemplateCode(String templateCode) throws DWBusinessException {
        if (null == templateCode) {
            return null;
        }
        String tenantId = AthenaUtils.getTenantId();
        String locale = AthenaUtils.getCurrentLocale();
        String version = this.tenantService.getTenantVersion(tenantId);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"templateCode").is((Object)templateCode).and("version").is((Object)version));
        Query query2 = Query.query((CriteriaDefinition)Criteria.where((String)"templateCode").is((Object)templateCode).and("version").is((Object)version).and("tenantId").is((Object)tenantId));
        List<EmailView> emailViewsSystem = this.dataPickService.filterByIndividual(this.mongoTemplateSystem.find(query, EmailView.class), null, EmailView::getApplication);
        List emailViewsUser = this.mongoTemplateUser.find(query2, EmailView.class);
        block0: for (EmailView ev : emailViewsSystem) {
            for (EmailView ev2 : emailViewsUser) {
                if (!ev.getCode().equals(ev2.getCode())) continue;
                AthenaUtils.mergeObject((Object)ev2, (Object)ev);
                continue block0;
            }
        }
        if (null != locale) {
            emailViewsSystem.forEach(viewSystem -> {
                if (null != viewSystem.getConfig() && null != viewSystem.getConfig().getTables()) {
                    viewSystem.getConfig().getTables().forEach(table -> {
                        if (null != table.getLang() && null != table.getLang().get("name") && null != ((Map)table.getLang().get("name")).get(locale)) {
                            table.setName((String)((Map)table.getLang().get("name")).get(locale));
                        }
                        if (null != table.getFields()) {
                            table.getFields().forEach(field -> {
                                if (null != field.getLang() && null != field.getLang().get("name") && null != ((Map)field.getLang().get("name")).get(locale)) {
                                    field.setName((String)((Map)field.getLang().get("name")).get(locale));
                                }
                            });
                        }
                    });
                }
            });
        }
        return emailViewsSystem;
    }

    @Override
    public Object postEmailUpdate(EmailView data) throws DWException {
        String tenantId = AthenaUtils.getTenantId();
        String id = data.getId();
        if (id == null) {
            throw new DWBusinessException("id is null");
        }
        EmailView indb = (EmailView)((Object)this.mongoTemplateUser.findById((Object)data.getId(), EmailView.class));
        if (indb == null) {
            indb = this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)data.getId()), EmailView.class, "emailView");
            if (indb == null) {
                throw new DWArgumentException("id", "cant not find data by id:" + id);
            }
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)indb.getCode()).and("version").is((Object)indb.getVersion()).and("tenantId").is((Object)tenantId));
            EmailView indb2 = (EmailView)((Object)this.mongoTemplateUser.findOne(query, EmailView.class));
            if (null != indb2) {
                AthenaUtils.mergeObject((Object)data, (Object)indb2);
                this.mongoTemplateUser.save((Object)indb2);
            } else {
                data.setTenantId(tenantId);
                data.setId(null);
                data.setTemplateCode(indb.getTemplateCode());
                data.setCode(indb.getCode());
                data.setVersion(indb.getVersion());
                this.mongoTemplateUser.save((Object)data);
            }
        } else {
            AthenaUtils.mergeObject((Object)data, (Object)indb);
            this.mongoTemplateUser.save((Object)indb);
        }
        return "success";
    }
}

