/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.service.DWFile;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.clients.DMCUtils;
import com.digiwin.athena.knowledgegraph.po.FileInfo;
import com.digiwin.athena.knowledgegraph.service.IFileService;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Lang
@Service
public class FileService
implements IFileService {
    private static final Logger log = LoggerFactory.getLogger(FileService.class);
    @Autowired
    private DMCUtils dmcUtils;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate sysMongoTemplate;

    @Override
    public Object postUpload(DWFile file, String key, String version) throws Exception {
        return this.postUpload(file, key, version, "");
    }

    @Override
    public Object postUpload(DWFile file, String key, String version, String desc) throws Exception {
        log.info("fileUpload key:{}, version:{}, desc:{}", new Object[]{key, version, desc});
        FileInfo fileInfo = new FileInfo();
        fileInfo.setDisplayName(file.getFileName());
        fileInfo.setDescription(desc);
        String upload = this.dmcUtils.upload(file, fileInfo);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"key").is((Object)key).and("version").is((Object)version);
        query.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("fileId", (Object)upload).set("desc", (Object)desc);
        this.sysMongoTemplate.upsert(query, update, "fileInfo");
        return upload;
    }

    @Override
    public void getDownloadTemplate(String fileId) throws Exception {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        HttpServletResponse response = ((ServletRequestAttributes)requestAttributes).getResponse();
        this.dmcUtils.downLoadTemplate(fileId, response);
    }

    @Override
    public Object getFileId(String key, String version) throws Exception {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"key").is((Object)key).and("version").is((Object)version);
        query.addCriteria((CriteriaDefinition)criteria);
        Map fileInfo = (Map)this.sysMongoTemplate.findOne(query, Map.class, "fileInfo");
        if (fileInfo == null) {
            return null;
        }
        return String.valueOf(fileInfo.get("fileId"));
    }
}

