/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBaseInfoBO;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.knowledgegraph.domain.guide.GuideConfig;
import com.digiwin.athena.knowledgegraph.domain.guide.GuideMechanismReference;
import com.digiwin.athena.knowledgegraph.domain.guide.GuideSetting;
import com.digiwin.athena.knowledgegraph.domain.mechanism.Mechanism;
import com.digiwin.athena.knowledgegraph.domain.mechanism.Principle;
import com.digiwin.athena.knowledgegraph.domain.mechanism.PrincipleDetail;
import com.digiwin.athena.knowledgegraph.repoSystem.GuideConfigRepository;
import com.digiwin.athena.knowledgegraph.service.IGuideService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.MechanismService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Lang
@Service
@MyExceptionHandler
public class GuideService
implements IGuideService {
    private static final Logger log = LoggerFactory.getLogger(GuideService.class);
    @Autowired
    private GuideConfigRepository guideConfigRepository;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSys;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    private MechanismService mechanismService;
    @Autowired
    private ComponentManager componentManager;
    @Autowired
    private DataPickService dataPickService;

    @Override
    public Object put(GuideConfig guideConfig) throws DWBusinessException {
        if (StringUtils.isEmpty((CharSequence)guideConfig.getAppCode())) {
            throw new DWArgumentException("guideConfig", I18nUtils.getValue("knowledgegraph.guideConfig.appCodeEmpty", new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)guideConfig.getCode())) {
            throw new DWArgumentException("guideConfig", I18nUtils.getValue("knowledgegraph.guideConfig.codeEmpty", new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)guideConfig.getType())) {
            throw new DWArgumentException("guideConfig", I18nUtils.getValue("knowledgegraph.guideConfig.typeEmpty", new Object[0]));
        }
        String version = guideConfig.getVersion();
        if (StringUtils.isEmpty((CharSequence)version)) {
            version = this.kgInnerService.getTenantVersion(AthenaUtils.getTenantId());
            guideConfig.setVersion(version);
        }
        try {
            GuideConfig re = this.guideConfigRepository.findOneByAppCodeAndCodeAndTypeAndVersion(guideConfig.getAppCode(), guideConfig.getCode(), guideConfig.getType(), version);
            if (re == null) {
                this.guideConfigRepository.insert((Object)guideConfig);
            } else {
                re.setSettings(guideConfig.getSettings());
                this.guideConfigRepository.save((Object)re);
            }
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public Object delete(String appCode, String code, String type, String version) throws DWBusinessException {
        if (StringUtils.isEmpty((CharSequence)appCode)) {
            throw new DWArgumentException("guideConfig", I18nUtils.getValue("knowledgegraph.guideConfig.appCodeEmpty", new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)code)) {
            throw new DWArgumentException("guideConfig", I18nUtils.getValue("knowledgegraph.guideConfig.codeEmpty", new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)type)) {
            throw new DWArgumentException("guideConfig", I18nUtils.getValue("knowledgegraph.guideConfig.typeEmpty", new Object[0]));
        }
        String tenantId = AthenaUtils.getTenantId();
        if (StringUtils.isEmpty((CharSequence)version)) {
            version = this.kgInnerService.getTenantVersion(tenantId);
        }
        Criteria criteria = new Criteria();
        criteria.and("appCode").is((Object)appCode).and("code").is((Object)code).and("type").is((Object)type).and("version").is((Object)version);
        this.dataPickService.addTenantCondition(criteria, appCode, tenantId);
        try {
            this.mongoTemplateSys.remove(new Query((CriteriaDefinition)criteria), GuideConfig.class);
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public Object post(GuideConfig guideConfig) throws DWBusinessException {
        if (StringUtils.isEmpty((CharSequence)guideConfig.getAppCode())) {
            throw new DWArgumentException("guideConfig", I18nUtils.getValue("knowledgegraph.guideConfig.appCodeEmpty", new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)guideConfig.getCode())) {
            throw new DWArgumentException("guideConfig", I18nUtils.getValue("knowledgegraph.guideConfig.codeEmpty", new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)guideConfig.getType())) {
            throw new DWArgumentException("guideConfig", I18nUtils.getValue("knowledgegraph.guideConfig.typeEmpty", new Object[0]));
        }
        String version = guideConfig.getVersion();
        if (StringUtils.isEmpty((CharSequence)version)) {
            version = this.kgInnerService.getTenantVersion(AthenaUtils.getTenantId());
        }
        Criteria criteria = new Criteria();
        criteria.and("appCode").is((Object)guideConfig.getAppCode()).and("code").is((Object)guideConfig.getCode()).and("type").is((Object)guideConfig.getType()).and("version").is((Object)version);
        this.dataPickService.addTenantCondition(criteria, guideConfig.getAppCode(), AthenaUtils.getTenantId());
        Update update = new Update();
        update.set("settings", guideConfig.getSettings());
        try {
            this.mongoTemplateSys.upsert(new Query((CriteriaDefinition)criteria), update, GuideConfig.class);
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public Object postQuery(String appCode, String code, String type) throws DWBusinessException {
        GuideConfig re;
        String version = this.kgInnerService.getTenantVersion(AthenaUtils.getTenantId());
        try {
            Criteria criteria = new Criteria();
            criteria.and("appCode").is((Object)appCode).and("code").is((Object)code).and("type").is((Object)type);
            re = this.dataPickService.findOneByCondition(criteria, GuideConfig.class, "guideConfig");
            if (re != null) {
                this.filterByComponentManager(re);
                this.processReferMechismPrinceple(re);
                Locale locale = DWResourceBundleUtils.getCurrentLocale();
                String localeStr = locale.toString();
                LanguageUtil.processLocaleLanguage((Object)re, localeStr);
            }
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return re;
    }

    public void filterByComponentManager(GuideConfig config) throws DWBusinessException {
        List<GuideSetting> list = config.getSettings();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            HashMap<String, GuideSetting> map = new HashMap<String, GuideSetting>();
            ArrayList<ComponentBaseInfoBO> componentBaseInfos = new ArrayList<ComponentBaseInfoBO>();
            for (GuideSetting g : list) {
                map.put(g.getCode(), g);
                ComponentBaseInfoBO info = new ComponentBaseInfoBO();
                info.setCode(g.getCode());
                info.setType(ComponentTypeEnum.Guidance);
                componentBaseInfos.add(info);
            }
            List<ComponentBaseInfoBO> filterComponents = this.componentManager.FilterByTenantApplicationComponentList(config.getAppCode(), AthenaUtils.getTenantId(), componentBaseInfos);
            List<GuideSetting> filterSettings = new ArrayList<GuideSetting>();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(filterComponents)) {
                if (list.size() == filterComponents.size()) {
                    filterSettings = list;
                } else {
                    for (ComponentBaseInfoBO c : filterComponents) {
                        filterSettings.add((GuideSetting)map.get(c.getCode()));
                    }
                }
            }
            config.setSettings(filterSettings);
        }
    }

    public void processReferMechismPrinceple(GuideConfig config) throws DWBusinessException {
        if (!CollectionUtils.isEmpty(config.getSettings())) {
            block0: for (GuideSetting setting : config.getSettings()) {
                Mechanism m;
                GuideMechanismReference ref = setting.getReference();
                if (ref == null || ref.isEmpty() || (m = (Mechanism)((Object)this.mechanismService.postQueryMechanismByCode(ref.getMechanismCode(), null))) == null || CollectionUtils.isEmpty(m.getPrinciples())) continue;
                for (Principle p : m.getPrinciples()) {
                    if (!StringUtils.equals((CharSequence)ref.getPrincipleCode(), (CharSequence)p.getCode())) continue;
                    if (CollectionUtils.isEmpty(p.getDetails())) continue block0;
                    for (PrincipleDetail d : p.getDetails()) {
                        if (!StringUtils.equals((CharSequence)ref.getDetailCode(), (CharSequence)d.getCode())) continue;
                        String c = d.getContent();
                        Map cmap = (Map)d.getLang().get("content");
                        this.setContent(c, cmap, ref.getLineNo(), setting);
                        continue block0;
                    }
                    continue block0;
                }
            }
        }
    }

    public void setContent(String c, Map<String, String> cmap, List<Integer> lineNo, GuideSetting setting) {
        if (!CollectionUtils.isEmpty(lineNo)) {
            c = this.processLineNo(c, lineNo);
            for (Map.Entry<String, String> entry : cmap.entrySet()) {
                entry.setValue(this.processLineNo(entry.getValue(), lineNo));
            }
        }
        setting.setContent(c);
        if (setting.getLang() != null) {
            setting.getLang().put("content", cmap);
        } else {
            HashMap<String, Map<String, String>> lang = new HashMap<String, Map<String, String>>();
            lang.put("content", cmap);
            setting.setLang(lang);
        }
    }

    public String processLineNo(String c, List<Integer> lineNo) {
        String spliter = "\r\n";
        if (!c.contains(spliter)) {
            spliter = "\n";
        }
        String[] cs = c.split(spliter);
        StringBuilder tmp = new StringBuilder();
        for (Integer i : lineNo) {
            if (i > cs.length) continue;
            tmp.append(cs[i - 1] + "\r\n");
        }
        return tmp.toString();
    }
}

