/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.clients.EocService;
import com.digiwin.athena.knowledgegraph.dto.IMMessageDTO;
import com.digiwin.athena.knowledgegraph.dto.IMMessageTemplateDTO;
import com.digiwin.athena.knowledgegraph.dto.TenantAppExpireDTO;
import com.digiwin.athena.knowledgegraph.service.IIMService;
import com.digiwin.athena.knowledgegraph.service.impl.AppService;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Lang
@Service
public class IMService
implements IIMService {
    private static final Logger log = LoggerFactory.getLogger(IMService.class);
    @Autowired
    @Qualifier(value="aimRestTemplate")
    RestTemplate restTemplate;
    @Value(value="${aimUrl}")
    private String aimUrl;
    @Autowired
    EocService eocService;
    @Autowired
    AppService appService;
    @Autowired
    IamService iamService;
    private Integer bufferDays = 30;
    private Integer expiredDays = 60;

    @Override
    public void noticeAppRenew(String tenantId, String appCode) throws Exception {
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("tenantId", tenantId);
        requestMap.put("appCode", appCode);
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        headers.add("token", this.iamService.getTenantToken(tenantId));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(this.aimUrl + "/api/aim/v2/expire/renewal", HttpMethod.POST, requestEntity, Map.class, new Object[0]);
        if (result.getStatusCodeValue() != 200) {
            log.error("notice app [renew] failed for tenant:{} appcode:{}", (Object)tenantId, (Object)appCode);
        }
    }

    @Override
    public void noticeAppRestricted(String tenantId, String appCode) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        String tenantToken = this.iamService.getTenantToken(tenantId);
        headers.add("token", tenantToken);
        TenantAppExpireDTO tenantAppExpireDTO = this.buildAppMessage(tenantId, appCode, "buffer_period", tenantToken);
        HttpEntity requestEntity = new HttpEntity((Object)tenantAppExpireDTO, (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(this.aimUrl + "/api/aim/v2/expire/message", HttpMethod.POST, requestEntity, Map.class, new Object[0]);
        if (result.getStatusCodeValue() != 200) {
            log.error("notice app [restricted] failed for tenant:{} appcode:{}", (Object)tenantId, (Object)appCode);
        }
    }

    private TenantAppExpireDTO buildAppMessage(String tenantId, String appCode, String type, String token) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        TenantAppExpireDTO tenantAppExpireDTO = new TenantAppExpireDTO();
        tenantAppExpireDTO.setTenantId(tenantId);
        Set<String> userIds = this.eocService.appHasUser(appCode, tenantId, token);
        if (CollectionUtils.isEmpty(userIds)) {
            log.warn("tenant-[{}] app-[{}] has no auth user", (Object)tenantId, (Object)appCode);
            return null;
        }
        tenantAppExpireDTO.setUserIdList(userIds);
        tenantAppExpireDTO.setMessage(this.buildAppRestrictedMessageDTO(tenantId, appCode, type));
        return tenantAppExpireDTO;
    }

    private Date calculateBufferStartDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private Date calculateExpireStartDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private IMMessageDTO buildAppRestrictedMessageDTO(String tenantId, String appCode, String type) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        IMMessageDTO imMessageDTO = new IMMessageDTO();
        imMessageDTO.setAppCode(appCode);
        imMessageDTO.setType(type);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        switch (type) {
            case "buffer_period": {
                Date bufferStartDay = this.calculateBufferStartDay();
                imMessageDTO.setEndTime(sdf.format(this.calculateEndDay(bufferStartDay, this.bufferDays)));
                imMessageDTO.setTemplate(this.buildTemplate(appCode, type, bufferStartDay, tenantId));
                break;
            }
            case "data_retention": {
                Date expireStartDay = this.calculateExpireStartDay();
                imMessageDTO.setEndTime(sdf.format(this.calculateEndDay(expireStartDay, this.expiredDays)));
                imMessageDTO.setTemplate(this.buildTemplate(appCode, type, expireStartDay, tenantId));
                break;
            }
            default: {
                throw new DWBusinessException("unsupported message type");
            }
        }
        return imMessageDTO;
    }

    private IMMessageTemplateDTO buildTemplate(String appCode, String type, Date startDay, String tenantId) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        IMMessageTemplateDTO imMessageTemplateDTO = new IMMessageTemplateDTO();
        ArrayList<Map> variableList = new ArrayList<Map>();
        HashMap<String, String> var1 = new HashMap<String, String>();
        Application application = this.appService.getApplicationByCode(appCode, tenantId);
        LanguageUtil.processLocaleLanguage(application, AthenaUtils.getCurrentLocale());
        var1.put("key", "app_name");
        var1.put("value", application.getName());
        variableList.add(var1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, String> var2 = new HashMap<String, String>();
        var2.put("key", "expire_date");
        var2.put("value", sdf.format(startDay));
        variableList.add(var2);
        HashMap<String, String> var3 = new HashMap<String, String>();
        switch (type) {
            case "buffer_period": {
                imMessageTemplateDTO.setCode("buffer_period_template");
                var3.put("key", "deadline_date");
                var3.put("value", sdf.format(this.calculateEndDay(startDay, this.bufferDays)));
                variableList.add(var3);
                imMessageTemplateDTO.setVariableList(variableList);
                break;
            }
            case "data_retention": {
                imMessageTemplateDTO.setCode("data_retention_period_template");
                var3.put("key", "deadline_date");
                var3.put("value", sdf.format(this.calculateEndDay(startDay, this.expiredDays)));
                variableList.add(var3);
                imMessageTemplateDTO.setVariableList(variableList);
                break;
            }
            default: {
                throw new DWBusinessException("unsupported message type");
            }
        }
        imMessageTemplateDTO.setVariableList(variableList);
        return imMessageTemplateDTO;
    }

    private Date calculateEndDay(Date startDay, Integer bufferDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDay);
        calendar.add(5, bufferDays);
        return calendar.getTime();
    }

    @Override
    public void noticeAppExpired(String tenantId, String appCode) throws Exception {
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("tenantId", tenantId);
        requestMap.put("appId", appCode);
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        String tenantToken = this.iamService.getTenantToken(tenantId);
        headers.add("token", tenantToken);
        TenantAppExpireDTO tenantAppExpireDTO = this.buildAppMessage(tenantId, appCode, "data_retention", tenantToken);
        HttpEntity requestEntity = new HttpEntity((Object)tenantAppExpireDTO, (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(this.aimUrl + "/api/aim/v2/expire/message", HttpMethod.POST, requestEntity, Map.class, new Object[0]);
        if (result.getStatusCodeValue() != 200) {
            log.error("notice app [expired] failed for tenant:{} appcode:{}", (Object)tenantId, (Object)appCode);
        }
    }
}

