/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.domain.common.IndexStructure;
import com.digiwin.athena.domain.log.OperationRecord;
import com.digiwin.athena.domain.log.OperationRecordType;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.knowledgegraph.service.IIndexService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.OperationRecordUtil;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Lang
@Service
public class IndexService
implements IIndexService {
    private static final Logger log = LoggerFactory.getLogger(IndexService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplateSystem;
    @Autowired
    OperationRecordUtil operationRecordUtil;

    @Override
    public Object postIndexCheck() {
        List<String> databaseList = AthenaUtils.indexFiledName(Objects.requireNonNull(ServiceUtils.class.getResource("/index")).getPath());
        ArrayList<String> check = new ArrayList<String>();
        for (String database : databaseList) {
            String defaultIndex = AthenaUtils.loadStream("/index/" + database);
            List indexStructures = JSON.parseArray((String)defaultIndex, IndexStructure.class);
            String databaseName = database.replace(".json", "");
            if (CollectionUtils.isEmpty((Collection)indexStructures)) continue;
            for (IndexStructure indexStructure : indexStructures) {
                MongoCollection collection = this.mongoTemplateSystem.getMongoDbFactory().getDb(databaseName).getCollection(indexStructure.getCollectionName());
                ListIndexesIterable documents = collection.listIndexes();
                boolean needCreate = true;
                for (Document document : documents) {
                    boolean keyEquals;
                    if ("_id_".equals(document.get((Object)"name")) || !(keyEquals = ((Map)JSON.parseObject((String)JSON.toJSONString((Object)document.get((Object)"key")), Map.class)).keySet().containsAll(indexStructure.getKey()))) continue;
                    needCreate = false;
                }
                if (!needCreate) continue;
                check.add(databaseName + "," + indexStructure);
            }
        }
        if (!CollectionUtils.isEmpty(check)) {
            this.operationRecordUtil.recordInfo(OperationRecord.builder().type(OperationRecordType.INDEX.toString()).path(this.getClass().getName()).supplementaryContent(check).build());
        }
        return "ok";
    }

    @Override
    public Object postIndexCreate() throws DWException {
        List<String> databaseList = AthenaUtils.indexFiledName(Objects.requireNonNull(ServiceUtils.class.getResource("/index")).getPath());
        for (String database : databaseList) {
            String defaultIndex = AthenaUtils.loadStream("/index/" + database);
            List indexStructures = JSON.parseArray((String)defaultIndex, IndexStructure.class);
            String databaseName = database.replace(".json", "");
            if (CollectionUtils.isEmpty((Collection)indexStructures)) continue;
            for (IndexStructure indexStructure : indexStructures) {
                MongoCollection collection = this.mongoTemplateSystem.getMongoDbFactory().getDb(databaseName).getCollection(indexStructure.getCollectionName());
                ListIndexesIterable documents = collection.listIndexes();
                String indexName = String.join((CharSequence)"_", indexStructure.getKey());
                boolean needCreate = true;
                for (Document document : documents) {
                    boolean keyEquals;
                    if ("_id_".equals(document.get((Object)"name")) || !(keyEquals = ((Map)JSON.parseObject((String)JSON.toJSONString((Object)document.get((Object)"key")), Map.class)).keySet().containsAll(indexStructure.getKey()))) continue;
                    needCreate = false;
                }
                if (!needCreate) continue;
                IndexOptions indexOptions = new IndexOptions().name(indexName).unique(indexStructure.getUnique().booleanValue()).background(true);
                collection.createIndex(Indexes.ascending((List)indexStructure.getKey()), indexOptions);
            }
        }
        return "ok";
    }
}

