/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.MechanismApplyRecord;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.domain.component.bo.ComponentBaseInfoBO;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.clients.ESPUtils;
import com.digiwin.athena.knowledgegraph.component.ComponentApplyContext;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.knowledgegraph.dao.ActivityDAO;
import com.digiwin.athena.knowledgegraph.domain.ComponentStructuredList;
import com.digiwin.athena.knowledgegraph.domain.VariableDefinition;
import com.digiwin.athena.knowledgegraph.domain.mechanism.Mechanism;
import com.digiwin.athena.knowledgegraph.domain.mechanism.Principle;
import com.digiwin.athena.knowledgegraph.domain.mechanism.PrincipleDetail;
import com.digiwin.athena.knowledgegraph.domain.valueobject.ActivityDataEntryVO;
import com.digiwin.athena.knowledgegraph.enums.MechanismParameterTypeEnum;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.filter.LoginInfo;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismBuilderService;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.knowledgegraph.po.MechanismFunction;
import com.digiwin.athena.knowledgegraph.po.MechanismReq;
import com.digiwin.athena.knowledgegraph.po.MechanismUserDesignerInfo;
import com.digiwin.athena.knowledgegraph.po.PhPMechanismApiCommonConfig;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleConfigService;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IMechanismDesignService;
import com.digiwin.athena.knowledgegraph.service.IMechanismService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.ActionService;
import com.digiwin.athena.knowledgegraph.service.impl.TaskService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.service.model.MonitorRuleConfigDTO;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.ResultBean;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.JsonUtil;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import com.digiwin.athena.knowledgegraph.vo.mechanism.MechanismApiInfoReqVO;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.mechanism.bo.MechanismApiInfoBO;
import com.digiwin.athena.mechanism.bo.MechanismLogic;
import com.digiwin.athena.mechanism.pre.MechanismCapacity;
import com.digiwin.athena.mechanism.pre.MechanismMsgTemplate;
import com.digiwin.athena.mechanism.pre.MechanismPartDoc;
import com.digiwin.athena.mechanism.pre.MechanismTheory;
import com.digiwin.athena.mechanism.pre.parts.ActionWarnMessagePart;
import com.digiwin.athena.mechanism.vo.LinkInfo;
import com.digiwin.athena.mechanism.widgets.activity.IMActivityWidget;
import com.digiwin.athena.repository.neo4j.Activity2Repository;
import com.google.common.collect.ImmutableMap;
import com.mongodb.client.result.UpdateResult;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Lang
@Service
public class MechanismDesignService
implements IMechanismDesignService {
    private static final Logger log = LoggerFactory.getLogger(MechanismDesignService.class);
    public static final String FROM_USER = "user";
    public static final String UD_THEORY_PREFIX = "ud_p_";
    public static final String UD_THEORY_DETAIL_PREFIX = "ud_pd_";
    public static final String UD_CAPACITY_PREFIX = "ud_c_";
    public static final String SYSTEM = "SYSTEM";
    @Autowired
    private ActionService actionService;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    DataMapService dataMapService;
    @Autowired
    KgHelpService kgHelpService;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    TenantService tenantService;
    @Autowired
    MechanismBuilderService mechanismBuilderService;
    @Autowired
    IMechanismService mechanismService;
    @Autowired
    ComponentManager componentManager;
    @Autowired
    TaskService taskService;
    @Autowired
    IMechanismService iMechanismService;
    @Autowired
    ESPUtils espUtils;
    @Autowired
    MonitorRuleConfigService monitorRuleConfigService;
    @Autowired
    Activity2Repository activityRepository;
    @Autowired
    DataPickService dataPickService;
    @Autowired
    private ActivityDAO activityDAO;

    @Override
    public Object postMechanismDetail(MechanismReq req) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        Object object = this.mechanismService.postQueryMechanismByCode(req.getCode(), null);
        if (object == null) {
            return null;
        }
        Mechanism mechanism = (Mechanism)((Object)object);
        this.mergeMechanismDesignInfo(mechanism, 0);
        String tenantId = AthenaUtils.getTenantId();
        List<MechanismCapacity> mechanismCapacity = this.findMechanismCapacity(mechanism.getCode(), tenantId);
        List<MechanismCapacity> sysMechanismCapacity = this.findSysMechanismCapacity(mechanism.getCode(), tenantId, SYSTEM);
        mechanismCapacity = this.mergeMechanismCapacityInfo(mechanismCapacity, sysMechanismCapacity);
        mechanism.setCapacities(mechanismCapacity);
        LanguageUtil.processLocaleLanguage((Object)mechanism, AthenaUtils.getCurrentLocale());
        return mechanism;
    }

    @Override
    public Object postMechanismVariableByPrinciple(MechanismReq req) throws Exception {
        ArrayList<String> keyList = new ArrayList<String>();
        String tenantId = AthenaUtils.getTenantId();
        Criteria criteria = Criteria.where((String)"mechanismCode").is((Object)req.getCode()).and("appCode").is((Object)req.getAppCode());
        List<ComponentStructuredList> componentStructuredListBOS = this.dataPickService.find(criteria, ComponentStructuredList.class, "componentStructuredList");
        ArrayList<ComponentTypeEnum> mechanismArrayList = new ArrayList<ComponentTypeEnum>();
        mechanismArrayList.add(ComponentTypeEnum.MechanismVariable);
        mechanismArrayList.add(ComponentTypeEnum.MechanismParam);
        List<ComponentBO> componentBOS = this.componentManager.filterComponentByType(componentStructuredListBOS, mechanismArrayList, req.getTheoryCode());
        keyList.addAll(componentBOS.stream().map(ComponentBaseInfoBO::getCode).collect(Collectors.toList()));
        Query query1 = new Query();
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"mechanismCode").is((Object)req.getCode()).and("mechanismTheoryCode").is((Object)req.getTheoryCode()));
        List mechanismCapacities = this.mongoTemplateUser.find(query1, MechanismCapacity.class);
        this.filterMechanismVariable(keyList, mechanismCapacities);
        Criteria variableCriteria = new Criteria();
        if (CollectionUtils.isNotEmpty(req.getFilterType())) {
            variableCriteria.and("code").in(keyList).and("dataType").in(req.getFilterType()).and("application").is((Object)req.getAppCode());
        } else {
            variableCriteria.and("code").in(keyList).and("application").is((Object)req.getAppCode());
        }
        if (CollectionUtils.isNotEmpty(req.getDisplayType())) {
            variableCriteria.and("displayType").in(req.getDisplayType());
        }
        if (keyList.isEmpty()) {
            return null;
        }
        List<VariableDefinition> variableDefinitions = this.dataPickService.find(variableCriteria, VariableDefinition.class, "variableDefinition");
        for (VariableDefinition variableDefinition : variableDefinitions) {
            Map variable = (Map)this.mechanismService.getVariable(variableDefinition.getCode(), tenantId);
            variableDefinition.setValue(variable.get(variableDefinition.getCode()));
        }
        LanguageUtil.processLocaleLanguage(variableDefinitions, AthenaUtils.getCurrentLocale());
        return variableDefinitions;
    }

    private void filterMechanismVariable(ArrayList<String> keyList, List<MechanismCapacity> mechanismCapacities) {
        if (CollectionUtils.isNotEmpty(mechanismCapacities)) {
            for (MechanismCapacity mechanismCapacity : mechanismCapacities) {
                if (mechanismCapacity == null || !CollectionUtils.isNotEmpty((Collection)mechanismCapacity.getMechanismLink())) continue;
                for (LinkInfo linkInfo : mechanismCapacity.getMechanismLink()) {
                    if (!ComponentTypeEnum.MechanismVariable.toString().equals(linkInfo.getType())) continue;
                    keyList.add(linkInfo.getCode());
                }
            }
        }
    }

    @Override
    public Object postMechanismCapacity(MechanismReq req) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("code").is((Object)req.getCode()));
        MechanismCapacity one = (MechanismCapacity)this.mongoTemplateUser.findOne(query, MechanismCapacity.class);
        if (null == one) {
            String version = this.tenantService.getTenantVersion(tenantId);
            Query sysQuery = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)SYSTEM).and("code").is((Object)req.getCode()).and("version").is((Object)version));
            one = (MechanismCapacity)this.mongoTemplateSystem.findOne(sysQuery, MechanismCapacity.class);
        }
        return one;
    }

    @Override
    public Object postSaveMechanismTheory(MechanismReq req) throws DWBusinessException {
        List details;
        String code;
        MechanismTheory theory = req.getTheory();
        if (theory == null) {
            throw new DWBusinessException("mechanism theory is null");
        }
        if (StringUtils.isEmpty((CharSequence)req.getCode()) && StringUtils.isEmpty((CharSequence)req.getTheory().getMechanismCode())) {
            throw new DWBusinessException("mechanism code is null");
        }
        String tenantId = AthenaUtils.getTenantId();
        theory.setTenantId(tenantId);
        if (theory.getStatus() == null) {
            theory.setStatus(Integer.valueOf(0));
        }
        if (StringUtils.isEmpty((CharSequence)theory.getMechanismCode())) {
            theory.setMechanismCode(req.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)(code = theory.getCode()))) {
            code = UD_THEORY_PREFIX + UUID.randomUUID().toString().replace("-", "");
            theory.setCode(code);
            theory.setFrom(FROM_USER);
        }
        if (CollectionUtils.isNotEmpty((Collection)(details = theory.getDetails()))) {
            com.digiwin.athena.mechanism.pre.PrincipleDetail principleDetail = (com.digiwin.athena.mechanism.pre.PrincipleDetail)details.get(0);
            if (StringUtils.isEmpty((CharSequence)principleDetail.getCode())) {
                principleDetail.setCode(UD_THEORY_DETAIL_PREFIX + UUID.randomUUID().toString().replace("-", ""));
            }
            theory.setDetails(Arrays.asList(principleDetail));
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("code").is((Object)code));
        this.mongoTemplateUser.remove(query, MechanismTheory.class);
        this.mongoTemplateUser.save((Object)theory);
        return theory;
    }

    @Override
    public Object postSaveMechanismCapacity(MechanismReq req) throws DWBusinessException {
        MechanismCapacity capacity = this.kgHelpService.convert(req.getCapacity(), MechanismCapacity.class);
        if (capacity == null) {
            throw new DWBusinessException("mechanism capacity is null");
        }
        if (StringUtils.isEmpty((CharSequence)capacity.getMechanismTheoryCode())) {
            throw new DWBusinessException("mechanism theory code is null");
        }
        if (StringUtils.isEmpty((CharSequence)capacity.getMechanismCode()) && StringUtils.isEmpty((CharSequence)req.getCode())) {
            throw new DWBusinessException("mechanism code is null");
        }
        if (StringUtils.isEmpty((CharSequence)capacity.getMechanismCode())) {
            capacity.setMechanismCode(req.getCode());
        }
        String tenantId = AthenaUtils.getTenantId();
        String code = capacity.getCode();
        if (StringUtils.isEmpty((CharSequence)code)) {
            code = UD_CAPACITY_PREFIX + UUID.randomUUID().toString().replace("-", "");
            capacity.setCode(code);
        }
        capacity.setTenantId(tenantId);
        if (capacity.getStatus() == null) {
            capacity.setStatus(Integer.valueOf(0));
        }
        if (capacity.getCreateTime() == null) {
            capacity.setCreateTime(new Date());
        }
        if (StringUtils.isEmpty((CharSequence)capacity.getFrom())) {
            capacity.setFrom(FROM_USER);
        }
        this.setActivityWidgetMessage(capacity);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("code").is((Object)code));
        this.mongoTemplateUser.remove(query, MechanismCapacity.class);
        this.mongoTemplateUser.save((Object)capacity);
        return capacity;
    }

    public void setActivityWidgetMessage(MechanismCapacity capacity) {
        if (null != capacity.getAction() && "im".equalsIgnoreCase(capacity.getAction().getType())) {
            ActionWarnMessagePart actionWarnMessagePart = (ActionWarnMessagePart)capacity.getAction();
            List imActivityWidgets = actionWarnMessagePart.getImWidget();
            String currentLocale = AthenaUtils.getCurrentLocale();
            for (IMActivityWidget imActivityWidget : imActivityWidgets) {
                if (!"im".equalsIgnoreCase(imActivityWidget.getType()) || !"template".equalsIgnoreCase(imActivityWidget.getMsgType())) continue;
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"code").is((Object)imActivityWidget.getMsgCode()));
                MechanismMsgTemplate template = (MechanismMsgTemplate)this.mongoTemplateSystem.findOne(query, MechanismMsgTemplate.class);
                String currentContent = (String)((Map)template.getLang().get("content")).get(currentLocale);
                imActivityWidget.setMessage(StringUtils.isNotEmpty((CharSequence)currentContent) ? currentContent : template.getContent());
            }
        }
    }

    @Override
    public Object postDeleteMechanismTheory(MechanismReq req) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("code").is((Object)req.getCode()));
        Update update = new Update();
        update.set("status", (Object)-1);
        UpdateResult updateResult = this.mongoTemplateUser.updateFirst(query, update, MechanismTheory.class);
        return updateResult.getModifiedCount();
    }

    @Override
    public Object postDeleteMechanismCapacity(MechanismReq req) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("code").is((Object)req.getCode()));
        Update update = new Update();
        update.set("status", (Object)-1);
        UpdateResult updateResult = this.mongoTemplateUser.updateFirst(query, update, MechanismCapacity.class);
        return updateResult.getModifiedCount();
    }

    @Override
    public Object postApplyMechanismCapacity(MechanismReq req) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String version = this.tenantService.getTenantVersion(tenantId);
        MechanismCapacity capacity = this.kgHelpService.convert(req.getCapacity(), MechanismCapacity.class);
        if (null == capacity) {
            return null;
        }
        this.setActivityWidgetMessage(capacity);
        if (StringUtils.isEmpty((CharSequence)capacity.getCode())) {
            String code = UD_CAPACITY_PREFIX + UUID.randomUUID().toString().replace("-", "");
            capacity.setCode(code);
        }
        req.setCapacity(capacity);
        if (StringUtils.isNotEmpty((CharSequence)capacity.getType())) {
            String pluginId = capacity.getCode() + "_" + tenantId;
            MechanismParseContext context = new MechanismParseContext();
            context.setTenantId(tenantId);
            context.setTenantVersion(version);
            context.setCapacity(capacity);
            context.setPluginId(pluginId);
            MechanismLogic logic = this.mechanismBuilderService.build(context);
            this.kgHelpService.executeCyhper("match(m:MechanismComponent{pluginId:'" + pluginId + "'}) detach delete m", new HashMap<String, Object>());
            String cyhper = context.getCypherSb().toString();
            this.kgHelpService.executeCyhper(cyhper, new HashMap<String, Object>());
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("code").is((Object)capacity.getCode()));
            this.mongoTemplateUser.remove(query, MechanismLogic.class);
            this.mongoTemplateUser.save((Object)logic);
        }
        Object o = this.applyMechanismInfo(req);
        return o;
    }

    private Object applyMechanismInfo(MechanismReq req) throws DWBusinessException {
        MechanismCapacity capacity = this.kgHelpService.convert(req.getCapacity(), MechanismCapacity.class);
        capacity.setStatus(Integer.valueOf(1));
        req.setCapacity(capacity);
        Object savedCapacity = this.postSaveMechanismCapacity(req);
        String mechanismTheoryCode = capacity.getMechanismTheoryCode();
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("code").is((Object)mechanismTheoryCode));
        Update update = new Update();
        update.set("status", (Object)1);
        this.mongoTemplateUser.updateMulti(query, update, MechanismTheory.class);
        return savedCapacity;
    }

    @Override
    public Object postUnApplyMechanismCapacity(MechanismReq req) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        MechanismCapacity capacity = this.kgHelpService.convert(req.getCapacity(), MechanismCapacity.class);
        if (null == capacity) {
            return null;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("code").is((Object)capacity.getCode()));
        Update update = new Update();
        update.set("status", (Object)0);
        UpdateResult updateResult1 = this.mongoTemplateUser.updateMulti(query, update, MechanismCapacity.class);
        Query query2 = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("mechanismTheoryCode").is((Object)capacity.getMechanismTheoryCode()).and("status").is((Object)1));
        List publishedMechanismCapacities = this.mongoTemplateUser.find(query2, MechanismCapacity.class);
        if (CollectionUtils.isEmpty((Collection)publishedMechanismCapacities) || publishedMechanismCapacities.size() == 1 && ((MechanismCapacity)publishedMechanismCapacities.get(0)).getCode().equals(capacity.getCode())) {
            Query query3 = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("code").is((Object)capacity.getMechanismTheoryCode()));
            Update update2 = new Update();
            update2.set("status", (Object)0);
            UpdateResult updateResult = this.mongoTemplateUser.updateMulti(query3, update2, MechanismTheory.class);
            log.info("UnApplyMechanismTheory code:{}, count", (Object)capacity.getMechanismTheoryCode(), (Object)updateResult.getModifiedCount());
        }
        return updateResult1.getModifiedCount();
    }

    @Override
    public Object postResetTenantMechanismCapacity(MechanismReq req) throws DWBusinessException {
        return null;
    }

    private boolean checkTheoryMatchStatus(List<MechanismCapacity> mechanismCapacityList, String theoryCode, Integer status) {
        if (CollectionUtils.isEmpty(mechanismCapacityList)) {
            return 0 == status;
        }
        List collect = mechanismCapacityList.stream().filter(e -> StringUtils.equals((String)theoryCode, (String)e.getMechanismTheoryCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return 0 == status;
        }
        List publishedCapacity = collect.stream().filter(e -> 1 == e.getStatus()).collect(Collectors.toList());
        if (1 == status) {
            return CollectionUtils.isNotEmpty(publishedCapacity);
        }
        return CollectionUtils.isEmpty(publishedCapacity);
    }

    public void mergeMechanismDesignInfo(Mechanism mechanism, Integer status) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        List<MechanismTheory> mechanismTheoryList = this.findMechanismTheory(mechanism.getCode(), tenantId);
        List<MechanismCapacity> mechanismCapacityList = this.findMechanismCapacity(mechanism.getCode(), tenantId);
        List<MechanismCapacity> sysMechanismCapacity = this.findSysMechanismCapacity(mechanism.getCode(), tenantId, SYSTEM);
        List<MechanismCapacity> mergeMechanismCapacityList = this.mergeMechanismCapacityInfo(mechanismCapacityList, sysMechanismCapacity);
        Map mechanismTheoryMap = mechanismTheoryList.stream().filter(e -> -1 != e.getStatus()).filter(e -> this.checkTheoryMatchStatus(mergeMechanismCapacityList, e.getCode(), status)).collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (key1, key2) -> key2));
        List<Principle> principles = mechanism.getPrinciples();
        for (Principle principle : principles) {
            MechanismTheory mechanismTheory2 = (MechanismTheory)mechanismTheoryMap.remove(principle.getCode());
            List<MechanismCapacity> mechanismCapacities = this.filterMechanismCapacity(mergeMechanismCapacityList, principle.getCode(), status);
            List<PrincipleDetail> principleDetails = this.generatePrincipleDetail(mechanismCapacities);
            List<PrincipleDetail> details = principle.getDetails();
            if (CollectionUtils.isNotEmpty(details) && CollectionUtils.isNotEmpty(principleDetails)) {
                details.addAll(principleDetails);
            }
            if (!CollectionUtils.isEmpty(details)) continue;
            principle.setDetails(principleDetails);
        }
        ArrayList userDesignPrinciples = new ArrayList();
        if (!mechanismTheoryMap.isEmpty()) {
            mechanismTheoryMap.values().forEach(mechanismTheory -> {
                Principle principle = (Principle)((Object)((Object)JSON.parseObject((String)JSON.toJSONString((Object)mechanismTheory), Principle.class)));
                principle.setFrom(FROM_USER);
                principle.setStatus(status);
                List<MechanismCapacity> mechanismCapacities = this.filterMechanismCapacity(mergeMechanismCapacityList, principle.getCode(), status);
                List<PrincipleDetail> principleDetails = this.generatePrincipleDetail(mechanismCapacities);
                List<PrincipleDetail> details = principle.getDetails();
                if (CollectionUtils.isNotEmpty(details) && CollectionUtils.isNotEmpty(principleDetails)) {
                    details.addAll(principleDetails);
                }
                if (CollectionUtils.isEmpty(details)) {
                    principle.setDetails(principleDetails);
                }
                userDesignPrinciples.add(principle);
            });
        }
        principles.addAll(userDesignPrinciples);
        List<Principle> sortedPrinciples = principles.stream().sorted((c1, c2) -> {
            Integer sequence = c1.getSequence();
            Integer sequence2 = c2.getSequence();
            if (sequence == null) {
                sequence = -1;
            }
            if (sequence2 == null) {
                sequence2 = -1;
            }
            return sequence - sequence2;
        }).collect(Collectors.toList());
        mechanism.setPrinciples(sortedPrinciples);
        if (1 == status) {
            List<MechanismCapacity> publishedCapacityList = mergeMechanismCapacityList.stream().filter(e -> status == e.getStatus()).collect(Collectors.toList());
            List<FieldDescription> fieldDescriptions = this.generateParamDescription(publishedCapacityList);
            List<FieldDescription> paramDescription = mechanism.getParamDescription();
            if (paramDescription == null) {
                mechanism.setParamDescription(fieldDescriptions);
            } else if (CollectionUtils.isNotEmpty(fieldDescriptions)) {
                paramDescription.addAll(fieldDescriptions);
            }
        }
    }

    public List<MechanismCapacity> mergeMechanismCapacityInfo(List<MechanismCapacity> mechanismCapacity, List<MechanismCapacity> sysMechanismCapacity) {
        if (CollectionUtils.isEmpty(sysMechanismCapacity)) {
            return mechanismCapacity;
        }
        if (CollectionUtils.isEmpty(mechanismCapacity)) {
            return sysMechanismCapacity;
        }
        mechanismCapacity.addAll(sysMechanismCapacity);
        return mechanismCapacity.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MechanismCapacity>(Comparator.comparing(o -> o.getCode() + ";" + o.getMechanismTheoryCode() + ";" + o.getMechanismCode()))), ArrayList::new));
    }

    private List<FieldDescription> generateParamDescription(List<MechanismCapacity> mechanismCapacities) throws DWBusinessException {
        if (CollectionUtils.isEmpty(mechanismCapacities)) {
            return null;
        }
        ArrayList<FieldDescription> result = new ArrayList<FieldDescription>();
        for (MechanismCapacity capacity : mechanismCapacities) {
            List links = capacity.getLinks();
            if (!CollectionUtils.isNotEmpty((Collection)links)) continue;
            for (LinkInfo each : links) {
                this.generateFieldDescription(each).map(result::add);
            }
        }
        return result;
    }

    private Optional<FieldDescription> generateFieldDescription(LinkInfo linkInfo) throws DWBusinessException {
        if ("BaseDataEntry".equals(linkInfo.getType())) {
            FieldDescription fieldDescription = MechanismDesignService.constractDefaultFieldDescription(linkInfo);
            String tenantId = AthenaUtils.getTenantId();
            String version = this.tenantService.getTenantVersion(tenantId);
            Activity activityNeo4j = this.dataPickService.chooseOneWithSameCode(this.activityDAO.getActivityByCodeAndVersion(linkInfo.getCode(), version, tenantId));
            fieldDescription.setKey(linkInfo.getCode());
            fieldDescription.setValue((Object)("&routerLink=/base-data-entry&code=" + linkInfo.getCode() + "&category=" + linkInfo.getCategory()));
            fieldDescription.setFrom("athena");
            fieldDescription.setDescription("\u8df3\u8f6c\u5230athena\u57fa\u7840\u8d44\u6599\u5f55\u5165\u8fdb\u884c\u76f8\u5173\u57fa\u7840\u8d44\u6599\u5f55\u5165");
            fieldDescription.setName(activityNeo4j.getName());
            HashMap<String, Map> lang = new HashMap<String, Map>();
            Map nameLang = activityNeo4j.getLang() == null ? null : (Map)activityNeo4j.getLang().get("name");
            HashMap<String, String> descriptionLang = new HashMap<String, String>();
            descriptionLang.put("zh_TW", "\u8df3\u8f49\u5230athena\u57fa\u790e\u8cc7\u6599\u9304\u5165\u9032\u884c\u76f8\u95dc\u57fa\u790e\u8cc7\u6599\u9304\u5165");
            descriptionLang.put("zh_CN", "\u8df3\u8f6c\u5230athena\u57fa\u7840\u8d44\u6599\u5f55\u5165\u8fdb\u884c\u76f8\u5173\u57fa\u7840\u8d44\u6599\u5f55\u5165");
            lang.put("name", nameLang);
            lang.put("description", descriptionLang);
            fieldDescription.setLang(lang);
            return Optional.of(fieldDescription);
        }
        if ("Report".equals(linkInfo.getType())) {
            Activity activityConfig = this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)linkInfo.getCode()), Activity.class, "activityConfigs");
            FieldDescription fieldDescription = MechanismDesignService.constractDefaultFieldDescription(linkInfo);
            fieldDescription.setKey(linkInfo.getCode());
            fieldDescription.setValue((Object)("&routerLink=/report&code=" + linkInfo.getCode() + "&category=" + linkInfo.getCategory() + "&appCode=" + linkInfo.getAppCode()));
            fieldDescription.setFrom("athena");
            fieldDescription.setDescription("\u8df3\u8f6c\u5230athena\u62a5\u8868\u9875\u9762");
            fieldDescription.setName(activityConfig.getName());
            HashMap<String, Map> lang = new HashMap<String, Map>();
            Map nameLang = activityConfig.getLang() == null ? null : (Map)activityConfig.getLang().get("name");
            HashMap<String, String> descriptionLang = new HashMap<String, String>();
            descriptionLang.put("zh_TW", "\u8df3\u8f49\u5230athena\u5831\u8868\u9801\u9762");
            descriptionLang.put("zh_CN", "\u8df3\u8f6c\u5230athena\u62a5\u8868\u9875\u9762");
            lang.put("name", nameLang);
            lang.put("description", descriptionLang);
            fieldDescription.setLang(lang);
            return Optional.of(fieldDescription);
        }
        if ("GlobalInformation".equals(linkInfo.getType())) {
            FieldDescription fieldDescription = MechanismDesignService.constractDefaultFieldDescription(linkInfo);
            fieldDescription.setKey(linkInfo.getType());
            fieldDescription.setValue((Object)"&routerLink=/global-information");
            fieldDescription.setFrom("athena");
            fieldDescription.setDescription("\u8df3\u8f6c\u5230athena\u5168\u5c40\u8d44\u8baf\u9875\u9762");
            fieldDescription.setName("\u5168\u5c40\u8d44\u8baf");
            HashMap lang = new HashMap();
            HashMap<String, String> nameLang = new HashMap<String, String>();
            nameLang.put("zh_TW", "\u5168\u5c40\u8cc7\u8a0a");
            nameLang.put("zh_CN", "\u5168\u5c40\u8d44\u8baf");
            HashMap<String, String> descriptionLang = new HashMap<String, String>();
            descriptionLang.put("zh_TW", "\u8df3\u8f49\u5230athena\u5168\u5c40\u8cc7\u8a0a\u9801\u9762");
            descriptionLang.put("zh_CN", "\u8df3\u8f6c\u5230athena\u5168\u5c40\u8d44\u8baf\u9875\u9762");
            lang.put("name", nameLang);
            lang.put("description", descriptionLang);
            fieldDescription.setLang(lang);
            return Optional.of(fieldDescription);
        }
        if ("CommonSet".equals(linkInfo.getType())) {
            FieldDescription fieldDescription = MechanismDesignService.constractDefaultFieldDescription(linkInfo);
            fieldDescription.setKey(linkInfo.getType());
            fieldDescription.setValue((Object)"&routerLink=com-set");
            fieldDescription.setFrom("tdd");
            fieldDescription.setDescription("\u8df3\u8f6c\u5230\u5168\u5c40\u8d44\u8baf\u901a\u7528\u53c2\u6570");
            fieldDescription.setName("\u5168\u5c40\u770b\u677f\u5448\u73b0\u914d\u7f6e");
            HashMap lang = new HashMap();
            HashMap<String, String> nameLang = new HashMap<String, String>();
            nameLang.put("zh_TW", "\u5168\u5c40\u770b\u677f\u5448\u73fe\u914d\u7f6e");
            nameLang.put("zh_CN", "\u5168\u5c40\u770b\u677f\u5448\u73b0\u914d\u7f6e");
            HashMap<String, String> descriptionLang = new HashMap<String, String>();
            descriptionLang.put("zh_TW", "\u8df3\u8f49\u5230\u5168\u5c40\u8cc7\u8a0a\u901a\u7528\u53c3\u6578");
            descriptionLang.put("zh_CN", "\u8df3\u8f6c\u5230\u5168\u5c40\u8d44\u8baf\u901a\u7528\u53c2\u6570");
            lang.put("name", nameLang);
            lang.put("description", descriptionLang);
            fieldDescription.setLang(lang);
            return Optional.of(fieldDescription);
        }
        if ("Project".equals(linkInfo.getType())) {
            JSONObject projectObj;
            Object project;
            HashMap<String, String> nameLang = new HashMap<String, String>();
            nameLang.put("zh_TW", "\u767c\u8d77\u5c08\u6848");
            nameLang.put("zh_CN", "\u53d1\u8d77\u9879\u76ee");
            if (StringUtils.isNotEmpty((CharSequence)linkInfo.getCode()) && (project = this.dataMapService.getProject(linkInfo.getCode())) != null && (projectObj = JSON.parseObject((String)JSON.toJSONString((Object)project))).containsKey((Object)"taskName")) {
                JSONObject taskNameLang = projectObj.getJSONObject("taskName");
                nameLang.put("zh_TW", "\u767c\u8d77-" + taskNameLang.getString("zh_TW"));
                nameLang.put("zh_CN", "\u53d1\u8d77-" + taskNameLang.getString("zh_CN"));
            }
            FieldDescription fieldDescription = MechanismDesignService.constractDefaultFieldDescription(linkInfo);
            fieldDescription.setKey(linkInfo.getCode());
            fieldDescription.setValue((Object)("&routerLink=/add-task&code=" + linkInfo.getCode()));
            fieldDescription.setFrom("athena");
            fieldDescription.setDescription("\u8df3\u8f6c\u5230athena\u53d1\u8d77\u9879\u76ee");
            fieldDescription.setName((String)nameLang.get(AthenaUtils.getCurrentLocale()));
            HashMap lang = new HashMap();
            HashMap<String, String> descriptionLang = new HashMap<String, String>();
            descriptionLang.put("zh_TW", "\u8df3\u8f49\u5230athena\u767c\u8d77\u5c08\u6848");
            descriptionLang.put("zh_CN", "\u8df3\u8f6c\u5230athena\u53d1\u8d77\u9879\u76ee");
            lang.put("name", nameLang);
            lang.put("description", descriptionLang);
            fieldDescription.setLang(lang);
            return Optional.of(fieldDescription);
        }
        return Optional.empty();
    }

    private static FieldDescription constractDefaultFieldDescription(LinkInfo linkInfo) {
        FieldDescription fieldDescription = new FieldDescription();
        fieldDescription.setIsExecute(Boolean.valueOf(true));
        fieldDescription.setDataType("object");
        fieldDescription.setReadOnly(false);
        fieldDescription.setVersion("1.0");
        fieldDescription.setRequired(Boolean.valueOf(true));
        fieldDescription.setDisplayType("LINK");
        fieldDescription.setCategory("link");
        fieldDescription.setIsSimulation(Boolean.valueOf(false));
        if (StringUtils.isNotEmpty((CharSequence)linkInfo.getTarget())) {
            fieldDescription.setTarget(linkInfo.getTarget());
        }
        return fieldDescription;
    }

    private List<PrincipleDetail> generatePrincipleDetail(List<MechanismCapacity> mechanismCapacities) {
        if (null == mechanismCapacities || mechanismCapacities.isEmpty()) {
            return null;
        }
        ArrayList<PrincipleDetail> details = new ArrayList<PrincipleDetail>();
        List<MechanismCapacity> collect = mechanismCapacities.stream().sorted(this::sortCapacities).collect(Collectors.toList());
        collect.forEach(e -> {
            PrincipleDetail principleDetail = new PrincipleDetail();
            principleDetail.setCode(e.getCode());
            principleDetail.setTitle(this.handleLanguage(e.getName(), e.getLang(), "name"));
            principleDetail.setDescription(this.handleLanguage(e.getDescription(), e.getLang(), "description"));
            if (CollectionUtils.isEmpty((Collection)e.getLinks())) {
                principleDetail.setRelatedParamKeys(Arrays.asList(e.getCode()));
            } else {
                List collect1 = e.getLinks().stream().map(linkInfo -> {
                    if ("GlobalInformation".equals(linkInfo.getType()) || "CommonSet".equals(linkInfo.getType())) {
                        return linkInfo.getType();
                    }
                    return linkInfo.getCode();
                }).distinct().collect(Collectors.toList());
                ArrayList<String> paramKeys = new ArrayList<String>();
                paramKeys.add(e.getCode());
                paramKeys.addAll(collect1);
                principleDetail.setRelatedParamKeys(paramKeys);
            }
            principleDetail.setFrom(FROM_USER);
            details.add(principleDetail);
        });
        return details;
    }

    private String handleLanguage(String origin, Map<String, Map<String, String>> lang, String key) {
        if (null != lang && lang.containsKey(key)) {
            Map<String, String> map = lang.get(key);
            String locale = AthenaUtils.getCurrentLocale();
            if (map != null && map.containsKey(locale)) {
                return map.get(locale);
            }
        }
        return origin;
    }

    private int sortCapacities(MechanismCapacity c1, MechanismCapacity c2) {
        return Long.compare(this.getSortedTime(c1), this.getSortedTime(c2));
    }

    private long getSortedTime(MechanismCapacity capacity) {
        if (capacity.getCreateDate() != null) {
            return capacity.getCreateDate().getTime();
        }
        return capacity.getCreateTime() == null ? 0L : capacity.getCreateTime().getTime();
    }

    public void mergeMechanismDesignInfoByStatus(Mechanism mechanism, Integer status) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        List<MechanismTheory> mechanismTheoryList = this.findMechanismTheory(mechanism.getCode(), tenantId);
        List<MechanismCapacity> mechanismCapacityList = this.findMechanismCapacity(mechanism.getCode(), tenantId);
        Map mechanismTheoryMap = mechanismTheoryList.stream().filter(e -> status == e.getStatus()).collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (key1, key2) -> key2));
        List<Principle> principles = mechanism.getPrinciples();
        for (Principle principle : principles) {
            List<PrincipleDetail> details;
            MechanismTheory mechanismTheory = (MechanismTheory)mechanismTheoryMap.remove(principle.getCode());
            if (mechanismTheory != null) {
                principle.setFrom(mechanismTheory.getFrom());
            }
            if (!CollectionUtils.isNotEmpty(details = principle.getDetails())) continue;
            for (int i = 0; i < details.size(); ++i) {
                com.digiwin.athena.mechanism.pre.PrincipleDetail mechanismTheoryDetail;
                PrincipleDetail principleDetail = details.get(i);
                if (mechanismTheory != null && (mechanismTheoryDetail = this.findMechanismTheoryDetail(mechanismTheory.getDetails(), principleDetail.getCode())) != null) {
                    principleDetail.setContent(mechanismTheoryDetail.getContent());
                }
                if (i != details.size() - 1) continue;
                List<String> relatedParamKeys = principleDetail.getRelatedParamKeys();
                if (CollectionUtils.isEmpty(relatedParamKeys)) {
                    List<MechanismCapacity> mechanismCapacities = this.filterMechanismCapacity(mechanismCapacityList, principle.getCode(), status);
                    if (null == mechanismCapacities || mechanismCapacities.isEmpty()) continue;
                    List<String> mechanismCapacityCodeList = mechanismCapacities.stream().map(BaseEntity::getCode).collect(Collectors.toList());
                    principleDetail.setRelatedParamKeys(mechanismCapacityCodeList);
                    String str = this.mergeMechanismCapacityDescription(principleDetail.getDescription(), mechanismCapacities);
                    principleDetail.setDescription(str);
                    continue;
                }
                ArrayList<String> newRelatedParamKeyList = new ArrayList<String>();
                ArrayList<MechanismCapacity> matchedMechanismCapacityList = new ArrayList<MechanismCapacity>();
                List<MechanismCapacity> mechanismCapacities = this.filterMechanismCapacity(mechanismCapacityList, principle.getCode());
                Map collect = mechanismCapacities.stream().collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (key1, key2) -> key2));
                for (String relatedParamKey : relatedParamKeys) {
                    MechanismCapacity capacity2 = (MechanismCapacity)collect.remove(relatedParamKey);
                    if (capacity2 == null) {
                        newRelatedParamKeyList.add(relatedParamKey);
                        continue;
                    }
                    if (1 == status && 1 == capacity2.getStatus()) {
                        newRelatedParamKeyList.add(relatedParamKey);
                        matchedMechanismCapacityList.add(capacity2);
                        continue;
                    }
                    if (0 != status || 1 != capacity2.getStatus() && 0 != capacity2.getStatus()) continue;
                    newRelatedParamKeyList.add(relatedParamKey);
                }
                if (!collect.isEmpty()) {
                    collect.values().forEach(capacity -> {
                        if (1 == status && 1 == capacity.getStatus()) {
                            newRelatedParamKeyList.add(capacity.getCode());
                            matchedMechanismCapacityList.add((MechanismCapacity)capacity);
                        } else if (0 == status && (1 == capacity.getStatus() || 0 == capacity.getStatus())) {
                            newRelatedParamKeyList.add(capacity.getCode());
                        }
                    });
                }
                principleDetail.setRelatedParamKeys(newRelatedParamKeyList);
                String str = this.mergeMechanismCapacityDescription(principleDetail.getDescription(), matchedMechanismCapacityList);
                principleDetail.setDescription(str);
            }
        }
        if (!mechanismTheoryMap.isEmpty()) {
            mechanismTheoryMap.values().forEach(e -> {
                Principle principle = (Principle)((Object)((Object)JSON.parseObject((String)JSON.toJSONString((Object)e), Principle.class)));
                if (CollectionUtils.isNotEmpty(principle.getDetails())) {
                    PrincipleDetail principleDetail = principle.getDetails().get(0);
                    ArrayList<String> newRelatedParamKeyList = new ArrayList<String>();
                    ArrayList<MechanismCapacity> matchedMechanismCapacityList = new ArrayList<MechanismCapacity>();
                    List<MechanismCapacity> mechanismCapacities = this.filterMechanismCapacity(mechanismCapacityList, principle.getCode());
                    if (CollectionUtils.isNotEmpty(mechanismCapacities)) {
                        mechanismCapacities.forEach(capacity -> {
                            if (1 == status && 1 == capacity.getStatus()) {
                                newRelatedParamKeyList.add(capacity.getCode());
                                matchedMechanismCapacityList.add((MechanismCapacity)capacity);
                            } else if (0 == status && (1 == capacity.getStatus() || 0 == capacity.getStatus())) {
                                newRelatedParamKeyList.add(capacity.getCode());
                            }
                        });
                    }
                    principleDetail.setRelatedParamKeys(newRelatedParamKeyList);
                    String str = this.mergeMechanismCapacityDescription(principleDetail.getDescription(), matchedMechanismCapacityList);
                    principleDetail.setDescription(str);
                }
                principles.add(principle);
            });
        }
    }

    private String mergeMechanismCapacityDescription(String sourceDescription, List<MechanismCapacity> mechanismCapacities) {
        if (CollectionUtils.isEmpty(mechanismCapacities)) {
            return sourceDescription;
        }
        StringBuilder sb = new StringBuilder();
        mechanismCapacities.forEach(e -> sb.append(e.getName() + ":" + e.getDescription() + "\r\n"));
        if (StringUtils.isEmpty((CharSequence)sourceDescription)) {
            return sb.toString();
        }
        if (sourceDescription.endsWith("\r\n")) {
            return sourceDescription + sb.toString();
        }
        return sourceDescription + "\r\n" + sb.toString();
    }

    private com.digiwin.athena.mechanism.pre.PrincipleDetail findMechanismTheoryDetail(List<com.digiwin.athena.mechanism.pre.PrincipleDetail> details1, String code) {
        if (CollectionUtils.isEmpty(details1)) {
            return null;
        }
        Optional<com.digiwin.athena.mechanism.pre.PrincipleDetail> any = details1.stream().filter(e -> StringUtils.equals((String)e.getCode(), (String)code)).findAny();
        if (any.isPresent()) {
            return any.get();
        }
        return null;
    }

    private MechanismCapacity filterMechanismCapacity(List<MechanismCapacity> mechanismCapacityList, String theoryCode, String capacityCode) {
        if (CollectionUtils.isEmpty(mechanismCapacityList)) {
            return null;
        }
        Optional<MechanismCapacity> collect = mechanismCapacityList.stream().filter(e -> StringUtils.equals((String)theoryCode, (String)e.getMechanismTheoryCode()) && StringUtils.equals((String)capacityCode, (String)e.getCode())).findAny();
        if (collect.isPresent()) {
            return collect.get();
        }
        return null;
    }

    private List<MechanismCapacity> filterMechanismCapacity(List<MechanismCapacity> mechanismCapacityList, String theoryCode) {
        if (CollectionUtils.isEmpty(mechanismCapacityList)) {
            return null;
        }
        List<MechanismCapacity> collect = mechanismCapacityList.stream().filter(e -> StringUtils.equals((String)theoryCode, (String)e.getMechanismTheoryCode())).collect(Collectors.toList());
        return collect;
    }

    private List<MechanismCapacity> filterMechanismCapacity(List<MechanismCapacity> mechanismCapacityList, String theoryCode, Integer status) {
        if (CollectionUtils.isEmpty(mechanismCapacityList)) {
            return null;
        }
        List<MechanismCapacity> collect = mechanismCapacityList.stream().filter(e -> StringUtils.equals((String)theoryCode, (String)e.getMechanismTheoryCode()) && status == e.getStatus()).collect(Collectors.toList());
        return collect;
    }

    private MechanismTheory filterMechanismTheory(List<MechanismTheory> mechanismTheoryList, String theoryCode, Integer status) {
        if (CollectionUtils.isEmpty(mechanismTheoryList)) {
            return null;
        }
        Optional<MechanismTheory> any = mechanismTheoryList.stream().filter(e -> StringUtils.equals((String)theoryCode, (String)e.getCode()) && status == e.getStatus()).findAny();
        if (any.isPresent()) {
            return any.get();
        }
        return null;
    }

    private List<MechanismTheory> findMechanismTheory(String mechanismCode, String tenantId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mechanismCode").is((Object)mechanismCode).and("tenantId").is((Object)tenantId));
        List mechanismTheories = this.mongoTemplateUser.find(query, MechanismTheory.class);
        return mechanismTheories;
    }

    private List<MechanismCapacity> findMechanismCapacity(String mechanismCode, String tenantId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mechanismCode").is((Object)mechanismCode).and("tenantId").is((Object)tenantId));
        List mechanismCapacities = this.mongoTemplateUser.find(query, MechanismCapacity.class);
        return mechanismCapacities;
    }

    private List<MechanismCapacity> findSysMechanismCapacity(String mechanismCode, String tenantId, String tenantSysId) {
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mechanismCode").is((Object)mechanismCode).and("tenantId").is((Object)tenantSysId).and("version").is((Object)tenantVersion));
        List mechanismCapacities = this.mongoTemplateSystem.find(query, MechanismCapacity.class);
        return mechanismCapacities;
    }

    @Override
    public Object postProject(MechanismReq req) throws DWBusinessException {
        return null;
    }

    @Override
    public Object postDataMeta(MechanismReq req) throws DWBusinessException {
        return null;
    }

    @Override
    public Object getBasicDataList(String pattern, String appCode) throws Exception {
        Object activitiesObject = this.taskService.getActivitiesByPattern(pattern);
        if (activitiesObject == null) {
            return null;
        }
        List activitiesByPattern = JSON.parseArray((String)JSON.toJSONString((Object)activitiesObject), ActivityDataEntryVO.class);
        ArrayList<ActivityDataEntryVO> list = new ArrayList<ActivityDataEntryVO>();
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        for (ActivityDataEntryVO vo : activitiesByPattern) {
            if (!vo.getAppCode().equals(appCode)) continue;
            Activity betterActivity = this.kgInnerService.findBetterActivity(tenantId, vo.getCode(), tenantVersion);
            if (betterActivity == null || ObjectUtils.isEmpty((Object)betterActivity.getDataSources())) {
                log.warn("BasicData not search activityConfigs,code:{}", (Object)vo.getCode());
                continue;
            }
            Map dataSources = betterActivity.getDataSources();
            Object actionId = JsonUtil.getJsonValue(JSON.toJSONString((Object)dataSources), "actionId");
            vo.setActionId(actionId);
            vo.setDataSources(dataSources);
            list.add(vo);
        }
        for (ActivityDataEntryVO vo : list) {
            ArrayList<Object> operations = new ArrayList<Object>();
            this.addOperations("\u6253\u5f00\u65f6", "\u6253\u958b\u6642", "open", operations);
            this.addOperations("\u4fee\u6539\u65f6", "\u4fee\u6539\u6642", "update", operations);
            this.addOperations("\u65b0\u589e\u65f6", "\u65b0\u589e\u6642", "add", operations);
            this.addOperations("\u5220\u9664\u65f6", "\u522a\u9664\u6642", "delete", operations);
            vo.setOperations(operations);
        }
        return list;
    }

    @Override
    public Object postPartInfo(MechanismReq req) throws DWBusinessException {
        Query query = new Query();
        if (null != req.getAppCode()) {
            Criteria criteria = new Criteria();
            criteria.orOperator(new Criteria[]{Criteria.where((String)"applications").in(new Object[]{req.getAppCode()}), Criteria.where((String)"applications").is(null)});
            query.addCriteria((CriteriaDefinition)criteria);
        }
        if (null != req.getAbility()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"abilities").in(new Object[]{req.getAbility()}));
        }
        if (null != req.getFactor()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"factors").in(new Object[]{req.getFactor()}));
        }
        List docs = this.mongoTemplateSystem.find(query, MechanismPartDoc.class);
        return docs;
    }

    private void addOperations(String labelCN, String labelTW, String op, List<Object> operations) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("value", op);
        map1.put("label", labelCN);
        map1.put("lang", (String)ImmutableMap.of((Object)"label", (Object)ImmutableMap.of((Object)"zh_CN", (Object)labelCN, (Object)"zh_TW", (Object)labelTW)));
        operations.add(map1);
    }

    public void updateUserDesignMechanismInfo(MechanismUserDesignerInfo info) throws DWBusinessException {
        List<MechanismTheory> theoryList = info.getTheory();
        if (!CollectionUtils.isEmpty(theoryList)) {
            MechanismTheory mechanismTheory = theoryList.get(0);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)AthenaUtils.getTenantId()).and("code").is((Object)mechanismTheory.getCode()));
            MechanismTheory one = (MechanismTheory)this.mongoTemplateUser.findOne(query, MechanismTheory.class);
            if (one != null) {
                one.setTitle(mechanismTheory.getTitle());
                one.setDetails(mechanismTheory.getDetails());
                this.mongoTemplateUser.save((Object)one);
            }
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)AthenaUtils.getTenantId()).and("mechanismCode").is((Object)info.getMechanismCode()));
        List mechanismCapacities = this.mongoTemplateUser.find(query, MechanismCapacity.class);
        Map hasApply = mechanismCapacities.stream().filter(e -> BooleanUtils.isTrue((Boolean)e.getHasApply())).collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (a, b) -> a));
        Map published = mechanismCapacities.stream().filter(e -> 1 == e.getStatus()).collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (a, b) -> a));
        Map hasDeletedFromDevPlatform = mechanismCapacities.stream().filter(MechanismCapacity::isDeletedByDevPlatform).collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (a, b) -> a));
        info.getCapacity().removeIf(capacity -> hasDeletedFromDevPlatform.containsKey(capacity.getCode()));
        ArrayList applyComponentBOS = new ArrayList();
        ArrayList unApplyComponentBOS = new ArrayList();
        ArrayList allRegisterParams = new ArrayList();
        if (!CollectionUtils.isEmpty(info.getCapacity())) {
            info.getCapacity().forEach(e -> {
                hasApply.remove(e.getCode());
                published.remove(e.getCode());
                MechanismCapacity capacity = this.filterMechanismCapacity((List<MechanismCapacity>)mechanismCapacities, e.getMechanismTheoryCode(), e.getCode());
                capacity.setName(e.getName());
                capacity.setDescription(e.getDescription());
                capacity.setLang(e.getLang());
                capacity.setHasApply(Boolean.valueOf(true));
                this.mongoTemplateUser.save((Object)capacity);
                if (CollectionUtils.isNotEmpty((Collection)capacity.getRegisterParams())) {
                    allRegisterParams.addAll(capacity.getRegisterParams());
                }
                applyComponentBOS.add(this.transToComponentBO(capacity));
            });
        }
        ArrayList needToDeleteAfterUnapplyMechanismLogicCodes = new ArrayList();
        if (!hasApply.isEmpty()) {
            hasApply.values().forEach(e -> {
                published.remove(e.getCode());
                MechanismCapacity capacity = this.filterMechanismCapacity((List<MechanismCapacity>)mechanismCapacities, e.getMechanismTheoryCode(), e.getCode());
                capacity.setHasApply(Boolean.valueOf(false));
                if (capacity.isDeletedByDevPlatform()) {
                    capacity.setStatus(Integer.valueOf(-1));
                    this.mongoTemplateUser.remove((Object)capacity);
                    needToDeleteAfterUnapplyMechanismLogicCodes.add(capacity.getCode());
                } else {
                    capacity.setStatus(Integer.valueOf(0));
                    this.mongoTemplateUser.save((Object)capacity);
                }
                unApplyComponentBOS.add(this.transToComponentBO(capacity));
            });
        }
        if (!published.isEmpty()) {
            published.values().forEach(e -> {
                MechanismCapacity capacity = this.filterMechanismCapacity((List<MechanismCapacity>)mechanismCapacities, e.getMechanismTheoryCode(), e.getCode());
                if (capacity.isDeletedByDevPlatform()) {
                    capacity.setStatus(Integer.valueOf(-1));
                    this.mongoTemplateUser.remove((Object)capacity);
                    needToDeleteAfterUnapplyMechanismLogicCodes.add(capacity.getCode());
                } else {
                    capacity.setStatus(Integer.valueOf(0));
                    this.mongoTemplateUser.save((Object)capacity);
                }
            });
        }
        HashMap allMechaniseVariables = new HashMap();
        if (CollectionUtils.isNotEmpty(allRegisterParams)) {
            allRegisterParams.forEach(key -> {
                try {
                    Object variable = this.mechanismService.getVariable((String)key, AthenaUtils.getTenantId());
                    if (!ObjectUtils.isEmpty((Object)variable)) {
                        Map variableMap = (Map)variable;
                        allMechaniseVariables.putAll(variableMap);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
        }
        log.info("startApplyUDComponentBO:{}", (Object)JSON.toJSONString(applyComponentBOS));
        applyComponentBOS.forEach(componentBO -> {
            ComponentApplyContext componentApplyContext = new ComponentApplyContext();
            componentApplyContext.setMechanismCode(info.getMechanismCode());
            componentApplyContext.setMechanismVariables(allMechaniseVariables);
            try {
                this.componentManager.applyComponent((ComponentBO)componentBO, componentApplyContext);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
        log.info("startUnApplyUDComponentBO:{}", (Object)JSON.toJSONString(unApplyComponentBOS));
        unApplyComponentBOS.forEach(componentBO -> {
            ComponentApplyContext componentApplyContext = new ComponentApplyContext();
            componentApplyContext.setMechanismCode(info.getMechanismCode());
            try {
                this.componentManager.unApplyComponent((ComponentBO)componentBO, componentApplyContext);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
        if (!needToDeleteAfterUnapplyMechanismLogicCodes.isEmpty()) {
            this.mongoTemplateUser.remove(Query.query((CriteriaDefinition)Criteria.where((String)"code").in(needToDeleteAfterUnapplyMechanismLogicCodes).and("tenantId").is((Object)AthenaUtils.getTenantId())), MechanismLogic.class);
        }
    }

    private ComponentBO transToComponentBO(MechanismCapacity capacity) {
        ComponentBO componentBO = new ComponentBO();
        componentBO.setCode(capacity.getCode());
        if (StringUtils.isNotEmpty((CharSequence)capacity.getType())) {
            componentBO.setType(ComponentTypeEnum.valueOf((String)capacity.getType()));
        }
        componentBO.setMechanismCapacity(capacity);
        return componentBO;
    }

    @Override
    public Object postTemplateDataList(String appCode) {
        String locale = "zh_CN";
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode));
        List templateDataList = this.mongoTemplateSystem.find(query, MechanismMsgTemplate.class);
        String currentLocale = AthenaUtils.getCurrentLocale();
        if (!locale.equalsIgnoreCase(currentLocale)) {
            Iterator iterator = templateDataList.iterator();
            while (iterator.hasNext()) {
                MechanismMsgTemplate template;
                String currentName = (String)((Map)(template = (MechanismMsgTemplate)iterator.next()).getLang().get("name")).get(currentLocale);
                template.setName(StringUtils.isNotEmpty((CharSequence)currentName) ? currentName : template.getName());
                String currentContent = (String)((Map)template.getLang().get("content")).get(currentLocale);
                template.setContent(StringUtils.isNotEmpty((CharSequence)currentContent) ? currentContent : template.getContent());
            }
        }
        return templateDataList;
    }

    @Override
    public Object postTemplateSelectResult(String appCode) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode));
        boolean result = this.mongoTemplateSystem.exists(query, MechanismMsgTemplate.class);
        return result;
    }

    @Override
    public Object getMechanismCapacityAdaptation(String code, String metaFieldType) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"code").is((Object)code));
        List apiList = this.mongoTemplateUser.find(query, MechanismApiInfoBO.class);
        if ("openWindow".equals(metaFieldType)) {
            return apiList.stream().filter(v -> v.getHasScheme()).collect(Collectors.toList());
        }
        return apiList;
    }

    @Override
    public Object postQueryApiInfo(MechanismApiInfoReqVO req) throws Exception {
        log.info("MechanismDesignService.postQueryApiInfo beginning...req={}", (Object)req);
        if (req.getIsNeedEsp() != null && req.getIsNeedEsp().booleanValue()) {
            this.setApplication(req);
            return this.espUtils.execute(AthenaUtils.getHeaderToken(), AthenaUtils.getTenantId(), req.getApi(), req.getRequestJson());
        }
        return this.dataMapService.postQueryApiResult(req.getApi(), (Map<String, Object>)JSON.parseObject((String)JSON.toJSONString((Object)req)));
    }

    private void setApplication(MechanismApiInfoReqVO req) throws DWBusinessException {
        try {
            Mechanism mechanism;
            String mechanismCode = req.getMechanismCode();
            Object object = this.mechanismService.postQueryMechanismByCode(mechanismCode, null);
            LoginInfo loginInfo = KgFilter.getLoginInfo();
            if (Objects.nonNull(object) && Objects.nonNull(loginInfo) && StringUtils.isNotEmpty((CharSequence)(mechanism = (Mechanism)((Object)object)).getApplication())) {
                loginInfo.setApplication(mechanism.getApplication());
            }
        }
        catch (DWBusinessException e) {
            log.error("setApplication,error:" + JSON.toJSONString((Object)req), (Throwable)e);
        }
    }

    @Override
    public List<GetActionLocaleResponseDTO> getControlAbilityOutcomesApi(String appCode) {
        ArrayList<GetActionLocaleResponseDTO> result = new ArrayList<GetActionLocaleResponseDTO>();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)appCode));
        PhPMechanismApiCommonConfig phPMechanismApiCommonConfig = (PhPMechanismApiCommonConfig)this.mongoTemplateSystem.findOne(query, PhPMechanismApiCommonConfig.class);
        if (!Objects.isNull(phPMechanismApiCommonConfig) && !org.springframework.util.CollectionUtils.isEmpty(phPMechanismApiCommonConfig.getActionIds())) {
            phPMechanismApiCommonConfig.getActionIds().forEach(res -> {
                GetActionLocaleResponseDTO getActionLocaleResponseDTO = null;
                try {
                    String actionId = null;
                    actionId = phPMechanismApiCommonConfig.isEnablePrefix() ? phPMechanismApiCommonConfig.action_id_prefix + "." + res : res;
                    getActionLocaleResponseDTO = (GetActionLocaleResponseDTO)this.actionService.getMetadata(actionId);
                    this.replaceActionNameByLocale(AthenaUtils.getCurrentLocale(), getActionLocaleResponseDTO);
                    result.add(getActionLocaleResponseDTO);
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6action getMetadata error:" + res, (Throwable)e);
                }
            });
        }
        return result;
    }

    private void replaceActionNameByLocale(String currentLocale, GetActionLocaleResponseDTO getActionLocaleResponseDTO) {
        if ("zh_TW".equals(currentLocale) && StringUtils.isNotEmpty((CharSequence)getActionLocaleResponseDTO.getActionName_tw())) {
            getActionLocaleResponseDTO.setActionName(getActionLocaleResponseDTO.getActionName_tw());
        }
    }

    @Override
    public Object postMechanismParameterDic(MechanismReq req) {
        List<Map> list = MechanismParameterTypeEnum.toList();
        try {
            Object o = this.postMechanismVariableByPrinciple(req);
            List resulstList = list.stream().filter(res -> res.get("value").equals(MechanismParameterTypeEnum.MECHANISM_PARAMETER.getValue())).collect(Collectors.toList());
            for (Map map : resulstList) {
                map.put("params", o);
            }
            LanguageUtil.processLocaleLanguage(list, AthenaUtils.getCurrentLocale());
        }
        catch (Exception e) {
            log.error("getMechanismParameterDic error", (Throwable)e);
        }
        return list;
    }

    @Override
    public Object postSetPhpApiCommonParam(PhPMechanismApiCommonConfig req) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)req.getCode()));
        this.mongoTemplateSystem.remove(query, PhPMechanismApiCommonConfig.class);
        this.mongoTemplateSystem.save((Object)req);
        return req;
    }

    @Override
    public void postApplyMechanisms(String application, List<String> mechanismCodes) throws Exception {
        this.postApplyMechanisms(application, "1.0", mechanismCodes);
    }

    @Override
    public void postApplyMechanisms(String application, String version, List<String> mechanismCodes) throws Exception {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mechanismCode").in(mechanismCodes).and("tenantId").is((Object)SYSTEM).and("version").is((Object)version).and("application").is((Object)application));
        List sysMechanismCapacities = this.mongoTemplateSystem.find(query, MechanismCapacity.class);
        this.handleSysMechanism(application, version, sysMechanismCapacities);
        this.handleTenantMechanism(application, mechanismCodes);
    }

    @Override
    public void postApplyMechanisms(String application, String version, List<String> mechanismCodes, List<String> tenantIds) throws Exception {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mechanismCode").in(mechanismCodes).and("tenantId").in(tenantIds).and("sourceLevel").is((Object)200).and("version").is((Object)version).and("application").is((Object)application));
        List sysMechanismCapacities = this.mongoTemplateSystem.find(query, MechanismCapacity.class);
        this.handleSysMechanismForIndividualCase(application, version, sysMechanismCapacities, tenantIds);
        this.handleTenantMechanism(application, mechanismCodes);
    }

    private void handleSysMechanism(String application, String version, List<MechanismCapacity> capacities) throws DWBusinessException {
        ArrayList<MechanismLogic> logics = new ArrayList<MechanismLogic>();
        for (MechanismCapacity capacity : capacities) {
            if (StringUtils.isNotEmpty((CharSequence)capacity.getType())) {
                String pluginId = capacity.getCode() + "_" + SYSTEM;
                MechanismParseContext context = new MechanismParseContext();
                context.setTenantId(SYSTEM);
                context.setTenantVersion(version);
                context.setCapacity(capacity);
                context.setPluginId(pluginId);
                MechanismLogic logic = this.mechanismBuilderService.build(context);
                logics.add(logic);
            }
            capacity.setStatus(Integer.valueOf(1));
        }
        this.mongoTemplateSystem.remove(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)SYSTEM).and("application").is((Object)application).and("version").is((Object)version)), MechanismLogic.class);
        this.mongoTemplateSystem.insertAll(logics);
        this.mongoTemplateSystem.remove(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)SYSTEM).and("application").is((Object)application).and("version").is((Object)version)), MechanismCapacity.class);
        this.mongoTemplateSystem.insertAll(capacities);
    }

    private void handleSysMechanismForIndividualCase(String application, String version, List<MechanismCapacity> capacities, List<String> tenantIds) throws DWBusinessException {
        ArrayList<MechanismLogic> logics = new ArrayList<MechanismLogic>();
        for (MechanismCapacity capacity : capacities) {
            if (StringUtils.isNotEmpty((CharSequence)capacity.getType())) {
                String pluginId = capacity.getCode() + "_" + capacity.getTenantId();
                MechanismParseContext context = new MechanismParseContext();
                context.setTenantId(capacity.getTenantId());
                context.setTenantVersion(version);
                context.setCapacity(capacity);
                context.setPluginId(pluginId);
                MechanismLogic logic = this.mechanismBuilderService.build(context);
                logics.add(logic);
            }
            capacity.setStatus(Integer.valueOf(1));
        }
        this.mongoTemplateSystem.remove(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").in(tenantIds).and("application").is((Object)application).and("version").is((Object)version)), MechanismLogic.class);
        this.mongoTemplateSystem.insertAll(logics);
        this.mongoTemplateSystem.remove(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").in(tenantIds).and("application").is((Object)application).and("version").is((Object)version)), MechanismCapacity.class);
        this.mongoTemplateSystem.insertAll(capacities);
    }

    private void handleTenantMechanism(String application, List<String> mechanismCodes) throws Exception {
        this.handleWithoutMechanism(application, mechanismCodes);
    }

    private void handleWithoutMechanism(String application, List<String> mechanismCodes) throws Exception {
        List mechanismCapacities = this.mongoTemplateUser.find(Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("mechanismCode").nin(mechanismCodes)), MechanismCapacity.class);
        Collection needUnapplyCapacities = mechanismCapacities.stream().collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (a, b) -> a)).values();
        for (MechanismCapacity capacity : needUnapplyCapacities) {
            this.unapplyCapacity(capacity);
        }
        List needRemoved = needUnapplyCapacities.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        this.mongoTemplateUser.remove(Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("code").in(needRemoved)), MechanismCapacity.class);
        this.mongoTemplateUser.remove(Query.query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application).and("code").in(needRemoved)), MechanismLogic.class);
    }

    private void unapplyCapacity(MechanismCapacity capacity) throws Exception {
        if (null == capacity.getHasApply() || !capacity.getHasApply().booleanValue()) {
            return;
        }
        MechanismLogic logic = (MechanismLogic)this.mongoTemplateUser.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)capacity.getCode()).and("tenantId").is((Object)capacity.getTenantId())), MechanismLogic.class);
        if (null == logic || logic.getLogic() == null) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type", logic.getType());
        param.put("pluginId", logic.getCode());
        param.put("mechanismCode", capacity.getMechanismCode());
        param.put("ability", logic.getLogic());
        this.dataMapService.unBindMechanismComponentWithTenantId(param, capacity.getTenantId());
        this.mongoTemplateUser.remove(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)logic.getTenantId()).and("mechanismAbilityCode").is((Object)logic.getCode())), MechanismApplyRecord.class);
        if (ComponentTypeEnum.MechanismDrive.name().equals(logic.getType())) {
            DriveAbilityBo bo = this.kgHelpService.convert(logic.getLogic(), DriveAbilityBo.class);
            String monitorRuleId = bo.getMonitorRuleId();
            String actionId = bo.getActionId();
            HashMap<String, Object> param2 = new HashMap<String, Object>();
            param2.put("tenantId", logic.getTenantId());
            param2.put("monitorRuleId", monitorRuleId);
            param2.put("actionId", actionId);
            String createMonitorRelation = "match(t:TenantEntity{tenantId:$tenantId})-[r:USE]->(m:MonitorRule{code:$monitorRuleId}) delete r";
            String createActionRelation = "match(t:TenantEntity{tenantId:$tenantId})-[r:ACTION]->(m:StartServiceComposerAction{actionId:$actionId}) delete r";
            this.kgHelpService.executeCyhper(createMonitorRelation, param2);
            this.kgHelpService.executeCyhper(createActionRelation, param2);
            String product = this.kgHelpService.getTenantProduct(monitorRuleId);
            MonitorRuleConfigDTO config = new MonitorRuleConfigDTO();
            config.setConfigId(logic.getCode());
            config.setTenantId(logic.getTenantId());
            config.setMonitorRuleId(monitorRuleId);
            config.setProductName(product);
            config.setStatus(0);
            this.monitorRuleConfigService.delete(logic.getTenantId(), monitorRuleId);
        }
    }

    @Override
    public Object postMechanismFunction(MechanismFunction req) {
        try {
            req.setIsPreset(Boolean.FALSE);
            req.setCode(req.getTaskCode() + UUID.randomUUID().toString().replace("-", ""));
            this.mongoTemplateSystem.save((Object)req);
        }
        catch (Exception e) {
            log.error("MechanismDesignService.postMechanismFunction\u5931\u8d25\uff0ce={}", (Throwable)e);
            return ResultBean.fail(1, e.getMessage());
        }
        return req;
    }

    @Override
    public Object getMechanismFunction(String projectCode, String taskCode, String fieldCode, String dataType) {
        Query queryPresetFun = Query.query((CriteriaDefinition)Criteria.where((String)"isPreset").is((Object)Boolean.TRUE).orOperator(new Criteria[]{Criteria.where((String)"inputType").is((Object)"all"), Criteria.where((String)"inputType").is((Object)dataType.toLowerCase())}));
        List mechanismPresetFuns = this.mongoTemplateSystem.find(queryPresetFun, MechanismFunction.class);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"projectCode").is((Object)projectCode).and("taskCode").is((Object)taskCode).and("fieldCode").is((Object)fieldCode).and("isPreset").is((Object)Boolean.FALSE));
        List mechanismFunctions = this.mongoTemplateSystem.find(query, MechanismFunction.class);
        if (!CollectionUtils.isEmpty((Collection)mechanismFunctions)) {
            mechanismPresetFuns.addAll(mechanismFunctions);
        }
        return mechanismPresetFuns;
    }
}

