/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kg.activity.Package;
import com.digiwin.athena.kg.domain.CodedEntity;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.filter.LoginInfo;
import com.digiwin.athena.knowledgegraph.service.IPackageService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.repository.neo4j.PackageRepository;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Lang
@Service
public class PackageService
implements IPackageService {
    private static final Logger log = LoggerFactory.getLogger(PackageService.class);
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    PackageRepository packageRepository;

    @Override
    @Deprecated
    public List<String> getTenantAll() throws Exception {
        try {
            String tenantId = AthenaUtils.getTenantId();
            String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
            List<Package> packages = this.packageRepository.getTenantPackages(tenantId, "DATA_ENTRY", tenantVersion);
            if (CollectionUtils.isEmpty(packages)) {
                return Collections.emptyList();
            }
            return packages.stream().map(CodedEntity::getCode).collect(Collectors.toList());
        }
        catch (Exception e) {
            LoginInfo loginInfo;
            HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
            String token = request.getHeader("token");
            if (null == token) {
                token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
            }
            if (null == token && null != (loginInfo = KgFilter.getLoginInfo())) {
                token = loginInfo.getToken();
            }
            log.error("getTenantAll error, token: {}", (Object)token, (Object)e);
            throw e;
        }
    }
}

