/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.component.bo.ComponentStructuredListType;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kg.domain.FieldOpenWindowSetting;
import com.digiwin.athena.kg.domain.OpenWindowDefinition;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.knowledgegraph.domain.ComponentStructuredList;
import com.digiwin.athena.knowledgegraph.domain.TenantAppRelation;
import com.digiwin.athena.knowledgegraph.domain.TenantEntity;
import com.digiwin.athena.knowledgegraph.domain.mechanism.MechanismTenantParadigm;
import com.digiwin.athena.knowledgegraph.domain.mechanism.Paradigm;
import com.digiwin.athena.knowledgegraph.domain.mechanism.ParadigmCondition;
import com.digiwin.athena.knowledgegraph.domain.mechanism.ParadigmConditionConfig;
import com.digiwin.athena.knowledgegraph.dto.AfsDTO;
import com.digiwin.athena.knowledgegraph.dto.ParadigmDto;
import com.digiwin.athena.knowledgegraph.service.IAppService;
import com.digiwin.athena.knowledgegraph.service.IMechanismService;
import com.digiwin.athena.knowledgegraph.service.IParadigmService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.RedisLock;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.KgHttpUtil;
import com.digiwin.athena.knowledgegraph.vo.HandleParadigmListVo;
import com.digiwin.athena.knowledgegraph.vo.ParadigmConditionVO;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Lang
@Service
public class ParadigmService
implements IParadigmService {
    private static final Logger log = LoggerFactory.getLogger(ParadigmService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplateUser;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private ComponentManager componentManager;
    @Autowired
    RedisLock redisLock;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    IMechanismService iMechanismService;
    @Autowired
    IAppService iAppService;
    @Autowired
    private DataPickService dataPickService;

    @Override
    public Object getParadigmCondition(String code) throws DWException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.tenantService.getTenantVersion(tenantId);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"paradigmCode").is((Object)code).and("version").is((Object)tenantVersion));
        ParadigmConditionConfig paradigmConditionConfig = (ParadigmConditionConfig)this.mongoTemplateSystem.findOne(query, ParadigmConditionConfig.class, "paradigmConditionConfig");
        if (paradigmConditionConfig == null) {
            return null;
        }
        Query query2 = new Query();
        query2.addCriteria((CriteriaDefinition)Criteria.where((String)"paradigmCode").is((Object)code).and("tenantId").is((Object)tenantId));
        ParadigmCondition paradigmCondition = (ParadigmCondition)this.mongoTemplateUser.findOne(query2, ParadigmCondition.class, "paradigmCondition");
        ParadigmConditionVO paradigmConditionVO = new ParadigmConditionVO();
        try {
            BeanUtils.copyProperties((Object)paradigmConditionVO, (Object)paradigmConditionConfig);
            List<FieldOpenWindowSetting> fieldOpenWindowMap = paradigmConditionConfig.getFieldOpenWindowMap();
            if (!CollectionUtils.isEmpty(fieldOpenWindowMap)) {
                HashMap<String, OpenWindowDefinition> fieldOpenWindowDefinitions = new HashMap<String, OpenWindowDefinition>();
                fieldOpenWindowMap.forEach(e -> {
                    JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)e));
                    String column = jsonObject.getString("column");
                    String openWindowKey = jsonObject.getString("openWindowKey");
                    Query query3 = new Query();
                    query3.addCriteria((CriteriaDefinition)Criteria.where((String)"key").is((Object)openWindowKey).and("version").is((Object)tenantVersion));
                    OpenWindowDefinition openWindowDefinition = (OpenWindowDefinition)this.mongoTemplateSystem.findOne(query3, OpenWindowDefinition.class, "openWindowDefinition");
                    if (openWindowDefinition != null) {
                        fieldOpenWindowDefinitions.put(column, openWindowDefinition);
                    }
                });
                paradigmConditionVO.setFieldOpenWindowDefinitions(fieldOpenWindowDefinitions);
            }
            if (paradigmCondition != null) {
                paradigmConditionVO.setConditions(paradigmCondition.getConditions());
            }
        }
        catch (IllegalAccessException | InvocationTargetException e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        return paradigmConditionVO;
    }

    @Override
    public Object postSaveParadigmCondition(ParadigmConditionVO paradigmCondition) throws DWException {
        String tenantId = AthenaUtils.getTenantId();
        Query query2 = new Query();
        query2.addCriteria((CriteriaDefinition)Criteria.where((String)"paradigmCode").is((Object)paradigmCondition.getParadigmCode()).and("tenantId").is((Object)tenantId));
        Update update = new Update();
        update.set("conditions", paradigmCondition.getConditions());
        this.mongoTemplateUser.upsert(query2, update, "paradigmCondition");
        return null;
    }

    @Override
    public Boolean postSaveParadigm(ParadigmDto paradigmDto) throws DWException {
        this.mongoTemplateSystem.remove(Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)paradigmDto.getCode())), Paradigm.class);
        Paradigm paradigm = new Paradigm();
        org.springframework.beans.BeanUtils.copyProperties((Object)paradigmDto, (Object)((Object)paradigm));
        paradigm.setVersion("1.0");
        this.mongoTemplateSystem.insert((Object)paradigm, "paradigm");
        return true;
    }

    @Override
    public Boolean postDeleteParadigm(String code) throws DWException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"code").is((Object)code));
        this.mongoTemplateSystem.remove(query, "paradigm");
        return true;
    }

    @Override
    public Object getParadigmConditionByMechanismCode(String mechanismCode) throws DWException {
        String tenantId = AthenaUtils.getTenantId();
        String version = this.kgInnerService.getTenantVersion(tenantId);
        ComponentStructuredList mechanismComponentStructuredList = this.componentManager.findMechanismComponentStructuredList(mechanismCode, version, tenantId);
        if (mechanismComponentStructuredList != null) {
            String paradigmCode = mechanismComponentStructuredList.getParadigm();
            String tenantVersion = this.tenantService.getTenantVersion(tenantId);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"paradigmCode").is((Object)paradigmCode).and("version").is((Object)tenantVersion));
            ParadigmConditionConfig paradigmConditionConfig = (ParadigmConditionConfig)this.mongoTemplateSystem.findOne(query, ParadigmConditionConfig.class, "paradigmConditionConfig");
            if (paradigmConditionConfig == null) {
                return null;
            }
            Query query2 = new Query();
            query2.addCriteria((CriteriaDefinition)Criteria.where((String)"paradigmCode").is((Object)paradigmCode).and("tenantId").is((Object)tenantId));
            ParadigmCondition paradigmCondition = (ParadigmCondition)this.mongoTemplateUser.findOne(query2, ParadigmCondition.class, "paradigmCondition");
            if (paradigmCondition != null && paradigmCondition.getConditions() != null) {
                Object conditions = paradigmCondition.getConditions();
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("tenantId", tenantId);
                result.put("paradigmCode", paradigmCode);
                result.put("fieldMapsTo", paradigmConditionConfig.getFieldMapsTo());
                if (conditions instanceof Collection) {
                    HashMap<String, Object> andCondition = new HashMap<String, Object>();
                    andCondition.put("type", "AND_GROUP");
                    andCondition.put("items", conditions);
                    result.put("conditions", andCondition);
                } else {
                    result.put("conditions", conditions);
                }
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object postHandleParadigmInit() {
        String paradigmInitSwitch = DWApplicationConfigUtils.getProperty((String)"paradigmInitSwitch");
        log.info("paradigmInitSwitch:{}", (Object)paradigmInitSwitch);
        if (StringUtils.equalsIgnoreCase((CharSequence)paradigmInitSwitch, (CharSequence)"false")) {
            return null;
        }
        String kgTenantParadigmInitLockKey = "knowledgegraph:tenantParadigmInitLockKey";
        String tenantParadigmInitLockKey = null;
        try {
            tenantParadigmInitLockKey = this.redisLock.tryLock(kgTenantParadigmInitLockKey, 300000L);
            if (tenantParadigmInitLockKey != null) {
                log.info("=======\u62ff\u5230\u79df\u6237\u8303\u5f0f\u521d\u59cb\u5316\u9501{}:{}=======", (Object)kgTenantParadigmInitLockKey, (Object)tenantParadigmInitLockKey);
                log.info("===========\u5f00\u59cbTenantParadigmInit\u8fc7\u7a0b==========");
                List<ApplicationRelation> relations = this.iAppService.getApplicationRelationByType("paradigm");
                if (CollectionUtils.isEmpty(relations)) {
                    log.info("hasNoParadigmRelation...");
                    Object var5_6 = null;
                    return var5_6;
                }
                List<String> appCodeList = relations.stream().map(ApplicationRelation::getAppCode).distinct().collect(Collectors.toList());
                List<TenantAppRelation> tenantAppRelationByAppCode = this.dataPickService.getTenantAppRelationByAppCode(appCodeList);
                if (CollectionUtils.isEmpty(tenantAppRelationByAppCode)) {
                    log.info("noTenantHasParadigmApplication...");
                    Object var7_9 = null;
                    return var7_9;
                }
                List allParadigms = this.mongoTemplateSystem.findAll(Paradigm.class);
                if (CollectionUtils.isEmpty((Collection)allParadigms)) {
                    log.info("not found paradigm...");
                    Object var8_11 = null;
                    return var8_11;
                }
                Map collect = allParadigms.stream().collect(Collectors.toMap(Paradigm::getCode, Function.identity(), (a, b) -> a));
                Map<String, List<Paradigm>> appAndParadigmMap = relations.stream().collect(Collectors.toMap(ApplicationRelation::getAppCode, p -> {
                    ArrayList<Paradigm> paradigmList = new ArrayList<Paradigm>();
                    Paradigm paradigm = (Paradigm)((Object)((Object)collect.get(p.getCode())));
                    if (paradigm != null) {
                        paradigmList.add(paradigm);
                    }
                    return paradigmList;
                }, (value1, value2) -> {
                    value1.addAll(value2);
                    return value1;
                }));
                HashSet<String> hasInitTenants = new HashSet<String>();
                for (TenantAppRelation tenantAppInfoDTO : tenantAppRelationByAppCode) {
                    log.info("handle tenant:{} , appCode:{}", (Object)tenantAppInfoDTO.getTenantId(), (Object)tenantAppInfoDTO.getAppCode());
                    if (hasInitTenants.contains(tenantAppInfoDTO.getTenantId() + tenantAppInfoDTO.getAppCode())) continue;
                    TenantEntity tenant = this.tenantService.getTenant(tenantAppInfoDTO.getTenantId());
                    if (StringUtils.isEmpty((CharSequence)tenant.getCustomerServiceCode())) {
                        log.info("ParadigmInit tenantId:{} customerServiceCode is null", (Object)tenantAppInfoDTO.getTenantId());
                        continue;
                    }
                    try {
                        HashMap<String, String> request = new HashMap<String, String>();
                        request.put("AFS01", tenant.getCustomerServiceCode());
                        String reqUrl = DWApplicationConfigUtils.getProperty((String)"tiptopUrl") + "/api/Athena/AthenaFS";
                        String result = KgHttpUtil.post(reqUrl, JSON.toJSONString(request));
                        JSONObject jsonObject = JSON.parseObject((String)result);
                        String domain = jsonObject.getString("domain");
                        String code = jsonObject.getString("code");
                        if (!StringUtils.equals((CharSequence)code, (CharSequence)"0")) {
                            log.error("ParadigmInit tenantId:{} getOrderInfoError:{}", (Object)tenantAppInfoDTO.getTenantId(), (Object)domain);
                            continue;
                        }
                        String s = StringEscapeUtils.unescapeJava((String)domain);
                        List afsDTOS = JSONArray.parseArray((String)s, AfsDTO.class);
                        if (CollectionUtils.isEmpty((Collection)afsDTOS)) continue;
                        HashMap appParadigmMap = new HashMap();
                        List sortedAfsDTOS = afsDTOS.stream().sorted(Comparator.comparing(AfsDTO::getAFS04).reversed()).collect(Collectors.toList());
                        ArrayList<String> paradigmCodeList = new ArrayList();
                        String beforeOrderTime = null;
                        for (AfsDTO afsDTO : sortedAfsDTOS) {
                            List<String> paradigmCodes;
                            if (StringUtils.isNotEmpty(beforeOrderTime) && !StringUtils.equals((CharSequence)beforeOrderTime, (CharSequence)afsDTO.getAFS04())) break;
                            beforeOrderTime = afsDTO.getAFS04();
                            LocalDate orderDate = LocalDate.parse(afsDTO.getAFS04(), DateTimeFormatter.ofPattern("yyyyMMdd"));
                            if (orderDate.plusDays(30L).isBefore(LocalDate.now())) break;
                            List<String> paradigmFromAFS06 = this.getParadigmFromAFS06(afsDTO.getAFS06());
                            if (CollectionUtils.isEmpty(paradigmFromAFS06) || CollectionUtils.isEmpty(paradigmCodes = this.matchParadigmByName(appAndParadigmMap, paradigmFromAFS06, tenantAppInfoDTO.getAppCode()))) continue;
                            paradigmCodeList.addAll(paradigmCodes);
                        }
                        log.info("paradigmCodeList:{}", paradigmCodeList);
                        if (!CollectionUtils.isEmpty(paradigmCodeList)) {
                            paradigmCodeList = paradigmCodeList.stream().distinct().collect(Collectors.toList());
                            List<String> mechanismByAppCodeAndParadigms = this.getMechanismByAppCodeAndParadigms(tenantAppInfoDTO.getAppCode(), paradigmCodeList);
                            MechanismTenantParadigm mechanismTenantParadigm = this.getMechanismTenantParadigm(tenantAppInfoDTO.getAppCode(), tenantAppInfoDTO.getTenantId());
                            if (mechanismTenantParadigm == null) {
                                this.componentManager.InitializeTenantApplicationComponentList(tenantAppInfoDTO.getAppCode(), tenantAppInfoDTO.getTenantId(), paradigmCodeList, mechanismByAppCodeAndParadigms);
                            } else {
                                List<String> existsParadigms = this.getExistsParadigms(mechanismTenantParadigm);
                                boolean subCollection = CollectionUtils.isSubCollection(paradigmCodeList, existsParadigms);
                                if (!subCollection) {
                                    this.componentManager.UpdateTenantApplicationComponentListByMechanism(tenantAppInfoDTO.getAppCode(), tenantAppInfoDTO.getTenantId(), paradigmCodeList, mechanismByAppCodeAndParadigms, null);
                                }
                            }
                        }
                        hasInitTenants.add(tenantAppInfoDTO.getTenantId() + tenantAppInfoDTO.getAppCode());
                    }
                    catch (Exception e) {
                        log.error("ParadigmInit tenantId:{} error:{}", (Object)tenantAppInfoDTO.getTenantId(), (Object)e.getMessage());
                    }
                }
            } else {
                log.info("=======\u6ca1\u6709\u62ff\u5230\u79df\u6237\u8303\u5f0f\u521d\u59cb\u5316\u7684\u9501{}\uff0c\u5e94\u7528\u7684\u5176\u4ed6\u5b9e\u4f8b\u6b63\u5728\u5904\u7406=======", (Object)kgTenantParadigmInitLockKey);
            }
        }
        catch (Exception e) {
            log.error("tenantParadigmInit error:{}", (Object)e.getMessage());
        }
        finally {
            if (tenantParadigmInitLockKey != null) {
                log.info("\u91ca\u653e\u9501{}\uff1a{}", (Object)kgTenantParadigmInitLockKey, (Object)tenantParadigmInitLockKey);
                this.redisLock.unlock(kgTenantParadigmInitLockKey, tenantParadigmInitLockKey);
            }
        }
        return null;
    }

    @Override
    public Object getParadigmsByAppCode(String appCode) throws DWException {
        List<ComponentStructuredList> componentStructuredLists;
        String tenantId = AthenaUtils.getTenantId();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("code").is((Object)appCode));
        MechanismTenantParadigm one = (MechanismTenantParadigm)this.mongoTemplateUser.findOne(query, MechanismTenantParadigm.class);
        if (one == null) {
            return null;
        }
        if (CollectionUtils.isNotEmpty(one.getParadigms())) {
            return one.getParadigms();
        }
        if (CollectionUtils.isNotEmpty(one.getValue()) && CollectionUtils.isNotEmpty(componentStructuredLists = this.dataPickService.find(Criteria.where((String)"mechanismCode").in(one.getValue()).and("appCode").is((Object)appCode), ComponentStructuredList.class, "componentStructuredList"))) {
            List collect = componentStructuredLists.stream().map(ComponentStructuredList::getParadigm).distinct().collect(Collectors.toList());
            return collect;
        }
        return null;
    }

    private List<String> getExistsParadigms(MechanismTenantParadigm mechanismTenantParadigm) throws DWBusinessException {
        if (CollectionUtils.isEmpty(mechanismTenantParadigm.getParadigms())) {
            List<String> value = mechanismTenantParadigm.getValue();
            Criteria criteria = Criteria.where((String)"mechanismCode").in(value).and("type").is((Object)ComponentStructuredListType.Mechanism);
            List<ComponentStructuredList> result = this.dataPickService.find(criteria, ComponentStructuredList.class, "componentStructuredList");
            return result == null ? new ArrayList<String>() : result.stream().map(ComponentStructuredList::getParadigm).distinct().collect(Collectors.toList());
        }
        return mechanismTenantParadigm.getParadigms();
    }

    public List<String> getMechanismByAppCodeAndParadigms(String appCode, List<String> paradigmList) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"appCode").is((Object)appCode).and("paradigm").in(paradigmList).and("type").is((Object)ComponentStructuredListType.Mechanism);
        List<ComponentStructuredList> result = this.dataPickService.find(criteria, ComponentStructuredList.class, "componentStructuredList");
        if (CollectionUtils.isEmpty(result)) {
            return new ArrayList<String>();
        }
        return result.stream().map(ComponentStructuredList::getMechanismCode).distinct().collect(Collectors.toList());
    }

    public List<String> getMechanismByParadigmCode(String ParadigmCode) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"paradigm").is((Object)ParadigmCode).and("type").is((Object)ComponentStructuredListType.Mechanism);
        List<ComponentStructuredList> result = this.dataPickService.find(criteria, ComponentStructuredList.class, "componentStructuredList");
        if (CollectionUtils.isEmpty(result)) {
            return new ArrayList<String>();
        }
        return result.stream().map(ComponentStructuredList::getMechanismCode).distinct().collect(Collectors.toList());
    }

    private MechanismTenantParadigm getMechanismTenantParadigm(String appCode, String tenantId) {
        Query query = new Query();
        Criteria criteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"code").is((Object)appCode), Criteria.where((String)"tenantId").is((Object)tenantId)});
        query.addCriteria((CriteriaDefinition)criteria);
        MechanismTenantParadigm mechanismTenantParadigm = (MechanismTenantParadigm)this.mongoTemplateUser.findOne(query, MechanismTenantParadigm.class, "mechanismTenantParadigm");
        return mechanismTenantParadigm;
    }

    private List<String> matchParadigmByName(Map<String, List<Paradigm>> appAndParadigmMap, List<String> toMatchNameList, String appCode) {
        List<Paradigm> paradigms = appAndParadigmMap.get(appCode);
        if (CollectionUtils.isEmpty(paradigms)) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String name : toMatchNameList) {
            for (Paradigm paradigm : paradigms) {
                Map lang = paradigm.getLang();
                if (lang == null || lang.get("name") == null) {
                    if (!StringUtils.equals((CharSequence)paradigm.getName(), (CharSequence)name)) continue;
                    result.add(paradigm.getCode());
                    continue;
                }
                Map nameLang = (Map)lang.get("name");
                String zh_tw = (String)nameLang.get("zh_TW");
                String zh_cn = (String)nameLang.get("zh_CN");
                if (!StringUtils.equals((CharSequence)zh_tw, (CharSequence)name) && !StringUtils.equals((CharSequence)zh_cn, (CharSequence)name)) continue;
                result.add(paradigm.getCode());
            }
        }
        return result;
    }

    private List<String> getParadigmFromAFS06(String asf06) {
        if (StringUtils.isEmpty((CharSequence)asf06)) {
            return null;
        }
        String[] s = StringUtils.split((String)asf06, (String)"_");
        if (s.length != 3) {
            return null;
        }
        String s1 = s[1];
        if (StringUtils.contains((CharSequence)s1, (CharSequence)"(") && StringUtils.contains((CharSequence)s1, (CharSequence)")")) {
            String paradigmInfo = s1.substring(s1.indexOf("(") + 1, s1.indexOf(")"));
            String[] split = StringUtils.split((String)paradigmInfo, (String)"/");
            return Arrays.asList(split);
        }
        return null;
    }

    public static void main(String[] args) {
        ParadigmService paradigmService = new ParadigmService();
        List<String> paradigmFromAFS06 = paradigmService.getParadigmFromAFS06("****_****(\u8303\u5f0f1/\u8303\u5f0f2)_****");
        System.out.println(paradigmFromAFS06);
    }

    @Override
    public HandleParadigmListVo postHandleParadigmList(String appCode, List<String> mechanismCodes, String tenantId) {
        HandleParadigmListVo handleParadigmListVo = new HandleParadigmListVo();
        try {
            List checkedList = (List)this.iMechanismService.getMechanismTenantParadigm(appCode, tenantId);
            handleParadigmListVo.setCheckedList(checkedList);
            List<ApplicationRelation> paradigmByTypeAndAppCode = this.iAppService.getParadigmByTypeAndAppCode("paradigm", appCode);
            if (CollectionUtils.isNotEmpty(paradigmByTypeAndAppCode)) {
                List<String> paradigmCodeList = paradigmByTypeAndAppCode.stream().map(BaseEntity::getCode).collect(Collectors.toList());
                List<Paradigm> paradigmList = this.iMechanismService.postParadigmNameAndCode(paradigmCodeList);
                handleParadigmListVo.setParadigmList(paradigmList);
            }
            Map<String, String> mechanismParadigmMap = this.iMechanismService.postParadigmCode(mechanismCodes);
            handleParadigmListVo.setMechanismParadigmMap(mechanismParadigmMap);
        }
        catch (Exception e) {
            log.error("Route==>ParadigmService method=getHandleParadigmList error:", (Throwable)e);
        }
        return handleParadigmListVo;
    }

    @Override
    public List<Map> postHandleParadigmShare(List<Map> list) throws DWException {
        String version = this.kgInnerService.getTenantVersion(AthenaUtils.getTenantId());
        list.forEach(x -> {
            x.put("paradigmConfig", "independence");
            String code = x.get("code") + "";
            Query query = new Query();
            Criteria criteria = Criteria.where((String)"paradigm").in(new Object[]{code}).and("version").is((Object)version);
            List<ComponentStructuredList> result = null;
            try {
                result = this.dataPickService.find(criteria, ComponentStructuredList.class, "componentStructuredList");
            }
            catch (DWBusinessException e) {
                log.error("\u67e5\u8be2\u5171\u4eab\u8303\u5f0f\u7ec4\u4ef6\u6e05\u5355\u5f02\u5e38:", (Throwable)e);
            }
            if (CollectionUtils.isNotEmpty(result)) {
                Paradigm paradigm;
                List appCodeList = result.stream().map(ComponentStructuredList::getAppCode).distinct().collect(Collectors.toList());
                if (appCodeList.size() > 1) {
                    x.put("paradigmConfig", "share");
                } else if (appCodeList.size() == 1 && Objects.nonNull((Object)(paradigm = (Paradigm)((Object)((Object)this.mongoTemplateSystem.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)code).and("version").is((Object)version)), Paradigm.class))))) && "commonParadigm".equals(paradigm.getApplication())) {
                    x.put("paradigmConfig", "share");
                }
            }
        });
        return list;
    }
}

