/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kg.report.hz.model.sence.ReportSceneDTO;
import com.digiwin.athena.kg.report.hz.model.standardParams.PermissionSchemas;
import com.digiwin.athena.kg.report.hz.model.standardParams.StandardParams;
import com.digiwin.athena.kg.report.hz.model.standardParams.StandardParamsDTO;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.dto.report.ReportSceneDTOs;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.service.IParameterService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.SceneService;
import io.seata.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Lang
@Service
@MyExceptionHandler
public class ParameterService
implements IParameterService {
    private static final Logger log = LoggerFactory.getLogger(ParameterService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    SceneService sceneService;
    public static final List<String> OPERATOR_TYPE = Arrays.asList("eq", "ne", "like", "rl", "nrl", "ll", "nll", "gt", "gte", "lt", "lte", "between", "in", "nin", "null", "nn");

    @Override
    public Object getParameter(String appCode, String tenantId) {
        String tenantVersion = "1.0";
        PermissionSchemas permissionSchemas = new PermissionSchemas();
        if (StringUtils.isNotBlank((String)tenantId)) {
            tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("version").is((Object)tenantVersion).and("application").is((Object)appCode).and("data_type").is((Object)"string");
        query.addCriteria((CriteriaDefinition)criteria);
        List standardParams = this.mongoTemplate.find(query, StandardParams.class);
        if (CollectionUtils.isEmpty((Collection)standardParams)) {
            return Collections.singletonList(permissionSchemas);
        }
        ArrayList standardParamsDTOS = new ArrayList();
        standardParams.forEach(item -> standardParamsDTOS.add(StandardParamsDTO.builder().id(item.getData_name()).name(item.getName()).dataType(item.getData_type()).dataSource("api").filterType(item.getOperator()).build()));
        permissionSchemas.setFields(standardParamsDTOS);
        return Collections.singletonList(permissionSchemas);
    }

    @Override
    public Object getParameter(String appId, String tenantId, String moduleId, String actionId) throws DWBusinessException {
        ReportSceneDTOs dataSet;
        KgFilter.getLoginInfo().setTenantId(tenantId);
        String tenantVersion = "1.0";
        PermissionSchemas permissionSchemas = new PermissionSchemas();
        if (StringUtils.isNotBlank((String)tenantId)) {
            tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        }
        if (Objects.isNull(dataSet = (ReportSceneDTOs)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("appCode").is((Object)appId).and("code").is((Object)actionId)), ReportSceneDTOs.class, "agiledatainquiry_data_set"))) {
            ReportSceneDTO reportScene = this.sceneService.querySceneMaps(Collections.singletonList(actionId), tenantVersion);
            if (Objects.isNull(reportScene) || !Objects.equals(reportScene.getViewType(), "dataset")) {
                Query query = new Query();
                Criteria criteria = new Criteria();
                criteria.and("version").is((Object)tenantVersion).and("application").is((Object)appId).and("data_type").is((Object)"string");
                query.addCriteria((CriteriaDefinition)criteria);
                List standardParams = this.mongoTemplate.find(query, StandardParams.class);
                if (CollectionUtils.isEmpty((Collection)standardParams)) {
                    return Collections.singletonList(permissionSchemas);
                }
                ArrayList standardParamsDTOS = new ArrayList();
                standardParams.forEach(item -> standardParamsDTOS.add(StandardParamsDTO.builder().id(item.getData_name()).name(item.getName()).dataType(item.getData_type()).dataSource("api").filterType(item.getOperator()).build()));
                permissionSchemas.setFields(standardParamsDTOS);
            } else {
                List fieldSchemas = reportScene.getFieldSchema();
                ArrayList<StandardParamsDTO> standardParamsDTOS = new ArrayList<StandardParamsDTO>();
                for (Object fieldSchema : fieldSchemas) {
                    Map item2 = (Map)fieldSchema;
                    standardParamsDTOS.add(StandardParamsDTO.builder().id(item2.get("name").toString()).name(item2.get("title").toString()).dataType(item2.get("dataType").toString()).dataSource("api").filterType(OPERATOR_TYPE).build());
                }
                permissionSchemas.setFields(standardParamsDTOS);
                permissionSchemas.setName(reportScene.getSceneTitle());
                permissionSchemas.setId(reportScene.getCode());
            }
        } else {
            List<Object> dimensions = dataSet.getDimensions();
            dimensions.addAll(dataSet.getMeasures());
            ArrayList<StandardParamsDTO> standardParamsDTOS = new ArrayList<StandardParamsDTO>();
            for (Object dimension : dimensions) {
                Map item3 = (Map)dimension;
                standardParamsDTOS.add(StandardParamsDTO.builder().id(item3.get("data_name").toString()).name(item3.getOrDefault("name", "").toString()).dataType(item3.get("data_type").toString()).dataSource("api").filterType(OPERATOR_TYPE).build());
            }
            permissionSchemas.setFields(standardParamsDTOS);
            permissionSchemas.setName(dataSet.getName());
            permissionSchemas.setId(dataSet.getCode());
        }
        return Collections.singletonList(permissionSchemas);
    }
}

