/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.module.DWModuleConfigUtils;
import com.digiwin.athena.kg.monitorRule.TriggerDTO;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.data.MongoDBManager;
import com.digiwin.athena.knowledgegraph.mq.RabbitMQManager;
import com.digiwin.athena.knowledgegraph.service.IScheduleRuleConfigService;
import com.digiwin.athena.knowledgegraph.service.impl.ConfigChangeTypeEnum;
import com.digiwin.athena.knowledgegraph.service.impl.UnitTestHelper;
import com.digiwin.athena.knowledgegraph.service.model.ScheduleRuleConfigDTO;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.stereotype.Service;

@Lang
@Service
public class ScheduleRuleConfigService
implements IScheduleRuleConfigService {
    private static String scheduleRuleConfigColName = "scheduleRuleConfigs";
    protected static String scheduleRuleConfigKeyName = "configId";
    private static String rabbitQueueName = "utScheduleRuleConfigQueue";
    private static String rabbitRoutingKey = "utScheduleRuleConfig";
    private static Log log = LogFactory.getLog(ScheduleRuleConfigService.class);

    @Override
    public Object put(ScheduleRuleConfigDTO config) throws Exception {
        String configId = config.getConfigId();
        if (StringUtils.isEmpty((CharSequence)configId)) {
            throw new DWArgumentException("config", I18nUtils.getValue("knowledgegraph.config.configIdEmpty", new Object[0]));
        }
        String tenantId = config.getTenantId();
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWArgumentException("config", I18nUtils.getValue("knowledgegraph.config.tenantIdEmpty", new Object[0]));
        }
        String ruleId = config.getRuleId();
        if (StringUtils.isEmpty((CharSequence)ruleId)) {
            throw new DWArgumentException("config", I18nUtils.getValue("knowledgegraph.config.ruleIdEmpty", new Object[0]));
        }
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put(scheduleRuleConfigKeyName, config.getConfigId());
        configMap.put("tenantId", tenantId);
        configMap.put("ruleId", ruleId);
        configMap.put("status", config.getStatus());
        configMap.put("trigger", this.convertToMap(config.getTrigger()));
        try {
            MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollection(scheduleRuleConfigColName, scheduleRuleConfigKeyName);
            col.insertOne((Object)new Document(configMap));
            this.SendMessage(tenantId, ruleId, ConfigChangeTypeEnum.CREATED);
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return null;
    }

    private Map<String, Object> convertToMap(TriggerDTO triggerDTO) throws IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean hasData = false;
        for (Field field : TriggerDTO.class.getDeclaredFields()) {
            field.setAccessible(true);
            if (field.isSynthetic()) continue;
            String fieldName = field.getName();
            Object value = field.get(triggerDTO);
            if (value == null) continue;
            map.put(fieldName, value);
            hasData = true;
        }
        if (!hasData) {
            map = null;
        }
        return map;
    }

    private void SendMessage(String tenantId, String ruleId, ConfigChangeTypeEnum changeType) throws Exception {
        RabbitMQManager mqManager = RabbitMQManager.getRabbitMQManager();
        if (mqManager.getEnabled()) {
            String msg = String.format("{\"tenantId\":\"%s\",\"ruleId\":\"%s\",\"changeType\":\"%s\"}", new Object[]{tenantId, ruleId, changeType});
            try {
                boolean sendSuccess = mqManager.PublishMessage(msg, rabbitQueueName, rabbitRoutingKey);
                if (!sendSuccess) {
                    log.info((Object)"RabbitMQ message was sent failed");
                }
            }
            catch (Exception e) {
                log.info((Object)"RabbitMQ message was sent failed");
                throw new DWBusinessException(e.getLocalizedMessage());
            }
        }
    }

    @Override
    public Object get(String ruleId, String tenantId) throws Exception {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollection(scheduleRuleConfigColName, scheduleRuleConfigKeyName);
        Document doc = (Document)col.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"ruleId", (Object)ruleId), Filters.eq((String)"tenantId", (Object)tenantId), Filters.eq((String)"status", (Object)1)})).first();
        String result = null;
        if (doc != null) {
            result = doc.toJson();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getQuery(String tenantId, int count) throws Exception {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollection(scheduleRuleConfigColName, scheduleRuleConfigKeyName);
        Bson condition = Filters.eq((String)"status", (Object)1);
        if (tenantId != null && !tenantId.isEmpty()) {
            condition = Filters.and((Bson[])new Bson[]{Filters.eq((String)"tenantId", (Object)tenantId), condition});
        }
        ArrayList<String> result = new ArrayList<String>();
        try (MongoCursor cursor = count > 0 ? col.find(condition).limit(count).iterator() : col.find(condition).iterator();){
            while (cursor.hasNext()) {
                result.add(((Document)cursor.next()).toJson());
            }
        }
        String[] re = result.size() > 0 ? result.toArray(new String[0]) : null;
        return re;
    }

    private Document get(String configId) throws Exception {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollection(scheduleRuleConfigColName, scheduleRuleConfigKeyName);
        Document doc = (Document)col.find(Filters.eq((String)"configId", (Object)configId)).first();
        return doc;
    }

    @Override
    public Object delete(String configId) throws Exception {
        Document doc = this.get(configId);
        if (doc != null) {
            MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollection(scheduleRuleConfigColName, scheduleRuleConfigKeyName);
            col.deleteOne(Filters.eq((String)scheduleRuleConfigKeyName, (Object)configId));
            this.SendMessage((String)doc.get((Object)"tenantId"), (String)doc.get((Object)"ruleId"), ConfigChangeTypeEnum.DELETED);
        }
        return null;
    }

    @Override
    public Object putEnable(String configId) throws Exception {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollection(scheduleRuleConfigColName, scheduleRuleConfigKeyName);
        col.updateOne(Filters.eq((String)scheduleRuleConfigKeyName, (Object)configId), Updates.set((String)"status", (Object)1));
        Document doc = this.get(configId);
        if (doc != null) {
            this.SendMessage((String)doc.get((Object)"tenantId"), (String)doc.get((Object)"ruleId"), ConfigChangeTypeEnum.ENABLED);
        }
        return null;
    }

    @Override
    public Object putDisable(String configId) throws Exception {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollection(scheduleRuleConfigColName, scheduleRuleConfigKeyName);
        col.updateOne(Filters.eq((String)scheduleRuleConfigKeyName, (Object)configId), Updates.set((String)"status", (Object)0));
        Document doc = this.get(configId);
        if (doc != null) {
            this.SendMessage((String)doc.get((Object)"tenantId"), (String)doc.get((Object)"ruleId"), ConfigChangeTypeEnum.DISABLED);
        }
        return null;
    }

    static {
        if (!UnitTestHelper.isUnitTest) {
            rabbitQueueName = DWModuleConfigUtils.getProperty((String)"knowledgegraph", (String)"monitorRuleConfigQueueName");
            rabbitRoutingKey = DWModuleConfigUtils.getProperty((String)"knowledgegraph", (String)"monitorRuleConfigRoutingKey");
        }
    }
}

