/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.KmHttpUtil;
import com.digiwin.athena.knowledgegraph.data.MongoDBManager;
import com.digiwin.athena.knowledgegraph.service.ISubscribeService;
import com.digiwin.athena.knowledgegraph.service.model.GoodsEntityRelation;
import com.digiwin.athena.knowledgegraph.service.model.SimpleHttpEntity;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.Date;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Lang
@Service
public class SubscribeService
implements ISubscribeService {
    @Value(value="${cacUrl}")
    private String cacUrl = "https://cac1-test.digiwincloud.com.cn";

    @Override
    public Object postRelation(GoodsEntityRelation relation) throws DWException {
        if (null == relation.getEntityID() || null == relation.getGoodsID() || null == relation.getType()) {
            throw new DWException(I18nUtils.getValue("knowledgegraph.entityOrdGoodsOrTypeEmpty", new Object[0]));
        }
        MongoCollection<Document> col = this.getCol();
        Document doc = (Document)col.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"entityID", (Object)relation.getEntityID())})).first();
        if (null != doc) {
            return null;
        }
        doc = new Document();
        doc.put("entityID", (Object)relation.getEntityID());
        doc.put("goodsID", (Object)relation.getGoodsID());
        doc.put("type", (Object)relation.getType());
        doc.put("createTime", (Object)new Date());
        col.insertOne((Object)doc);
        return null;
    }

    @Override
    public Object deleteRelation(String entityID, String goodsID) throws DWException {
        if (null == entityID || null == goodsID) {
            throw new DWException(I18nUtils.getValue("knowledgegraph.entityOrdGoodsEmpty", new Object[0]));
        }
        MongoCollection<Document> col = this.getCol();
        col.deleteOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"entityID", (Object)entityID), Filters.eq((String)"goodsID", (Object)goodsID)}));
        return null;
    }

    @Override
    public Object getSubscription(String tenantID, String userID, String entityID, String type) throws DWException {
        if (null == entityID || null == tenantID || null == userID) {
            throw new DWException(I18nUtils.getValue("knowledgegraph.entityOrdTenantEmpty", new Object[0]));
        }
        MongoCollection<Document> col = this.getCol();
        Document doc = (Document)col.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"entityID", (Object)entityID), Filters.eq((String)"type", (Object)type)})).first();
        if (doc == null) {
            return null;
        }
        String goodsID = doc.getString((Object)"goodsID");
        String url = this.cacUrl + "/api/cac/v4/authorizations/tenants/" + tenantID + "/users/" + userID + "/goods/" + goodsID + "/module/" + entityID;
        SimpleHttpEntity entity = (SimpleHttpEntity)KmHttpUtil.get((String)url, null, null, SimpleHttpEntity.class);
        return null;
    }

    private MongoCollection<Document> getCol() {
        MongoDatabase database = MongoDBManager.getMongoDBManager().getDatabase();
        MongoCollection col = database.getCollection("GoodsEntityRelation");
        return col;
    }
}

