/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.clients.CacService;
import com.digiwin.athena.knowledgegraph.clients.ESPUtils;
import com.digiwin.athena.knowledgegraph.domain.targets.Flag;
import com.digiwin.athena.knowledgegraph.domain.targets.MechanismTargetRelation;
import com.digiwin.athena.knowledgegraph.domain.targets.TBBTarget;
import com.digiwin.athena.knowledgegraph.domain.targets.TBBTargetTree;
import com.digiwin.athena.knowledgegraph.domain.targets.TBBTargetTreeOperationConst;
import com.digiwin.athena.knowledgegraph.domain.targets.TBBTargetsRequest;
import com.digiwin.athena.knowledgegraph.domain.targets.TBBTreeNode;
import com.digiwin.athena.knowledgegraph.domain.targets.TBBTreeNodeFormatter;
import com.digiwin.athena.knowledgegraph.domain.targets.Target;
import com.digiwin.athena.knowledgegraph.domain.targets.TargetNode;
import com.digiwin.athena.knowledgegraph.domain.targets.TargetTree;
import com.digiwin.athena.knowledgegraph.domain.topic.Topic;
import com.digiwin.athena.knowledgegraph.dto.AppendLeafDto;
import com.digiwin.athena.knowledgegraph.dto.RemoveNodeDto;
import com.digiwin.athena.knowledgegraph.dto.TargetForAppNodeInfoDto;
import com.digiwin.athena.knowledgegraph.dto.TargetNodeDto;
import com.digiwin.athena.knowledgegraph.dto.TargetTreeDto;
import com.digiwin.athena.knowledgegraph.dto.TargetTreeForAppDto;
import com.digiwin.athena.knowledgegraph.service.ITargetService;
import com.digiwin.athena.knowledgegraph.service.impl.AppService;
import com.digiwin.athena.knowledgegraph.service.impl.ParadigmService;
import com.digiwin.athena.knowledgegraph.service.impl.TopicService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Lang
@Service
public class TargetService
implements ITargetService {
    private static final Logger log = LoggerFactory.getLogger(TargetService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    CacService cacService;
    @Autowired
    AppService appService;
    @Autowired
    TopicService topicService;
    @Autowired
    ParadigmService paradigmService;
    @Autowired
    ESPUtils espUtils;

    @Override
    public Object getForest() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId));
        List targetForest = this.mongoTemplateUser.find(query, TargetTree.class);
        if (!CollectionUtils.isEmpty((Collection)targetForest)) {
            List rootTargetIds = targetForest.stream().map(t -> t.getRoot().getId()).distinct().collect(Collectors.toList());
            Query queryTargets = new Query();
            queryTargets.addCriteria((CriteriaDefinition)Criteria.where((String)"id").in(rootTargetIds).and("tenantId").is((Object)tenantId));
            List targetRootList = this.mongoTemplateUser.find(queryTargets, Target.class);
            this.renderTargetToForest(targetForest, targetRootList);
        }
        return targetForest;
    }

    private void renderTargetToForest(List<TargetTree> targetForest, List<Target> targetRootList) {
        String userLocale = AthenaUtils.getCurrentLocale();
        Map targetMap = targetRootList.stream().collect(Collectors.toMap(Target::getId, Function.identity()));
        targetForest.forEach(tree -> {
            String localeName = ((Target)targetMap.get(tree.getRoot().getId())).getLang().get("name").get(userLocale);
            tree.getRoot().setName(StringUtils.isEmpty((CharSequence)localeName) ? ((Target)targetMap.get(tree.getRoot().getId())).getName() : localeName);
            tree.getRoot().setEnabled(((Target)targetMap.get(tree.getRoot().getId())).getEnabled());
        });
    }

    @Override
    public Object getMechanismTargets(String mechanismId) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"mechanismCode").is((Object)mechanismId).and("tenantId").is((Object)tenantId));
        List mechanismTargetRelations = this.mongoTemplateUser.find(query, MechanismTargetRelation.class);
        List targetIds = mechanismTargetRelations.stream().map(MechanismTargetRelation::getTargetId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(targetIds)) {
            return Collections.EMPTY_LIST;
        }
        Query queryTargets = new Query();
        queryTargets.addCriteria((CriteriaDefinition)Criteria.where((String)"id").in(targetIds).and("tenantId").is((Object)tenantId));
        return this.mongoTemplateUser.find(queryTargets, Target.class);
    }

    @Override
    public Object postBuildTree(TargetTreeForAppDto targetTree) throws Exception {
        List<Target> targets = this.transformToTargets(targetTree);
        this.saveTargetsToLocal(targets);
        TargetTree localTargetTree = this.buildTargetTreeByAppTargets(targetTree);
        String token = DWServiceContext.getContext().getToken();
        this.postTBBTargets(targetTree.getTenantId(), targets, token);
        if (this.isEmptyRoot(localTargetTree)) {
            List<TargetTree> targetForest = this.buildForestByNoRootTargetTree(localTargetTree);
            this.upsert(targetForest.get(0));
            for (TargetTree item : targetForest) {
                Map<String, Object> map = this.postTBBTargetTree(TBBTargetTreeOperationConst.UPSERT, item, token);
            }
        } else {
            this.upsert(localTargetTree);
            Map<String, Object> map = this.postTBBTargetTree(TBBTargetTreeOperationConst.UPSERT, localTargetTree, token);
        }
        return null;
    }

    private void upsert(TargetTree targetTree) throws DWBusinessException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"treeId").is((Object)targetTree.getTreeId()).and("tenantId").is((Object)targetTree.getTenantId()));
        TargetTree targetTreeInDB = (TargetTree)this.mongoTemplateUser.findOne(query, TargetTree.class);
        if (StringUtils.isEmpty((CharSequence)targetTree.getTreeId())) {
            targetTree.setTreeId(UUID.randomUUID().toString());
            this.mongoTemplateUser.save((Object)targetTree);
        } else if (null != targetTreeInDB) {
            this.mongoTemplateUser.save((Object)targetTree);
        } else {
            throw new DWBusinessException("tree not found");
        }
    }

    private List<TargetTree> buildForestByNoRootTargetTree(TargetTree targetTree) {
        List<TargetNode> newRoots = targetTree.getRoot().getChildren();
        LinkedList<TargetTree> forest = new LinkedList<TargetTree>();
        newRoots.forEach(item -> {
            TargetTree newTargetTree = TargetTree.builder().tenantId(targetTree.getTenantId()).root((TargetNode)item).treeName(targetTree.getTreeName()).treeId(targetTree.getTreeId()).build();
            forest.add(newTargetTree);
        });
        return forest;
    }

    private boolean isEmptyRoot(TargetTree targetTree) {
        return StringUtils.isEmpty((CharSequence)targetTree.getRoot().getId());
    }

    private Map<String, Object> postTBBTargets(String tenantId, List<Target> targets, String token) throws Exception {
        TBBTargetsRequest tbbTargetRequest = this.transformToTBBTargets(targets);
        tbbTargetRequest.setTenantId(tenantId);
        return this.espUtils.execute(token, tenantId, "indicator.import", tbbTargetRequest);
    }

    public static void main(String[] args) {
        TBBTarget tbbTarget = new TBBTarget();
        System.out.println(JSON.toJSONString((Object)tbbTarget, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }

    private Map<String, Object> postTBBTargetTree(Integer operation, TargetTree targetTree, String token) throws Exception {
        TBBTargetTree tbbTargetTreeRequest = this.transformToTBBTargetTree(operation, targetTree);
        return this.espUtils.execute(token, targetTree.getTenantId(), "indicator.tree.import", tbbTargetTreeRequest);
    }

    private TBBTargetTree transformToTBBTargetTree(Integer operation, TargetTree targetTree) {
        List<TBBTreeNode> rootChildren = this.transformToTBBTreeNode(targetTree.getRoot().getChildren());
        TBBTargetTree tbbTargetTree = TBBTargetTree.builder().treeId(targetTree.getTreeId()).tenantId(targetTree.getTenantId()).operation(operation).IndicatorKey(targetTree.getRoot().getId()).nodeName(targetTree.getTreeName()).direction("vertical").formatter(new TBBTreeNodeFormatter()).children(rootChildren).build();
        return tbbTargetTree;
    }

    private List<TBBTreeNode> transformToTBBTreeNode(List<TargetNode> targetNodes) {
        LinkedList<TBBTreeNode> tbbTreeNodes = new LinkedList<TBBTreeNode>();
        if (!CollectionUtils.isEmpty(targetNodes)) {
            targetNodes.forEach(targetNode -> {
                TBBTreeNode tbbTreeNode = new TBBTreeNode();
                tbbTreeNode.setNodeName(targetNode.getName());
                tbbTreeNode.setDirection("vertical");
                tbbTreeNode.setIndicatorKey(targetNode.getId());
                tbbTreeNode.setChildren(this.transformToTBBTreeNode(targetNode.getChildren()));
                tbbTreeNodes.add(tbbTreeNode);
            });
        }
        return tbbTreeNodes;
    }

    private TBBTargetsRequest transformToTBBTargets(List<Target> targets) throws DWBusinessException {
        TBBTargetsRequest tbbTargetsRequest = new TBBTargetsRequest();
        LinkedList<TBBTarget> tbbTargets = new LinkedList<TBBTarget>();
        for (Target target : targets) {
            Map<String, Map<String, String>> langMap = target.getLang();
            if (CollectionUtils.isEmpty(langMap)) {
                throw new DWBusinessException(I18nUtils.getValue("lang.required", new Object[0]));
            }
            TBBTarget tbbTarget = TBBTarget.builder().IndicatorKey(target.getId()).Athena_lang("zh-cn").Period(target.getPeriodKey()).IndicatorName(target.getName()).IndicatorValue(Double.valueOf(StringUtils.isEmpty((CharSequence)target.getValue()) ? "0" : target.getValue())).TrendType(Integer.valueOf(StringUtils.isEmpty((CharSequence)target.getTendency()) ? "0" : target.getTendency())).Unit(target.getUnit()).PeriodKind(target.getPeriod()).Cycle(target.getPeriod()).System(null).HighAlert(Double.valueOf(StringUtils.isEmpty((CharSequence)target.getTarget()) ? "0" : target.getTarget())).LowAlert(Double.valueOf(StringUtils.isEmpty((CharSequence)target.getWarningStage()) ? "0" : target.getWarningStage())).TargetValue(Double.valueOf(StringUtils.isEmpty((CharSequence)target.getTarget()) ? "0" : target.getTarget())).MakeBy(CollectionUtils.isEmpty(target.getPersonInCharge()) ? "" : target.getPersonInCharge().get(0)).build();
            Map<String, String> nameLang = langMap.get("name");
            if (CollectionUtils.isEmpty(nameLang)) {
                throw new DWBusinessException(I18nUtils.getValue("lang.required", new Object[0]));
            }
            for (Map.Entry<String, String> entry : nameLang.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                TBBTarget langTarget = new TBBTarget();
                switch (k) {
                    case "zh_CN": {
                        BeanUtils.copyProperties((Object)tbbTarget, (Object)langTarget);
                        langTarget.setAthena_lang("zh-cn");
                        break;
                    }
                    case "zh_TW": {
                        BeanUtils.copyProperties((Object)tbbTarget, (Object)langTarget);
                        langTarget.setAthena_lang("zh-tw");
                        break;
                    }
                    case "en_US": {
                        BeanUtils.copyProperties((Object)tbbTarget, (Object)langTarget);
                        langTarget.setAthena_lang("en-us");
                        break;
                    }
                    default: {
                        throw new DWBusinessException(I18nUtils.getValue("unsupported.lang", new Object[0]));
                    }
                }
                langTarget.setIndicatorName(v);
                tbbTargets.add(langTarget);
            }
        }
        tbbTargetsRequest.setIndicator_detail(tbbTargets);
        return tbbTargetsRequest;
    }

    private List<Target> transformToTargets(TargetTreeForAppDto targetTreeForAppDto) {
        List<TargetForAppNodeInfoDto> nodeInfos = targetTreeForAppDto.getNodeInfos();
        LinkedList<Target> targets = new LinkedList<Target>();
        if (!CollectionUtils.isEmpty(nodeInfos)) {
            nodeInfos.forEach(nodeInfo -> {
                Target target = Target.builder().tenantId(targetTreeForAppDto.getTenantId()).id(nodeInfo.getId()).name(nodeInfo.getName()).tendency(nodeInfo.getTendency()).period(nodeInfo.getPeriod()).periodKey(nodeInfo.getPeriodKey()).unit(nodeInfo.getUnit()).precision(nodeInfo.getPrecision()).description(nodeInfo.getDescription()).target(nodeInfo.getTarget()).warningStage(nodeInfo.getWarningStage()).personInCharge(nodeInfo.getPersonInCharge()).enabled(nodeInfo.getEnabled()).code(nodeInfo.getCode()).type(nodeInfo.getType()).value(nodeInfo.getValue()).build();
                target.setLang(nodeInfo.getLang());
                targets.add(target);
            });
        }
        return targets;
    }

    private void saveTargetsToLocal(List<Target> targets) {
        targets.forEach(target -> {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)target.getTenantId()).and("id").is((Object)target.getId()));
            Target targetInDB = (Target)this.mongoTemplateUser.findOne(query, Target.class);
            if (null == targetInDB) {
                this.mongoTemplateUser.insert(target);
            } else {
                String objectId = targetInDB.getObjectId();
                BeanUtils.copyProperties((Object)target, (Object)targetInDB);
                targetInDB.setObjectId(objectId);
                this.mongoTemplateUser.save((Object)targetInDB);
            }
        });
    }

    private TargetTree buildTargetTreeByAppTargets(TargetTreeForAppDto targetTreeForAppDto) throws DWBusinessException {
        HashSet<String> currentTopicAppCode;
        Topic currentTopic;
        String tenantId = targetTreeForAppDto.getTenantId();
        TargetTree targetTree = TargetTree.builder().treeId(targetTreeForAppDto.getTreeId()).treeName(targetTreeForAppDto.getTreeName()).tenantId(targetTreeForAppDto.getTenantId()).build();
        targetTree.setLang(targetTreeForAppDto.getLang());
        List<TargetForAppNodeInfoDto> nodeInfos = targetTreeForAppDto.getNodeInfos();
        List l0Dto = nodeInfos.stream().filter(item -> item.getType().equals("topic") && StringUtils.isEmpty((CharSequence)item.getParentNodeId())).collect(Collectors.toList());
        List l1Dto = nodeInfos.stream().filter(item -> item.getType().equals("application") && StringUtils.isEmpty((CharSequence)item.getParentNodeId())).collect(Collectors.toList());
        List l2Dto = nodeInfos.stream().filter(item -> item.getType().equals("paradigm") && StringUtils.isEmpty((CharSequence)item.getParentNodeId())).collect(Collectors.toList());
        List l3Dto = nodeInfos.stream().filter(item -> item.getType().equals("mechanism") && StringUtils.isEmpty((CharSequence)item.getParentNodeId())).collect(Collectors.toList());
        List l4Dto = nodeInfos.stream().filter(item -> item.getType().equals("business") || item.getType().equals("usertrack")).collect(Collectors.toList());
        List customizedDto = nodeInfos.stream().filter(item -> !item.getType().equals("business") && !item.getType().equals("usertrack") && !StringUtils.isEmpty((CharSequence)item.getParentNodeId())).collect(Collectors.toList());
        HashMap<String, List<TargetForAppNodeInfoDto>> levelDtoMap = new HashMap<String, List<TargetForAppNodeInfoDto>>();
        levelDtoMap.put("LEVEL_0", l0Dto);
        levelDtoMap.put("LEVEL_1", l1Dto);
        levelDtoMap.put("LEVEL_2", l2Dto);
        levelDtoMap.put("LEVEL_3", l3Dto);
        levelDtoMap.put("LEVEL_4", l4Dto);
        levelDtoMap.put("CUSTOMIZED", customizedDto);
        Map<String, List<TargetForAppNodeInfoDto>> groupedChildrenParentMap = customizedDto.stream().collect(Collectors.groupingBy(TargetForAppNodeInfoDto::getParentNodeId));
        if (CollectionUtils.isEmpty(l0Dto)) {
            currentTopic = new Topic();
        } else {
            Set<Topic> topicSet = this.getTopicsByTenantId(targetTreeForAppDto.getTenantId());
            if (CollectionUtils.isEmpty(topicSet)) {
                throw new DWBusinessException(I18nUtils.getValue("target.noTopic", new Object[0]));
            }
            currentTopic = (Topic)topicSet.stream().filter(item -> item.getCode().equals(((TargetForAppNodeInfoDto)l0Dto.get(0)).getCode())).collect(Collectors.toList()).get(0);
            if (null == currentTopic) {
                throw new DWBusinessException(I18nUtils.getValue("target.noCurrentTopic", new Object[0]));
            }
        }
        String topicCode = currentTopic.getCode();
        if (CollectionUtils.isEmpty(l0Dto)) {
            if (l1Dto.size() != 1) {
                throw new DWBusinessException("\u4ec5\u652f\u6301\u4e00\u4e2a\u5e94\u7528\u8282\u70b9\u4f5c\u4e3a\u6839");
            }
            currentTopicAppCode = new HashSet(l1Dto.stream().map(TargetForAppNodeInfoDto::getCode).collect(Collectors.toList()));
        } else {
            currentTopicAppCode = new HashSet<String>(currentTopic.getRelatedApps());
        }
        TargetNode root = TargetNode.builder().id(CollectionUtils.isEmpty(l0Dto) ? null : ((TargetForAppNodeInfoDto)l0Dto.get(0)).getId()).name(targetTreeForAppDto.getTreeName()).enabled(true).build();
        root.setLang(CollectionUtils.isEmpty(l0Dto) ? null : ((TargetForAppNodeInfoDto)l0Dto.get(0)).getLang());
        root.setNodeId(CollectionUtils.isEmpty(l0Dto) ? null : ((TargetForAppNodeInfoDto)l0Dto.get(0)).getNodeId());
        root.setName(CollectionUtils.isEmpty(l0Dto) ? null : ((TargetForAppNodeInfoDto)l0Dto.get(0)).getName());
        targetTree.setRoot(root);
        this.buildDown(root, "LEVEL_1", levelDtoMap, currentTopicAppCode, tenantId, groupedChildrenParentMap);
        if (!CollectionUtils.isEmpty((Collection)groupedChildrenParentMap.get(root.getNodeId()))) {
            this.buildDown(root, "CUSTOMIZED", levelDtoMap, null, tenantId, groupedChildrenParentMap);
        }
        return targetTree;
    }

    private void buildDown(TargetNode targetNode, String level, Map<String, List<TargetForAppNodeInfoDto>> levelDtoMap, Set<String> nextRelatedCodes, String tenantId, Map<String, List<TargetForAppNodeInfoDto>> groupedChildrenParentMap) throws DWBusinessException {
        switch (level) {
            case "LEVEL_1": {
                if (null == nextRelatedCodes || nextRelatedCodes.isEmpty()) {
                    throw new DWBusinessException(I18nUtils.getValue("target.noAppOnCurrentTopic", new Object[0]));
                }
                List<String> tenantApp = this.cacService.getAuthorizationsApplication(tenantId);
                List<TargetForAppNodeInfoDto> l1Dtos = levelDtoMap.get("LEVEL_1");
                for (TargetForAppNodeInfoDto dto : l1Dtos) {
                    if (!tenantApp.contains(dto.getCode())) {
                        throw new DWBusinessException(I18nUtils.getValue("app.expired", new Object[0]));
                    }
                    HashSet<String> paradigmSet = new HashSet<String>();
                    List<ApplicationRelation> appParadigmRelations = this.appService.getApplicationRelationByTypeAndAppCode(tenantId, "paradigm", dto.getCode());
                    if (!CollectionUtils.isEmpty(appParadigmRelations)) {
                        List paradigmList = appParadigmRelations.stream().map(BaseEntity::getCode).collect(Collectors.toList());
                        paradigmSet.addAll(paradigmList);
                    }
                    if (!nextRelatedCodes.contains(dto.getCode())) continue;
                    TargetNode l1TargetNode = TargetNode.builder().id(dto.getId()).name(dto.getName()).enabled(true).build();
                    l1TargetNode.setLang(dto.getLang());
                    targetNode.addChildren(l1TargetNode);
                    this.buildDown(l1TargetNode, "LEVEL_2", levelDtoMap, paradigmSet, tenantId, groupedChildrenParentMap);
                    if (CollectionUtils.isEmpty((Collection)groupedChildrenParentMap.get(dto.getNodeId()))) continue;
                    l1TargetNode.setNodeId(dto.getNodeId());
                    this.buildDown(l1TargetNode, "CUSTOMIZED", levelDtoMap, null, tenantId, groupedChildrenParentMap);
                }
                break;
            }
            case "LEVEL_2": {
                List<TargetForAppNodeInfoDto> l2Dtos = levelDtoMap.get("LEVEL_2");
                for (TargetForAppNodeInfoDto paradigm : l2Dtos) {
                    if (nextRelatedCodes == null || !nextRelatedCodes.contains(paradigm.getCode())) continue;
                    HashSet<String> paradigmMechanisms = new HashSet<String>(this.paradigmService.getMechanismByParadigmCode(paradigm.getCode()));
                    TargetNode l2TargetNode = TargetNode.builder().id(paradigm.getId()).name(paradigm.getName()).enabled(true).build();
                    l2TargetNode.setLang(paradigm.getLang());
                    targetNode.addChildren(l2TargetNode);
                    this.buildDown(l2TargetNode, "LEVEL_3", levelDtoMap, paradigmMechanisms, tenantId, groupedChildrenParentMap);
                    if (CollectionUtils.isEmpty((Collection)groupedChildrenParentMap.get(paradigm.getNodeId()))) continue;
                    l2TargetNode.setNodeId(paradigm.getNodeId());
                    this.buildDown(l2TargetNode, "CUSTOMIZED", levelDtoMap, null, tenantId, groupedChildrenParentMap);
                }
                break;
            }
            case "LEVEL_3": {
                List<TargetForAppNodeInfoDto> l3Dtos = levelDtoMap.get("LEVEL_3");
                for (TargetForAppNodeInfoDto mechanismDto : l3Dtos) {
                    if (nextRelatedCodes == null || !nextRelatedCodes.contains(mechanismDto.getCode())) continue;
                    TargetNode l3TargetNode = TargetNode.builder().id(mechanismDto.getId()).name(mechanismDto.getName()).enabled(true).build();
                    l3TargetNode.setLang(mechanismDto.getLang());
                    targetNode.addChildren(l3TargetNode);
                    HashSet<String> singleEleSet = new HashSet<String>();
                    singleEleSet.add(mechanismDto.getNodeId());
                    this.buildDown(l3TargetNode, "LEVEL_4", levelDtoMap, singleEleSet, tenantId, groupedChildrenParentMap);
                    if (CollectionUtils.isEmpty((Collection)groupedChildrenParentMap.get(mechanismDto.getNodeId()))) continue;
                    l3TargetNode.setNodeId(mechanismDto.getNodeId());
                    this.buildDown(l3TargetNode, "CUSTOMIZED", levelDtoMap, null, tenantId, groupedChildrenParentMap);
                }
                break;
            }
            case "LEVEL_4": {
                List<TargetForAppNodeInfoDto> l4Dtos = levelDtoMap.get("LEVEL_4");
                String parentNodeId = "";
                if (nextRelatedCodes == null) break;
                Iterator<Object> l3TargetNode = nextRelatedCodes.iterator();
                while (l3TargetNode.hasNext()) {
                    String nextRelatedCode;
                    parentNodeId = nextRelatedCode = l3TargetNode.next();
                }
                for (TargetForAppNodeInfoDto customDto : l4Dtos) {
                    if (!customDto.getParentNodeId().equals(parentNodeId)) continue;
                    TargetNode l4TargetNode = TargetNode.builder().id(customDto.getId()).name(customDto.getName()).enabled(true).build();
                    l4TargetNode.setLang(customDto.getLang());
                    targetNode.addChildren(l4TargetNode);
                }
                break;
            }
            case "CUSTOMIZED": {
                List<TargetForAppNodeInfoDto> childrenDtos = groupedChildrenParentMap.get(targetNode.getNodeId());
                if (CollectionUtils.isEmpty(childrenDtos)) break;
                for (TargetForAppNodeInfoDto childrenDto : childrenDtos) {
                    TargetNode childTargetNode = TargetNode.builder().id(childrenDto.getId()).nodeId(childrenDto.getNodeId()).name(childrenDto.getName()).enabled(true).build();
                    targetNode.setLang(childrenDto.getLang());
                    targetNode.addChildren(childTargetNode);
                    this.buildDown(childTargetNode, "CUSTOMIZED", levelDtoMap, null, tenantId, groupedChildrenParentMap);
                }
                break;
            }
        }
    }

    private Set<Topic> getTopicsByTenantId(String tenantId) throws DWBusinessException {
        List<String> tenantApp = this.cacService.getAuthorizationsApplication(tenantId);
        List<String> allAthenaApp = this.appService.getAllAppCode();
        tenantApp = tenantApp.stream().filter(item -> allAthenaApp.contains(item)).collect(Collectors.toList());
        List<Topic> allTopics = this.topicService.getAllTopics();
        List<String> finalTenantApp = tenantApp;
        Set<Topic> tenantAllTopics = allTopics.stream().filter(item -> !Collections.disjoint(item.getRelatedApps(), finalTenantApp)).collect(Collectors.toSet());
        return tenantAllTopics;
    }

    @Override
    public Object postAppendLeaf(AppendLeafDto appendLeafDto) throws Exception {
        String token = DWServiceContext.getContext().getToken();
        String rootId = appendLeafDto.getRootId();
        String parentId = appendLeafDto.getParentId();
        List<String> targetId = appendLeafDto.getTargetId();
        String tenantId = AthenaUtils.getTenantId();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("id").in(targetId));
        List targets = this.mongoTemplateUser.find(query, Target.class);
        if (StringUtils.isEmpty((CharSequence)rootId)) {
            List<TargetTree> targetTrees = this.buildTreesFromRoot(targets, tenantId);
            this.mongoTemplateUser.insertAll(targetTrees);
            for (TargetTree targetTree : targetTrees) {
                this.postTBBTargetTree(TBBTargetTreeOperationConst.UPSERT, targetTree, token);
            }
            return targetTrees;
        }
        if (StringUtils.isEmpty((CharSequence)parentId)) {
            throw new DWBusinessException("\u7f3a\u5c11parentId\u53c2\u6570");
        }
        Query queryTree = new Query();
        queryTree.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("treeId").is((Object)rootId));
        TargetTree targetTree = (TargetTree)this.mongoTemplateUser.findOne(queryTree, TargetTree.class);
        targetTree = this.appendChildren(targetTree, parentId, targets);
        this.mongoTemplateUser.save((Object)targetTree);
        this.postTBBTargetTree(TBBTargetTreeOperationConst.UPSERT, targetTree, token);
        return null;
    }

    private TargetTree appendChildren(TargetTree targetTree, String parentId, List<Target> targets) {
        String userLocale = AthenaUtils.getCurrentLocale();
        TargetNode parentNode = this.findNode(targetTree, parentId);
        targets.forEach(target -> {
            TargetNode targetNode = new TargetNode();
            targetNode.setId(target.getId());
            String localeName = target.getLang().get("name").get(userLocale);
            targetNode.setName(StringUtils.isEmpty((CharSequence)localeName) ? target.getName() : localeName);
            parentNode.addChildren(targetNode);
        });
        return targetTree;
    }

    private TargetNode findNode(TargetTree targetTree, String parentId) {
        LinkedList<TargetNode> queue = new LinkedList<TargetNode>();
        queue.offer(targetTree.getRoot());
        while (!queue.isEmpty()) {
            TargetNode targetNode = (TargetNode)queue.poll();
            if (targetNode.getId().equals(parentId)) {
                return targetNode;
            }
            if (CollectionUtils.isEmpty(targetNode.getChildren())) continue;
            for (TargetNode targetChild : targetNode.getChildren()) {
                queue.offer(targetChild);
            }
        }
        return null;
    }

    private List<TargetTree> buildTreesFromRoot(List<Target> targets, String tenantId) {
        LinkedList<TargetTree> targetTrees = new LinkedList<TargetTree>();
        String userLocale = AthenaUtils.getCurrentLocale();
        targets.forEach(target -> {
            TargetTree targetTree = new TargetTree();
            targetTree.setTenantId(tenantId);
            targetTree.setTreeId(UUID.randomUUID().toString());
            TargetNode targetNode = new TargetNode();
            targetNode.setId(target.getId());
            String localeName = target.getLang().get("name").get(userLocale);
            targetNode.setName(StringUtils.isEmpty((CharSequence)localeName) ? target.getName() : localeName);
            targetTree.setRoot(targetNode);
            targetTrees.add(targetTree);
        });
        return targetTrees;
    }

    @Override
    public Object getTargetPool() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String locale = AthenaUtils.getCurrentLocale();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId));
        List targetPool = this.mongoTemplateUser.find(query, Target.class);
        if (!CollectionUtils.isEmpty((Collection)targetPool)) {
            targetPool.forEach(item -> {
                try {
                    LanguageUtil.processLocaleLanguage(item, locale);
                }
                catch (Exception e) {
                    log.warn("\u591a\u8bed\u8a00\u89e3\u6790\u5f02\u5e38", (Throwable)e);
                }
            });
        }
        return targetPool;
    }

    @Override
    public Object getTargetTree(String rootId) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String locale = AthenaUtils.getCurrentLocale();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("treeId").is((Object)rootId));
        TargetTree targetTree = (TargetTree)this.mongoTemplateUser.findOne(query, TargetTree.class);
        Set<String> flatTargetIds = this.getFlatTargetIdFromTree(targetTree);
        Query queryTargets = new Query();
        queryTargets.addCriteria((CriteriaDefinition)Criteria.where((String)"id").in(flatTargetIds).and("tenantId").is((Object)tenantId));
        List treeTargets = this.mongoTemplateUser.find(queryTargets, Target.class);
        Map<String, Target> treeTargetMap = new HashMap<String, Target>();
        if (!CollectionUtils.isEmpty((Collection)treeTargets)) {
            treeTargetMap = treeTargets.stream().collect(Collectors.toMap(Target::getId, Function.identity()));
        }
        TargetTreeDto targetTreeDto = this.renderRichTargetTree(targetTree, treeTargetMap, locale);
        return targetTreeDto;
    }

    private TargetTreeDto renderRichTargetTree(TargetTree targetTree, Map<String, Target> treeTargetMap, String locale) {
        TargetTreeDto targetTreeDto = new TargetTreeDto();
        targetTreeDto.setTreeId(targetTree.getTreeId());
        targetTreeDto.setObjectId(targetTree.getObjectId());
        targetTreeDto.setTenantId(targetTree.getTenantId());
        TargetNodeDto targetNodeDto = new TargetNodeDto();
        targetTreeDto.setRoot(targetNodeDto);
        this.renderRecursively(targetNodeDto, targetTree.getRoot(), treeTargetMap, locale);
        return targetTreeDto;
    }

    private void renderRecursively(TargetNodeDto targetNodeDto, TargetNode node, Map<String, Target> treeTargetMap, String locale) {
        List<TargetNode> children;
        targetNodeDto.setId(node.getId());
        Target target = treeTargetMap.get(node.getId());
        if (null != target) {
            targetNodeDto.setObjectId(target.getObjectId());
            targetNodeDto.setTarget(target.getTarget());
            String localeDescription = ((Map)target.getLang().getOrDefault("description", new HashMap())).getOrDefault(locale, target.getDescription());
            targetNodeDto.setDescription(localeDescription);
            targetNodeDto.setTenantId(target.getTenantId());
            targetNodeDto.setPeriod(target.getPeriod());
            targetNodeDto.setTendency(target.getTendency());
            targetNodeDto.setTendencyName(target.getTendencyName());
            String localeUnit = ((Map)target.getLang().getOrDefault("unit", new HashMap())).getOrDefault(locale, target.getDescription());
            targetNodeDto.setUnit(localeUnit);
            targetNodeDto.setPrecision(target.getPrecision());
            targetNodeDto.setWarningStage(target.getWarningStage());
            targetNodeDto.setLang(target.getLang());
            String localeName = ((Map)target.getLang().getOrDefault("name", new HashMap())).getOrDefault(locale, target.getDescription());
            targetNodeDto.setName(localeName);
            targetNodeDto.setPersonInCharge(target.getPersonInCharge());
            targetNodeDto.setEnabled(target.getEnabled());
        }
        if (!CollectionUtils.isEmpty(children = node.getChildren())) {
            for (TargetNode nodeChild : children) {
                TargetNodeDto targetNodeDtoChild = new TargetNodeDto();
                targetNodeDto.addChildren(targetNodeDtoChild);
                this.renderRecursively(targetNodeDtoChild, nodeChild, treeTargetMap, locale);
            }
        }
    }

    private Set<String> getFlatTargetIdFromTree(TargetTree targetTree) {
        if (null == targetTree || null == targetTree.getRoot() || StringUtils.isEmpty((CharSequence)targetTree.getRoot().getId())) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> flatTargetIds = new HashSet<String>();
        LinkedList<TargetNode> queue = new LinkedList<TargetNode>();
        queue.offer(targetTree.getRoot());
        while (!queue.isEmpty()) {
            TargetNode targetNode = (TargetNode)queue.poll();
            flatTargetIds.add(targetNode.getId());
            if (CollectionUtils.isEmpty(targetNode.getChildren())) continue;
            for (TargetNode targetChild : targetNode.getChildren()) {
                queue.offer(targetChild);
            }
        }
        return flatTargetIds;
    }

    private TargetTree getTree(String treeId, String tenantId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("treeId").is((Object)treeId));
        TargetTree targetTree = (TargetTree)this.mongoTemplateUser.findOne(query, TargetTree.class);
        return targetTree;
    }

    @Override
    public Object postRemoveNode(RemoveNodeDto removeNodeDto) throws Exception {
        String token = DWServiceContext.getContext().getToken();
        String rootId = removeNodeDto.getRootId();
        String targetId = removeNodeDto.getTargetId();
        String tenantId = AthenaUtils.getTenantId();
        if (StringUtils.isEmpty((CharSequence)rootId) || StringUtils.isEmpty((CharSequence)targetId)) {
            throw new DWBusinessException("rootId\u548ctargetId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TargetTree targetTree = this.getTree(rootId, tenantId);
        if (null == targetTree) {
            throw new DWBusinessException("\u8981\u5220\u9664\u7684\u6811\u4e0d\u5b58\u5728");
        }
        if (this.isRoot(targetTree, targetId)) {
            this.mongoTemplateUser.remove((Object)targetTree);
            this.postTBBTargetTree(TBBTargetTreeOperationConst.DELETE, targetTree, token);
        } else {
            this.removeFromTree(targetTree, targetId);
            this.mongoTemplateUser.save((Object)targetTree);
            this.postTBBTargetTree(TBBTargetTreeOperationConst.UPSERT, targetTree, token);
        }
        return null;
    }

    private boolean isRoot(TargetTree targetTree, String targetId) {
        return targetTree.getRoot().getId().equals(targetId);
    }

    private void removeFromTree(TargetTree targetTree, String targetId) {
        TargetNode root = targetTree.getRoot();
        this.traverseAndRemove(root, targetId, Flag.getInstance(false));
    }

    private void traverseAndRemove(TargetNode parent, String targetId, Flag findFlag) {
        List<TargetNode> children = parent.getChildren();
        if (!CollectionUtils.isEmpty(children)) {
            Iterator<TargetNode> iterator = children.iterator();
            while (iterator.hasNext() && !findFlag.getFlag().booleanValue()) {
                TargetNode child = iterator.next();
                if (child.getId().equals(targetId)) {
                    iterator.remove();
                    findFlag.setFlag(true);
                    continue;
                }
                this.traverseAndRemove(child, targetId, findFlag);
            }
        }
    }

    @Override
    public Object getTarget(String targetId) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        String tenantId = AthenaUtils.getTenantId();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("id").is((Object)targetId));
        Target target = (Target)this.mongoTemplateUser.findOne(query, Target.class);
        LanguageUtil.processLocaleLanguage(target, AthenaUtils.getCurrentLocale());
        return target;
    }

    @Override
    public Object postTarget(Target target) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("id").is((Object)target.getId()));
        Target targetInDB = (Target)this.mongoTemplateUser.findOne(query, Target.class);
        targetInDB.setTarget(target.getTarget());
        targetInDB.setWarningStage(target.getWarningStage());
        targetInDB.setPersonInCharge(target.getPersonInCharge());
        targetInDB.setEnabled(target.getEnabled());
        this.mongoTemplateUser.save((Object)targetInDB);
        return null;
    }
}

