/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kg.domain.CodedEntity;
import com.digiwin.athena.kmservice.cache.old.Cache;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.domain.cardfield.Group;
import com.digiwin.athena.knowledgegraph.domain.cardfield.TaskCardFields;
import com.digiwin.athena.knowledgegraph.domain.task.CardColumn;
import com.digiwin.athena.knowledgegraph.domain.task.CardFilterConfigDTO;
import com.digiwin.athena.knowledgegraph.domain.task.CardGroupApplication;
import com.digiwin.athena.knowledgegraph.domain.task.CardGroupGroup;
import com.digiwin.athena.knowledgegraph.domain.task.CardGroupTask;
import com.digiwin.athena.knowledgegraph.domain.task.CardLabel;
import com.digiwin.athena.knowledgegraph.domain.task.CardOrderConfigDTO;
import com.digiwin.athena.knowledgegraph.domain.task.LabelVO;
import com.digiwin.athena.knowledgegraph.domain.task.ReturnFieldVO;
import com.digiwin.athena.knowledgegraph.dto.CardConfigDTO;
import com.digiwin.athena.knowledgegraph.dto.GroupAndLabelDto;
import com.digiwin.athena.knowledgegraph.enums.BusinessMessageSourceMethod;
import com.digiwin.athena.knowledgegraph.service.ATMCService;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IAppService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Lang
@Service
public class TaskFieldService {
    private static final Logger log = LoggerFactory.getLogger(TaskFieldService.class);
    @Autowired
    private ATMCService atmcService;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    TenantService tenantService;
    @Autowired
    DataMapService dataMapService;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    IAppService appService;
    public static final String NON_REAL_TIME = "NON_REAL_TIME";

    public List<CardGroupGroup> sysCardGroups(String tenantId) {
        List<CardGroupGroup> sysCardGroups = null;
        try {
            sysCardGroups = this.atmcService.getGroupDimension(tenantId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (null == sysCardGroups) {
            sysCardGroups = new ArrayList<CardGroupGroup>();
        }
        sysCardGroups.forEach(s -> {
            s.setEnabled(true);
            s.setCommonEnable(true);
        });
        return sysCardGroups;
    }

    @Cache(namespace="knowledgegraph", key="applicationGroupAndCard", tenant=true, ttlSecs=86400L, loadEmpty=true, language=true)
    public GroupAndLabelDto applicationGroupAndCard() throws Exception {
        GroupAndLabelDto dto = new GroupAndLabelDto();
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<String> authApps = this.tenantService.getAppCodes();
        List<ApplicationRelation> taskRelations = this.appService.getApplicationRelationByTypeAndAppCode("activity", authApps);
        List<Application> apps = this.appService.getApplicationsByCodes(authApps);
        List taskCodes = taskRelations.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        HashMap<String, ApplicationRelation> taskRelationsMap = new HashMap<String, ApplicationRelation>();
        HashMap<String, Application> applicationMap = new HashMap<String, Application>();
        taskRelations.forEach(applicationRelation -> taskRelationsMap.put(applicationRelation.getCode(), (ApplicationRelation)applicationRelation));
        apps.forEach(app -> applicationMap.put(app.getCode(), (Application)app));
        dto.setTaskRelationsMap(taskRelationsMap);
        HashMap query = MapUtil.of((Object)"code", taskCodes);
        List tasks = this.dataMapService.postCardConfig(query);
        for (Object task : tasks) {
            Object columns;
            Object groups;
            Map map = (Map)task;
            String taskCode = (String)map.get("code");
            String taskName = (String)map.get("name");
            Object taskCardFields = map.get("fieldConfig");
            String businessMessageSourceMethod = ((JSONObject)JSON.parseObject((String)JSON.toJSONString(taskCardFields), JSONObject.class)).getString("businessMessageSourceMethod");
            if (NON_REAL_TIME.equals(businessMessageSourceMethod)) {
                dto.getBusinessMessageSourceMethodMap().put(taskCode, this.taskCardFieldToCardConfig(taskCardFields));
            }
            Map taskLang = null;
            if (null == taskCardFields) continue;
            try {
                taskLang = (Map)JSON.parseObject((String)JSON.toJSONString(map.get("lang")), Map.class);
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
            Object labels = JSONPath.eval(taskCardFields, (String)"$.taskCardField.labels");
            if (null != labels) {
                CardLabel cardLabel = new CardLabel();
                cardLabel.setTaskCode(taskCode);
                cardLabel.setLabels(JSON.parseArray((String)JSON.toJSONString((Object)labels), LabelVO.class));
                dto.getCardLabels().add(cardLabel);
                cardLabel.getLabels().forEach(labelVO -> {
                    if (null == labelVO.getOriginName()) {
                        labelVO.setOriginName(labelVO.getName());
                    }
                });
            }
            if (null != (groups = JSONPath.eval(taskCardFields, (String)"$.taskCardField.groups"))) {
                CardGroupApplication cardGroupApplication = this.taskGroup(taskCode, dto, taskRelationsMap, applicationMap);
                CardGroupTask cardGroupTask = new CardGroupTask();
                cardGroupTask.setTaskId((String)map.get("id"));
                cardGroupTask.setCode(taskCode);
                cardGroupTask.setName(taskName);
                cardGroupTask.setLang(taskLang);
                if (StringUtils.isNotBlank((CharSequence)businessMessageSourceMethod)) {
                    cardGroupTask.setBusinessMessageSourceMethod(BusinessMessageSourceMethod.valueOf(businessMessageSourceMethod));
                }
                List cardGroupGroups = JSON.parseArray((String)JSON.toJSONString((Object)groups), CardGroupGroup.class);
                for (CardGroupGroup cardGroupGroup : cardGroupGroups) {
                    cardGroupGroup.setEnabled(cardGroupGroup.isDefaultEffective());
                    cardGroupGroup.setCommonEnable(false);
                    cardGroupGroup.setDefaultGroup(false);
                }
                cardGroupTask.setGroups(cardGroupGroups);
                cardGroupApplication.getTasks().add(cardGroupTask);
            }
            if (null == (columns = JSONPath.eval(taskCardFields, (String)"$.taskCardField.columns"))) continue;
            List cardColumns = JSON.parseArray((String)JSON.toJSONString((Object)columns), CardColumn.class);
            cardColumns.forEach(e -> e.setTaskCode(taskCode));
            dto.getColumns().addAll(cardColumns);
        }
        return dto;
    }

    public List<CardConfigDTO> taskCardFieldToCardConfig(Object taskCardFields) {
        try {
            String locale = AthenaUtils.getCurrentLocale();
            LinkedHashSet aliasCode = new LinkedHashSet();
            Object labels = JSONPath.eval((Object)taskCardFields, (String)"$.taskCardField.labels");
            HashMap<String, CardConfigDTO.Config.Label> labelCodeMap = new HashMap<String, CardConfigDTO.Config.Label>();
            if (labels != null) {
                List labelVOS = JSON.parseArray((String)JSON.toJSONString((Object)labels), LabelVO.class);
                Set labelCodes = labelVOS.stream().map(CodedEntity::getCode).collect(Collectors.toCollection(LinkedHashSet::new));
                aliasCode.addAll(labelCodes);
                if (CollectionUtils.isNotEmpty((Collection)labelVOS)) {
                    List labelVOList = labelVOS.stream().filter(LabelVO::isDefaultEffective).collect(Collectors.toList());
                    for (LabelVO labelVO : labelVOList) {
                        Optional<CardConfigDTO.Config.Label.Style> styleOptional;
                        CardConfigDTO.Config.Label label = new CardConfigDTO.Config.Label();
                        label.setDefaultEffective("true");
                        try {
                            LanguageUtil.processLocaleLanguage((Object)labelVO, locale);
                        }
                        catch (IllegalAccessException | NoSuchFieldException e) {
                            log.error("processLocaleLanguage error, " + (Object)((Object)labelVO));
                        }
                        CardConfigDTO.Config.Label.Style style = new CardConfigDTO.Config.Label.Style();
                        label.setStyle(style);
                        label.setAliasName(labelVO.getName());
                        label.setLang(labelVO.getLang());
                        labelCodeMap.put(labelVO.getCode(), label);
                        List<ReturnFieldVO> returnFields = labelVO.getReturnFields();
                        if (!CollectionUtils.isNotEmpty(returnFields) || !(styleOptional = returnFields.stream().map(o -> {
                            CardConfigDTO.Config.Label.Style style1 = new CardConfigDTO.Config.Label.Style();
                            if (o.getStyle() != null) {
                                style1.setColor(o.getStyle().getColor());
                            }
                            return style1;
                        }).findFirst()).isPresent()) continue;
                        CardConfigDTO.Config.Label.Style style1 = styleOptional.get();
                        style.setColor(style1.getColor());
                    }
                }
            }
            Object groups = JSONPath.eval((Object)taskCardFields, (String)"$.taskCardField.groups");
            HashMap<String, CardConfigDTO.Config.Data> groupCodeMap = new HashMap<String, CardConfigDTO.Config.Data>();
            if (groups != null) {
                List cardGroupGroups = JSON.parseArray((String)JSON.toJSONString((Object)groups), CardGroupGroup.class);
                Set groupCodes = cardGroupGroups.stream().map(CodedEntity::getCode).collect(Collectors.toCollection(LinkedHashSet::new));
                aliasCode.addAll(groupCodes);
                groupCodeMap.putAll(cardGroupGroups.stream().filter(o -> "true".equals(String.valueOf(o.isDefaultEffective()))).collect(Collectors.toMap(o -> o.getCode(), o -> {
                    CardConfigDTO.Config.Data group = new CardConfigDTO.Config.Data();
                    try {
                        LanguageUtil.processLocaleLanguage(o, locale);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        log.error("processLocaleLanguage error, " + group);
                    }
                    group.setDefaultEffective("true");
                    group.setAliasName(o.getName());
                    group.setLang(o.getLang());
                    return group;
                }, (o1, o2) -> o1)));
            }
            Object columns = JSONPath.eval((Object)taskCardFields, (String)"$.taskCardField.columns");
            HashMap<String, CardConfigDTO.Config.Column> columnCodeMap = new HashMap<String, CardConfigDTO.Config.Column>();
            if (columns != null) {
                List cardColumns = JSON.parseArray((String)JSON.toJSONString((Object)columns), CardColumn.class);
                Set columnCodes = cardColumns.stream().map(CodedEntity::getCode).collect(Collectors.toCollection(LinkedHashSet::new));
                aliasCode.addAll(columnCodes);
                columnCodeMap.putAll(cardColumns.stream().collect(Collectors.toMap(CodedEntity::getCode, o -> {
                    try {
                        LanguageUtil.processLocaleLanguage(o, locale);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        log.error("processLocaleLanguage error, " + (Object)o);
                    }
                    CardConfigDTO.Config.Column column = new CardConfigDTO.Config.Column();
                    column.setDefaultEffective("true");
                    column.setValueType(o.getValueType());
                    column.setAliasName(o.getName());
                    column.setLang(o.getLang());
                    return column;
                }, (o1, o2) -> o1)));
            }
            Object order = JSONPath.eval((Object)taskCardFields, (String)"$.taskCardField.order");
            HashMap<String, CardConfigDTO.Config.Data> orderCodeMap = new HashMap<String, CardConfigDTO.Config.Data>();
            if (order != null) {
                List cardOrderConfigList = JSON.parseArray((String)JSON.toJSONString((Object)order), CardOrderConfigDTO.class);
                Set orderCodes = cardOrderConfigList.stream().map(CardOrderConfigDTO::getCode).collect(Collectors.toCollection(LinkedHashSet::new));
                aliasCode.addAll(orderCodes);
                orderCodeMap.putAll(cardOrderConfigList.stream().filter(o -> "true".equals(o.getDefaultEffective())).collect(Collectors.toMap(CardOrderConfigDTO::getCode, o -> {
                    try {
                        LanguageUtil.processLocaleLanguage(o, locale);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        log.error("processLocaleLanguage error, " + o);
                    }
                    CardConfigDTO.Config.Data orderData = new CardConfigDTO.Config.Data();
                    orderData.setAliasName(o.getName());
                    orderData.setDefaultEffective("true");
                    orderData.setLang(o.getLang());
                    return orderData;
                }, (o1, o2) -> o1)));
            }
            Object filter = JSONPath.eval((Object)taskCardFields, (String)"$.taskCardField.filter");
            HashMap<String, CardConfigDTO.Config.Data> filterCodeMap = new HashMap<String, CardConfigDTO.Config.Data>();
            if (filter != null) {
                List cardFilterConfigList = JSON.parseArray((String)JSON.toJSONString((Object)filter), CardFilterConfigDTO.class);
                Set filterCodes = cardFilterConfigList.stream().map(CardFilterConfigDTO::getCode).collect(Collectors.toCollection(LinkedHashSet::new));
                aliasCode.addAll(filterCodes);
                filterCodeMap.putAll(cardFilterConfigList.stream().filter(o -> "true".equals(o.getDefaultEffective())).collect(Collectors.toMap(CardFilterConfigDTO::getCode, o -> {
                    try {
                        LanguageUtil.processLocaleLanguage(o, locale);
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        log.error("processLocaleLanguage error, " + o);
                    }
                    CardConfigDTO.Config.Data filterData = new CardConfigDTO.Config.Data();
                    filterData.setDefaultEffective("true");
                    filterData.setDataType(o.getDataType());
                    filterData.setAliasName(o.getName());
                    filterData.setLang(o.getLang());
                    return filterData;
                }, (o1, o2) -> o1)));
            }
            return aliasCode.stream().map(code -> {
                CardConfigDTO cardConfigDTO = new CardConfigDTO();
                cardConfigDTO.setAliasField((String)code);
                CardConfigDTO.Config config = new CardConfigDTO.Config();
                cardConfigDTO.setConfig(config);
                config.setGroup((CardConfigDTO.Config.Data)groupCodeMap.get(code));
                config.setOrder((CardConfigDTO.Config.Data)orderCodeMap.get(code));
                config.setFilter((CardConfigDTO.Config.Data)filterCodeMap.get(code));
                config.setLabel((CardConfigDTO.Config.Label)labelCodeMap.get(code));
                config.setColumn((CardConfigDTO.Config.Column)columnCodeMap.get(code));
                return cardConfigDTO;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("parse taskCardFields error,", (Throwable)e);
            return new ArrayList<CardConfigDTO>();
        }
    }

    private CardGroupApplication taskGroup(String taskCode, GroupAndLabelDto dto, Map<String, ApplicationRelation> taskRelationsMap, Map<String, Application> applicationMap) {
        ApplicationRelation applicationRelation = taskRelationsMap.get(taskCode);
        String appCode = applicationRelation.getAppCode();
        Application app = applicationMap.get(appCode);
        CardGroupApplication groupApplication = null;
        for (CardGroupApplication cgp : dto.getCardGroupApplications()) {
            if (!cgp.getAppCode().equals(appCode)) continue;
            groupApplication = cgp;
            break;
        }
        if (null == groupApplication) {
            groupApplication = new CardGroupApplication();
            groupApplication.setAppCode(appCode);
            groupApplication.setAppName(applicationRelation.getAppName());
            groupApplication.setTasks(new ArrayList<CardGroupTask>());
            if (null != app && null != app.getLang()) {
                groupApplication.setLang(app.getLang());
                groupApplication.getLang().put("appName", app.getLang().get("name"));
            }
            dto.getCardGroupApplications().add(groupApplication);
        }
        return groupApplication;
    }

    public List<CardGroupApplication> generateApplicationGroups(Map<String, List<TaskCardFields>> appTasks) {
        if (org.springframework.util.CollectionUtils.isEmpty(appTasks)) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<CardGroupApplication> cardGroupApplications = new LinkedList<CardGroupApplication>();
        appTasks.forEach((k, v) -> {
            CardGroupApplication cardGroupApplication = new CardGroupApplication();
            cardGroupApplication.setAppCode((String)k);
            List appTasksList = v;
            LinkedList<CardGroupTask> tasks = new LinkedList<CardGroupTask>();
            appTasksList.forEach(appTask -> {
                CardGroupTask cardGroupTask = new CardGroupTask();
                cardGroupTask.setCode(appTask.getCode());
                List<Group> groups = appTask.getTaskCardField().getGroups();
                cardGroupTask.setGroups(JSON.parseArray((String)JSON.toJSONString(groups), CardGroupGroup.class));
                tasks.add(cardGroupTask);
            });
            cardGroupApplication.setTasks(tasks);
            cardGroupApplications.add(cardGroupApplication);
        });
        return cardGroupApplications;
    }
}

