/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.domain.mechanism.FormulaTemplate;
import com.digiwin.athena.knowledgegraph.domain.mechanism.MechanismFormula;
import com.digiwin.athena.knowledgegraph.domain.mechanism.TenantSettings;
import com.digiwin.athena.knowledgegraph.repo.TenantSettingsRepository;
import com.digiwin.athena.knowledgegraph.repoSystem.FormulaTemplateRepository;
import com.digiwin.athena.knowledgegraph.service.ITenantSettingsService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Lang
@Service
public class TenantSettingsService
implements ITenantSettingsService {
    @Autowired
    private TenantSettingsRepository repository;
    @Autowired
    private FormulaTemplateRepository formulaTemplateRepository;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate template;

    @Override
    public Object postScheduleConstructionThreshold(String tenantId, String taskId) {
        TenantSettings settings = this.repository.findOneByTenantId(tenantId);
        if (null != settings) {
            HashMap<String, Double> data = new HashMap<String, Double>();
            data.put("threshold", settings.getScheduleConstructionThreshold());
            return data;
        }
        return null;
    }

    @Override
    public Object postMechanismFormulaUpdate(String tenantId, String taskId, String key) {
        TenantSettings settings;
        HashMap<String, String> data = new HashMap<String, String>();
        FormulaTemplate ftemplate = this.formulaTemplateRepository.findOneByKey(key);
        if (null != ftemplate) {
            MechanismFormula update = new MechanismFormula();
            update.setTenantId(tenantId);
            update.setStatus(0);
            update.setKey(ftemplate.getKey());
            update.setName(ftemplate.getName());
            update.setFormulaName(ftemplate.getFormulaName());
            update.setFormulaVariables(ftemplate.getItems());
            update.setActionId(ftemplate.getActionId());
            update.setLang(ftemplate.getLang());
            this.template.save((Object)update);
            data.put("newFormulaId", update.getId());
            data.put("variableKey", update.getKey());
            data.put("variableName", update.getName());
            data.put("formulaName", update.getFormulaName());
        }
        if (null != (settings = this.repository.findOneByTenantId(tenantId))) {
            data.put("oldFormulaId", settings.getScheduleConstructionFormulaId());
        }
        return data;
    }

    @Override
    public Object getFormula(String formulaId) {
        MechanismFormula formula = (MechanismFormula)((Object)this.template.findById((Object)formulaId, MechanismFormula.class));
        return formula;
    }

    @Override
    public Object getCurrentFormula(String tenantId, String taskId) {
        TenantSettings settings = this.repository.findOneByTenantId(tenantId);
        if (null != settings && null != settings.getScheduleConstructionFormulaId()) {
            MechanismFormula formula = (MechanismFormula)((Object)this.template.findById((Object)settings.getScheduleConstructionFormulaId(), MechanismFormula.class));
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("actionId", formula.getActionId());
            if (null != formula.getFormulaVariables()) {
                formula.getFormulaVariables().forEach(e -> data.put(e.getKey(), (String)e.getValue()));
            }
            return data;
        }
        return null;
    }

    @Override
    public Object postFormula(MechanismFormula param) {
        if (null == param.getId()) {
            this.template.save((Object)param);
        } else {
            MechanismFormula formula = (MechanismFormula)((Object)this.template.findById((Object)param.getId(), MechanismFormula.class));
            if (null != formula) {
                if (null != param.getStatus()) {
                    formula.setStatus(param.getStatus());
                }
                if (null != param.getRemark()) {
                    formula.setRemark(param.getRemark());
                }
                if (null != param.getTenantId()) {
                    formula.setTenantId(param.getTenantId());
                }
                if (null != param.getFormulaVariables()) {
                    formula.setFormulaVariables(param.getFormulaVariables());
                }
                if (null != param.getKey()) {
                    formula.setKey(param.getKey());
                }
                if (null != param.getName()) {
                    formula.setName(param.getName());
                }
                this.template.save((Object)formula);
                if (param.getStatus() != null && param.getStatus() == 3) {
                    TenantSettings settings = this.repository.findOneByTenantId(param.getTenantId());
                    settings.setScheduleConstructionFormulaId(param.getId());
                    this.repository.save(settings);
                }
            }
        }
        return param;
    }

    public Object getSynchronously(String code) throws Exception {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)"system").and("code").is((Object)code));
        TenantSettings system = (TenantSettings)this.template.findOne(query, TenantSettings.class);
        Query query2 = new Query();
        query2.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)AthenaUtils.getTenantId()).and("code").is((Object)code));
        TenantSettings tenantSettings = (TenantSettings)this.template.findOne(query2, TenantSettings.class);
        if (tenantSettings != null) {
            AthenaUtils.mergeObject(tenantSettings, system);
        }
        if (system != null) {
            LanguageUtil.processLocaleLanguage(system.getExecuteType(), AthenaUtils.getCurrentLocale());
        }
        return system;
    }
}

