/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.domain.triples.Conclusion;
import com.digiwin.athena.knowledgegraph.domain.triples.Condition;
import com.digiwin.athena.knowledgegraph.domain.triples.Factor;
import com.digiwin.athena.knowledgegraph.domain.triples.Property;
import com.digiwin.athena.knowledgegraph.domain.triples.Scene;
import com.digiwin.athena.knowledgegraph.po.TriplesRequest;
import com.digiwin.athena.knowledgegraph.service.ITriplesService;
import com.digiwin.athena.knowledgegraph.vo.TriplesResponse;
import com.digiwin.athena.knowledgegraph.vo.TriplesVO;
import com.digiwin.athena.repository.neo4j.TriplesRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Lang
@Service
public class TriplesService
implements ITriplesService {
    private static final Logger log = LoggerFactory.getLogger(TriplesService.class);
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain1")
    SessionFactory sessionFactory1;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain2")
    SessionFactory sessionFactory2;
    @Autowired
    TriplesRepository triplesRepository;

    @Override
    public Object postTriplesSave(TriplesRequest triplesRequest) throws DWException {
        log.info("TriplesService.sava start,request:{}", (Object)triplesRequest);
        TriplesVO scene = triplesRequest.getScene();
        if (!ObjectUtils.isEmpty((Object)scene)) {
            List<String> list = Collections.singletonList("merge (f:" + scene.getCategory() + "{code:'" + scene.getCode() + "'})set f.name=" + this.toJsonStr(scene.getName()) + ";");
            TriplesService.sessionExecute(this.sessionFactory1, list);
            TriplesService.sessionExecute(this.sessionFactory2, list);
        }
        List<List<TriplesVO>> triplesVOList = triplesRequest.getTriplesVOList();
        for (List<TriplesVO> triplesVO : triplesVOList) {
            ArrayList<String> nodeSqlList = new ArrayList<String>();
            ArrayList<String> relationSqlList = new ArrayList<String>();
            ArrayList<String> versionSqlList = new ArrayList<String>();
            for (int i = 0; i < triplesVO.size(); ++i) {
                TriplesVO vo = triplesVO.get(i);
                StringBuilder nodeSql = new StringBuilder();
                StringBuilder relationSql = new StringBuilder();
                StringBuilder versionSql = new StringBuilder();
                nodeSql.append("merge(f:").append(vo.getCategory()).append("{code:'").append(vo.getCode()).append("'})").append("set f.name=").append(this.toJsonStr(vo.getName())).append(";");
                nodeSqlList.add(nodeSql.toString());
                if (i != triplesVO.size() - 1) {
                    TriplesVO voo = triplesVO.get(i + 1);
                    relationSql.append("match(f:").append(vo.getCategory()).append("{name:'").append(vo.getName()).append("',code:'").append(vo.getCode()).append("'}),(ff:").append(voo.getCategory()).append("{name:'").append(voo.getName()).append("',code:'").append(voo.getCode()).append("'}) merge (f)-[:").append(voo.getCategory()).append("]->(ff);");
                    relationSqlList.add(relationSql.toString());
                }
                if (!StringUtils.isNotEmpty((CharSequence)vo.getVersion())) continue;
                versionSql.append("match(f:").append(vo.getCategory()).append("{name:'").append(vo.getName()).append("',code:'").append(vo.getCode()).append("'})").append("merge (f)-[:Version]->(p:Property{version:'").append(vo.getVersion()).append("'}) set p.value=").append(this.toJsonStr(vo.getValue())).append(";");
                versionSqlList.add(versionSql.toString());
            }
            TriplesService.sessionExecute(this.sessionFactory1, nodeSqlList, relationSqlList, versionSqlList);
            TriplesService.sessionExecute(this.sessionFactory2, nodeSqlList, relationSqlList, versionSqlList);
            this.bindParentNode(scene, triplesVO);
        }
        return "success";
    }

    private String toJsonStr(Object o) {
        if (ObjectUtils.isEmpty((Object)o)) {
            return "";
        }
        return JSON.toJSONString((Object)o);
    }

    @Override
    public Object postTriplesDel(TriplesRequest triplesRequest) throws DWException {
        ArrayList<String> nodeSqlList = new ArrayList<String>();
        TriplesVO scene = triplesRequest.getScene();
        if (!ObjectUtils.isEmpty((Object)scene)) {
            nodeSqlList.add("match(f:" + scene.getCategory() + "{code:'" + scene.getCode() + "'}) detach delete f");
        }
        List<List<TriplesVO>> triplesVOList = triplesRequest.getTriplesVOList();
        for (List<TriplesVO> triplesVOS : triplesVOList) {
            for (TriplesVO triplesVO : triplesVOS) {
                if (!StringUtils.isNotEmpty((CharSequence)triplesVO.getVersion())) continue;
                nodeSqlList.add("match(f:" + triplesVO.getCategory() + "{code:'" + triplesVO.getCode() + "'})-[:Version]->(p:Property{version:'" + triplesVO.getVersion() + "'}) detach delete p");
            }
        }
        ArrayList<String> searchRelationDelSql = new ArrayList<String>();
        searchRelationDelSql.add("match (n:Factor) where not (n)-[:Factor]-(:Scene) detach delete n");
        searchRelationDelSql.add("match (n:Factor) where not (n)-[:Version]-(:Property) detach delete n");
        searchRelationDelSql.add("match (n:Condition) where not (n)-[:Condition]-(:Factor) detach delete n");
        searchRelationDelSql.add("match (n:Condition) where not (n)-[:Version]-(:Property) detach delete n");
        searchRelationDelSql.add("match (n:Conclusion) where not (n)-[:Conclusion]-(:Condition) detach delete n");
        searchRelationDelSql.add("match (n:Conclusion) where not (n)-[:Version]-(:Property) detach delete n");
        searchRelationDelSql.add("match (n:Property) where size((n)--())=0 delete (n)");
        TriplesService.sessionExecute(this.sessionFactory1, nodeSqlList, searchRelationDelSql);
        TriplesService.sessionExecute(this.sessionFactory2, nodeSqlList, searchRelationDelSql);
        return "success";
    }

    @Override
    public Object postTriplesQuery(TriplesRequest triplesRequest) throws Exception {
        double version = Double.parseDouble(triplesRequest.getVersion());
        boolean keepAllNodes = triplesRequest.getKeepAllNodes();
        List<Scene> scenes = this.triplesRepository.findAllByCode(triplesRequest.getScene().getCode());
        TriplesResponse triplesRes = new TriplesResponse();
        ArrayList<List<TriplesVO>> list = new ArrayList<List<TriplesVO>>();
        if (CollectionUtils.isEmpty(scenes)) {
            return triplesRes;
        }
        triplesRes.setScenes(scenes);
        for (Scene scene : scenes) {
            triplesRes.setScene(TriplesVO.builder().id(scene.getId()).name(scene.getName()).code(scene.getCode()).build());
            List<Factor> factors = scene.getFactor();
            if (CollectionUtils.isEmpty(factors)) continue;
            for (Factor factor : factors) {
                List<Property> fProperties = this.sortProperty(keepAllNodes, version, factor.getProperty());
                factor.setProperty(fProperties);
                List<Condition> conditions = factor.getCondition();
                if (CollectionUtils.isEmpty(conditions) || !keepAllNodes && CollectionUtils.isEmpty(fProperties)) continue;
                for (Condition condition : conditions) {
                    List<Property> conditionProperties = this.sortProperty(keepAllNodes, version, condition.getProperty());
                    condition.setProperty(conditionProperties);
                    List<Conclusion> conclusions = condition.getConclusion();
                    if (CollectionUtils.isEmpty(conclusions) || !keepAllNodes && CollectionUtils.isEmpty(conditionProperties)) continue;
                    for (Conclusion conclusion : conclusions) {
                        List<Property> conclusionProperties = this.sortProperty(keepAllNodes, version, conclusion.getProperty());
                        conclusion.setProperty(conclusionProperties);
                        if (!keepAllNodes && CollectionUtils.isEmpty(conclusionProperties)) continue;
                        ArrayList<TriplesVO> tripList = new ArrayList<TriplesVO>();
                        tripList.add(TriplesVO.builder().category("Factor").id(factor.getId()).name(factor.getName()).code(factor.getCode()).version(factor.getProperty().get(0).getVersion()).value(factor.getProperty().get(0).getValue()).build());
                        tripList.add(TriplesVO.builder().category("Condition").id(condition.getId()).name(condition.getName()).code(condition.getCode()).version(condition.getProperty().get(0).getVersion()).value(condition.getProperty().get(0).getValue()).build());
                        tripList.add(TriplesVO.builder().category("Conclusion").id(conclusion.getId()).name(conclusion.getName()).code(conclusion.getCode()).version(conclusion.getProperty().get(0).getVersion()).value(conclusion.getProperty().get(0).getValue()).build());
                        list.add(tripList);
                    }
                }
            }
        }
        triplesRes.setTriplesVOList(list);
        return triplesRes;
    }

    private List<Property> sortProperty(boolean keepAllNodes, double version, List<Property> propertyList) {
        if (CollectionUtils.isEmpty(propertyList)) {
            if (keepAllNodes) {
                Property property = new Property();
                return Collections.singletonList(property);
            }
            return new ArrayList<Property>();
        }
        return propertyList.stream().filter(v -> Double.parseDouble(v.getVersion()) <= version).sorted(Comparator.comparing(Property::getVersion).reversed()).collect(Collectors.toList());
    }

    private void bindParentNode(TriplesVO scene, List<TriplesVO> triplesVO) throws DWException {
        if (ObjectUtils.isEmpty((Object)scene)) {
            return;
        }
        TriplesVO triplesVO1 = triplesVO.get(0);
        if (StringUtils.isNotEmpty((CharSequence)triplesVO1.getParent()) && triplesVO1.getParent().equals(scene.getCode())) {
            List<String> sql = Collections.singletonList("match (f:" + scene.getCategory() + "{code:'" + scene.getCode() + "'}),(ff:" + triplesVO1.getCategory() + "{code:'" + triplesVO1.getCode() + "'}) merge (f)-[:" + triplesVO1.getCategory() + "]->(ff);");
            TriplesService.sessionExecute(this.sessionFactory1, sql);
            TriplesService.sessionExecute(this.sessionFactory2, sql);
        }
    }

    @SafeVarargs
    private static void sessionExecute(SessionFactory sessionFactory, List<String> ... sqlList) throws DWException {
        if (null != sessionFactory) {
            Session session = sessionFactory.openSession();
            for (List<String> string : sqlList) {
                for (String sql : string) {
                    if (!StringUtils.isNotEmpty((CharSequence)sql)) continue;
                    try {
                        session.query(sql, new HashMap());
                    }
                    catch (Exception e) {
                        throw new DWException(e.toString(), (Throwable)e);
                    }
                }
            }
            session.clear();
        }
    }
}

