/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kmservice.action.metadata.model.DataEntityMetadataDTO;
import com.digiwin.athena.kmservice.action.metadata.model.DataEntityMetadataDTO2;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.domain.business.BkField;
import com.digiwin.athena.knowledgegraph.domain.business.BkInfo;
import com.digiwin.athena.knowledgegraph.domain.task.EmailView;
import com.digiwin.athena.knowledgegraph.po.BkRequest;
import com.digiwin.athena.knowledgegraph.po.DapResponse;
import com.digiwin.athena.knowledgegraph.po.SimpleRequest;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleManager;
import com.digiwin.athena.knowledgegraph.rule.model.ActionParamDTO;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleDTO;
import com.digiwin.athena.knowledgegraph.rule.model.ReturnColumnDTO;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IViewService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.TaskService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.task.ActivityService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.vo.BkResponse;
import com.digiwin.athena.repository.neo4j.TaskRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.integration.util.CallerBlocksPolicy;
import org.springframework.stereotype.Service;

@Lang
@Service
public class ViewService
implements IViewService {
    private static final Logger log = LoggerFactory.getLogger(ViewService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    MonitorRuleManager monitorRuleManager;
    @Autowired
    TaskService taskService;
    @Autowired
    ActivityService activityService;
    @Autowired
    TenantService tenantService;
    @Autowired
    TaskRepository taskRepository;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    DataMapService dataMapService;
    @Autowired
    private DataPickService dataPickService;
    ExecutorService monitorsPool = new ThreadPoolExecutor(1, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(2), (RejectedExecutionHandler)new CallerBlocksPolicy(Integer.MAX_VALUE));

    @Override
    public Object getTest(String code) throws DWException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        return this.taskRepository.findTaskAndActivities(tenantId, code, tenantVersion);
    }

    @Override
    public Object getEmail(String emailCode, String locale) throws DWException {
        System.out.println("test getEmail:" + emailCode + " and locale=" + locale);
        HashMap<String, Object> map = new HashMap<String, Object>();
        String tenantId = AthenaUtils.getTenantId();
        String version = this.tenantService.getTenantVersion(tenantId);
        EmailView viewUser = (EmailView)((Object)this.mongoTemplateUser.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)emailCode).and("tenantId").is((Object)tenantId).and("version").is((Object)version)), EmailView.class));
        EmailView viewSystem = this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)emailCode), EmailView.class, "emailView");
        if (null != viewSystem) {
            if (null != viewUser) {
                AthenaUtils.mergeObject((Object)viewUser, (Object)viewSystem);
            }
            if (null != viewSystem.getLocaleViews() && null != viewSystem.getLocaleViews().get(locale)) {
                map.put("eventId", viewSystem.getLocaleViews().get(locale));
            }
            if (null != viewSystem.getConfig()) {
                if (null != viewSystem.getConfig().getTables()) {
                    viewSystem.getConfig().getTables().forEach(table -> {
                        if (null != table.getLang() && null != table.getLang().get("name") && null != ((Map)table.getLang().get("name")).get(locale)) {
                            table.setName((String)((Map)table.getLang().get("name")).get(locale));
                        }
                        table.setLang(null);
                        if (null != table.getFields()) {
                            table.getFields().forEach(field -> {
                                if (null != field.getLang() && null != field.getLang().get("name") && null != ((Map)field.getLang().get("name")).get(locale)) {
                                    field.setName((String)((Map)field.getLang().get("name")).get(locale));
                                }
                                field.setLang(null);
                            });
                        }
                    });
                }
                map.put("meta", viewSystem.getConfig());
            }
        }
        return map;
    }

    @Override
    public Object postBk(BkRequest request) throws DWException {
        BkResponse resp = new BkResponse();
        Criteria criteria = Criteria.where((String)"objectType").is((Object)request.getObjectType()).and("objectValue").is((Object)request.getObjectValue());
        List<BkInfo> infos = this.dataPickService.find(criteria, BkInfo.class, "bkInfo");
        resp.setType(request.getObjectType());
        resp.setQueryCode(request.getObjectValue());
        resp.setBkInfo(infos);
        if (infos.isEmpty()) {
            Map m = null;
            if ("task".equalsIgnoreCase(request.getObjectType())) {
                m = (Map)this.taskService.getInputData(request.getObjectValue());
            } else if ("activity".equalsIgnoreCase(request.getObjectType())) {
                m = (Map)this.activityService.getInputData(request.getObjectValue());
            }
            if (null != m && null != m.get("inputData")) {
                Object obj = m.get("inputData");
                ArrayList infos2 = new ArrayList();
                HashMap<String, Object> info2 = new HashMap<String, Object>();
                ArrayList<Object> bk = new ArrayList<Object>();
                info2.put("bk", bk);
                if (obj instanceof DataEntityMetadataDTO) {
                    DataEntityMetadataDTO defaultbk = (DataEntityMetadataDTO)obj;
                    info2.put("entityName", defaultbk.getEntity_name());
                    info2.put("entity_name", defaultbk.getEntity_name());
                    bk.add(defaultbk);
                } else if (obj instanceof Map) {
                    Map defaultbk = (Map)obj;
                    info2.put("entityName", defaultbk.get("entity_name"));
                    info2.put("entity_name", defaultbk.get("entity_name"));
                    bk.add(defaultbk);
                } else {
                    try {
                        DataEntityMetadataDTO defaultbk = (DataEntityMetadataDTO)JSON.parseObject((String)JSON.toJSONString(obj), DataEntityMetadataDTO.class);
                        info2.put("entityName", defaultbk.getEntity_name());
                        info2.put("entity_name", defaultbk.getEntity_name());
                        bk.add(defaultbk);
                    }
                    catch (Exception e) {
                        DataEntityMetadataDTO2 defaultbk2 = (DataEntityMetadataDTO2)JSON.parseObject((String)JSON.toJSONString(obj), DataEntityMetadataDTO2.class);
                        info2.put("entityName", defaultbk2.getEntity_name());
                        info2.put("entity_name", defaultbk2.getEntity_name());
                        bk.add(defaultbk2);
                    }
                }
                infos2.add(info2);
                resp.setBkInfo(infos2);
            }
        } else {
            infos.forEach(info -> this.transBk((BkInfo)((Object)info)));
        }
        return resp;
    }

    private void transBk(BkInfo in) {
        in.setEntity_name(in.getEntityName());
        if (null != in.getBk()) {
            this.transbkField(in.getBk());
        }
    }

    private void transbkField(List<BkField> fields) {
        fields.forEach(fd -> {
            fd.setEntity_name(fd.getEntityName());
            fd.setData_type(fd.getDataType());
            fd.setData_name(fd.getDataName());
            fd.setBk_name(fd.getBkName());
            fd.setIs_array(fd.getIsArray());
            fd.setIs_businesskey(fd.getIsBusinesskey());
            if (null != fd.getField()) {
                this.transbkField(fd.getField());
            }
        });
    }

    @Override
    public Object postBkMeta(BkRequest request) throws DWException {
        final String tenantId = AthenaUtils.getTenantId();
        String version = this.tenantService.getTenantVersion(tenantId);
        BkResponse resp = new BkResponse();
        Query query = null;
        if ("activityCheckCycle".equalsIgnoreCase(request.getObjectType())) {
            query = Query.query((CriteriaDefinition)Criteria.where((String)"objectType").is((Object)"activityCheckCycle"));
        } else {
            String bkConcat = ViewService.bkConcat(request.getBk());
            query = Query.query((CriteriaDefinition)Criteria.where((String)"objectType").is((Object)"activityCheck").and("bkConcat").is((Object)bkConcat).and("entityName").is((Object)request.getEntityName()));
            resp.setBkConcat(bkConcat);
        }
        if (null != request.getTaskCode()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"objectValue").is((Object)request.getTaskCode()));
        }
        if (null != request.getActivityCode()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"objectValue").is((Object)request.getActivityCode()));
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        List infos = this.mongoTemplate.find(query, BkInfo.class);
        infos = this.dataPickService.excludeWithSameCode(infos);
        resp.setQueryCode(request.getTaskCode());
        resp.setEntityName(request.getEntityName());
        if (infos.size() > 0) {
            final String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
            MonitorRuleDTO dto = this.getRule(((BkInfo)((Object)infos.get(0))).getRuleId(), tenantId, tenantVersion);
            if (dto == null) {
                return resp;
            }
            resp.setRule(dto);
            resp.setProductName(dto.getProduct_name());
            if (infos.size() > 1) {
                ArrayList<String> ruleIds = new ArrayList<String>();
                for (int i = 1; i < infos.size(); ++i) {
                    BkInfo info = (BkInfo)((Object)infos.get(i));
                    if (null == info.getRuleId() || ruleIds.contains(info.getRuleId())) continue;
                    ruleIds.add(info.getRuleId());
                }
                ArrayList fds = new ArrayList();
                ruleIds.forEach(ruleId -> {
                    Future<MonitorRuleDTO> fd = this.monitorsPool.submit(new Callable<MonitorRuleDTO>(){

                        @Override
                        public MonitorRuleDTO call() throws Exception {
                            return ViewService.this.getRule(ruleId, tenantId, tenantVersion);
                        }
                    });
                    fds.add(fd);
                });
                HashSet params = new HashSet();
                HashSet returnCols = new HashSet();
                fds.forEach(fd -> {
                    try {
                        MonitorRuleDTO dto1 = (MonitorRuleDTO)fd.get();
                        if (null != dto1) {
                            if (null != dto1.getAction_params()) {
                                params.addAll(dto1.getAction_params());
                            }
                            if (null != dto1.getReturn_columns()) {
                                returnCols.addAll(dto1.getReturn_columns());
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                });
                dto.setAction_params(new ArrayList<ActionParamDTO>());
                dto.setReturn_columns(new ArrayList<ReturnColumnDTO>());
                dto.getAction_params().addAll(params);
                dto.getReturn_columns().addAll(returnCols);
            }
        }
        return resp;
    }

    @Override
    public Object postDataMap(SimpleRequest request) throws DWException {
        DapResponse resp = this.dataMapService.requestDataMap(request.getUri(), request.getMethod(), request.getParam());
        return resp.getResponse();
    }

    @Override
    public Object postDataMapPublic(SimpleRequest request) throws DWException {
        DapResponse resp = this.dataMapService.requestDataMap(request.getUri(), request.getMethod(), request.getParam());
        return resp.getResponse();
    }

    private MonitorRuleDTO getRule(String ruleId, String tenantId, String tenantVersion) {
        if (null == ruleId) {
            return null;
        }
        try {
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("ruleId", ruleId);
            config.put("tenantId", tenantId);
            MonitorRuleDTO dto = this.monitorRuleManager.getMonitorRule(config, tenantVersion);
            return dto;
        }
        catch (Exception e) {
            log.error("query monitor rule error by ruleId:" + ruleId, (Throwable)e);
            return null;
        }
    }

    public static String bkConcat(List<String> bks) {
        Collections.sort(bks);
        StringBuilder sb = new StringBuilder();
        bks.forEach(bk -> sb.append((String)bk).append("$&"));
        return sb.toString();
    }
}

