/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleConfigService;
import com.digiwin.athena.knowledgegraph.service.impl.ActionService;
import com.digiwin.athena.knowledgegraph.service.impl.KgProductService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class KgHelpService {
    private static final Logger log = LoggerFactory.getLogger(KgHelpService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    SessionFactory neo4jSessionFactory;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain1")
    SessionFactory sessionFactory1;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain2")
    SessionFactory sessionFactory2;
    @Autowired
    ActionService actionService;
    @Autowired
    KgProductService productService;
    @Autowired
    MonitorRuleConfigService monitorRuleConfigService;
    @Autowired
    ObjectMapper objectMapper;

    public void executeCyhper(String cyhper, Map<String, Object> param) {
        Session session;
        if (null != this.sessionFactory1) {
            session = this.sessionFactory1.openSession();
            session.query(cyhper, param);
        }
        if (null != this.sessionFactory2) {
            session = this.sessionFactory2.openSession();
            session.query(cyhper, param);
        }
    }

    public void executeCyhperSave(MonitorRule rule) {
        Session session;
        if (null != this.sessionFactory1) {
            rule.setNeo4jId(null);
            session = this.sessionFactory1.openSession();
            session.save((Object)rule);
        }
        if (null != this.sessionFactory2) {
            rule.setNeo4jId(null);
            session = this.sessionFactory2.openSession();
            session.save((Object)rule);
        }
    }

    public String getTenantProduct(String ruleId) {
        try {
            List monitorRuleProducts = null;
            if (null != ruleId && (monitorRuleProducts = (List)this.monitorRuleConfigService.getProductNameByMonitorRule(ruleId)).size() == 1) {
                return (String)monitorRuleProducts.get(0);
            }
            List<String> tenantProducts = this.actionService.getTenantProductList();
            if (CollectionUtils.isEmpty(tenantProducts)) {
                return null;
            }
            if (tenantProducts.size() == 1) {
                return tenantProducts.get(0);
            }
            List allSteadyProduct = (List)this.productService.getAllSteadyProduct();
            tenantProducts.retainAll(allSteadyProduct);
            if (CollectionUtils.isEmpty(tenantProducts)) {
                return null;
            }
            if (tenantProducts.size() == 1) {
                return tenantProducts.get(0);
            }
            if (null != monitorRuleProducts) {
                tenantProducts.retainAll(monitorRuleProducts);
                if (tenantProducts.size() > 0) {
                    return tenantProducts.get(0);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public <T> T convert(Object obj, Class<T> c) {
        Object t = this.objectMapper.convertValue(obj, c);
        return (T)t;
    }

    public Query buildQuery(Map<String, Object> query) throws DWBusinessException {
        Query query1 = new Query();
        query.forEach((k, v) -> {
            if (v instanceof Collection) {
                ArrayList list = new ArrayList();
                Collection collection = (Collection)v;
                collection.forEach(ele -> list.add(ele));
                query1.addCriteria((CriteriaDefinition)Criteria.where((String)k).in(list));
            } else if ("name".equalsIgnoreCase((String)k) && v instanceof String) {
                String sv = (String)v;
                query1.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"name").regex(sv), Criteria.where((String)"lang.name.zh_CN").regex(sv), Criteria.where((String)"lang.name.zh_TW").regex(sv), Criteria.where((String)"lang.name.en_US").regex(sv)}));
            } else {
                query1.addCriteria((CriteriaDefinition)Criteria.where((String)k).is(v));
            }
        });
        return query1;
    }
}

