/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.common.HierarchicalEntity;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentStructuredListType;
import com.digiwin.athena.domain.component.bo.StructuredComponentBO;
import com.digiwin.athena.knowledgegraph.domain.ComponentStructuredList;
import com.digiwin.athena.knowledgegraph.domain.mechanism.Mechanism;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.mechanism.bo.ControlAbilityBO;
import com.digiwin.athena.mechanism.bo.MechanismLogic;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.PlanWidget;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class MechanismGraphService {
    private static final Logger log = LoggerFactory.getLogger(MechanismGraphService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    SessionFactory sessionFactory;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain1")
    SessionFactory sessionFactory1;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain2")
    SessionFactory sessionFactory2;
    @Autowired
    ObjectMapper objectMapper;
    @Autowired
    private DataPickService dataPickService;

    public String buildMechanismGraph(String code) throws DWBusinessException {
        String nodeId;
        String traceId = nodeId = code;
        Mechanism mechanism = this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)code), Mechanism.class, "mechanism");
        if (null == mechanism) {
            return null;
        }
        StringBuilder nodeSb = new StringBuilder();
        StringBuilder linkSb = new StringBuilder();
        ArrayList<String> mc = new ArrayList<String>();
        HashSet<String> nodeIds = new HashSet<String>();
        nodeSb.append("create (").append(nodeId).append(":Mechanism:MechanismPart:DTD {").append("nodeId:'").append(nodeId).append("',").append("code:'").append(mechanism.getCode()).append("',").append("name:'").append(mechanism.getName()).append("',").append("composite:'").append(mechanism.getComposite()).append("',").append("paradigmCode:'").append(mechanism.getParadigmCode()).append("',").append("traceId:'").append(traceId).append("'").append("})\r\n");
        Criteria criteria = Criteria.where((String)"mechanismCode").is((Object)code).and("type").is((Object)ComponentStructuredListType.Mechanism);
        ComponentStructuredList components = this.dataPickService.findOneByCondition(criteria, ComponentStructuredList.class, "componentStructuredList");
        if (null != components && CollectionUtils.isNotEmpty(components.getComponents())) {
            for (StructuredComponentBO principle : components.getComponents()) {
                this.componentBo(principle, nodeId, traceId, nodeSb, linkSb, mc, nodeIds);
            }
        }
        String cypher = nodeSb.toString() + linkSb.toString();
        System.out.println(cypher);
        try {
            this.executeCypher(cypher, mc);
        }
        catch (Exception e) {
            String deleteCyhper = "match(ms:MechanismPart{traceId:')" + traceId + "'}) detach delete ms";
            this.executeCypher(deleteCyhper, null);
            log.error("\u673a\u5236\u751f\u6210\u56fe\u8c31\u5931\u8d25 \u56de\u6eda:" + traceId);
            throw e;
        }
        return nodeId;
    }

    public boolean existMechanismPart(String nodeId, Set<String> nodeIds) {
        if (nodeIds.contains(nodeId)) {
            return true;
        }
        String cypher = "match (m:MechanismPart:DTD{nodeId:'" + nodeId + "'}) return m.nodeId";
        Session session = this.sessionFactory.openSession();
        Result result = session.query(cypher, new HashMap());
        return result.iterator().hasNext();
    }

    public String matchCyhper(String parentCode, String code, String name) {
        StringBuilder sbtmp1 = new StringBuilder();
        sbtmp1.append("match (").append(parentCode).append(":MechanismPart:DTD{nodeId:'").append(parentCode).append("'})").append(" match (").append(code).append(":MechanismPart:DTD{nodeId:'").append(code).append("'})").append(" create (").append(parentCode).append(")-[:Link{name:'" + name + "'}]->(").append(code).append(")");
        return sbtmp1.toString();
    }

    private String componentBo(StructuredComponentBO bo, String parentId, String traceId, StringBuilder nodeSb, StringBuilder linkSb, List<String> mc, Set<String> nodeIds) throws DWBusinessException {
        String logicId;
        String nodeId = "MechanismComponent_" + bo.getCode();
        if (this.existMechanismPart(nodeId, nodeIds)) {
            mc.add(this.matchCyhper(parentId, nodeId, "\u5305\u542b"));
            return nodeId;
        }
        nodeSb.append("create (").append(nodeId).append(":MechanismComponent:MechanismPart:DTD {").append("nodeId:'").append(nodeId).append("',").append("code:'").append(bo.getCode()).append("',").append("name:'").append(bo.getName() == null ? bo.getCode() : "").append("',").append("type:'").append(bo.getType()).append("',").append("disabled:").append(bo.isDisabled()).append(",").append("traceId:'").append(traceId).append("'").append("})\r\n");
        linkSb.append("create (").append(parentId).append(")-[:Link{name:'\u5305\u542b'}]->(").append(nodeId).append(")\r\n");
        nodeIds.add(nodeId);
        if ((ComponentTypeEnum.MechanismDrive == bo.getType() || ComponentTypeEnum.MechanismDecision == bo.getType() || ComponentTypeEnum.MechanismControl == bo.getType() || ComponentTypeEnum.MechanismLimit == bo.getType() || ComponentTypeEnum.MechanismAssign == bo.getType() || ComponentTypeEnum.MechanismDefault == bo.getType()) && null != (logicId = this.buildMechanismLogic(bo.getCode(), traceId, nodeIds))) {
            mc.add(this.matchCyhper(nodeId, logicId, "\u6620\u5c04"));
        }
        if (CollectionUtils.isNotEmpty((Collection)bo.getSubComponents())) {
            for (StructuredComponentBO boSub : bo.getSubComponents()) {
                this.componentBo(boSub, nodeId, traceId, nodeSb, linkSb, mc, nodeIds);
            }
        }
        return nodeId;
    }

    public String buildMechanismLogic(String logicCode, String traceId, Set<String> nodeIds) throws DWBusinessException {
        MechanismLogic logic;
        String nodeId = "MechanismLogic_" + logicCode;
        if (this.existMechanismPart(nodeId, nodeIds)) {
            return nodeId;
        }
        Criteria criteria = Criteria.where((String)"code").is((Object)logicCode);
        Query query = Query.query((CriteriaDefinition)criteria);
        List<MechanismLogic> mechanismLogics = this.dataPickService.excludeWithSameCode(this.mongoTemplateSystem.find(query, MechanismLogic.class), BaseEntity::getCode, HierarchicalEntity::getSourceLevel);
        MechanismLogic mechanismLogic = logic = CollectionUtils.isNotEmpty(mechanismLogics) ? mechanismLogics.get(0) : null;
        if (null == logic || logic.getLogic() == null) {
            return null;
        }
        if (ComponentTypeEnum.MechanismControl.name().equalsIgnoreCase(logic.getType())) {
            ControlAbilityBO bo = this.convert(logic.getLogic(), ControlAbilityBO.class);
            this.buildControl(bo, logic, traceId, nodeId);
        }
        return nodeId;
    }

    private String buildControl(ControlAbilityBO bo, MechanismLogic logic, String traceId, String nodeId) {
        StringBuilder sbtmp1;
        StringBuilder nodeSb = new StringBuilder();
        StringBuilder linkSb = new StringBuilder();
        ArrayList<String> mc = new ArrayList<String>();
        nodeSb.append("create (").append(nodeId).append(":MechanismLogic:MechanismPart:DTD {").append("nodeId:'").append(nodeId).append("',").append("pluginId:'").append(nodeId).append("',").append("code:'").append(logic.getCode()).append("',").append("name:'").append(logic.getName()).append("',").append("application:'").append(logic.getApplication()).append("',").append("type:'").append(logic.getType()).append("',").append("id:'").append(logic.getId()).append("',").append("traceId:'").append(traceId).append("'").append("})\r\n");
        String problemId = MechanismGraphService.uid();
        nodeSb.append("create (").append(problemId).append(":MechanismProblem:MechanismPart:DTD {").append("nodeId:'").append(problemId).append("',").append("pluginId:'").append(nodeId).append("',").append("name:'").append("\u5f02\u5e38").append("',").append("traceId:'").append(traceId).append("'").append("})\r\n");
        linkSb.append("create (").append(nodeId).append(")-[:Link{name:'\u5904\u7406'}]->(").append(problemId).append(")\r\n");
        String checkNodeId = MechanismGraphService.uid();
        String checkNodeId2 = MechanismGraphService.uid();
        String planNodeId = MechanismGraphService.uid();
        String targetNodeId = MechanismGraphService.uid();
        String activitiesNodeId = MechanismGraphService.uid();
        if (null != bo.getChoose()) {
            SingleStrategyWidget chooseWidget = bo.getChoose();
            Object checkWidget = chooseWidget.getCondition();
            PlanWidget planWidget = chooseWidget.getPositiveTarget();
            if (null != checkWidget) {
                nodeSb.append("create (").append(checkNodeId).append(":MechanismCheck:MechanismPart:DTD {").append("nodeId:'").append(checkNodeId).append("',").append("pluginId:'").append(nodeId).append("',").append("name:'").append("\u5bf9\u6bd4").append("',").append("traceId:'").append(traceId).append("'").append("})\r\n");
                nodeSb.append("create (").append(checkNodeId2).append(":MechanismCondition:MechanismPart:DTD {").append("nodeId:'").append(checkNodeId2).append("',").append("pluginId:'").append(nodeId).append("',").append("name:'").append("\u516c\u5f0f").append("',").append("type:'").append(checkWidget.getType()).append("',").append("expression:'").append(checkWidget.getExpression()).append("',").append("traceId:'").append(traceId).append("'").append("})\r\n");
                linkSb.append("create (").append(checkNodeId).append(")-[:Link{name:'\u4f7f\u7528'}]->(").append(checkNodeId2).append(")\r\n");
                linkSb.append("create (").append(checkNodeId).append(")-[:Link{name:'\u68c0\u51fa'}]->(").append(problemId).append(")\r\n");
            }
            if (null != planWidget) {
                nodeSb.append("create (").append(planNodeId).append(":MechanismActivity:MechanismPart:DTD {").append("nodeId:'").append(planNodeId).append("',").append("pluginId:'").append(nodeId).append("',").append("name:'").append("\u89e3\u51b3\u65b9\u6848").append("',").append("type:'").append(planWidget.getType()).append("',").append("traceId:'").append(traceId).append("'").append("})\r\n");
                linkSb.append("create (").append(planNodeId).append(")-[:Link{name:'\u89e3\u51b3'}]->(").append(problemId).append(")\r\n");
            }
        }
        nodeSb.append("create (").append(activitiesNodeId).append(":MechanismCheck:MechanismPart:DTD {").append("nodeId:'").append(activitiesNodeId).append("',").append("pluginId:'").append(nodeId).append("',").append("name:'").append("\u6570\u636e").append("',").append("traceId:'").append(traceId).append("'").append("})\r\n");
        linkSb.append("create (").append(checkNodeId).append(")-[:Link{name:'\u68c0\u5165'}]->(").append(activitiesNodeId).append(")\r\n");
        if (null != bo.getCheckSource()) {
            SourceWidget sourceWidget = bo.getCheckSource();
            nodeSb.append("create (").append(targetNodeId).append(":MechanismCheck:MechanismPart:DTD {").append("nodeId:'").append(targetNodeId).append("',").append("pluginId:'").append(nodeId).append("',").append("name:'").append("\u76ee\u6807").append("',").append("type:'").append(sourceWidget.getType()).append("',").append("target:'").append(sourceWidget.getTarget()).append("',").append("traceId:'").append(traceId).append("'").append("})\r\n");
            linkSb.append("create (").append(activitiesNodeId).append(")-[:Link{name:'\u6765\u6e90'}]->(").append(targetNodeId).append(")\r\n");
            switch (sourceWidget.getType()) {
                case "taskSource": {
                    String taskId = MechanismGraphService.uid();
                    sbtmp1 = new StringBuilder();
                    sbtmp1.append("match (").append(taskId).append(":Task:DTD{code:'").append(sourceWidget.getTarget()).append("'})").append(" match (").append(targetNodeId).append(":MechanismCheck:DTD{nodeId:'").append(targetNodeId).append("'})").append(" create (").append(targetNodeId).append(")-[:Link{name:'\u6620\u5c04'}]->(").append(taskId).append(")");
                    mc.add(sbtmp1.toString());
                    break;
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)bo.getPreActivities())) {
            for (int i = 0; i < bo.getPreActivities().size(); ++i) {
                ActivityWidget activityWidget = (ActivityWidget)bo.getPreActivities().get(i);
                String aid = MechanismGraphService.uid();
                nodeSb.append("create (").append(aid).append(":MechanismActivity:MechanismPart:DTD {").append("nodeId:'").append(aid).append("',").append("pluginId:'").append(nodeId).append("',").append("type:'").append(activityWidget.getType()).append("',").append("name:'").append(activityWidget.getName() == null ? "\u90e8\u4ef6" : activityWidget.getName()).append("',").append("traceId:'").append(traceId).append("'").append("})\r\n");
                linkSb.append("create (").append(activitiesNodeId).append(")-[:Link{name:'\u4f9d\u8d56',seq:").append(i).append("}]->(").append(aid).append(")\r\n");
                if (null == activityWidget.getTemplateCode()) continue;
                String tmid = MechanismGraphService.uid();
                sbtmp1 = new StringBuilder();
                sbtmp1.append("match (").append(tmid).append(":MechanismActivity{code:'").append(activityWidget.getTemplateCode()).append("'})").append(" match (").append(aid).append(":MechanismActivity:DTD{nodeId:'").append(aid).append("'})").append(" create (").append(aid).append(")-[:Link{name:'\u6620\u5c04'}]->(").append(tmid).append(")");
                mc.add(sbtmp1.toString());
            }
        }
        String cypher = nodeSb.toString() + linkSb.toString();
        System.out.println(cypher);
        this.executeCypher(cypher, mc);
        return nodeId;
    }

    private void executeCypher(String cypher, List<String> mc) {
        Session session1 = null;
        Session session2 = null;
        if (null != this.sessionFactory1) {
            session1 = this.sessionFactory1.openSession();
            session1.query(cypher, new HashMap());
            if (null != mc) {
                for (String str : mc) {
                    session1.query(str, new HashMap());
                }
            }
        }
        if (null != this.sessionFactory2) {
            session2 = this.sessionFactory2.openSession();
            session2.query(cypher, new HashMap());
            if (null != mc) {
                for (String str : mc) {
                    session2.query(str, new HashMap());
                }
            }
        }
    }

    public <T> T convert(Object obj, Class<T> c) {
        Object t = this.objectMapper.convertValue(obj, c);
        return (T)t;
    }

    public static String uid() {
        return "node" + UUID.randomUUID().toString().replaceAll("-", "");
    }
}

