/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.set;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.knowledgegraph.set.IOperateParser;
import com.digiwin.athena.knowledgegraph.set.IPartParser;
import com.digiwin.athena.knowledgegraph.set.SetParseContext;
import com.digiwin.athena.knowledgegraph.set.partParsers.monitorRule.IMonitorRulePartParser;
import com.digiwin.athena.set.Sets;
import com.digiwin.athena.set.part.Part;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PartParserService {
    @Autowired
    private List<IPartParser> partParsers;
    @Autowired
    private List<IMonitorRulePartParser> monitorRulePartParsers;
    @Autowired
    private List<IOperateParser> operateParsers;

    public void parsePart(SetParseContext context, Part part) throws DWBusinessException {
        for (IPartParser parser : this.partParsers) {
            if (!parser.accept(part)) continue;
            parser.parse(context, part);
            return;
        }
        throw new DWBusinessException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684PartParser:" + part);
    }

    public void parseMonitorRulePart(MonitorRule monitorRule, Sets sets) throws DWBusinessException {
        for (IMonitorRulePartParser parser : this.monitorRulePartParsers) {
            if (!parser.accept((Part)sets.getS().getPart())) continue;
            parser.parse(monitorRule, sets);
            return;
        }
        throw new DWBusinessException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684MonitorRulePartParser:" + sets.getS().getPart());
    }

    public void parseOperatePart(SetParseContext context, Part part) throws DWBusinessException {
        for (IOperateParser parser : this.operateParsers) {
            if (!parser.accept(context)) continue;
            parser.parse(context, part);
            return;
        }
        throw new DWBusinessException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684OperateParser:" + part);
    }
}

