/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.set.partParsers.monitorRule;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicParamsDO;
import com.digiwin.athena.kg.monitorRule.tenant.RuleDO;
import com.digiwin.athena.kg.monitorRule.tenant.StaticParamsDO;
import com.digiwin.athena.knowledgegraph.clients.CacService;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleCategoryEnum;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.set.partParsers.monitorRule.IMonitorRulePartParser;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import com.digiwin.athena.set.Sets;
import com.digiwin.athena.set.part.Part;
import com.digiwin.athena.set.part.Processor;
import com.digiwin.athena.set.part.SystemPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ApiMonitorRulePartParser
implements IMonitorRulePartParser {
    @Autowired
    KgHelpService kgHelpService;
    @Autowired
    MonitorRuleRepository monitorRuleRepository;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    CacService cacService;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;

    @Override
    public boolean accept(Part part) {
        return StringUtils.equalsIgnoreCase((CharSequence)MonitorRuleCategoryEnum.API.toString(), (CharSequence)part.getDetectType());
    }

    @Override
    public void parse(MonitorRule monitorRule, Sets sets) throws DWBusinessException {
        this.saveMonitorRule(sets, monitorRule);
    }

    private void saveMonitorRule(Sets sets, MonitorRule monitorRule) {
        SystemPart sPart = sets.getS().getPart();
        String ruleId = monitorRule.getId();
        String ruleName = monitorRule.getName();
        String tenantVersion = monitorRule.getVersion();
        List<DynamicParamsDO> dynamicParams = this.getDynamicParams(sPart.getParams());
        String jsonString = "CREATE (m:MonitorRule{actionType:'serviceComposer',code:$code,autoRun:true,pluginId:$pluginId,name:$name,";
        if (!CollectionUtils.isEmpty(dynamicParams)) {
            jsonString = jsonString + "dynamicParams:$dynamicParams,";
        }
        jsonString = jsonString + "actionCommonId:$actionCommonId,monitorActionId:$monitorActionId,standardPollingRule:$standardPollingRule,type:'CUSTOM',category:'API',version:$version,athena_namespace:$athena_namespace})";
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("code", ruleId);
        props.put("pluginId", sets.getCode());
        props.put("name", ruleName);
        if (!CollectionUtils.isEmpty(dynamicParams)) {
            props.put("dynamicParams", JSON.toJSONString(dynamicParams));
        }
        props.put("actionCommonId", "ServiceComposerBySet_" + sets.getCode());
        props.put("monitorActionId", sPart.getActionId());
        props.put("standardPollingRule", JSON.toJSONString((Object)sPart.getStandard_polling_rule()));
        props.put("version", tenantVersion);
        props.put("athena_namespace", sets.getAppCode());
        props.put("tenantId", "SYSTEM");
        this.kgHelpService.executeCyhper(jsonString, props);
        MonitorRuleProductConfig monitorRuleProductConfig = new MonitorRuleProductConfig();
        monitorRuleProductConfig.setMonitorRuleId(ruleId);
        monitorRuleProductConfig.setProductName(monitorRule.getProductName());
        monitorRuleProductConfig.setVersion(tenantVersion);
        monitorRuleProductConfig.setPluginId(sets.getCode());
        monitorRuleProductConfig.setIsPollingIds(Boolean.FALSE);
        monitorRuleProductConfig.setStaticParams(this.getStaticParams(sPart.getParams()));
        monitorRuleProductConfig.setAthena_namespace(sets.getAppCode());
        monitorRuleProductConfig.setTenantId("SYSTEM");
        this.mongoTemplateSystem.save((Object)monitorRuleProductConfig);
    }

    private List<StaticParamsDO> getStaticParams(List<Processor> params) {
        ArrayList<StaticParamsDO> staticParams = new ArrayList<StaticParamsDO>();
        for (Processor param : params) {
            if (Objects.equals("Preset", param.getType())) continue;
            StaticParamsDO staticParam = new StaticParamsDO();
            staticParam.setParam_name(param.getName());
            staticParam.setParam_value(param.getValue());
            staticParam.setParam_target("MONITOR_ACTION");
            staticParam.setParam_type(param.getType());
            staticParams.add(staticParam);
        }
        return staticParams;
    }

    private List<DynamicParamsDO> getDynamicParams(List<Processor> params) {
        ArrayList<DynamicParamsDO> dynamicParams = new ArrayList<DynamicParamsDO>();
        for (Processor param : params) {
            if (!Objects.equals("Preset", param.getType())) continue;
            RuleDO rule = new RuleDO();
            rule.setAdd_day("");
            rule.setDay("");
            rule.setPeriod("DAY");
            rule.setRange("0");
            rule.setTime_type("startTime".equalsIgnoreCase(param.getValue()) ? "START" : "END");
            DynamicParamsDO dynamicParam = new DynamicParamsDO();
            dynamicParam.setParam_name(param.getName());
            dynamicParam.setRule(rule);
            dynamicParam.setParam_target("MONITOR_ACTION");
            dynamicParam.setParam_type("DATE_TIME");
            dynamicParams.add(dynamicParam);
        }
        return dynamicParams;
    }
}

