/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.set.partParsers.monitorRule;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.set.partParsers.monitorRule.IMonitorRulePartParser;
import com.digiwin.athena.set.Sets;
import com.digiwin.athena.set.part.Part;
import com.digiwin.athena.set.part.SystemPart;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class SqlMonitorRulePartParser
implements IMonitorRulePartParser {
    @Autowired
    KgHelpService kgHelpService;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;

    @Override
    public boolean accept(Part part) {
        return StringUtils.equalsIgnoreCase((CharSequence)"SQL", (CharSequence)part.getDetectType());
    }

    @Override
    public void parse(MonitorRule monitorRule, Sets sets) throws DWBusinessException {
        this.saveMonitorRule(sets, monitorRule);
    }

    private void saveMonitorRule(Sets sets, MonitorRule monitorRule) {
        SystemPart sPart = sets.getS().getPart();
        String jsonString = "CREATE (m:MonitorRule{actionType:'serviceComposer',code:$code,autoRun:true,pluginId:$pluginId,name:$name,actionCommonId:$actionCommonId,standardPollingRule:$standardPollingRule,type:'SQL_SCRIPT',category:'SQL_SCRIPT',version:$version,athena_namespace:$athena_namespace})";
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("code", monitorRule.getId());
        props.put("pluginId", sets.getCode());
        props.put("name", monitorRule.getName());
        props.put("actionCommonId", "ServiceComposerBySet_" + sets.getCode());
        props.put("standardPollingRule", JSON.toJSONString((Object)sPart.getStandard_polling_rule()));
        props.put("version", monitorRule.getVersion());
        props.put("athena_namespace", sets.getAppCode());
        props.put("tenantId", "SYSTEM");
        this.kgHelpService.executeCyhper(jsonString, props);
        MonitorRuleProductConfig monitorRuleProductConfig = new MonitorRuleProductConfig();
        monitorRuleProductConfig.setMonitorRuleId(monitorRule.getId());
        monitorRuleProductConfig.setProductName(monitorRule.getProductName());
        monitorRuleProductConfig.setVersion(monitorRule.getVersion());
        monitorRuleProductConfig.setPluginId(sets.getCode());
        monitorRuleProductConfig.setIsPollingIds(Boolean.FALSE);
        monitorRuleProductConfig.setScript(sPart.getSqlScript());
        monitorRuleProductConfig.setAthena_namespace(sets.getAppCode());
        monitorRuleProductConfig.setTenantId("SYSTEM");
        this.mongoTemplateSystem.save((Object)monitorRuleProductConfig);
    }
}

