/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.svcomposition.bpm;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.svcomposition.bpm.Chain;
import com.digiwin.athena.knowledgegraph.svcomposition.bpm.Link;
import com.digiwin.athena.knowledgegraph.svcomposition.bpm.LinkFactory;
import com.digiwin.athena.knowledgegraph.svcomposition.bpm.Node;
import com.digiwin.athena.knowledgegraph.svcomposition.bpm.NodeFactory;
import com.digiwin.athena.knowledgegraph.svcomposition.bpm.NodeType;
import com.digiwin.athena.knowledgegraph.svcomposition.bpm.Process;
import com.digiwin.athena.knowledgegraph.svcomposition.bpm.ProcessVariable;
import com.digiwin.athena.knowledgegraph.svcomposition.bpm.ProcessVariableFactory;
import com.digiwin.athena.knowledgegraph.svcomposition.graph.GraphHelperTemplate;
import com.digiwin.athena.knowledgegraph.svcomposition.graph.MatrixGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class BPMConverter {
    private static final Map EMPTY_MAP = new HashMap();
    private static final String LINK_TYPE = "Straight";
    private static final String CATEGORY_ID = "ThemeMap";

    public static void addStartEndNodes(MatrixGraph<Map> graph) {
        HashMap<String, Object> start = new HashMap<String, Object>(4);
        start.put("name", "start");
        start.put("index", graph.size());
        start.put("type", (Object)NodeType.START);
        graph.insertVertex(start);
        HashMap<String, Object> end = new HashMap<String, Object>(4);
        end.put("name", "end");
        end.put("index", graph.size());
        end.put("type", (Object)NodeType.END);
        graph.insertVertex(end);
        HashMap<String, Object> user = new HashMap<String, Object>(4);
        user.put("name", "userTask");
        user.put("index", graph.size());
        user.put("type", (Object)NodeType.USER);
        graph.insertVertex(user);
        for (int i = 0; i < graph.size() - 3; ++i) {
            if (graph.inDegree(i) == 0) {
                graph.insertEdge(graph.size() - 1, i);
            }
            if (graph.outDegree(i) != 0) continue;
            graph.insertEdge(i, graph.size() - 2);
        }
        graph.insertEdge(graph.size() - 3, graph.size() - 1);
    }

    public static void addGateway(MatrixGraph<Map> graph) {
        int graphPreSize = graph.size();
        for (int i = 0; i < graphPreSize; ++i) {
            int j;
            HashMap<String, Object> gateway;
            if (graph.outDegree(i) > 1) {
                List<Integer> outNodeIndexes = graph.outNodeIndexes(i);
                gateway = new HashMap<String, Object>(4);
                gateway.put("name", "outGateway");
                gateway.put("index", graph.size());
                gateway.put("type", (Object)NodeType.PARAGATEWAY);
                graph.insertVertex(gateway);
                graph.insertEdge(i, graph.size() - 1);
                for (j = 0; j < outNodeIndexes.size(); ++j) {
                    graph.removeEdge(i, outNodeIndexes.get(j));
                    graph.insertEdge(graph.size() - 1, outNodeIndexes.get(j));
                }
            }
            if (graph.inDegree(i) <= 1) continue;
            List<Integer> inNodeIndexes = graph.inNodeIndexes(i);
            gateway = new HashMap(4);
            gateway.put("name", "inGateway");
            gateway.put("index", graph.size());
            gateway.put("type", (Object)NodeType.PARAGATEWAY);
            graph.insertVertex(gateway);
            graph.insertEdge(graph.size() - 1, i);
            for (j = 0; j < inNodeIndexes.size(); ++j) {
                graph.removeEdge(inNodeIndexes.get(j), i);
                graph.insertEdge(inNodeIndexes.get(j), graph.size() - 1);
            }
        }
    }

    public static Process convertToBPMJson(MatrixGraph<Map> graph, String tenantId) throws DWBusinessException {
        int i;
        Process process = new Process();
        ArrayList<Map> nodeMapList = graph.getVertexList();
        int[][] matrix = graph.getMatrix();
        LinkedList<Node> nodeList = new LinkedList<Node>();
        LinkedList<Chain> chainList = new LinkedList<Chain>();
        LinkedList<Link> linkList = new LinkedList<Link>();
        LinkedList<ProcessVariable> processVariableList = new LinkedList<ProcessVariable>();
        int startIndex = GraphHelperTemplate.getFirstNodeIndex(graph);
        List<Integer> outIndexes = graph.outNodeIndexes(graph.outNodeIndexes(startIndex).get(0));
        LinkedList<Integer> requireInputIndexes = new LinkedList<Integer>();
        for (i = 0; i < outIndexes.size(); ++i) {
            Map node = (Map)nodeMapList.get(outIndexes.get(i));
            if (node.get("type") == NodeType.PARAGATEWAY) {
                List<Integer> gatewayOutIndexes = graph.outNodeIndexes((Integer)node.get("index"));
                gatewayOutIndexes.forEach(item -> requireInputIndexes.add((Integer)item));
                continue;
            }
            requireInputIndexes.add(outIndexes.get(i));
        }
        for (i = 0; i < nodeMapList.size(); ++i) {
            List<ProcessVariable> requiredOutPVs;
            ProcessVariable createdPV = ProcessVariableFactory.createProcessVariableOfCreated((Map)nodeMapList.get(i));
            if (null != createdPV) {
                processVariableList.add(createdPV);
            }
            if (requireInputIndexes.contains(((Map)nodeMapList.get(i)).get("index")) && null != (requiredOutPVs = ProcessVariableFactory.createProcessVariableOfRequired((Map)nodeMapList.get(i)))) {
                processVariableList.addAll(requiredOutPVs);
            }
            List<ProcessVariable> requiredPVs = ProcessVariableFactory.createProcessVariableOfRequired((Map)nodeMapList.get(i));
            Node node = NodeFactory.createNode((Map)nodeMapList.get(i), tenantId, requiredPVs, createdPV);
            nodeList.add(node);
        }
        for (i = 0; i < graph.size(); ++i) {
            for (int j = 0; j < graph.size(); ++j) {
                if (matrix[i][j] <= 0) continue;
                Chain chain = new Chain(i, j);
                chainList.add(chain);
            }
        }
        Map<Integer, Node> nodeMap = nodeList.stream().collect(Collectors.toMap(Node::getIndex, item -> item));
        chainList.forEach(item -> {
            Node preNode = (Node)nodeMap.get(item.getPreIndex());
            Node nextNode = (Node)nodeMap.get(item.getNextIndex());
            Link link = LinkFactory.createLink(preNode, nextNode, linkList.size());
            linkList.add(link);
        });
        process.setId("").setName("").setTenantId("athenaTest").setNodes(nodeList).setLinks(linkList).setProcessVariable(processVariableList).setNameI18n(EMPTY_MAP).setLinkType(LINK_TYPE).setLimit(0).setCompletedEvent(EMPTY_MAP).setTerminatedEvent(EMPTY_MAP).setAbortedEvent(EMPTY_MAP).setAbortedNotice(true).setTerminatedNotice(true).setCompletedNotice(true).setReassignNotice(true).setRollbackNotice(true).setCategoryId(CATEGORY_ID).setCurrentAuthorId("");
        return process;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }
}

