/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.svcomposition.bpm;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.knowledgegraph.svcomposition.bpm.Node;
import com.digiwin.athena.knowledgegraph.svcomposition.bpm.NodeType;
import com.digiwin.athena.knowledgegraph.svcomposition.bpm.ProcessVariable;
import com.digiwin.athena.knowledgegraph.svcomposition.bpm.VelocityEngineHelper;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.SpringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class NodeFactory {
    private static final String START_NODE = "StartEvent";
    private static final String END_NODE = "EndEvent";
    private static final String USER_TASK = "UserTask";
    private static final String PARALLEL_GATEWAY = "ParallelGateway";
    private static final String SERVICE_TASK = "ServiceTask";
    private static final String EXTERNAL_REQUEST_HTTP_METHOD_POST = "POST";
    private static final String FIRST_GET_FIRST_WIN = "FIRST_GET_FIRST_WIN";
    private static final String EXTERNAL_SERVICE_REQUEST_TYPE = "standard";
    private static final Map EMPTY_MAP = Collections.EMPTY_MAP;

    public static Node createNode(Map nodeMap, String tenantId, List<ProcessVariable> requiredPVs, ProcessVariable createdPV) throws DWBusinessException {
        NodeType nodeType = (NodeType)((Object)nodeMap.get("type"));
        int nodeIndex = (Integer)nodeMap.get("index");
        Node node = new Node();
        switch (nodeType) {
            case START: {
                node.setId(START_NODE + nodeIndex).setIndex(nodeIndex).setName((String)nodeMap.get("name")).setType(START_NODE + nodeIndex).setText("").setExternalRequestHttpMethod(EXTERNAL_REQUEST_HTTP_METHOD_POST).setExternalServiceUrl("").setMultiUserMode(FIRST_GET_FIRST_WIN).setGroupId("").setDescription("").setLimit(0).setVisible(true).setTextI18n(EMPTY_MAP).setExternalRequestParameters(EMPTY_MAP).setExternalResponseParameters(EMPTY_MAP).setExternalServiceRequestType(EXTERNAL_SERVICE_REQUEST_TYPE).setExternalCustomRequest("").setBeforeRequestScript("").setAfterRequestScript("").setAsync(false).setExternalCustomHeader("").setServicePattern("").setEspServiceName("").setEspProductName("").setPerformerType(0).setProcessVariable("").setBasicOnProcessVariable("").setTop(0).setLeft(0).setWidth(50).setHeight(50).setBasicOnTask("").setNotice(false).setNoticeTemplate(EMPTY_MAP).setOrgService("").setSpecificRoleId("").setSpecificRoleId(START_NODE + nodeIndex);
                return node;
            }
            case USER: {
                node.setId(USER_TASK + nodeIndex).setIndex(nodeIndex).setName((String)nodeMap.get("name")).setType(USER_TASK + nodeIndex).setText("").setExternalRequestHttpMethod(EXTERNAL_REQUEST_HTTP_METHOD_POST).setExternalServiceUrl("").setMultiUserMode(FIRST_GET_FIRST_WIN).setGroupId("").setDescription("").setLimit(0).setVisible(true).setTextI18n(EMPTY_MAP).setExternalRequestParameters(EMPTY_MAP).setExternalResponseParameters(EMPTY_MAP).setExternalServiceRequestType(EXTERNAL_SERVICE_REQUEST_TYPE).setExternalCustomRequest("").setBeforeRequestScript("").setAfterRequestScript("").setAsync(false).setExternalCustomHeader("").setServicePattern("").setEspServiceName("").setEspProductName("").setPerformerType(0).setProcessVariable("").setBasicOnProcessVariable("").setTop(0).setLeft(0).setWidth(50).setHeight(50).setBasicOnTask("").setNotice(false).setNoticeTemplate(EMPTY_MAP).setOrgService("").setSpecificRoleId("").setSpecificRoleId(USER_TASK + nodeIndex);
                return node;
            }
            case SERVICE: {
                List nodeLabels = (List)nodeMap.get("eleLabels");
                node.setId(SERVICE_TASK + nodeIndex).setIndex(nodeIndex).setName((String)nodeMap.get("name")).setType(SERVICE_TASK + nodeIndex).setText("").setExternalRequestHttpMethod(EXTERNAL_REQUEST_HTTP_METHOD_POST).setExternalServiceUrl("").setMultiUserMode(FIRST_GET_FIRST_WIN).setGroupId("").setDescription("").setLimit(0).setVisible(true).setTextI18n(EMPTY_MAP).setExternalRequestParameters(EMPTY_MAP).setExternalResponseParameters(EMPTY_MAP).setExternalServiceRequestType(EXTERNAL_SERVICE_REQUEST_TYPE).setExternalCustomRequest("").setBeforeRequestScript("").setAfterRequestScript("").setAsync(false).setExternalCustomHeader("").setServicePattern("").setEspServiceName("").setEspProductName("").setPerformerType(3).setProcessVariable("").setBasicOnProcessVariable("").setTop(0).setLeft(0).setWidth(50).setHeight(50).setBasicOnTask("").setNotice(false).setNoticeTemplate(EMPTY_MAP).setOrgService("").setSpecificRoleId("").setSpecificRoleId(SERVICE_TASK + nodeIndex);
                if (nodeLabels.contains("EspAction")) {
                    Map outerRequireParas;
                    String productName;
                    try {
                        productName = SpringUtil.getBean(ProductNameResolver.class).getProductName((String)nodeMap.get("serviceName"), tenantId);
                    }
                    catch (Exception e) {
                        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.searchProductError", new Object[0]));
                    }
                    node.setEspProductName(productName).setEspServiceName((String)nodeMap.get("serviceName")).setServicePattern("servicePool").setExternalCustomHeader("").setExternalServiceRequestType("scriptEngine");
                    HashMap<String, Object> requestScriptSubstituteMap = new HashMap<String, Object>(3);
                    HashMap<String, String> responseScriptSubstituteMap = new HashMap<String, String>(3);
                    Map innerRequireParas = (Map)nodeMap.get("requires");
                    if (!CollectionUtils.isEmpty((Map)innerRequireParas)) {
                        Map requireEntity = new HashMap();
                        for (Iterator paraKey : innerRequireParas.keySet()) {
                            requireEntity = (Map)innerRequireParas.get(paraKey);
                        }
                        LinkedList processVariableKey = new LinkedList();
                        if (!CollectionUtils.isEmpty(requireEntity)) {
                            for (String paraKey : requireEntity.keySet()) {
                                if (((List)requireEntity.get(paraKey)).size() <= 1) continue;
                                ((List)requireEntity.get(paraKey)).forEach(item -> processVariableKey.add(item.substring(0, item.lastIndexOf("_"))));
                            }
                        }
                        requestScriptSubstituteMap.put("processVariables", processVariableKey);
                    }
                    if (!CollectionUtils.isEmpty((Map)(outerRequireParas = (Map)nodeMap.get("outerRequires")))) {
                        Map requireEntity = new HashMap();
                        for (String paraKey : outerRequireParas.keySet()) {
                            requireEntity = (Map)outerRequireParas.get(paraKey);
                        }
                        LinkedList processVariableKey = new LinkedList();
                        if (!CollectionUtils.isEmpty(requireEntity)) {
                            for (String paraKey : requireEntity.keySet()) {
                                if (((List)requireEntity.get(paraKey)).size() <= 1) continue;
                                ((List)requireEntity.get(paraKey)).forEach(item -> processVariableKey.add(item.substring(0, item.lastIndexOf("_"))));
                            }
                        }
                        requestScriptSubstituteMap.put("outerProcessVariables", processVariableKey);
                    }
                    if (!CollectionUtils.isEmpty(requiredPVs)) {
                        Assert.isTrue((requiredPVs.size() == 1 ? 1 : 0) != 0, (String)"\u6682\u4e14\u8ba4\u4e3arequiredPVs\u5165\u53c2\u53ea\u6709\u4e00\u4e2a");
                        requestScriptSubstituteMap.put("param", requiredPVs.get(0).getName());
                    }
                    if (null != createdPV) {
                        responseScriptSubstituteMap.put("response", createdPV.getName());
                    }
                    node.setBeforeRequestScript(VelocityEngineHelper.replace(requestScriptSubstituteMap, "/vm/esprequest.vm")).setAfterRequestScript(VelocityEngineHelper.replace(responseScriptSubstituteMap, "/vm/espresponse.vm"));
                }
                return node;
            }
            case END: {
                node.setId(END_NODE + nodeIndex).setIndex((Integer)nodeMap.get("index")).setName((String)nodeMap.get("name")).setType(END_NODE + nodeIndex).setText("").setExternalRequestHttpMethod(EXTERNAL_REQUEST_HTTP_METHOD_POST).setExternalServiceUrl("").setMultiUserMode(FIRST_GET_FIRST_WIN).setGroupId("").setDescription("").setLimit(0).setVisible(true).setTextI18n(EMPTY_MAP).setExternalRequestParameters(EMPTY_MAP).setExternalResponseParameters(EMPTY_MAP).setExternalServiceRequestType(EXTERNAL_SERVICE_REQUEST_TYPE).setExternalCustomRequest("").setBeforeRequestScript("").setAfterRequestScript("").setAsync(false).setExternalCustomHeader("").setServicePattern("").setEspServiceName("").setEspProductName("").setPerformerType(0).setProcessVariable("").setBasicOnProcessVariable("").setTop(0).setLeft(0).setWidth(50).setHeight(50).setBasicOnTask("").setNotice(false).setNoticeTemplate(EMPTY_MAP).setOrgService("").setSpecificRoleId("").setSpecificRoleId(END_NODE + nodeIndex);
                return node;
            }
            case PARAGATEWAY: {
                node.setId(PARALLEL_GATEWAY + nodeIndex).setIndex(nodeIndex).setName("Gateway").setType(PARALLEL_GATEWAY + nodeIndex).setText("").setExternalRequestHttpMethod(EXTERNAL_REQUEST_HTTP_METHOD_POST).setExternalServiceUrl("").setMultiUserMode(FIRST_GET_FIRST_WIN).setGroupId("").setDescription("").setLimit(0).setVisible(true).setTextI18n(EMPTY_MAP).setExternalRequestParameters(EMPTY_MAP).setExternalResponseParameters(EMPTY_MAP).setExternalServiceRequestType(EXTERNAL_SERVICE_REQUEST_TYPE).setExternalCustomRequest("").setBeforeRequestScript("").setAfterRequestScript("").setAsync(false).setExternalCustomHeader("").setServicePattern("").setEspServiceName("").setEspProductName("").setPerformerType(0).setProcessVariable("").setBasicOnProcessVariable("").setTop(0).setLeft(0).setWidth(50).setHeight(50).setBasicOnTask("").setNotice(false).setNoticeTemplate(EMPTY_MAP).setOrgService("").setSpecificRoleId("").setSpecificRoleId(PARALLEL_GATEWAY + nodeIndex);
                return node;
            }
        }
        throw new IllegalStateException(I18nUtils.getValue("knowledgegraph.unexpectedValue", new Object[]{nodeType}));
    }
}

