/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.svcomposition.bpm;

import com.digiwin.athena.knowledgegraph.svcomposition.bpm.ProcessVariable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public class ProcessVariableFactory {
    public static ProcessVariable createProcessVariableOfCreated(Map<String, Object> nodeMap) {
        Map createEntity = (Map)nodeMap.get("creates");
        String actionId = (String)nodeMap.get("actionId");
        if (null == createEntity) {
            return null;
        }
        ProcessVariable processVariable = ProcessVariableFactory.castToProcessVariable(createEntity, actionId);
        return processVariable;
    }

    private static ProcessVariable castToProcessVariable(Map<String, Object> createEntity, String actionId) {
        Assert.isTrue((createEntity.size() == 1 ? 1 : 0) != 0, (String)"action can create only one Entity");
        ProcessVariable processVariable = new ProcessVariable();
        for (String key : createEntity.keySet()) {
            processVariable.setId(actionId + "_" + key);
            processVariable.setName(actionId + "_" + key);
            processVariable.setType("STRING");
            processVariable.setValue("");
            processVariable.setDescription("");
        }
        return processVariable;
    }

    public static List<ProcessVariable> createProcessVariableOfRequired(Map nodeMap) {
        Map requireEntity = (Map)nodeMap.get("requires");
        if (null == requireEntity) {
            return null;
        }
        String actionId = (String)nodeMap.get("actionId");
        LinkedList<ProcessVariable> processVariables = new LinkedList<ProcessVariable>();
        ProcessVariable processVariable = new ProcessVariable();
        for (String key : requireEntity.keySet()) {
            processVariable.setId(actionId + "_" + "requires" + "_" + key);
            processVariable.setName(actionId + "_" + "requires" + "_" + key);
            processVariable.setType("STRING");
            processVariable.setValue("");
            processVariable.setDescription("");
            processVariables.add(processVariable);
        }
        return processVariables;
    }
}

