/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.synonym.controller.impl;

import com.digiwin.athena.kg.report.hz.model.sence.ReportSceneDTO;
import com.digiwin.athena.knowledgegraph.service.IScreenService;
import com.digiwin.athena.knowledgegraph.synonym.controller.IBigScreenViewConfigService;
import com.digiwin.athena.knowledgegraph.synonym.dao.BigScreenViewConfigDao;
import com.digiwin.athena.knowledgegraph.synonym.domain.BigScreenViewConfig;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.DeleteVo;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.ResultBean;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.ScreenInfo;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BigScreenViewConfigServiceImpl
implements IBigScreenViewConfigService {
    private static final Logger log = LoggerFactory.getLogger(BigScreenViewConfigServiceImpl.class);
    @Autowired
    private BigScreenViewConfigDao bigScreenViewConfigDao;
    @Autowired
    private IScreenService screenService;

    @Override
    public ResultBean<Object> getList(String appCode, String tenantId) {
        try {
            return ResultBean.success(this.bigScreenViewConfigDao.findList(appCode, tenantId));
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> delete(DeleteVo deleteVo) {
        try {
            this.bigScreenViewConfigDao.deleteList(deleteVo.getTid(), deleteVo.getIds(), deleteVo.getId());
            return ResultBean.success("");
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> insertList(List<BigScreenViewConfig> list) {
        try {
            this.bigScreenViewConfigDao.insertAll(list);
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
        return ResultBean.success("");
    }

    @Override
    public ResultBean<Object> update(BigScreenViewConfig bigScreenViewConfig) {
        try {
            this.bigScreenViewConfigDao.save(bigScreenViewConfig);
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
        return ResultBean.success("");
    }

    @Override
    public ResultBean<Object> findOne(String bigScreenViewConfigCode) {
        try {
            return ResultBean.success(this.bigScreenViewConfigDao.findOne(bigScreenViewConfigCode));
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> getQuerySceneByAppList(String appCode) throws Exception {
        try {
            ArrayList<String> strings = new ArrayList<String>();
            strings.add(appCode);
            List o = (List)this.screenService.postQuerySceneByApp(strings);
            ArrayList<ScreenInfo> syncDataVos = new ArrayList<ScreenInfo>();
            if (!CollectionUtils.isEmpty((Collection)o)) {
                for (ReportSceneDTO reportSceneDTO : o) {
                    ScreenInfo screenInfo = new ScreenInfo();
                    screenInfo.setCode(reportSceneDTO.getCode());
                    screenInfo.setSceneTitle(reportSceneDTO.getSceneTitle());
                    screenInfo.setDescription(reportSceneDTO.getDescription());
                    syncDataVos.add(screenInfo);
                }
            }
            return ResultBean.success(syncDataVos);
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }
}

