/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.synonym.controller.impl;

import com.digiwin.athena.knowledgegraph.synonym.controller.ISyncAppInfoService;
import com.digiwin.athena.knowledgegraph.synonym.dao.SyncAppInfoDao;
import com.digiwin.athena.knowledgegraph.synonym.domain.EntityTypeConfig;
import com.digiwin.athena.knowledgegraph.synonym.domain.LocalAppInfo;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.DeleteVo;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.ResultBean;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SyncAppInfoServiceImpl
implements ISyncAppInfoService {
    @Autowired
    private SyncAppInfoDao syncAppInfoDao;

    @Override
    public ResultBean<?> insertLocalAll(List<LocalAppInfo> localAppInfos) {
        if (localAppInfos == null || localAppInfos.isEmpty()) {
            return ResultBean.success(null);
        }
        this.syncAppInfoDao.insertLocalList(localAppInfos);
        return ResultBean.success(null);
    }

    @Override
    public ResultBean<Object> deleteLocal(DeleteVo deleteVo) {
        try {
            this.syncAppInfoDao.deleteLocal(deleteVo.getIds());
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
        return ResultBean.success(null);
    }

    @Override
    public ResultBean<Object> deleteEntityConfig(DeleteVo deleteVo) {
        try {
            this.syncAppInfoDao.deleteEntityConfig(deleteVo.getId(), deleteVo.getTid());
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
        return ResultBean.success(null);
    }

    @Override
    public ResultBean<Object> getFindLocalList(String tenantId) {
        return ResultBean.success(this.syncAppInfoDao.getLocalList(tenantId));
    }

    @Override
    public ResultBean<Object> getFindLocal(String id) {
        return ResultBean.success(this.syncAppInfoDao.find(id));
    }

    @Override
    public ResultBean<Object> getFindAll() {
        return ResultBean.success(this.syncAppInfoDao.getAll());
    }

    @Override
    public ResultBean<Object> getEntityConfigs(String appName, String appType) {
        return ResultBean.success(this.syncAppInfoDao.getEntityConfigs(appName, appType));
    }

    @Override
    public ResultBean<Object> updateLocal(LocalAppInfo localAppInfo) {
        this.syncAppInfoDao.updateLocal(localAppInfo);
        return ResultBean.success(null);
    }

    @Override
    public ResultBean<Object> updateEntityTypeConfig(EntityTypeConfig entityTypeConfig) {
        this.syncAppInfoDao.updateEntityTypeConfig(entityTypeConfig);
        return ResultBean.success(null);
    }

    @Override
    public ResultBean<?> saveEntityConfigAll(List<EntityTypeConfig> configs) {
        if (configs == null || configs.isEmpty()) {
            return ResultBean.success(null);
        }
        this.syncAppInfoDao.saveConfigsAll(configs);
        return ResultBean.success(null);
    }

    @Override
    public ResultBean<?> saveLocalAll(List<LocalAppInfo> localAppInfos) {
        if (localAppInfos == null || localAppInfos.isEmpty()) {
            return ResultBean.success(null);
        }
        this.syncAppInfoDao.saveAll(localAppInfos);
        return ResultBean.success(null);
    }
}

