/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.synonym.dao;

import com.digiwin.athena.knowledgegraph.synonym.domain.AppThresholdConfig;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class AppThresholdConfigDao {
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate systemMongoTemplate;

    public List<AppThresholdConfig> findList(String appCode, String tenantId) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        if (StringUtils.isNotBlank((CharSequence)appCode)) {
            criteria.and("appCode").is((Object)appCode);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, AppThresholdConfig.class);
    }

    public void deleteList(String tid, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)tid)) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").in(ids).andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tid)}));
        this.mongoTemplate.remove(query, AppThresholdConfig.class);
    }

    public void save(AppThresholdConfig appThresholdConfig) {
        this.mongoTemplate.save((Object)appThresholdConfig);
    }

    public void insertAll(List<AppThresholdConfig> appThresholdConfigs) {
        this.mongoTemplate.insertAll(appThresholdConfigs);
    }

    public void dataMigration() {
        long count = this.systemMongoTemplate.count(new Query(), AppThresholdConfig.class);
        if (count > 0L) {
            List appThresholdConfigs = this.systemMongoTemplate.find(new Query(), AppThresholdConfig.class);
            this.mongoTemplate.insertAll((Collection)appThresholdConfigs);
        }
    }
}

