/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.synonym.dao;

import com.digiwin.athena.knowledgegraph.synonym.domain.BigScreenViewConfig;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class BigScreenViewConfigDao {
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate systemMongoTemplate;

    public BigScreenViewConfig findOne(String code) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"bigScreenCode").is((Object)code)});
        query.addCriteria((CriteriaDefinition)criteria);
        return (BigScreenViewConfig)this.mongoTemplate.findOne(query, BigScreenViewConfig.class);
    }

    public List<BigScreenViewConfig> findList(String appCode, String tenantId) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("tenantId").is((Object)tenantId);
        if (StringUtils.isNotBlank((CharSequence)appCode)) {
            criteria.and("appCode").is((Object)appCode);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        List bigScreenViewConfigs = this.mongoTemplate.find(query, BigScreenViewConfig.class);
        return bigScreenViewConfigs;
    }

    public void deleteList(String tid, List<String> ids, String appCode) {
        if (StringUtils.isEmpty((CharSequence)tid)) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("tenantId").is((Object)tid);
        criteria.and("appCode").is((Object)appCode);
        criteria.and("type").ne((Object)"custom");
        if (!CollectionUtils.isEmpty(ids)) {
            criteria.and("bigScreenCode").in(ids);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(query, BigScreenViewConfig.class);
    }

    public void save(BigScreenViewConfig bigScreenViewConfig) {
        this.mongoTemplate.save((Object)bigScreenViewConfig);
    }

    public void insertAll(List<BigScreenViewConfig> bigScreenViewConfigs) {
        this.mongoTemplate.insertAll(bigScreenViewConfigs);
    }

    public void dataMigration() {
        List all = this.systemMongoTemplate.findAll(BigScreenViewConfig.class);
        this.mongoTemplate.insertAll((Collection)all);
    }
}

