/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.synonym.dao;

import com.digiwin.athena.knowledgegraph.synonym.domain.BusinessType;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.DeleteVo;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.PageVo;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class BusinessTypeDao {
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate systemMongoTemplate;
    private static final String APP_CODE = "appCode";
    private static final String TENANT_ID = "tenantId";

    public void batchInsert(List<BusinessType> businessTypes) {
        this.mongoTemplate.insertAll(businessTypes);
    }

    public void update(BusinessType businessType) {
        businessType.setEditTime(new Date());
        this.mongoTemplate.save((Object)businessType);
    }

    public void batchDelete(DeleteVo deleteVo) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and(TENANT_ID).is((Object)deleteVo.getTid());
        criteria.and(APP_CODE).is((Object)deleteVo.getAppCode());
        if (!CollectionUtils.isEmpty(deleteVo.getIds())) {
            criteria.and("id").in(deleteVo.getIds());
        }
        query.addCriteria((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(query, BusinessType.class);
    }

    public List<BusinessType> findList(String appCode, String tenantId) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)TENANT_ID).is((Object)tenantId)});
        criteria.and(APP_CODE).is((Object)appCode);
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, BusinessType.class);
    }

    public PageVo<BusinessType> getPage(String appCode, String tid, int pageNum, int pageSize) {
        if (StringUtils.isEmpty((CharSequence)tid)) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        --pageNum;
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and(TENANT_ID).is((Object)tid);
        criteria.and(APP_CODE).is((Object)appCode);
        query.addCriteria((CriteriaDefinition)criteria);
        PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"editTime"});
        long totalCount = this.mongoTemplate.count(query, BusinessType.class);
        List businessTypes = this.mongoTemplate.find(query.with((Pageable)pageable), BusinessType.class);
        int totalPage = (int)(totalCount % (long)pageSize == 0L ? totalCount / (long)pageSize : totalCount / (long)pageSize + 1L);
        return new PageVo<BusinessType>((int)totalCount, businessTypes, pageNum, pageSize, totalPage);
    }

    public List<BusinessType> querySystemBusinessTypeByVersion(String appCode, String tenantVersion) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"version").is((Object)tenantVersion)});
        criteria.and(APP_CODE).is((Object)appCode);
        query.addCriteria((CriteriaDefinition)criteria);
        return this.systemMongoTemplate.find(query, BusinessType.class);
    }

    public BusinessType querySystemBusinessType(String appCode, String code, String tenantVersion) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)APP_CODE).is((Object)appCode)});
        criteria.and("code").is((Object)code);
        criteria.and("version").is((Object)tenantVersion);
        query.addCriteria((CriteriaDefinition)criteria);
        return (BusinessType)this.systemMongoTemplate.findOne(query, BusinessType.class);
    }
}

