/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.synonym.dao;

import com.digiwin.athena.knowledgegraph.synonym.dao.SystemEntityType;
import com.digiwin.athena.knowledgegraph.synonym.domain.EntityType;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.PageVo;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class EntityTypeDao {
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate systemMongoTemplate;

    public void insert(EntityType entityType) {
        entityType.setCreateDate(new Date());
        this.mongoTemplate.insert((Object)entityType);
    }

    public void delete(String id, String tenantId) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"objectId").is((Object)id).andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)}));
        this.mongoTemplate.remove(query, EntityType.class);
    }

    public List<EntityType> findList(String tenantId) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, EntityType.class);
    }

    public PageVo<EntityType> getPage(String tid, int pageNum, int pageSize) {
        if (StringUtils.isEmpty((CharSequence)tid)) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tid)});
        query.addCriteria((CriteriaDefinition)criteria);
        PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize);
        long totalCount = this.mongoTemplate.count(query, EntityType.class);
        List entityTypes = this.mongoTemplate.find(query.with((Pageable)pageable), EntityType.class);
        int totalPage = (int)(totalCount % (long)pageSize == 0L ? totalCount / (long)pageSize : totalCount / (long)pageSize + 1L);
        return new PageVo<EntityType>((int)totalCount, entityTypes, pageNum, pageSize, totalPage);
    }

    public PageVo<SystemEntityType> getSystemPage(String entityTypeName, int pageNum, int pageSize) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (StringUtils.isNotEmpty((CharSequence)entityTypeName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"entityTypeName").is((Object)entityTypeName)});
            query.addCriteria((CriteriaDefinition)criteria);
        }
        long totalCount = this.systemMongoTemplate.count(query, SystemEntityType.class);
        PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize);
        List<Object> entityTypes = new ArrayList();
        entityTypes = pageSize == 0 && pageNum == 0 ? this.getAll() : this.systemMongoTemplate.find(query.with((Pageable)pageable), SystemEntityType.class);
        if (pageSize == 0) {
            throw new IllegalArgumentException("pageSize\u4e0d\u80fd\u4e3a0");
        }
        int totalPage = (int)(totalCount % (long)pageSize == 0L ? totalCount / (long)pageSize : totalCount / (long)pageSize + 1L);
        return new PageVo<SystemEntityType>((int)totalCount, entityTypes, pageNum, pageSize, totalPage);
    }

    public List<SystemEntityType> getAll() {
        return this.systemMongoTemplate.findAll(SystemEntityType.class);
    }

    public void deleteSysEntity(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"objectId").is((Object)id));
        this.systemMongoTemplate.remove(query, SystemEntityType.class);
    }

    public void saveAll(List<SystemEntityType> systemEntityTypes) {
        this.mongoTemplate.insertAll(systemEntityTypes);
    }

    public List<SystemEntityType> getSystemListByNames(List<String> nameList) {
        if (nameList == null || nameList.size() == 0) {
            return null;
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"entityTypeName").in(nameList)});
        query.addCriteria((CriteriaDefinition)criteria);
        return this.systemMongoTemplate.find(query, SystemEntityType.class);
    }

    public void deleteList(String tid, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)tid)) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"objectId").in(ids).andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tid)}));
        this.mongoTemplate.remove(query, EntityType.class);
    }

    public void dataMigration() {
        long count = this.systemMongoTemplate.count(new Query(), EntityType.class);
        if (count > 0L) {
            List appThresholdConfigs = this.systemMongoTemplate.find(new Query(), EntityType.class);
            this.mongoTemplate.insertAll((Collection)appThresholdConfigs);
        }
    }
}

