/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.synonym.dao;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.knowledgegraph.synonym.domain.Synonym;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.PageVo;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class SynonymDao {
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate systemMongoTemplate;

    public void insertOrUpdate(Synonym synonym) {
        if (synonym == null) {
            return;
        }
        synonym.setEditDate(new Date());
        this.mongoTemplate.save((Object)synonym);
    }

    public void saveAll(List<Synonym> synonyms) {
        if (CollectionUtils.isEmpty(synonyms)) {
            return;
        }
        List<String> collect = synonyms.stream().map(Synonym::getObjectId).collect(Collectors.toList());
        this.delete(collect);
        this.insertAll(synonyms);
    }

    public void insertAll(List<Synonym> synonyms) {
        this.mongoTemplate.insertAll(synonyms);
    }

    public PageVo findListPage(String tenantId, String properNoun, String entityTypeName, String des, int page, int pageSize) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        if (StringUtils.isNotEmpty((CharSequence)des)) {
            criteria.and("description").regex(des);
        }
        if (StringUtils.isNotEmpty((CharSequence)properNoun)) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"properNoun").regex(properNoun), Criteria.where((String)"zh_CN_Str").regex(properNoun), Criteria.where((String)"zh_TW_Str").regex(properNoun)});
        }
        if (StringUtils.isNotEmpty((CharSequence)entityTypeName)) {
            criteria.and("entityTypeName").regex(entityTypeName);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        PageRequest pageable = PageRequest.of((int)page, (int)pageSize);
        long totalCount = this.mongoTemplate.count(query, Synonym.class);
        List synonyms = this.mongoTemplate.find(query.with((Pageable)pageable), Synonym.class);
        int totalPage = (int)(totalCount % (long)pageSize == 0L ? totalCount / (long)pageSize : totalCount / (long)pageSize + 1L);
        return new PageVo((int)totalCount, synonyms, page, pageSize, totalPage);
    }

    public Map<String, Synonym> findMap(String tenantId, List<String> ids) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        if (!CollectionUtils.isEmpty(ids)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"_id").in(ids)});
        }
        query.addCriteria((CriteriaDefinition)criteria);
        List synonyms = this.mongoTemplate.find(query, Synonym.class);
        HashMap<String, Synonym> map = new HashMap<String, Synonym>();
        for (Synonym synonym : synonyms) {
            map.put(synonym.getObjectId(), synonym);
        }
        return map;
    }

    public List<Synonym> findList(String tenantId, String properNoun, String entityTypeName, String des) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        if (StringUtils.isNotEmpty((CharSequence)des)) {
            criteria.and("description").regex(des);
        }
        if (StringUtils.isNotEmpty((CharSequence)properNoun)) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"properNoun").regex(properNoun), Criteria.where((String)"zh_CN_Str").regex(properNoun), Criteria.where((String)"zh_TW_Str").regex(properNoun)});
        }
        if (StringUtils.isNotEmpty((CharSequence)entityTypeName)) {
            criteria.and("entityTypeName").regex(entityTypeName);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, Synonym.class);
    }

    public List<Synonym> findList(String tenantId, List<String> ids) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        if (!CollectionUtils.isEmpty(ids)) {
            criteria.and("_id").in(ids);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, Synonym.class);
    }

    public Synonym findOne(String tenantId, String properNoun) {
        if (StringUtils.isEmpty((CharSequence)tenantId) || StringUtils.isEmpty((CharSequence)properNoun)) {
            throw new BusinessException("\u79df\u6237id/\u4e13\u6709\u540d\u8bcd/\u5b9e\u4f53\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId), Criteria.where((String)"properNoun").is((Object)properNoun)});
        query.addCriteria((CriteriaDefinition)criteria);
        return (Synonym)this.mongoTemplate.findOne(query, Synonym.class);
    }

    public void delete(List<String> list, String tenantId) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"objectId").in(list).andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)}));
        this.mongoTemplate.remove(query, Synonym.class);
    }

    public void delete(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"objectId").in(list));
        this.mongoTemplate.remove(query, Synonym.class);
    }

    public Synonym getOne(String tenantId, String properNoun, String entityTypeName) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("tenantId").is((Object)tenantId).and("properNoun").is((Object)properNoun).and("entityTypeName").is((Object)entityTypeName);
        query.addCriteria((CriteriaDefinition)criteria);
        Synonym one = (Synonym)this.mongoTemplate.findOne(query, Synonym.class);
        return one;
    }

    public List<Synonym> getTwIsNotNullList() {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"zh_TW_Str").exists(true).ne((Object)""));
        return this.mongoTemplate.find(query, Synonym.class);
    }

    @Async
    public void dataMigration() {
        long count = this.systemMongoTemplate.count(new Query(), Synonym.class);
        if (count > 0L) {
            int totalPage = (int)(count / 1000L);
            for (int i = 0; i <= totalPage; ++i) {
                PageRequest pageable = PageRequest.of((int)i, (int)1000);
                List synonyms = this.systemMongoTemplate.find(new Query().with((Pageable)pageable), Synonym.class);
                if (CollectionUtils.isEmpty((Collection)synonyms)) continue;
                this.mongoTemplate.insertAll((Collection)synonyms);
            }
        }
    }

    public List<Synonym> findAll(int page, int pageSize) {
        PageRequest pageable = PageRequest.of((int)page, (int)pageSize);
        List synonyms = this.mongoTemplate.find(new Query().with((Pageable)pageable), Synonym.class);
        return synonyms;
    }

    public JSONObject groupByEntityCount(String tenantId) {
        JSONObject jsonObject = new JSONObject();
        MatchOperation matchOperation = Aggregation.match((Criteria)Criteria.where((String)"tenantId").is((Object)tenantId));
        GroupOperation groupOperation = Aggregation.group((String[])new String[]{"entityTypeName"}).count().as("count");
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{matchOperation, groupOperation});
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, "synonym", Map.class);
        List mappedResults = results.getMappedResults();
        if (CollectionUtils.isEmpty((Collection)mappedResults)) {
            return jsonObject;
        }
        for (Map mappedResult : mappedResults) {
            jsonObject.put(mappedResult.get("_id").toString(), mappedResult.get("count"));
        }
        return jsonObject;
    }
}

