/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.task;

import com.digiwin.athena.kg.activity.ActivityConfig;
import com.digiwin.athena.kmservice.utils.TranslateUtil;
import com.digiwin.athena.knowledgegraph.repoSystem.ActivityConfigRepository;
import com.digiwin.athena.knowledgegraph.task.model.ActivityConfigDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityConfigService {
    @Autowired
    ActivityConfigRepository activityConfigRepository;

    public ActivityConfigDTO getConfigByCode(String code) throws IllegalAccessException {
        ActivityConfig config = this.activityConfigRepository.findOneByCode(code);
        if (config == null) {
            return null;
        }
        ActivityConfigDTO configDTO = new ActivityConfigDTO();
        configDTO.setCode(config.getCode());
        configDTO.setMultipleSelect(config.getMultipleSelect());
        configDTO.setTitle(this.ProcessLanguage("title", config, config.getTitle()));
        configDTO.setSubTitle(this.ProcessLanguage("subTitle", config, config.getSubTitle()));
        configDTO.setDescription(this.ProcessLanguage("description", config, config.getDescription()));
        configDTO.setSubDescription(this.ProcessLanguage("subDescription", config, config.getSubDescription()));
        configDTO.setGetDataAction(this.ProcessMapLanguage(config.getGetDataAction()));
        configDTO.setRelationQueries(this.ProcessListLanguage(config.getRelationQueries()));
        configDTO.setSubmitActions(this.ProcessListLanguage(config.getSubmitActions()));
        configDTO.setSummaryFields(this.ProcessListLanguage(config.getSummaryFields()));
        configDTO.setFilters(this.ProcessListLanguage(config.getFilters()));
        configDTO.setOperations(this.ProcessListLanguage(config.getOperations()));
        configDTO.setGroupFields(this.ProcessListLanguage(config.getGroupFields()));
        configDTO.setGetTaskData(this.ProcessMapLanguage(config.getGetTaskData()));
        configDTO.setCheckItems(this.ProcessListLanguage(config.getCheckItems()));
        configDTO.setReason(this.ProcessMapLanguage(config.getReason()));
        configDTO.setGetFormulaAction(this.ProcessMapLanguage(config.getGetFormulaAction()));
        configDTO.setCountItems(this.ProcessMapLanguage(config.getCountItems()));
        return configDTO;
    }

    private Object ProcessLanguage(String key, ActivityConfig config, String defaultValue) {
        Map lang;
        if (config.getLanguage() != null && (lang = (Map)config.getLanguage().get(key)) != null) {
            lang.put("zh_CN", defaultValue);
            return lang;
        }
        return defaultValue;
    }

    private Map<String, Object> ProcessMapLanguage(Map<String, Object> data) {
        if (data == null || data.isEmpty()) {
            return data;
        }
        Map langMap = (Map)data.get("language");
        if (langMap != null) {
            for (Map.Entry<Object, Object> entry : langMap.entrySet()) {
                String key = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                if (key == null || key.isEmpty() || value == null || value.isEmpty()) continue;
                Object defValue = data.get(key);
                value.put("zh_CN", defValue);
                data.put(key, value);
            }
            data.remove("language");
        }
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                data.put((String)entry.getKey(), this.ProcessMapLanguage((Map)value));
                continue;
            }
            if (!(value instanceof List)) continue;
            data.put((String)entry.getKey(), this.ProcessListLanguage((List)value));
        }
        return data;
    }

    private List ProcessListLanguage(List data) {
        if (data == null || data.isEmpty()) {
            return data;
        }
        ArrayList<Map<String, Object>> re = new ArrayList<Map<String, Object>>(data.size());
        for (Object obj : data) {
            if (obj instanceof Map) {
                re.add(this.ProcessMapLanguage((Map)obj));
                continue;
            }
            re.add((Map<String, Object>)obj);
        }
        return re;
    }

    public ActivityConfigDTO getConfigByCodeLocale(String activityCode, String pageCode, String locale) {
        Map page;
        ActivityConfig config = this.activityConfigRepository.findOneByCode(activityCode);
        if (config == null) {
            return null;
        }
        ActivityConfigDTO configDTO = new ActivityConfigDTO();
        configDTO.setCode(config.getCode());
        configDTO.setDataSources(config.getDataSources());
        configDTO.setDataFilters(this.SetListLanguage(config.getDataFilters(), locale));
        configDTO.setApproves(config.getApproves());
        configDTO.setDataProcessors(this.SetListLanguage(config.getDataProcessors(), locale));
        configDTO.setMessages(config.getMessages());
        configDTO.setExpectedDuration(config.getExpectedDuration());
        configDTO.setAttachment(this.SetMapLanguage(config.getAttachment(), locale));
        configDTO.setActivityParameter(this.SetMapLanguage(config.getActivityParameter(), locale));
        TranslateUtil.dealLangRecusive(configDTO.getMessages(), (String)locale);
        if (config.getPages() != null && (page = (Map)config.getPages().get(pageCode)) != null) {
            configDTO.setPages(this.SetMapLanguage(page, locale));
        }
        return configDTO;
    }

    private Map<String, Object> SetMapLanguage(Map<String, Object> data, String locale) {
        if (data == null || data.isEmpty()) {
            return data;
        }
        Map langMap = (Map)data.get("language");
        if (langMap != null) {
            for (Map.Entry<Object, Object> entry : langMap.entrySet()) {
                String val;
                String key = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                if (key == null || key.isEmpty() || value == null || value.isEmpty() || (val = (String)value.get(locale)) == null || val.isEmpty()) continue;
                data.put(key, val);
            }
            data.remove("language");
        }
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                data.put((String)entry.getKey(), this.SetMapLanguage((Map)value, locale));
                continue;
            }
            if (!(value instanceof List)) continue;
            data.put((String)entry.getKey(), this.SetListLanguage((List)value, locale));
        }
        return data;
    }

    private List SetListLanguage(List data, String locale) {
        if (data == null || data.isEmpty()) {
            return data;
        }
        ArrayList<Map<String, Object>> re = new ArrayList<Map<String, Object>>(data.size());
        for (Object obj : data) {
            if (obj instanceof Map) {
                re.add(this.SetMapLanguage((Map)obj, locale));
                continue;
            }
            re.add((Map<String, Object>)obj);
        }
        return re;
    }
}

