/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.utils;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.service.DWServiceContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static Logger logger = LoggerFactory.getLogger(Utils.class);
    private static final String utf8 = "utf8";
    public static final String dateformat1 = "yyyy-MM-dd HH:mm:ss";
    public static final String base64ImgPrefix = "data:image/png;base64,";
    public static final BigDecimal yuanUnit = new BigDecimal(100);
    private static final String base64Key = "VHVvMTIzNDU2WXU3ODlMaUJhaVRpYW4=";
    private static AntPathMatcher antMatcher = new AntPathMatcher();
    public static HttpClient httpclient = null;
    public static RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).setMaxRedirects(50).build();
    @Autowired(required=false)
    @Qualifier(value="dwAttemptHttpLoadbalanceRoute")
    HttpRoutePlanner initHttpRoutePlanner;
    @Qualifier(value="dw-httpclient-request-retry-handler")
    HttpRequestRetryHandler initRequestRetryHandler;
    @Qualifier(value="dw-httpclient-response-retry-strategy")
    ServiceUnavailableRetryStrategy initServiceUnavailableRetryStrategy;
    static HttpRoutePlanner httpRoutePlanner;
    static HttpRequestRetryHandler requestRetryHandler;
    static ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy;

    @PostConstruct
    public void init() {
        httpRoutePlanner = this.initHttpRoutePlanner;
        requestRetryHandler = this.initRequestRetryHandler;
        serviceUnavailableRetryStrategy = this.initServiceUnavailableRetryStrategy;
    }

    public static HttpClient getHttpClient() {
        if (null == httpclient) {
            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("TLS");
                X509TrustManager tm = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                sslContext.init(null, new TrustManager[]{tm}, null);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            httpclient = HttpClients.custom().setMaxConnPerRoute(384).setMaxConnTotal(1024).setSSLContext(sslContext).setRoutePlanner(httpRoutePlanner).setRetryHandler(requestRetryHandler).setServiceUnavailableRetryStrategy(serviceUnavailableRetryStrategy).build();
        }
        return httpclient;
    }

    public static String getUrl(String url, Map<String, Object> params) {
        String result = url;
        if (null != params && !params.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("?");
            params.forEach((k, v) -> {
                try {
                    sb.append((String)k).append("=").append(URLEncoder.encode(v.toString(), "UTF-8")).append("&");
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            });
            result = url + sb.substring(0, sb.length() - 1).toString();
        }
        return result;
    }

    private static Header[] toHeader(Map<String, String> headers) {
        if (null != headers) {
            ArrayList hs = new ArrayList();
            headers.forEach((k, v) -> hs.add(new BasicHeader(k, v)));
            return hs.toArray(new Header[0]);
        }
        return null;
    }

    public static String get(String url, Map<String, String> headers, Map<String, Object> params) throws IOException {
        String result = null;
        HttpResponse response = Utils.get0(url, Utils.toHeader(headers), params);
        HttpEntity entity = response.getEntity();
        try {
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (logger.isInfoEnabled()) {
                logger.info("get result=" + result);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return result;
    }

    public static String get(String url, Header[] headers, Map<String, String> params) throws IOException {
        String result = null;
        HttpResponse response = Utils.get0(url, headers, params);
        HttpEntity entity = response.getEntity();
        try {
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (log.isInfoEnabled()) {
                log.info("get result=" + result);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return result;
    }

    public static <T> HttpResponse get0(String url, Header[] headers, Map<String, T> params) throws IOException {
        if (null != params && !params.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("?");
            params.forEach((k, v) -> {
                try {
                    String sv = v != null ? URLEncoder.encode(v.toString(), "UTF-8") : null;
                    sb.append((String)k).append("=");
                    if (null != sv) {
                        sb.append(sv);
                    }
                    sb.append("&");
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            });
            url = url + sb.substring(0, sb.length() - 1).toString();
        }
        HttpGet get = new HttpGet(url);
        get.setHeaders(headers);
        get.setConfig(requestConfig);
        HttpResponse response = null;
        if (logger.isInfoEnabled()) {
            logger.info("get url=" + url + ",headers=" + JSON.toJSONString((Object)headers) + ",params=" + params);
        }
        try {
            response = Utils.getHttpClient().execute((HttpUriRequest)get);
            return response;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static <T> T get(String url, Map<String, String> headers, Map<String, Object> params, Class<T> c) throws IOException {
        Object result = null;
        try {
            result = JSON.parseObject((String)Utils.get(url, headers, params), c);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return (T)result;
    }

    public static String postJson(String url, Map<String, String> headers, Map<String, Object> params) throws IOException {
        String result = null;
        HttpPost httppost = new HttpPost(url);
        httppost.setConfig(requestConfig);
        httppost.setHeaders(Utils.toHeader(headers));
        String jsonbody = JSON.toJSONString(params);
        StringEntity myEntity = new StringEntity(jsonbody, ContentType.APPLICATION_JSON);
        httppost.setEntity((HttpEntity)myEntity);
        HttpResponse response = null;
        if (logger.isInfoEnabled()) {
            logger.info("post to:" + url + ",and request body=" + jsonbody);
        }
        try {
            response = Utils.getHttpClient().execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
        if (logger.isInfoEnabled()) {
            logger.info("response from :" + url + ",response body=" + result);
        }
        return result;
    }

    public static String postJson(String url, Header[] headers, String jsonbody) {
        String result = null;
        HttpPost httppost = new HttpPost(url);
        httppost.setConfig(requestConfig);
        httppost.setHeaders(headers);
        StringEntity myEntity = new StringEntity(jsonbody, ContentType.APPLICATION_JSON);
        httppost.setEntity((HttpEntity)myEntity);
        HttpResponse response = null;
        if (logger.isInfoEnabled()) {
            logger.info("post to:" + url + ",and request body=" + jsonbody);
        }
        try {
            response = Utils.getHttpClient().execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException var11) {
            logger.error(var11.getMessage(), (Throwable)var11);
            throw new RuntimeException(var11);
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
        if (logger.isInfoEnabled()) {
            logger.info("response from :" + url + ",response body=" + result);
        }
        return result;
    }

    public static <T> T postJson(String url, Map<String, String> headers, Map<String, Object> params, Class<T> c) throws IOException {
        Object result = null;
        result = JSON.parseObject((String)Utils.postJson(url, headers, params), c);
        return (T)result;
    }

    public static HttpResponse postForm0(String url, Header[] headers, Map<String, Object> params) throws IOException {
        HttpPost httppost = new HttpPost(url);
        httppost.setConfig(requestConfig);
        httppost.setHeaders(headers);
        HttpResponse response = null;
        if (logger.isInfoEnabled()) {
            logger.info("post to:" + url + ",and request body=" + params);
        }
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (String name : params.keySet()) {
            String value = String.valueOf(params.get(name));
            nvps.add(new BasicNameValuePair(name, value));
        }
        httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, utf8));
        response = Utils.getHttpClient().execute((HttpUriRequest)httppost);
        if (logger.isInfoEnabled()) {
            logger.info("response from :" + url + ",response =" + response);
        }
        return response;
    }

    public static String postForm(String url, Header[] headers, Map<String, Object> params) throws IOException {
        String result = null;
        HttpResponse response = Utils.postForm0(url, headers, params);
        if (null == response) {
            return null;
        }
        try {
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
        if (logger.isInfoEnabled()) {
            logger.info("response from :" + url + ",response body=" + result);
        }
        return result;
    }

    public static <T> T postForm(String url, Header[] headers, Map<String, Object> params, Class<T> c) throws IOException {
        Object result = JSON.parseObject((String)Utils.postForm(url, headers, params), c);
        return (T)result;
    }

    public static boolean antMatch(String pattern, String path) {
        if (null == pattern || null == path) {
            return false;
        }
        return antMatcher.match(pattern, path);
    }

    public static String formatCurrency(long fen) {
        String yuan = null;
        BigDecimal bfen = new BigDecimal(fen);
        BigDecimal byuan = bfen.divide(yuanUnit);
        yuan = byuan.toString();
        return yuan;
    }

    public static void clearEmptyKey(Map<String, Object> map) {
        HashSet keys = new HashSet();
        if (null != map) {
            map.forEach((key, value) -> {
                if (null == value || value.toString().trim().equals("")) {
                    keys.add(key);
                }
                if (value instanceof ArrayList && ((ArrayList)value).isEmpty()) {
                    keys.add(key);
                }
            });
            for (String key2 : keys) {
                map.remove(key2);
            }
        }
    }

    public static boolean isPrimitive(Class<?> c) {
        return c != null && (c.isPrimitive() || c.equals(String.class) || Number.class.isAssignableFrom(c) || Boolean.class.equals(c) || Character.class.isAssignableFrom(c) || java.util.Date.class.equals(c) || Date.class.equals(c));
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static boolean isExcel2007(String filePath) {
        return filePath.matches("^.+\\.(?i)(xlsx)$");
    }

    public static boolean isExcel2003(String filePath) {
        return filePath.matches("^.+\\.(?i)(xls)$");
    }

    public static String join(List<?> list, String sep) {
        if (null == sep) {
            sep = ",";
        }
        if (null != list && list.size() > 0) {
            StringBuilder sb = new StringBuilder();
            int len = list.size();
            int last = len - 1;
            for (int i = 0; i < len; ++i) {
                sb.append(list.get(i));
                if (i >= last) continue;
                sb.append(sep);
            }
            return sb.toString();
        }
        return null;
    }

    public static Map<String, Object> objectToMap(Object obj) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)obj), Map.class);
        return map;
    }

    public static <T> T mapToObject(Map<String, Object> map, Class<T> c) {
        Object t = JSON.parseObject((String)JSON.toJSONString(map), c);
        return (T)t;
    }

    public static String base64img(byte[] bytes) {
        if (null != bytes && bytes.length > 0) {
            return base64ImgPrefix + Base64.encodeBase64String((byte[])bytes);
        }
        return null;
    }

    public static String signatureWeiXin(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            keys.add(entry.getKey());
        }
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        StringBuilder contents = new StringBuilder();
        int len = keys.size();
        for (int i = 0; i < len; ++i) {
            String key = (String)keys.get(i);
            contents.append(key).append("=").append(params.get(key));
            if (i >= len - 1) continue;
            contents.append("&");
        }
        System.out.println(contents.toString());
        String sign = Utils.sha1Encrypt(contents.toString());
        return sign;
    }

    public static String sha1Encrypt(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("SHA1");
            mdTemp.update(str.getBytes("UTF-8"));
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] buf = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                buf[k++] = hexDigits[byte0 >>> 4 & 0xF];
                buf[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(buf);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static Update toUpdate(Object obj) {
        try {
            Map<String, Object> map = Utils.toMap(obj);
            Update update = Update.fromDocument((Document)new Document(map), (String[])new String[0]);
            return update;
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> toMap(Object obj) throws IllegalAccessException {
        if (null == obj) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Field> fieldList = Utils.getFields(obj.getClass());
        for (Field f : fieldList) {
            f.setAccessible(true);
            Object value = f.get(obj);
            map.put(f.getName(), value);
        }
        return map;
    }

    public static List<Field> getFields(Class<?> clazz) {
        Class<?> c = clazz;
        ArrayList<Field> fields = new ArrayList<Field>();
        do {
            Field[] fs;
            for (Field f : fs = c.getDeclaredFields()) {
                int mod = f.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod) || Utils.isContain(fields, f)) continue;
                fields.add(f);
            }
        } while ((c = c.getSuperclass()) != null);
        return fields;
    }

    public static boolean isContain(List<Field> fieldList, Field field) {
        for (Field temp : fieldList) {
            if (!temp.getName().equals(field.getName())) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> requiredMapHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String routerKey = request.getHeader("routerKey");
            String token = request.getHeader("token");
            String locale = request.getHeader("locale");
            if (null == token) {
                token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
                routerKey = (String)DWServiceContext.getContext().getRequestHeader().get("routerKey");
                locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
            }
            if (null == token) {
                token = DWServiceContext.getContext().getToken();
            }
            if (null != routerKey) {
                headers.put("routerKey", routerKey);
            }
            if (null != token) {
                headers.put("token", token);
            }
            if (null != locale) {
                headers.put("locale", locale);
            }
        }
        catch (Exception e) {
            log.error("requiredHeaders error,{}", (Object)e.toString());
        }
        return headers;
    }

    public static Header[] requiredHeaders() {
        return Utils.toHeader(Utils.requiredMapHeaders());
    }

    public static void requiredHeaders(HttpHeaders headers) {
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String routerKey = request.getHeader("routerKey");
            String token = request.getHeader("token");
            String locale = request.getHeader("locale");
            String securityToken = request.getHeader("security-token");
            if (null == token) {
                token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
                routerKey = (String)DWServiceContext.getContext().getRequestHeader().get("routerKey");
                locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
            }
            if (null == token) {
                token = DWServiceContext.getContext().getToken();
            }
            if (null == securityToken) {
                securityToken = (String)DWServiceContext.getContext().getRequestHeader().get("security-token");
            }
            if (null != routerKey) {
                headers.set("routerKey", routerKey);
            }
            if (null != token) {
                headers.set("token", token);
                headers.set("digi-middleware-auth-user", token);
            }
            if (null != locale) {
                headers.set("locale", locale);
            }
            if (null != securityToken) {
                headers.set("security-token", securityToken);
            }
        }
        catch (Exception e) {
            log.error("requiredHeaders error,{}", (Object)e.toString());
        }
    }

    public static <T> List<List<T>> spliceArrays(List<T> datas, int splitSize) {
        if (datas == null || splitSize < 1) {
            return null;
        }
        int totalSize = datas.size();
        int count = totalSize % splitSize == 0 ? totalSize / splitSize : totalSize / splitSize + 1;
        ArrayList<List<T>> rows = new ArrayList<List<T>>(splitSize);
        for (int i = 0; i < count; ++i) {
            List<T> cols = datas.subList(i * splitSize, i == count - 1 ? totalSize : splitSize * (i + 1));
            rows.add(cols);
        }
        return rows;
    }

    public static void main(String[] args) throws IllegalAccessException {
    }
}

