/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.knowledgegraph.domain.TenantABIReportDAO;
import java.util.List;
import java.util.Map;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;

public interface Activity2Repository
extends Neo4jRepository<Activity, Long> {
    @Query(value="match(t:Task)-[:Contains]->(a:Activity) where t.code=$0 and a.code=$1 and (a.tenantId in ['SYSTEM',$2] or a.tenantId is null or $2 in a.inclusionTenant) return a")
    public List<Activity> getActivityDefinition(String var1, String var2, String var3);

    @Query(value="match (a:Activity{code:$1,version:$2}) where (a.tenantId in ['SYSTEM',$0] or a.tenantId is null or $0 in a.inclusionTenant) return a")
    public List<Activity> getActivityByCode(String var1, String var2, String var3);

    @Query(value="MATCH (activity:Activity) where activity.code = $0 and activity.version = $1 and (activity.tenantId in ['SYSTEM',$2] or activity.tenantId is null or $2 in activity.inclusionTenant)return activity")
    public List<Activity> getActivityByCodeAndVersion(String var1, String var2, String var3);

    @Query(value="match (a:Activity{pattern:$1,version:$2}) where a.tenantId in ['SYSTEM',$0] or a.tenantId is null or $0 in a.inclusionTenant  return a")
    public List<Activity> getActivitiesByPattern(String var1, String var2, String var3);

    @Query(value="match (a:Activity{pattern:$1,version:$2}) where (a.tenantId in ['SYSTEM',$0] or a.tenantId is null or $0 in a.inclusionTenant) and a.code in $3  return a")
    public List<Activity> getActivitiesByPattern(String var1, String var2, String var3, List<String> var4);

    @Query(value="match (a:Activity{nameSpace:'common'}) where a.tenantId in ['SYSTEM',$0] or a.tenantId is null or $0 in a.inclusionTenantreturn a")
    public List<Activity> getCommonBaseData(String var1);

    @Query(value="match (a:Activity{version:$2}) where a.code in $0  and (a.tenantId in ['SYSTEM',$1] or a.tenantId is null or $1 in a.inclusionTenant) return a")
    public List<Activity> getReportActivitiesByCode(List<String> var1, String var2, String var3);

    @Query(value="match (a:Activity{code:$0,version:$2}) where (a.tenantId in ['SYSTEM',$1] or a.tenantId is null or $1 in a.inclusionTenant) return a")
    public List<Activity> getReportActivitiesByCode(String var1, String var2, String var3);

    @Query(value="match(task:Task{version:$2})-[:Contains]->(a:Activity{code:$1}) where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null or $1 in task.inclusionTenant) return a")
    public List<Activity> findActivity(String var1, String var2, String var3);

    @Query(value="MATCH (n:Activity) where  ((n.pattern <> 'DATA_ENTRY' and n.pattern <>'STATEMENT') OR n.pattern IS NULL) and  n.code = $0  RETURN n")
    public Activity findActivityNoTenantId(String var1);

    @Query(value="match (a:Activity{version:$2}) where a.code in $1 and (a.tenantId in ['SYSTEM',$0] or a.tenantId is null or $0 in a.inclusionTenant) return a")
    public List<Activity> getActivitiesByCode(String var1, List<String> var2, String var3);

    @Query(value="match (n:Activity{version:$2}) where n.pattern = \"DATA_ENTRY\" and (n.name =~$0 or n.`lang.name.zh_TW` =~$0 or n.`lang.name.en_US` =~ $0 or n.`lang.name.zh_CN` =~ $0) and (n.tenantId in ['SYSTEM',$1] or n.tenantId is null or $1 in n.inclusionTenant) return n")
    public List<Activity> getDataEntryByName(String var1, String var2, String var3);

    @Query(value="match(n:Activity{version:$2}) where  n.pattern = \"DATA_ENTRY\" and (n.name =~$0 or n.`lang.name.zh_TW` =~$0 or n.`lang.name.en_US` =~ $0 or n.`lang.name.zh_CN` =~ $0) and (n.tenantId in ['SYSTEM',$1] or n.tenantId is null or $1 in n.inclusionTenant) return n")
    public List<Activity> getCommonDataEntryByName(String var1, String var2, String var3);

    @Query(value="match (n:Activity)  where n.pattern = \"DATA_ENTRY\" and n.nameSpace = $0 return n")
    public List<Activity> getDataEntryByNameSpace(String var1);

    @Query(value="match (n:Activity{version:$2}) where n.pattern = \"STATEMENT\" and (n.name =~$0 or n.`lang.name.zh_TW` =~$0 or n.`lang.name.en_US` =~ $0 or n.`lang.name.zh_CN` =~ $0) and (n.tenantId in ['SYSTEM',$1] or n.tenantId is null or $1 in n.inclusionTenant) return n")
    public List<Activity> getStatementsByName(String var1, String var2, String var3);

    @Query(value="match (n:Activity{version:$2}) where  n.pattern = \"STATEMENT\" and (n.name =~$0 or n.`lang.name.zh_TW` =~$0 or n.`lang.name.en_US` =~ $0 or n.`lang.name.zh_CN` =~ $0) and (n.tenantId in ['SYSTEM',$1] or n.tenantId is null or $1 in n.inclusionTenant) return n")
    public List<Activity> getCommonStatementsByName(String var1, String var2, String var3);

    @Query(value="match (t:Activity) return distinct t.code as code, t.name as name , t.nameSpace as nameSpace")
    public List<Map> getAllActivity();

    public Activity findOneByCode(String var1);

    @Query(value="match (t:TenantEntity)-[]->(a:Activity) where a.category = \"ABI-STATEMENT\" return t.tenantId as tenantId, t.tenantName as tenantName, a.code as code,a.nameSpace as namespace,a.athena_namespace as athenaNamespace")
    public List<TenantABIReportDAO> getAllABiReport();

    @Query(value="match(a:Activity) where a.category = 'ABI-STATEMENT' return distinct  a.code as code")
    public List<String> getAllABiReportCodes();
}

