/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.domain.component.bo.ComponentBaseInfoBO;
import com.digiwin.athena.domain.component.bo.ComponentStructuredListType;
import com.digiwin.athena.domain.component.bo.StructuredComponentBO;
import com.digiwin.athena.domain.component.bo.TenantAppComponentListBO;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.knowledgegraph.domain.ComponentStructuredList;
import com.digiwin.athena.knowledgegraph.domain.TenantEntity;
import com.digiwin.athena.knowledgegraph.domain.mechanism.MechanismTenantParadigm;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.AppService;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.support.SignOffAppHolder;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ComponentInitManager {
    private static final Logger log = LoggerFactory.getLogger(ComponentInitManager.class);
    @Autowired
    SessionFactory neo4jSessionFactory;
    @Autowired
    private DataMapService dataMapService;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplateSystem;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    TenantService tenantService;
    @Autowired
    IamService iamService;
    @Autowired
    ComponentManager componentManager;
    @Autowired
    AppService appService;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    DataPickService dataPickService;
    @Autowired
    @Qualifier(value="baseExecutor")
    ThreadPoolTaskExecutor executor;

    public List<ComponentBO> getAllComponentListByApplication(String appNameSpace, String appCode, String version, String tenantId) throws DWBusinessException {
        ArrayList<ComponentBO> result = new ArrayList<ComponentBO>();
        List<ComponentBO> monitorRuleComponent = this.getComponentList(Collections.singletonList(appCode), version, tenantId, ComponentTypeEnum.MonitorRule);
        List<ComponentBO> mechanismVariableComponent = this.getComponentList(Collections.singletonList(appCode), version, tenantId, ComponentTypeEnum.MechanismVariable);
        List<ComponentBO> projectComponent = this.getComponentList(Collections.singletonList(appCode), version, tenantId, ComponentTypeEnum.Project);
        List<ComponentBO> taskComponent = this.getComponentList(Collections.singletonList(appCode), version, tenantId, ComponentTypeEnum.Task);
        List<ComponentBO> baseDataEntryComponent = this.getComponentList(Collections.singletonList(appCode), version, tenantId, ComponentTypeEnum.BaseDataEntry);
        List<ComponentBO> reportComponent = this.getComponentList(Collections.singletonList(appCode), version, tenantId, ComponentTypeEnum.Report);
        List<ComponentBO> serviceCompositionComponent = this.getServiceCompositionComponent(appNameSpace, appCode, version, null);
        result.addAll(monitorRuleComponent);
        result.addAll(mechanismVariableComponent);
        result.addAll(projectComponent);
        result.addAll(taskComponent);
        result.addAll(baseDataEntryComponent);
        result.addAll(reportComponent);
        result.addAll(serviceCompositionComponent);
        return result;
    }

    public List<ComponentBO> getComponentList(List<String> appCodes, String version, String tenantId, ComponentTypeEnum typeEnum) throws DWBusinessException {
        ArrayList<ComponentBO> result = new ArrayList<ComponentBO>();
        HashSet<String> existsCodes = new HashSet<String>();
        String type = null;
        String subType = null;
        switch (typeEnum) {
            case MonitorRule: {
                type = "monitorRule";
                break;
            }
            case MechanismVariable: {
                type = "variable";
                break;
            }
            case Project: {
                type = "task";
                break;
            }
            case Task: {
                type = "activity";
                subType = "activity";
                break;
            }
            case BaseDataEntry: {
                type = "activity";
                subType = "base_entry";
                break;
            }
            case Report: {
                type = "activity";
                subType = "statement";
                break;
            }
            case ServiceComposition: {
                type = "serviceComposition";
                break;
            }
            default: {
                throw new DWBusinessException("Unexpected value: " + typeEnum);
            }
        }
        List<ApplicationRelation> monitorRules = this.dataPickService.applicationRelations(appCodes, type, subType, tenantId, version);
        for (ApplicationRelation applicationRelation : monitorRules) {
            if (existsCodes.contains(applicationRelation.getCode())) continue;
            existsCodes.add(applicationRelation.getCode());
            StructuredComponentBO componentBO = new StructuredComponentBO();
            componentBO.setCode(applicationRelation.getCode());
            componentBO.setType(typeEnum);
            componentBO.setName(applicationRelation.getName());
            componentBO.setVersion(applicationRelation.getVersion());
            result.add((ComponentBO)componentBO);
        }
        return result;
    }

    public List<ComponentBO> getCommonComponentList(String version, String tenantId, ComponentTypeEnum typeEnum) throws DWBusinessException {
        List<String> commonAppCodes = this.dataPickService.commonAppCodes(version);
        return this.getComponentList(commonAppCodes, version, tenantId, typeEnum);
    }

    public void initializeApplicationComponentList(String appCode, String paradigm, String version) throws DWBusinessException {
        List<ComponentBO> result = this.getAllComponentListByApplication(appCode, appCode, version, null);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"type").is((Object)"BaseFunction").and("appCode").is((Object)appCode).and("paradigm").is((Object)paradigm).and("version").is((Object)version).and("structureVersion").is((Object)"1.0");
        ComponentStructuredList componentStructuredList = this.dataPickService.findOneByCondition(criteria, ComponentStructuredList.class, "componentStructuredList");
        criteria.and("tenantId").is((Object)componentStructuredList.getTenantId());
        if (componentStructuredList.getSourceLevel() != null) {
            criteria.and("sourceLevel").is((Object)componentStructuredList.getSourceLevel());
        }
        query.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("components", result);
        this.mongoTemplateSystem.upsert(query, update, "componentStructuredList");
    }

    public List<ComponentBO> getMechanismVariableComponent(String appNameSpace, String appCode, String version, String tenantId) {
        ArrayList<ComponentBO> result = new ArrayList<ComponentBO>();
        HashSet<String> existsCodes = new HashSet<String>();
        Session session = this.neo4jSessionFactory.openSession();
        Result query = null;
        query = StringUtils.isEmpty((CharSequence)tenantId) ? session.query("match(n:GetMechanismVariableAction)-[:Creates]->(m:DataField) where n.version = '" + version + "' and (n.nameSpace='" + appNameSpace + "' or n.athena_namespace = '" + appCode + "') return distinct m.name as code", new HashMap()) : session.query("match (n:GetMechanismVariableAction)-[:Creates]->(m:DataField) where n.version = '" + version + "' and (n.tenantId is null or  n.tenantId in ['SYSTEM','" + tenantId + "']) and (n.nameSpace='" + appNameSpace + "' or n.athena_namespace = '" + appCode + "') return distinct m.name as code", new HashMap());
        for (Map next : query) {
            if (existsCodes.contains(String.valueOf(next.get("code")))) continue;
            existsCodes.add(String.valueOf(next.get("code")));
            StructuredComponentBO componentBO = new StructuredComponentBO();
            componentBO.setCode(String.valueOf(next.get("code")));
            componentBO.setType(ComponentTypeEnum.MechanismVariable);
            componentBO.setVersion("1.0");
            result.add((ComponentBO)componentBO);
        }
        return result;
    }

    public List<ComponentBO> getCommonMechanismVariableComponent(String version) {
        ArrayList<ComponentBO> result = new ArrayList<ComponentBO>();
        HashSet<String> existsCodes = new HashSet<String>();
        Session session = this.neo4jSessionFactory.openSession();
        Result query = session.query("match (n:GetMechanismVariableAction{commonApp:true})-[:Creates]->(m:DataField) where n.version ='" + version + "'  return distinct m.name as code", new HashMap());
        for (Map next : query) {
            if (existsCodes.contains(String.valueOf(next.get("code")))) continue;
            existsCodes.add(String.valueOf(next.get("code")));
            StructuredComponentBO componentBO = new StructuredComponentBO();
            componentBO.setCode(String.valueOf(next.get("code")));
            componentBO.setType(ComponentTypeEnum.MechanismVariable);
            componentBO.setVersion("1.0");
            result.add((ComponentBO)componentBO);
        }
        return result;
    }

    public static void main(String[] args) {
        String version = "1.0";
        String tenantId = "tenantId";
        String appNameSpace = "appNameSpace1";
        String appCode = "appCode1";
        String str = "(monitorRule2:MonitorRule) where monitorRule2.version = '" + version + "'   and (monitorRule2.tenantId is null or monitorRule2.tenantId in ['SYSTEM','" + tenantId + "'] ) and (monitorRule2.nameSpace='" + appNameSpace + "' or monitorRule2.relation_namespace='" + appNameSpace + "' or monitorRule2.athena_namespace = '" + appCode + "') return distinct monitorRule2.code as code, monitorRule2.name as name, monitorRule2.version as version";
        System.out.println(str);
    }

    public List<ComponentBO> getMonitorRuleComponent(String appNameSpace, String appCode, String version, String tenantId) {
        ArrayList<ComponentBO> result = new ArrayList<ComponentBO>();
        HashSet<String> existsCodes = new HashSet<String>();
        Session session = this.neo4jSessionFactory.openSession();
        Result query = null;
        query = StringUtils.isEmpty((CharSequence)tenantId) ? session.query("match(monitorRule2:MonitorRule) where monitorRule2.version = '" + version + "' and (monitorRule2.nameSpace='" + appNameSpace + "' or monitorRule2.relation_namespace='" + appNameSpace + "' or monitorRule2.athena_namespace = '" + appCode + "') return distinct monitorRule2.code as code, monitorRule2.name as name, monitorRule2.version as version", new HashMap()) : session.query("match(monitorRule2:MonitorRule) where monitorRule2.version = '" + version + "'   and (monitorRule2.tenantId is null or monitorRule2.tenantId in ['SYSTEM','" + tenantId + "'] ) and (monitorRule2.nameSpace='" + appNameSpace + "' or monitorRule2.relation_namespace='" + appNameSpace + "' or monitorRule2.athena_namespace = '" + appCode + "') return distinct monitorRule2.code as code, monitorRule2.name as name, monitorRule2.version as version", new HashMap());
        for (Map next : query) {
            if (existsCodes.contains(String.valueOf(next.get("code")))) continue;
            existsCodes.add(String.valueOf(next.get("code")));
            StructuredComponentBO componentBO = new StructuredComponentBO();
            componentBO.setCode(String.valueOf(next.get("code")));
            componentBO.setType(ComponentTypeEnum.MonitorRule);
            componentBO.setName(String.valueOf(next.get("name")));
            componentBO.setVersion(String.valueOf(next.get("version")));
            result.add((ComponentBO)componentBO);
        }
        return result;
    }

    public List<ComponentBO> getCommonMonitorRuleComponent(String version) {
        ArrayList<ComponentBO> result = new ArrayList<ComponentBO>();
        HashSet<String> existsCodes = new HashSet<String>();
        Session session = this.neo4jSessionFactory.openSession();
        Result query = session.query("match(monitorRule2:MonitorRule{commonApp:true}) where monitorRule2.version = '" + version + "'  return distinct monitorRule2.code as code, monitorRule2.name as name, monitorRule2.version as version", new HashMap());
        for (Map next : query) {
            if (existsCodes.contains(String.valueOf(next.get("code")))) continue;
            existsCodes.add(String.valueOf(next.get("code")));
            StructuredComponentBO componentBO = new StructuredComponentBO();
            componentBO.setCode(String.valueOf(next.get("code")));
            componentBO.setType(ComponentTypeEnum.MonitorRule);
            componentBO.setName(String.valueOf(next.get("name")));
            componentBO.setVersion(String.valueOf(next.get("version")));
            result.add((ComponentBO)componentBO);
        }
        return result;
    }

    public List<ComponentBO> getProjectComponent(String appNameSpace, String appCode, String version, String tenantId) {
        ArrayList<ComponentBO> result = new ArrayList<ComponentBO>();
        HashSet<String> existsCodes = new HashSet<String>();
        Session session = this.neo4jSessionFactory.openSession();
        Result query1 = null;
        query1 = StringUtils.isEmpty((CharSequence)tenantId) ? session.query("match(task2:Task) where task2.version = '" + version + "' and (task2.nameSpace = '" + appNameSpace + "' or task2.athena_namespace = '" + appCode + "' or task2.relation_namespace = '" + appNameSpace + "') return distinct task2.code as code, task2.name as name, task2.`lang.name.en_US` as name_us, task2.`lang.name.zh_CN` as name_cn, task2.`lang.name.zh_TW` as name_tw, task2.version as version", new HashMap()) : session.query("match(task2:Task) where task2.version ='" + version + "' and  (task2.tenantId is null or task2.tenantId in ['SYSTEM','" + tenantId + "']) and (task2.nameSpace = '" + appNameSpace + "' or task2.athena_namespace = '" + appCode + "' or task2.relation_namespace = '" + appNameSpace + "') return distinct task2.code as code, task2.name as name, task2.`lang.name.en_US` as name_us, task2.`lang.name.zh_CN` as name_cn, task2.`lang.name.zh_TW` as name_tw, task2.version as version", new HashMap());
        for (Map next : query1) {
            if (existsCodes.contains(String.valueOf(next.get("code")))) continue;
            existsCodes.add(String.valueOf(next.get("code")));
            StructuredComponentBO componentBO = new StructuredComponentBO();
            componentBO.setCode(String.valueOf(next.get("code")));
            componentBO.setType(ComponentTypeEnum.Project);
            componentBO.setName(String.valueOf(next.get("name")));
            componentBO.setVersion(String.valueOf(next.get("version")));
            HashMap lang = new HashMap();
            HashMap<String, String> nameLang = new HashMap<String, String>();
            if (!ObjectUtils.isEmpty(next.get("name_cn"))) {
                nameLang.put("zh_CN", String.valueOf(next.get("name_cn")));
            }
            if (!ObjectUtils.isEmpty(next.get("name_tw"))) {
                nameLang.put("zh_TW", String.valueOf(next.get("name_tw")));
            }
            if (!ObjectUtils.isEmpty(next.get("name_us"))) {
                nameLang.put("en_US", String.valueOf(next.get("name_us")));
            }
            if (!nameLang.isEmpty()) {
                lang.put("name", nameLang);
                componentBO.setLang(lang);
            }
            result.add((ComponentBO)componentBO);
        }
        try {
            List<ApplicationRelation> taskList = this.appService.getApplicationRelationByTypeAndAppCodeAndVersion("task", appCode, version);
            if (CollectionUtils.isNotEmpty(taskList)) {
                if (Boolean.TRUE.equals(SignOffAppHolder.getSignOffAppFlag())) {
                    this.handleComponentForSignOffApp(result, taskList, existsCodes, ComponentTypeEnum.Project);
                } else {
                    List<String> collect = taskList.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
                    Object projectObj = this.dataMapService.queryBatchCodeAndName(collect, "project", version);
                    if (!ObjectUtils.isEmpty((Object)projectObj)) {
                        JSONObject jsonObject1 = JSON.parseObject((String)JSON.toJSONString((Object)projectObj));
                        JSONArray projects = jsonObject1.getJSONArray("datas");
                        for (Object obj : projects) {
                            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(obj));
                            if (existsCodes.contains(String.valueOf(jsonObject.get((Object)"code")))) continue;
                            existsCodes.add(String.valueOf(jsonObject.get((Object)"code")));
                            StructuredComponentBO componentBO = new StructuredComponentBO();
                            componentBO.setCode(String.valueOf(jsonObject.get((Object)"code")));
                            componentBO.setType(ComponentTypeEnum.Project);
                            componentBO.setName(String.valueOf(jsonObject.get((Object)"name")));
                            componentBO.setVersion(String.valueOf(jsonObject.get((Object)"version")));
                            JSONObject lang = jsonObject.getJSONObject("lang");
                            if (!ObjectUtils.isEmpty((Object)lang) && lang.containsKey((Object)"name")) {
                                HashMap<String, JSONObject> lang2 = new HashMap<String, JSONObject>();
                                JSONObject name = lang.getJSONObject("name");
                                lang2.put("name", name);
                                componentBO.setLang(lang2);
                            }
                            result.add((ComponentBO)componentBO);
                        }
                    }
                }
                List leftCodes = taskList.stream().filter(e -> !existsCodes.contains(e.getCode())).map(BaseEntity::getCode).distinct().collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(leftCodes)) {
                    String leftCodesStr = "['" + StringUtils.join(leftCodes, (String)"','") + "']";
                    query1 = StringUtils.isEmpty((CharSequence)tenantId) ? session.query("match(task2:Task) where task2.version = '" + version + "' and task2.code in " + leftCodesStr + " return distinct task2.code as code, task2.name as name, task2.`lang.name.en_US` as name_us, task2.`lang.name.zh_CN` as name_cn, task2.`lang.name.zh_TW` as name_tw, task2.version as version", new HashMap()) : session.query("match (task2:Task) where task2.version ='" + version + "' and (task2.tenantId is null or task2.tenantId in ['SYSTEM','" + tenantId + "']) and task2.code in " + leftCodesStr + " return distinct task2.code as code, task2.name as name, task2.`lang.name.en_US` as name_us, task2.`lang.name.zh_CN` as name_cn, task2.`lang.name.zh_TW` as name_tw, task2.version as version", new HashMap());
                    for (Map next : query1) {
                        if (existsCodes.contains(String.valueOf(next.get("code")))) continue;
                        existsCodes.add(String.valueOf(next.get("code")));
                        StructuredComponentBO componentBO = new StructuredComponentBO();
                        componentBO.setCode(String.valueOf(next.get("code")));
                        componentBO.setType(ComponentTypeEnum.Project);
                        componentBO.setName(String.valueOf(next.get("name")));
                        componentBO.setVersion(String.valueOf(next.get("version")));
                        HashMap lang = new HashMap();
                        HashMap<String, String> nameLang = new HashMap<String, String>();
                        if (!ObjectUtils.isEmpty(next.get("name_cn"))) {
                            nameLang.put("zh_CN", String.valueOf(next.get("name_cn")));
                        }
                        if (!ObjectUtils.isEmpty(next.get("name_tw"))) {
                            nameLang.put("zh_TW", String.valueOf(next.get("name_tw")));
                        }
                        if (!ObjectUtils.isEmpty(next.get("name_us"))) {
                            nameLang.put("en_US", String.valueOf(next.get("name_us")));
                        }
                        if (!nameLang.isEmpty()) {
                            lang.put("name", nameLang);
                            componentBO.setLang(lang);
                        }
                        result.add((ComponentBO)componentBO);
                    }
                }
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        return result;
    }

    private void handleComponentForSignOffApp(List<ComponentBO> result, List<ApplicationRelation> list, Set<String> existsCodes, ComponentTypeEnum type) {
        list.forEach(project -> {
            if (!existsCodes.contains(project.getCode())) {
                StructuredComponentBO componentBO = new StructuredComponentBO();
                componentBO.setCode(project.getCode());
                componentBO.setType(type);
                componentBO.setName(project.getName());
                componentBO.setVersion(project.getVersion());
                result.add((ComponentBO)componentBO);
            }
        });
    }

    public List<ComponentBO> getTaskComponent(String appNameSpace, String appCode, String version, String tenantId) {
        ArrayList<ComponentBO> result = new ArrayList<ComponentBO>();
        HashSet<String> existsCodes = new HashSet<String>();
        Session session = this.neo4jSessionFactory.openSession();
        Result query1 = null;
        query1 = StringUtils.isEmpty((CharSequence)tenantId) ? session.query("match(n:Activity) where  n.version = '" + version + "' and n.pattern <> 'STATEMENT' and n.pattern <> 'DATA_ENTRY' and (n.nameSpace = '" + appNameSpace + "' or n.athena_namespace = '" + appCode + "' or n.relation_namespace = '" + appNameSpace + "') return distinct n.code as code, n.name as name, n.`lang.name.en_US` as name_us, n.`lang.name.zh_CN` as name_cn, n.`lang.name.zh_TW` as name_tw, n.version as version", new HashMap()) : session.query("match(n:Activity) where  n.version ='" + version + "' and (n.tenantId is null or n.tenantId in ['SYSTEM','" + tenantId + "']) and n.pattern <> 'STATEMENT' and n.pattern <> 'DATA_ENTRY' and (n.nameSpace = '" + appNameSpace + "' or n.athena_namespace = '" + appCode + "' or n.relation_namespace = '" + appNameSpace + "') return distinct n.code as code, n.name as name, n.`lang.name.en_US` as name_us, n.`lang.name.zh_CN` as name_cn, n.`lang.name.zh_TW` as name_tw, n.version as version", new HashMap());
        for (Map next : query1) {
            if (existsCodes.contains(String.valueOf(next.get("code")))) continue;
            existsCodes.add(String.valueOf(next.get("code")));
            StructuredComponentBO componentBO = new StructuredComponentBO();
            componentBO.setCode(String.valueOf(next.get("code")));
            componentBO.setType(ComponentTypeEnum.Task);
            componentBO.setName(String.valueOf(next.get("name")));
            componentBO.setVersion(String.valueOf(next.get("version")));
            HashMap lang = new HashMap();
            HashMap<String, String> nameLang = new HashMap<String, String>();
            if (!ObjectUtils.isEmpty(next.get("name_cn"))) {
                nameLang.put("zh_CN", String.valueOf(next.get("name_cn")));
            }
            if (!ObjectUtils.isEmpty(next.get("name_tw"))) {
                nameLang.put("zh_TW", String.valueOf(next.get("name_tw")));
            }
            if (!ObjectUtils.isEmpty(next.get("name_us"))) {
                nameLang.put("en_US", String.valueOf(next.get("name_us")));
            }
            if (!nameLang.isEmpty()) {
                lang.put("name", nameLang);
                componentBO.setLang(lang);
            }
            result.add((ComponentBO)componentBO);
        }
        try {
            List<String> collect;
            Object taskObj;
            List<ApplicationRelation> activityList = this.appService.getApplicationRelationByTypeAndAppCodeAndVersion("activity", appCode, version);
            if (CollectionUtils.isNotEmpty(activityList) && !ObjectUtils.isEmpty((Object)(taskObj = this.dataMapService.queryBatchCodeAndName(collect = activityList.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList()), "task", version)))) {
                JSONObject jsonObject1 = JSON.parseObject((String)JSON.toJSONString((Object)taskObj));
                JSONArray tasks = jsonObject1.getJSONArray("datas");
                for (Object obj : tasks) {
                    JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(obj));
                    if (existsCodes.contains(String.valueOf(jsonObject.get((Object)"code")))) continue;
                    existsCodes.add(String.valueOf(jsonObject.get((Object)"code")));
                    StructuredComponentBO componentBO = new StructuredComponentBO();
                    componentBO.setCode(String.valueOf(jsonObject.get((Object)"code")));
                    componentBO.setType(ComponentTypeEnum.Task);
                    componentBO.setName(String.valueOf(jsonObject.get((Object)"name")));
                    componentBO.setVersion(String.valueOf(jsonObject.get((Object)"version")));
                    JSONObject lang = jsonObject.getJSONObject("lang");
                    if (!ObjectUtils.isEmpty((Object)lang) && lang.containsKey((Object)"name")) {
                        HashMap<String, JSONObject> lang2 = new HashMap<String, JSONObject>();
                        JSONObject name = lang.getJSONObject("name");
                        lang2.put("name", name);
                        componentBO.setLang(lang2);
                    }
                    result.add((ComponentBO)componentBO);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List<ComponentBO> getBaseDataEntryComponent(String appNameSpace, String appCode, String version, String tenantId) {
        ArrayList<ComponentBO> result = new ArrayList<ComponentBO>();
        HashSet<String> existsCodes = new HashSet<String>();
        String baseDataCodeStr = null;
        try {
            List<ApplicationRelation> activityList = this.appService.getApplicationRelationByTypeAndAppCodeAndVersion("activity", appCode, version);
            List baseDataCodeList = activityList.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(baseDataCodeList)) {
                baseDataCodeStr = "['" + StringUtils.join(baseDataCodeList, (String)"','") + "']";
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        Session session = this.neo4jSessionFactory.openSession();
        Result query1 = null;
        query1 = StringUtils.isEmpty(baseDataCodeStr) ? (StringUtils.isEmpty((CharSequence)tenantId) ? session.query("match(n:Activity) where  n.version = '" + version + "' and n.pattern = 'DATA_ENTRY' and (n.nameSpace = '" + appNameSpace + "' or n.athena_namespace = '" + appCode + "' or n.relation_namespace = '" + appNameSpace + "') return distinct n.code as code, n.name as name, n.`lang.name.en_US` as name_us, n.`lang.name.zh_CN` as name_cn, n.`lang.name.zh_TW` as name_tw, n.version as version", new HashMap()) : session.query("match(n:Activity) where  n.version ='" + version + "' and (n.tenantId is null or n.tenantId in ['SYSTEM','" + tenantId + "']) and n.pattern = 'DATA_ENTRY' and (n.nameSpace = '" + appNameSpace + "' or n.athena_namespace = '" + appCode + "' or n.relation_namespace = '" + appNameSpace + "') return distinct n.code as code, n.name as name, n.`lang.name.en_US` as name_us, n.`lang.name.zh_CN` as name_cn, n.`lang.name.zh_TW` as name_tw, n.version as version", new HashMap())) : (StringUtils.isEmpty((CharSequence)tenantId) ? session.query("match(n:Activity) where  n.version = '" + version + "' and n.pattern = 'DATA_ENTRY' and n.code in " + baseDataCodeStr + "  return distinct n.code as code, n.name as name, n.`lang.name.en_US` as name_us, n.`lang.name.zh_CN` as name_cn, n.`lang.name.zh_TW` as name_tw, n.version as version", new HashMap()) : session.query("match(n:Activity) where  n.version ='" + version + "' and (n.tenantId is null or n.tenantId in ['SYSTEM','" + tenantId + "']) and n.pattern = 'DATA_ENTRY' and n.code in " + baseDataCodeStr + "  return distinct n.code as code, n.name as name, n.`lang.name.en_US` as name_us, n.`lang.name.zh_CN` as name_cn, n.`lang.name.zh_TW` as name_tw, n.version as version", new HashMap()));
        for (Map next : query1) {
            if (existsCodes.contains(String.valueOf(next.get("code")))) continue;
            existsCodes.add(String.valueOf(next.get("code")));
            StructuredComponentBO componentBO = new StructuredComponentBO();
            componentBO.setCode(String.valueOf(next.get("code")));
            componentBO.setType(ComponentTypeEnum.BaseDataEntry);
            componentBO.setName(String.valueOf(next.get("name")));
            componentBO.setVersion(String.valueOf(next.get("version")));
            HashMap lang = new HashMap();
            HashMap<String, String> nameLang = new HashMap<String, String>();
            if (!ObjectUtils.isEmpty(next.get("name_cn"))) {
                nameLang.put("zh_CN", String.valueOf(next.get("name_cn")));
            }
            if (!ObjectUtils.isEmpty(next.get("name_tw"))) {
                nameLang.put("zh_TW", String.valueOf(next.get("name_tw")));
            }
            if (!ObjectUtils.isEmpty(next.get("name_us"))) {
                nameLang.put("en_US", String.valueOf(next.get("name_us")));
            }
            if (!nameLang.isEmpty()) {
                lang.put("name", nameLang);
                componentBO.setLang(lang);
            }
            result.add((ComponentBO)componentBO);
        }
        return result;
    }

    public List<ComponentBO> getCommonBaseDataEntryComponent(String version) {
        ArrayList<ComponentBO> result = new ArrayList<ComponentBO>();
        HashSet<String> existsCodes = new HashSet<String>();
        Session session = this.neo4jSessionFactory.openSession();
        Result query1 = session.query("match (n:Activity{commonApp:true})  where  n.version ='" + version + "'  and n.pattern = 'DATA_ENTRY'  return distinct n.code as code, n.name as name, n.`lang.name.en_US` as name_us, n.`lang.name.zh_CN` as name_cn, n.`lang.name.zh_TW` as name_tw, n.version as version", new HashMap());
        for (Map next : query1) {
            if (existsCodes.contains(String.valueOf(next.get("code")))) continue;
            existsCodes.add(String.valueOf(next.get("code")));
            StructuredComponentBO componentBO = new StructuredComponentBO();
            componentBO.setCode(String.valueOf(next.get("code")));
            componentBO.setType(ComponentTypeEnum.BaseDataEntry);
            componentBO.setName(String.valueOf(next.get("name")));
            componentBO.setVersion(String.valueOf(next.get("version")));
            HashMap lang = new HashMap();
            HashMap<String, String> nameLang = new HashMap<String, String>();
            if (!ObjectUtils.isEmpty(next.get("name_cn"))) {
                nameLang.put("zh_CN", String.valueOf(next.get("name_cn")));
            }
            if (!ObjectUtils.isEmpty(next.get("name_tw"))) {
                nameLang.put("zh_TW", String.valueOf(next.get("name_tw")));
            }
            if (!ObjectUtils.isEmpty(next.get("name_us"))) {
                nameLang.put("en_US", String.valueOf(next.get("name_us")));
            }
            if (!nameLang.isEmpty()) {
                lang.put("name", nameLang);
                componentBO.setLang(lang);
            }
            result.add((ComponentBO)componentBO);
        }
        return result;
    }

    public List<ComponentBO> getReportComponent(String appNameSpace, String appCode, String version, String tenantId) {
        ArrayList<ComponentBO> result = new ArrayList<ComponentBO>();
        HashSet<String> existsCodes = new HashSet<String>();
        String reportCodeStr = null;
        try {
            List<ApplicationRelation> activityList = this.appService.getApplicationRelationByTypeAndAppCodeAndVersion("activity", appCode, version);
            List reportCodeList = activityList.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(reportCodeList)) {
                reportCodeStr = "['" + StringUtils.join(reportCodeList, (String)"','") + "']";
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        Session session = this.neo4jSessionFactory.openSession();
        Result query1 = null;
        query1 = StringUtils.isEmpty(reportCodeStr) ? (StringUtils.isEmpty((CharSequence)tenantId) ? session.query("match(n:Activity) where  n.version = '" + version + "' and n.pattern = 'STATEMENT' and (n.nameSpace = '" + appNameSpace + "' or n.athena_namespace = '" + appCode + "' or n.relation_namespace = '" + appNameSpace + "') return distinct n.code as code, n.name as name,  n.`lang.name.en_US` as name_us, n.`lang.name.zh_CN` as name_cn, n.`lang.name.zh_TW` as name_tw, n.version as version", new HashMap()) : session.query("match(n:Activity)  where  n.version ='" + version + "' and (n.tenantId is null or n.tenantId in ['SYSTEM','" + tenantId + "']) and n.pattern = 'STATEMENT' and (n.nameSpace = '" + appNameSpace + "' or n.athena_namespace = '" + appCode + "' or n.relation_namespace = '" + appNameSpace + "') return distinct n.code as code, n.name as name,  n.`lang.name.en_US` as name_us, n.`lang.name.zh_CN` as name_cn, n.`lang.name.zh_TW` as name_tw, n.version as version", new HashMap())) : (StringUtils.isEmpty((CharSequence)tenantId) ? session.query("match(n:Activity) where  n.version = '" + version + "' and n.pattern = 'STATEMENT' and n.code in " + reportCodeStr + " return distinct n.code as code, n.name as name,  n.`lang.name.en_US` as name_us, n.`lang.name.zh_CN` as name_cn, n.`lang.name.zh_TW` as name_tw, n.version as version", new HashMap()) : session.query("match(n:Activity)  where  n.version ='" + version + "' and (n.tenantId is null or n.tenantId in ['SYSTEM','" + tenantId + "']) and n.pattern = 'STATEMENT' and n.code in " + reportCodeStr + " return distinct n.code as code, n.name as name,  n.`lang.name.en_US` as name_us, n.`lang.name.zh_CN` as name_cn, n.`lang.name.zh_TW` as name_tw, n.version as version", new HashMap()));
        for (Map next : query1) {
            if (existsCodes.contains(String.valueOf(next.get("code")))) continue;
            existsCodes.add(String.valueOf(next.get("code")));
            StructuredComponentBO componentBO = new StructuredComponentBO();
            componentBO.setCode(String.valueOf(next.get("code")));
            componentBO.setType(ComponentTypeEnum.Report);
            componentBO.setName(String.valueOf(next.get("name")));
            componentBO.setVersion(String.valueOf(next.get("version")));
            HashMap lang = new HashMap();
            HashMap<String, String> nameLang = new HashMap<String, String>();
            if (!ObjectUtils.isEmpty(next.get("name_cn"))) {
                nameLang.put("zh_CN", String.valueOf(next.get("name_cn")));
            }
            if (!ObjectUtils.isEmpty(next.get("name_tw"))) {
                nameLang.put("zh_TW", String.valueOf(next.get("name_tw")));
            }
            if (!ObjectUtils.isEmpty(next.get("name_us"))) {
                nameLang.put("en_US", String.valueOf(next.get("name_us")));
            }
            if (!nameLang.isEmpty()) {
                lang.put("name", nameLang);
                componentBO.setLang(lang);
            }
            result.add((ComponentBO)componentBO);
        }
        return result;
    }

    public List<ComponentBO> getServiceCompositionComponent(String appNameSpace, String appCode, String version, String tenantId) {
        ArrayList<ComponentBO> result = new ArrayList<ComponentBO>();
        HashSet<String> existsCodes = new HashSet<String>();
        Session session = this.neo4jSessionFactory.openSession();
        Result query1 = null;
        query1 = StringUtils.isEmpty((CharSequence)tenantId) ? session.query("match(n:StartServiceComposerAction) where n.version = '" + version + "' and (n.nameSpace = '" + appNameSpace + "' or n.athena_namespace = '" + appCode + "' or n.relation_namespace = '" + appNameSpace + "') return distinct n.serviceComposerId as code, n.name as name, n.version as version", new HashMap()) : session.query("match (n:StartServiceComposerAction) where  n.version ='" + version + "' and (n.tenantId is null or n.tenantId in ['SYSTEM','" + tenantId + "']) and (n.nameSpace = '" + appNameSpace + "' or n.athena_namespace = '" + appCode + "' or n.relation_namespace = '" + appNameSpace + "') return distinct n.serviceComposerId as code, n.name as name, n.version as version", new HashMap());
        for (Map next : query1) {
            if (existsCodes.contains(String.valueOf(next.get("code")))) continue;
            existsCodes.add(String.valueOf(next.get("code")));
            StructuredComponentBO componentBO = new StructuredComponentBO();
            componentBO.setCode(String.valueOf(next.get("code")));
            componentBO.setType(ComponentTypeEnum.ServiceComposition);
            componentBO.setName(String.valueOf(next.get("name")));
            componentBO.setVersion(String.valueOf(next.get("version")));
            result.add((ComponentBO)componentBO);
        }
        return result;
    }

    public List<ComponentBO> getCommonServiceCompositionComponent(String version) {
        ArrayList<ComponentBO> result = new ArrayList<ComponentBO>();
        HashSet<String> existsCodes = new HashSet<String>();
        Session session = this.neo4jSessionFactory.openSession();
        Result query1 = session.query("match (n:StartServiceComposerAction{commonApp:true}) where  n.version ='" + version + "' return distinct n.serviceComposerId as code, n.name as name, n.version as version", new HashMap());
        for (Map next : query1) {
            if (existsCodes.contains(String.valueOf(next.get("code")))) continue;
            existsCodes.add(String.valueOf(next.get("code")));
            StructuredComponentBO componentBO = new StructuredComponentBO();
            componentBO.setCode(String.valueOf(next.get("code")));
            componentBO.setType(ComponentTypeEnum.ServiceComposition);
            componentBO.setName(String.valueOf(next.get("name")));
            componentBO.setVersion(String.valueOf(next.get("version")));
            result.add((ComponentBO)componentBO);
        }
        return result;
    }

    public Map<String, Object> queryComponent(String tenantId, String appCode, String eventType, List<String> component) throws DWBusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("tenantId", tenantId);
        result.put("appCode", appCode);
        result.put("eventType", eventType);
        if (CollectionUtils.isEmpty(component)) {
            return result;
        }
        boolean allAppExpired = false;
        TenantEntity tenant = this.tenantService.getTenant(tenantId);
        String tenantVersion = null;
        tenantVersion = tenant == null ? "1.0" : tenant.getVersion();
        Application application = this.appService.getApplicationByCode(appCode, tenantId);
        if (application == null) {
            for (String str : component) {
                result.put(str, new ArrayList());
            }
            log.info("queryComponentResult not found appEntity:{}", result);
            return result;
        }
        for (String str : component) {
            if (StringUtils.equals((CharSequence)str, (CharSequence)ComponentTypeEnum.MonitorRule.toString())) {
                List<String> monitorRule = this.getMonitorRule(appCode, tenantVersion, tenantId, allAppExpired);
                result.put(str, monitorRule);
                continue;
            }
            if (StringUtils.equals((CharSequence)str, (CharSequence)ComponentTypeEnum.MechanismVariable.toString())) {
                List<String> mechanismVariable = this.getMechanismVariable(appCode, tenantVersion, tenantId, allAppExpired);
                result.put(str, mechanismVariable);
                continue;
            }
            if (StringUtils.equals((CharSequence)str, (CharSequence)ComponentTypeEnum.Project.toString())) {
                List<String> project = this.getProject(appCode, tenantVersion, tenantId, allAppExpired);
                result.put(str, project);
                continue;
            }
            if (StringUtils.equals((CharSequence)str, (CharSequence)ComponentTypeEnum.Task.toString())) {
                List<String> task = this.getTask(appCode, tenantVersion, tenantId, allAppExpired);
                result.put(str, task);
                continue;
            }
            if (StringUtils.equals((CharSequence)str, (CharSequence)ComponentTypeEnum.BaseDataEntry.toString())) {
                List<String> baseDataEntry = this.getBaseDataEntry(appCode, tenantVersion, tenantId, allAppExpired);
                result.put(str, baseDataEntry);
                continue;
            }
            if (StringUtils.equals((CharSequence)str, (CharSequence)ComponentTypeEnum.Report.toString())) {
                List<String> report = this.getReport(appCode, tenantVersion, tenantId, allAppExpired);
                result.put(str, report);
                continue;
            }
            if (StringUtils.equals((CharSequence)str, (CharSequence)ComponentTypeEnum.ServiceComposition.toString())) {
                List<String> serviceComposition = this.getServiceComposition(appCode, appCode, tenantVersion, tenantId, allAppExpired);
                result.put(str, serviceComposition);
                continue;
            }
            result.put(str, new ArrayList());
        }
        log.info("queryComponentResult:{}", result);
        return result;
    }

    private List<String> getServiceComposition(String appNameSpace, String appCode, String version, String tenantId, boolean allAppExpired) {
        List<ComponentBO> appComponent = this.getServiceCompositionComponent(appNameSpace, appCode, version, tenantId);
        List<String> collect = appComponent.stream().map(ComponentBaseInfoBO::getCode).collect(Collectors.toList());
        return collect;
    }

    private List<String> getReport(String appCode, String version, String tenantId, boolean allAppExpired) throws DWBusinessException {
        List<ComponentBO> appComponent = this.getComponentList(Collections.singletonList(appCode), version, tenantId, ComponentTypeEnum.Report);
        List<String> collect = appComponent.stream().map(ComponentBaseInfoBO::getCode).collect(Collectors.toList());
        return collect;
    }

    private List<String> getBaseDataEntry(String appCode, String version, String tenantId, boolean allAppExpired) throws DWBusinessException {
        List<ComponentBO> appComponent = this.getComponentList(Collections.singletonList(appCode), version, tenantId, ComponentTypeEnum.BaseDataEntry);
        List<String> collect = appComponent.stream().map(ComponentBaseInfoBO::getCode).collect(Collectors.toList());
        return collect;
    }

    private List<String> getTask(String appCode, String version, String tenantId, boolean allAppExpired) throws DWBusinessException {
        List<ComponentBO> appComponent = this.getComponentList(Collections.singletonList(appCode), version, tenantId, ComponentTypeEnum.Task);
        List<String> collect = appComponent.stream().map(ComponentBaseInfoBO::getCode).collect(Collectors.toList());
        return collect;
    }

    private List<String> getMonitorRule(String appCode, String version, String tenantId, boolean allAppExpired) throws DWBusinessException {
        List<ComponentBO> appComponent = this.getComponentList(Collections.singletonList(appCode), version, tenantId, ComponentTypeEnum.MonitorRule);
        List<String> collect = appComponent.stream().map(ComponentBaseInfoBO::getCode).collect(Collectors.toList());
        return collect;
    }

    private List<String> getMechanismVariable(String appCode, String version, String tenantId, boolean allAppExpired) throws DWBusinessException {
        List<ComponentBO> appComponent = this.getComponentList(Collections.singletonList(appCode), version, tenantId, ComponentTypeEnum.MechanismVariable);
        List<String> collect = appComponent.stream().map(ComponentBaseInfoBO::getCode).collect(Collectors.toList());
        return collect;
    }

    private List<String> getProject(String appCode, String version, String tenantId, boolean allAppExpired) throws DWBusinessException {
        List<ComponentBO> appComponent = this.getComponentList(Collections.singletonList(appCode), version, tenantId, ComponentTypeEnum.Project);
        List<String> collect = appComponent.stream().map(ComponentBaseInfoBO::getCode).collect(Collectors.toList());
        return collect;
    }

    public void updateApplicationComponentList(String appCode, String version, String tenantId) throws DWBusinessException {
        Criteria appcriteria = new Criteria();
        appcriteria.and("code").is((Object)appCode).and("version").is((Object)version);
        Application application = this.dataPickService.findOneByCondition(appcriteria, tenantId, Application.class, "application");
        if (null != application && null != application.getCommonApp() && application.getCommonApp().booleanValue()) {
            return;
        }
        Boolean individualAll = Optional.ofNullable(application).map(Application::getIndividualAll).orElse(false);
        if (appCode.equalsIgnoreCase("common")) {
            return;
        }
        List<ComponentBO> result = this.getAllComponentListByApplication(appCode, appCode, version, tenantId);
        List<ApplicationRelation> applicationRelationList = this.dataPickService.applicationRelations(appCode, "paradigm", null, tenantId, version);
        if (CollectionUtils.isNotEmpty(applicationRelationList)) {
            Set paradigmCodeList = applicationRelationList.stream().map(BaseEntity::getCode).collect(Collectors.toSet());
            Map<String, Set<String>> existsParadigmAppComponent = this.getExistsParadigmAppComponent(appCode, version, individualAll != false ? tenantId : "SYSTEM");
            for (String paradigmCode : paradigmCodeList) {
                Update update;
                log.info("updateApplicationComponentList paradigmCode:{}", (Object)paradigmCode);
                Query query1 = new Query();
                Criteria criteria = Criteria.where((String)"appCode").is((Object)appCode).and("paradigm").is((Object)paradigmCode).and("type").is((Object)ComponentStructuredListType.BaseFunction).and("version").is((Object)version).and("tenantId").is((Object)(individualAll != false ? tenantId : "SYSTEM"));
                query1.addCriteria((CriteriaDefinition)criteria);
                ComponentStructuredList componentStructuredList = (ComponentStructuredList)((Object)this.mongoTemplateSystem.findOne(Query.query((CriteriaDefinition)criteria), ComponentStructuredList.class, "componentStructuredList"));
                if (componentStructuredList == null) {
                    Update update2 = new Update();
                    update2.set("components", result);
                    update2.set("structureVersion", (Object)"1.0");
                    update2.set("application", (Object)appCode);
                    update2.set("tenantId", (Object)(individualAll != false ? tenantId : "SYSTEM"));
                    this.mongoTemplateSystem.upsert(query1, update2, "componentStructuredList");
                    continue;
                }
                List<ComponentBO> extraComponet = this.componentManager.getExtraComponent(result, componentStructuredList.getComponents(), existsParadigmAppComponent, paradigmCode);
                if (!CollectionUtils.isNotEmpty(extraComponet)) continue;
                log.info("updateApplicationComponentList extraComponent size:{}", (Object)extraComponet.size());
                Update update3 = update = new Update();
                update3.getClass();
                Update.AddToSetBuilder add = new Update.AddToSetBuilder(update3, "components");
                update = add.each(new Object[]{extraComponet});
                this.mongoTemplateSystem.upsert(query1, update, "componentStructuredList");
            }
            this.updateTenantApplicationComponentList(appCode, version, tenantId, result, individualAll);
        }
    }

    private void updateTenantApplicationComponentList(String appCode, String version, String tenantId, List<ComponentBO> result, Boolean individualAll) throws DWBusinessException {
        Query tenantComponentQuery = new Query();
        Criteria criteria = Criteria.where((String)"appCode").is((Object)appCode);
        if (StringUtils.isNotEmpty((CharSequence)tenantId)) {
            criteria.and("tenantId").is((Object)tenantId);
        }
        tenantComponentQuery.addCriteria((CriteriaDefinition)criteria);
        List tenantAppComponentListBOS = this.mongoTemplateUser.find(tenantComponentQuery, TenantAppComponentListBO.class);
        if (CollectionUtils.isNotEmpty((Collection)tenantAppComponentListBOS)) {
            for (TenantAppComponentListBO tenantAppComponentListBO : tenantAppComponentListBOS) {
                String tenantVersion = null;
                try {
                    tenantVersion = this.kgInnerService.getTenantVersion(tenantAppComponentListBO.getTenantId());
                }
                catch (Exception e) {
                    log.error("\u79df\u6237\u67e5\u4e0d\u5230\u7248\u672c{}", (Object)tenantAppComponentListBO.getTenantId());
                }
                if (!version.equals(tenantVersion)) continue;
                ArrayList<ComponentBO> tenantAppComponent = new ArrayList<ComponentBO>();
                log.info("update TenantAppComponentListBO tenantId:{}", (Object)tenantAppComponentListBO.getTenantId());
                Query tenantParadigmQuery = new Query();
                tenantParadigmQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"code").is((Object)appCode).and("tenantId").is((Object)tenantAppComponentListBO.getTenantId()));
                MechanismTenantParadigm mechanismTenantParadigm = (MechanismTenantParadigm)this.mongoTemplateUser.findOne(tenantParadigmQuery, MechanismTenantParadigm.class, "mechanismTenantParadigm");
                if (mechanismTenantParadigm != null) {
                    Map<String, List<String>> tenantParadigmMap = this.componentManager.getTenantParadigm(mechanismTenantParadigm, version, tenantId);
                    if (tenantParadigmMap != null) {
                        Set<Map.Entry<String, List<String>>> entries = tenantParadigmMap.entrySet();
                        for (Map.Entry<String, List<String>> entry : entries) {
                            String paradigm = entry.getKey();
                            TenantAppComponentListBO tenantAppComponentListBO1 = this.componentManager.GetTenantUsingApplicationComponentList(appCode, individualAll != false ? tenantAppComponentListBO.getTenantId() : "SYSTEM", paradigm, entry.getValue(), version);
                            if (!CollectionUtils.isNotEmpty((Collection)tenantAppComponentListBO1.getComponents())) continue;
                            tenantAppComponent.addAll(tenantAppComponentListBO1.getComponents());
                        }
                    } else {
                        tenantAppComponent.addAll(result);
                    }
                } else {
                    tenantAppComponent.addAll(result);
                }
                this.compareAndUpdate(tenantAppComponentListBO, tenantAppComponent);
            }
        }
    }

    private Map<String, Set<String>> getExistsParadigmAppComponent(String appCode, String version, String tenantId) throws DWBusinessException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        Criteria criteria = Criteria.where((String)"appCode").is((Object)appCode).and("type").is((Object)ComponentStructuredListType.BaseFunction).and("version").is((Object)version).and("tenantId").is((Object)tenantId);
        List componentStructuredListBOS = this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)criteria), ComponentStructuredList.class, "componentStructuredList");
        if (CollectionUtils.isEmpty((Collection)componentStructuredListBOS)) {
            return result;
        }
        for (ComponentStructuredList componentStructuredListBO : componentStructuredListBOS) {
            ArrayList<ComponentBO> mergedList = new ArrayList<ComponentBO>();
            this.componentManager.Merge(mergedList, componentStructuredListBO.getComponents(), new ArrayList<ComponentBaseInfoBO>());
            Set collect = mergedList.stream().map(e -> e.getType().toString() + "#" + e.getCode()).collect(Collectors.toSet());
            result.put(componentStructuredListBO.getParadigm(), collect);
        }
        return result;
    }

    private void compareAndUpdate(TenantAppComponentListBO tenantAppComponentListBO, List<ComponentBO> tenantAppComponent) {
        if (CollectionUtils.isEmpty(tenantAppComponent)) {
            return;
        }
        List components = tenantAppComponentListBO.getComponents();
        if (CollectionUtils.isEmpty((Collection)components)) {
            tenantAppComponentListBO.setComponents(tenantAppComponent);
        } else {
            Set existsSet = components.stream().map(componentBO -> componentBO.getType().toString() + "#" + componentBO.getCode()).collect(Collectors.toSet());
            Set tenantAppComponentSet = tenantAppComponent.stream().map(componentBO -> componentBO.getType().toString() + "#" + componentBO.getCode()).collect(Collectors.toSet());
            ArrayList<ComponentBO> toAdd = new ArrayList<ComponentBO>();
            for (ComponentBO componentBO2 : tenantAppComponent) {
                if (existsSet.contains(componentBO2.getType().toString() + "#" + componentBO2.getCode())) continue;
                existsSet.add(componentBO2.getType().toString() + "#" + componentBO2.getCode());
                toAdd.add(componentBO2);
            }
            components.addAll(toAdd);
            components.removeIf(v -> !tenantAppComponentSet.contains(v.getType().toString() + "#" + v.getCode()));
            tenantAppComponentListBO.setComponents(components);
        }
        this.mongoTemplateUser.save((Object)tenantAppComponentListBO);
    }

    public void updateApplicationComponentList(String appCode, List<String> tenantIds, String version) throws DWBusinessException {
        CountDownLatch latch = new CountDownLatch(tenantIds.size());
        ArrayList errorMessage = new ArrayList();
        for (String tenantId : tenantIds) {
            this.executor.submit(() -> {
                try {
                    log.info("updateApplicationComponentList tenantId:{}", (Object)tenantId);
                    this.updateApplicationComponentList(appCode, version, tenantId);
                }
                catch (DWBusinessException e) {
                    log.error("updateApplicationComponentList error", (Throwable)e);
                    errorMessage.add("\u4e2a\u6848\u5e94\u7528\u66f4\u65b0\u7ec4\u4ef6\u6e05\u5355\u5931\u8d25\uff0c\u79df\u6237\uff1a" + tenantId + "\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("\u66f4\u65b0\u4e2a\u6848\u7ec4\u4ef6\u7ebf\u7a0b\u4e2d\u65ad");
            throw new DWBusinessException("\u66f4\u65b0\u4e2a\u6848\u7ec4\u4ef6\u7ebf\u7a0b\u4e2d\u65ad");
        }
        if (CollectionUtils.isNotEmpty(errorMessage)) {
            throw new DWBusinessException(Joiner.on((String)"\\n").join(errorMessage));
        }
    }
}

